Imports System
Imports System.Runtime.InteropServices
Imports CDF

Public Class CDFLeapSecondsInfo
	Inherits CDFAPIs

	Public Shared Sub Main(args As String())
		Dim dump As Boolean = False
		Dim table As String = Nothing
		Dim lt As Double(,)
		Dim fileStatus As Integer
		Dim year As Integer, month As Integer, day As Integer
		Dim ix As Integer, rows As Integer
		If args.Length = 1 Then
			Dim [option] As String = args(0)
			If [option].ToLower().Equals("dump") Then
				dump = True
			End If
		End If
		Console.WriteLine("Info for CDF leap second table...")
		Try
			table = CDFgetLeapSecondsTableEnvVar()
		Catch ex As CDFException
			table = Nothing
		End Try
		fileStatus = CDFgetLeapSecondsTableStatus()
		If table Is Nothing Then
			Console.WriteLine("Environment Variable: CDF_LEAPSECONDSTABLE is NOT defined....")
			Console.WriteLine("Thus, the hard-coded table is used.")
		Else
			If fileStatus = 0 Then
				Console.WriteLine("Environment Variable: CDF_LEAPSECONDSTABLE is defined as: " + table)
				Console.WriteLine("                      but the file is invalid....")
				Console.WriteLine("Thus, the hard-coded table is used.")
			Else
				Console.WriteLine("CDF's leap seconds table is based on the file: " + table)
			End If
		End If
		CDFgetLastDateinLeapSecondsTable(year, month, day)
                Dim filler1 as string, filler2 as string
                if month < 10 then
                  filler1 = "0"
                else
                  filler1 = ""
                end if
                if day < 10 then
                  filler2 = "0"
                else
                  filler2 = ""
                end if
		Console.WriteLine("The last date a leap second was added to the table is: {0}-{1}{2}-{3}{4}", year, filler1, month, filler2, day)
		If dump Then
			lt = DirectCast(CDFgetLeapSecondsTableObject(), Double(,))
			rows = CDFgetRowsinLeapSecondsTable()
			Console.WriteLine("    " & vbTab & "     " & vbTab & "     " & vbTab & "  Leap " & vbTab & vbTab & "Drift" & vbTab & vbTab & "Drift")
			Console.WriteLine("Year" & vbTab & "Month" & vbTab & "  Day" & vbTab & "Seconds" & vbTab & vbTab & "   1 " & vbTab & vbTab & "   2")
			For ix = 0 To rows - 1
			   If ix < 5 Then
				Console.WriteLine(lt(ix, 0) & vbTab & lt(ix, 1) & vbTab & lt(ix, 2) & vbTab & lt(ix, 3) & vbTab & lt(ix, 4) & vbTab & vbTab & lt(ix, 5))
			   ElseIf ix < 14 Then
				Console.WriteLine(lt(ix, 0) & vbTab & lt(ix, 1) & vbTab & lt(ix, 2) & vbTab & lt(ix, 3) & vbTab & vbTab & lt(ix, 4) & vbTab & vbTab & lt(ix, 5))
			   Else
				Console.WriteLine(lt(ix, 0) & vbTab & lt(ix, 1) & vbTab & lt(ix, 2) & vbTab & lt(ix, 3) & vbTab & vbTab & lt(ix, 4) & vbTab & vbTab & lt(ix, 5))

			   End If
			Next
		End If
	End Sub
End Class

