#!/usr/bin/perl -w
use strict;
use Math::BigInt;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF39_0/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF39_0/blib/lib'; }
use CDF;

print "\nTesting EPOCH.....\n";

my $year = 1970;
my $month = 1;
my $day = 1;
my $hour = 0;
my $minute = 0;
my $second = 0;
my $msec = 987;
my $str;

my $epoch = CDF::computeEPOCH ($year, $month, $day, $hour, $minute,  
                               $second, $msec);
CDF::toEncodeEPOCH($epoch, 4, $str);
print "epoch=$str\n";

my $unixTime;
my @unixTimes;
my @epochs;
# print "ref of epoch = ref($epoch)\n";
print "epoch=$epoch\n";
CDF::EPOCHtoUnixTime ($epoch, $unixTime);
print  "unixtime=$unixTime\n";
my $u1;
CDF::UnixTimetoEPOCH ($unixTime, $u1);
print  "u1=$u1\n";
CDF::toEncodeEPOCH($u1, 4, $str);
print "$str\n";

$epochs[0] = $epoch;
$epochs[1] = $epoch+1000.0;

CDF::EPOCHtoUnixTime (\@epochs, \@unixTimes);
print  "epoch=$epochs[0] $epochs[1]\n";
print  "unixtime=$unixTimes[0] $unixTimes[1]\n";

my @newepochs;
my @strs;
CDF::UnixTimetoEPOCH (\@unixTimes, \@newepochs);
CDF::toEncodeEPOCH(\@newepochs, 4, \@strs);
print "0: $strs[0]\n";
print "1: $strs[1]\n";

print "\nTesting TT2000.....\n";
my $tt2000 = CDF::computeTT2000 ($year, $month, $day, $hour, $minute,  
                                 $second, $msec, 234, 567);
CDF::toEncodeTT2000($tt2000, 3, $str);
print "tt2000=$str\n";

# print "ref of tt2000 = ref($tt2000)\n";
print "tt2000=$tt2000\n";
CDF::TT2000toUnixTime ($tt2000, $unixTime);
print  "unixtime=$unixTime\n";
CDF::UnixTimetoTT2000 ($unixTime, $u1);
print  "$tt2000 => $unixTime => $u1\n";
CDF::toEncodeTT2000($u1, 3, $str);
print "tt2000=$str\n";

my @tt2000s;
$tt2000s[0] = $tt2000;
$tt2000s[1] = $tt2000+1000000000.0;
@unixTimes = ();
print "**2nd element at tt2000s[1] is 1sec later....\n";
CDF::TT2000toUnixTime (\@tt2000s, \@unixTimes);
print  "tt2000=$tt2000s[0] $tt2000s[1]\n";
print  "unixtime=$unixTimes[0] $unixTimes[1]\n";
my @newtt2000s;
CDF::UnixTimetoTT2000 (\@unixTimes, \@newtt2000s);
print  "newtt2000=$newtt2000s[0] $newtt2000s[1]\n";
CDF::toEncodeTT2000(\@newtt2000s, 3, \@strs);
print "0: $strs[0]\n";
print "1: $strs[1]\n"; 

print "\nTesting EPOCH16.....\n";
my @ep16;
my $epoch16;
$epoch16 = CDF::computeEPOCH16 ($year, $month, $day, $hour, $minute,  
                                $second, $msec, 234, 567, 000, \@ep16);
print "$ep16[0] + $ep16[1] \n";
CDF::toEncodeEPOCH16(\@ep16, 4, $str);
#CDF::encodeEPOCH16_4(\@ep16, $str);
print "1... epoch16=$str\n";

CDF::EPOCH16toUnixTime (\@ep16, $unixTime);
print  "2... unixtime=$unixTime\n";
my @ep16o;
CDF::UnixTimetoEPOCH16 ($unixTime, \@ep16o);
print  "3... encoding $ep16o[0] $ep16o[1]\n";
my @ep16o2;
$ep16o2[0] = $ep16o[0];
$ep16o2[1] = $ep16o[1];
$ep16o2[2] = $ep16o[0]+10000;
$ep16o2[3] = $ep16o[1];
CDF::toEncodeEPOCH16(\@ep16o2, 4, \@strs);
print "4... $strs[0]\n";
print "5... $strs[1]\n";
@unixTimes = ();
print "5.a. input size: " . scalar(@ep16o2) . "\n";
CDF::EPOCH16toUnixTime (\@ep16o2, \@unixTimes);
print  "6... unixtime=$unixTimes[0]\n";
print  "7... unixtime=$unixTimes[1]\n";
my @ep16o3;
CDF::UnixTimetoEPOCH16(\@unixTimes, \@ep16o3);
print  "8... unixtime=$ep16o3[0] $ep16o3[1]\n";
print  "9... unixtime=$ep16o3[2] $ep16o3[3]\n";

CDF::toEncodeEPOCH16(\@ep16o3, 4, \@strs);
print "a... $strs[0]\n";
print "b... $strs[1]\n";

  exit;

