/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFException;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class AbstractFileAction
extends AbstractAction {
    protected MYEditor myEditor;
    protected JFileChooser chooser;

    protected AbstractFileAction(MYEditor mYEditor, String string) {
        super(string);
        this.myEditor = mYEditor;
    }

    public void performCloseAction() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.myEditor.closeFile();
        }
        catch (CDFException cDFException) {
            cDFException.printStackTrace();
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "MYEditor: CDFException", 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor, exception.getMessage(), "MYEditor: Exception", 0);
        }
    }

    public void performSaveAction(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        File file = null;
        Object var5_5 = null;
        boolean bl3 = true;
        if (bl) {
            this.chooser = this.myEditor.getFileChooser();
            this.chooser.setCurrentDirectory(this.myEditor.getWorkingDir());
            this.chooser.rescanCurrentDirectory();
            String string = this.myEditor.getLogicalFilename();
            if (string != null) {
                this.chooser.setSelectedFile(new File(string + ".cdf"));
            } else {
                this.chooser.setSelectedFile(this.myEditor.getFile());
            }
            int n = this.chooser.showSaveDialog(this.myEditor.sharedInstance());
            if (n == 0) {
                int n2;
                this.myEditor.setWaitCursor();
                file = this.chooser.getSelectedFile();
                if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this.myEditor, file.getName() + " exists.\nDo you want to " + "overwrite it?", "Overwrite?", 0)) != 0) {
                    bl3 = false;
                    bl2 = false;
                }
            } else {
                bl3 = false;
                bl2 = false;
            }
        } else {
            file = this.myEditor.getFile();
        }
        try {
            if (bl3) {
                this.myEditor.saveFile(file.getPath());
            }
            if (bl2) {
                this.myEditor.closeFile();
            }
        }
        catch (CDFException cDFException) {
            cDFException.printStackTrace();
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor.sharedInstance(), "File not saved due to CDF Error: " + CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "MYEditor: CDFException", 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor.sharedInstance(), "I/O Error. Check file permissions.", "MYEditor: IOException", 0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor.sharedInstance(), "Save was interupted, please try again", "MYEditor: InterruptedException", 0);
        }
    }
}

