#!/usr/bin/perl -w

use strict;
use Math::BigInt;
use Data::Dumper;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF38_1/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF38_1/blib/lib'; }
use CDF;

my $id;
my $status;
$status = CDF::CDFlib (&OPEN_, &CDF_, $ARGV[0], \$id,
		       &NULL_);
QuitCDF ("4.0", $status) if ($status < &CDF_OK);
my %var;
if (scalar(@ARGV) > 4) {
  ($status, %var) = CDF::CDFreadVar($id, $ARGV[1], $ARGV[2], $ARGV[3], $ARGV[4]);
} elsif (scalar(@ARGV) == 4) {
  ($status, %var) = CDF::CDFreadVar($id, $ARGV[1], $ARGV[2], $ARGV[3]);
} elsif (scalar(@ARGV) == 3) {
  ($status, %var) = CDF::CDFreadVar($id, $ARGV[1], $ARGV[2]);
} elsif (scalar(@ARGV) == 2) {
  ($status, %var) = CDF::CDFreadVar($id, $ARGV[1]);
} else {
  ($status, %var) = CDF::CDFreadVar($id);
}

if ($status == &CDF_OK) {
#  print Dumper(\%var);
  my ($key, $value);
        while ( ($key, $value) = each %var) {
          print $key . "\n";
          print Dumper(\$value);
        }
} else {
  QuitCDF ("28.0", $status);
}

$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("28.4", $status) if ($status < &CDF_OK) ;

exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

