

#
# testValidate
#
#   This program optionally validates the passed CDF file.
#   See README.
#
#  Usage:
#     perl testValidate.pl a_cdf_file
#
# Written By:
#
#    Mike H. Liu
#
#    17 July, 2009
#

use strict;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF38_1/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF38_1/blib/lib'; }
use CDF;

my $file = $ARGV[0];

#############################################################################
# Display title.
#############################################################################

print "\nTesting Perl-CDF Data Validation\n\n";
CDF::CDFsetValidate(&VALIDATEFILEon);
# CDF::CDFsetValidate(&VALIDATEFILEoff);

my $id; my $status;
$status = CDF::CDFlib(&OPEN_, &CDF_, $file, \$id,
 		      &NULL_);
QuitCDF ("1.0", $status) if ($status < &CDF_OK); 

#############################################################################
# Close CDF.
#############################################################################

$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("2.0", $status) if ($status < &CDF_OK) ;

#############################################################################
# Successful completion.
#############################################################################
print "Test completed successfully\n";
exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

