#!/usr/bin/perl -w

#
# testPerlCDFii
#
#   This program tests the PerlCDF internal interface.  PerlCDF must be installed.
#   See README.
#
#  Usage:
#     perl testPerlCDFii.pl
#
# Written By:
#
#    Emily A. Greene
#    NSSDC / Hughes STX
#
#    17 October, 1995
#
#    Version 1.0
#    Modified by: Michael Liu  - 20 March, 1998
#    Version 2.0
#    Modified by: Michael Liu  - 07 January, 2005
#
#############################################################################
#
#  Translated from qst2ic.c v. 1.10 by J. Love
#
#  Differences include:
#     z Variable is 5 strings each 8 characters long not a 40 character buffer
#          tests changed accordingly
#     maxiumum records written is a variable
#     Arrays are all 1 Dimensional.  2 dimensionality handled within CDF.
#     Added section confirming rVARs recCount, etc.
#     Added a few informational messages
#     Tests Epoch routines
# Note: As Perl uses double, a variable of data type CDF_REAL4/FLOAT will 
#	cause some minor value deviation due to different floating-point type 
#	representations. If the value is returned from the CDF's C routine 
#	and compared with Perl value, an epsilon is used for checkng their
#	equality. 10**(-9) is used for double and 10**(-5) for 
#	float/real. No problem for CDF_REAL8 data type.
#     
#############################################################################

use strict;
use Math::BigInt;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF38_1/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF38_1/blib/lib'; }
use CDF;

#############################################################################
# Display title.
#############################################################################

print "\nTesting Perl-CDF Internal/C interface for strings\n\n";

#############################################################################
# Open CDF.
#############################################################################
my $id;
my $status;

$status = CDF::CDFlib (&OPEN_, &CDF_, $ARGV[0], \$id,
		       &NULL_);
QuitCDF ("4.0", $status) if ($status < &CDF_OK) ;

#############################################################################
# PUT to attributes.
#############################################################################
my @strings;
my $string;
my $numStrings;
my $i;

$status = CDF::CDFlib (&SELECT_, &ATTR_, 0,
				&zVAR_, 0,
				&zENTRY_, 0,
		       &GET_, &zENTRY_STRINGSDATA_, \@strings,
#		       &GET_, &zENTRY_DATA_, \$string,
		       &NULL_);

if ($status == &CDF_OK) {
  $numStrings = scalar(@strings);
  for ($i = 0; $i < $numStrings; ++$i) {
    print "$i:\"$strings[$i]\" \n";
  }
#  print "\"$string\"\n";
}

$status = CDF::CDFlib (&SELECT_, &ATTR_, 1,
				&zVAR_, 0,
				&zENTRY_, 0,
		       &GET_, &zENTRY_STRINGSDATA_, \@strings,
#		       &GET_, &zENTRY_DATA_, \$string,
		       &NULL_);

if ($status == &CDF_OK) {
  $numStrings = scalar(@strings);
  for ($i = 0; $i < $numStrings; ++$i) {
    print "$i:\"$strings[$i]\" \n";
  }
#  print "\"$string\" \n";
}

$status = CDF::CDFlib (&SELECT_, &ATTR_, 2,
				&zVAR_, 0,
				&zENTRY_, 0,
		       &GET_, &zENTRY_STRINGSDATA_, \@strings,
#		       &GET_, &zENTRY_DATA_, \$string,
		       &NULL_);
if ($status == &CDF_OK) {
  $numStrings = scalar(@strings);
for ($i = 0; $i < $numStrings; ++$i) {
    print "$i:\"$strings[$i]\" \n";
  }
#  print "\"$string\" \n";
}
$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("28.2", $status) if ($status < &CDF_OK) ;

#############################################################################
# Successful completion.
#############################################################################
print "All tests completed successfully\n";
exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

