/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;

public class CDFJsonReader
implements CDFConstants {
    private static boolean toGlobal = true;
    private static boolean toVarAttrs = true;
    private static boolean toVarDesc = true;
    private static boolean toVarData = false;
    private static String[] varNames = null;
    private static String inFile = null;
    private static int varCount = 0;
    private static boolean toShow = true;
    private static String item1 = "CDFFileInfo";
    private static String item2 = "CDFglobalAttributes";
    private static String item3 = "CDFVariables";
    private static String item4 = "VarDescription";
    private static String item5 = "VarAttributes";
    private static String item6 = "VarData";
    private static String item7 = "EmptyAttributes";

    public static void main(String[] stringArray) throws IOException {
        CDFJsonReader.parseCmdLine(stringArray);
        FileInputStream fileInputStream = new FileInputStream(inFile);
        JsonReader jsonReader = Json.createReader((InputStream)fileInputStream);
        JsonObject jsonObject = jsonReader.readObject();
        jsonReader.close();
        ((InputStream)fileInputStream).close();
        JsonArray jsonArray = jsonObject.getJsonArray(item1);
        if (jsonArray != null) {
            CDFJsonReader.printJsonObject(jsonObject);
        } else {
            for (String string : jsonObject.keySet()) {
                JsonObject jsonObject2 = jsonObject.getJsonObject(string);
                System.out.println(string + ":");
                CDFJsonReader.printJsonObject(jsonObject.getJsonObject(string));
            }
        }
    }

    private static void printJsonObject(JsonObject jsonObject) {
        Object object;
        JsonValue jsonValue;
        Iterator iterator;
        Object object2;
        Object object3;
        Object object4;
        JsonArray jsonArray = jsonObject.getJsonArray(item1);
        if (jsonArray != null) {
            System.out.println("  " + item1 + ":");
            object4 = jsonArray.iterator();
            while (object4.hasNext()) {
                object3 = (JsonValue)object4.next();
                for (Object object5 : ((JsonObject)object3).keySet()) {
                    System.out.println("    " + (String)object5 + ":" + ((JsonObject)object3).getString((String)object5));
                }
            }
        }
        if (toGlobal && (object4 = jsonObject.getJsonArray(item2)) != null) {
            System.out.println("  " + item2 + ":");
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (JsonValue)object3.next();
                for (String string : ((JsonObject)object2).keySet()) {
                    System.out.println("    " + string + ":");
                    iterator = ((JsonObject)object2).getJsonArray(string);
                    for (int i = 0; i < iterator.size(); ++i) {
                        jsonValue = iterator.getJsonObject(i);
                        for (Object object6 : jsonValue.keySet()) {
                            object = jsonValue.get(object6);
                            System.out.println("      " + (String)object6 + ":" + object);
                        }
                    }
                }
            }
        }
        boolean bl = false;
        object3 = jsonObject.getJsonArray(item3);
        object2 = null;
        long l = 0L;
        if (object3 != null) {
            System.out.println("  " + item3 + ":");
            object2 = null;
            l = 0L;
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                JsonValue jsonValue2 = (JsonValue)iterator.next();
                for (Iterator iterator2 : ((JsonObject)jsonValue2).keySet()) {
                    Object object6;
                    object6 = ((JsonObject)jsonValue2).getJsonArray((String)((Object)iterator2));
                    object = object6.getJsonObject(0);
                    if (varCount > 0) {
                        toShow = CDFJsonReader.checkVar(object);
                    }
                    if (!toShow) continue;
                    System.out.println("    " + iterator2 + ":");
                    block8: for (int i = 0; i < object6.size(); ++i) {
                        object = object6.getJsonObject(i);
                        block9: for (String string : object.keySet()) {
                            if (string.equals("VarDescription")) {
                                bl = false;
                            }
                            if (string.equals(item5) && !toVarAttrs || string.equals(item6) && !toVarData && !bl) continue block8;
                            Object object7 = object.get((Object)string);
                            if (object7 instanceof JsonString) {
                                System.out.println("      " + string + ":" + object7);
                                continue;
                            }
                            if (object7 instanceof JsonArray) {
                                System.out.println("      " + string + ":");
                                int n = ((JsonArray)object7).size();
                                boolean bl2 = false;
                                for (int j = 0; j < n; ++j) {
                                    Object object8;
                                    Object object9 = ((JsonArray)object7).get(j);
                                    if (object9 instanceof JsonObject) {
                                        for (String string2 : ((JsonObject)object9).keySet()) {
                                            object8 = ((JsonObject)object9).get((Object)string2);
                                            System.out.println("        " + string2 + ":" + object8);
                                            if (!toVarDesc && string2.equalsIgnoreCase("varname")) {
                                                bl2 = true;
                                            }
                                            if (string2.equals("RecVariance") && object8.toString().equals("\"NOVARY\"")) {
                                                bl = true;
                                            }
                                            if (string2.equalsIgnoreCase("format")) {
                                                object2 = CDFJsonReader.toCformat(object8.toString().replaceAll("^\"|\"$", ""));
                                            }
                                            if (!string2.equalsIgnoreCase("datatype")) continue;
                                            l = CDFUtils.getDataTypeValue((String)object8.toString().replaceAll("^\"|\"$", ""));
                                        }
                                    } else if (object9 instanceof JsonArray) {
                                        System.out.print("        [");
                                        int n2 = ((JsonArray)object9).size();
                                        for (int k = 0; k < n2; ++k) {
                                            object8 = ((JsonArray)object9).get(k);
                                            System.out.print(object8 + (k < n2 - 1 ? ", " : "]"));
                                        }
                                        System.out.println("");
                                    } else if (object9 instanceof JsonNumber || object9 instanceof JsonString) {
                                        if (j == 0) {
                                            System.out.print("      [");
                                        }
                                        if (object9 instanceof JsonString || object2 == null || l != 21L && l != 22L && l != 44L && l != 45L) {
                                            System.out.print(object9 + (j < n - 1 ? ", " : ""));
                                        } else {
                                            System.out.print(String.format((String)object2, ((JsonNumber)object9).doubleValue()) + (j < n - 1 ? ", " : ""));
                                        }
                                        if (j == n - 1) {
                                            System.out.println("]");
                                        }
                                    } else {
                                        System.out.println("        " + object9);
                                    }
                                    if (bl2) continue block9;
                                }
                                continue;
                            }
                            if (object7 instanceof JsonObject) {
                                System.out.println("  :a jsonObject: " + object7);
                                continue;
                            }
                            System.out.println("  :unknown");
                        }
                    }
                }
            }
            iterator = jsonObject.getJsonArray(item7);
            if (iterator != null) {
                System.out.println("  " + item7 + ":");
                Iterator iterator3 = iterator.iterator();
                while (iterator3.hasNext()) {
                    jsonValue = (JsonValue)iterator3.next();
                    for (Object object6 : ((JsonObject)jsonValue).keySet()) {
                        System.out.println("    " + (String)object6 + ":" + ((JsonObject)jsonValue).get(object6));
                    }
                }
            }
        }
    }

    private static void parseCmdLine(String[] stringArray) {
        Object var1_1 = null;
        if (stringArray.length == 0) {
            CDFJsonReader.exit("");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string;
                if (i == stringArray.length - 1) {
                    inFile = stringArray[i];
                    if (new File(inFile).exists()) continue;
                    System.out.println("** Error: file '" + inFile + "' does not exist **");
                    System.exit(1);
                    continue;
                }
                int n2 = stringArray[i].indexOf(":");
                if (stringArray[i].toLowerCase().startsWith("-vardata:")) {
                    string = stringArray[i].substring(n2 + 1);
                    if (!string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("no")) {
                        CDFJsonReader.exit("** Error: Invalid -vardata entered **");
                    }
                    if (!string.equalsIgnoreCase("yes")) continue;
                    toVarData = true;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-globalmetadata:")) {
                    string = stringArray[i].substring(n2 + 1);
                    if (!string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("no")) {
                        CDFJsonReader.exit("** Error: Invalid -globalmetadata entered **");
                    }
                    if (!string.equalsIgnoreCase("no")) continue;
                    toGlobal = false;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-vardesc:")) {
                    string = stringArray[i].substring(n2 + 1);
                    if (!string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("no")) {
                        CDFJsonReader.exit("** Error: Invalid -vardesc entered **");
                    }
                    if (!string.equalsIgnoreCase("no")) continue;
                    toVarDesc = false;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-varmetadata:")) {
                    string = stringArray[i].substring(n2 + 1);
                    if (!string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("no")) {
                        CDFJsonReader.exit("** Error: Invalid -varmetadata entered **");
                    }
                    if (!string.equalsIgnoreCase("no")) continue;
                    toVarAttrs = false;
                    continue;
                }
                if (!stringArray[i].toLowerCase().startsWith("-vars:")) continue;
                string = stringArray[i].substring(6);
                varCount = 1;
                for (n = 0; n < string.length(); ++n) {
                    if (string.charAt(n) != ',') continue;
                    ++varCount;
                }
                varNames = new String[varCount];
                StringBuffer stringBuffer = new StringBuffer(string);
                for (n = 0; n < varCount; ++n) {
                    int n3 = stringBuffer.indexOf(",");
                    if (n3 != -1) {
                        CDFJsonReader.varNames[n] = stringBuffer.substring(0, n3).toString();
                        stringBuffer = new StringBuffer(stringBuffer.substring(n3 + 1));
                        continue;
                    }
                    CDFJsonReader.varNames[n] = new String(stringBuffer);
                }
            }
        }
    }

    private static boolean checkVar(JsonObject jsonObject) {
        for (String string : jsonObject.keySet()) {
            JsonArray jsonArray = jsonObject.getJsonArray(string);
            JsonObject jsonObject2 = jsonArray.getJsonObject(0);
            block1: for (String string2 : jsonObject2.keySet()) {
                Object object = jsonObject2.get((Object)string2);
                if (!string2.equalsIgnoreCase("varname")) continue;
                toShow = false;
                String string3 = ((JsonString)object).getString();
                for (int i = 0; i < varCount; ++i) {
                    if (!string3.equals(varNames[i])) continue;
                    toShow = true;
                    continue block1;
                }
            }
        }
        return toShow;
    }

    private static void exit(String string) {
        if (!string.equals("")) {
            System.out.println(string);
        }
        CDFJsonReader.usage();
        System.exit(1);
    }

    private static void usage() {
        System.out.println("\nDescription:");
        System.out.println("    This program displays the contents of a Json file.");
        System.out.println("");
        System.out.println("Usage: java CDFJsonReader [Options] JsonFileName ");
        System.out.println(" ");
        System.out.println("Options: ");
        System.out.println(" ");
        System.out.println("   -globalmetadata:[yes | no].  -globalmetadata:yesis the default.");
        System.out.println("      -globalmetadata:yes shows all global attributes.");
        System.out.println("      -globalmetadata:no doesn't show all global attributes.");
        System.out.println(" ");
        System.out.println("   -vardesc:[yes | no].  -vardesc:yes is the default.");
        System.out.println("      -vardesc:yes shows each variable's name and its specification.");
        System.out.println("      -vardesc:no shows the variable name only.");
        System.out.println(" ");
        System.out.println("   -varmetadata:[yes | no].  -varmetadata:yes is the default.");
        System.out.println("      -varmetadata:yes shows each variable's attributes.");
        System.out.println("      -varmetadata:no doesn't show each variable's attributes.");
        System.out.println(" ");
        System.out.println("   -vars:var1,var2,....   shows only the specified variables with");
        System.out.println("                          variable names separated by a single ','.");
        System.out.println("                          Otherwise, all variables are shown.");
        System.out.println(" ");
        System.out.println("   -vardata:[yes | no].  -vardata:no is the default.");
        System.out.println("      -vardata:yes shows the variable data");
        System.out.println("      -vardata:no doesn't show any record varying variable data");
        System.out.println(" ");
    }

    private static String toCformat(String string) {
        if (string.charAt(0) == '%') {
            return string;
        }
        if ((string = string.trim()) == null) {
            return null;
        }
        int n = string.length();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || c == '(') continue;
            string2 = string.substring(i);
            if (!string2.endsWith(")")) break;
            string2 = string2.substring(0, string2.length() - 1);
            break;
        }
        if (string2 == null) {
            return null;
        }
        switch (string2.charAt(0)) {
            case 'I': 
            case 'i': {
                String string3 = string2.substring(1);
                return "%" + string3 + "d";
            }
            case 'F': 
            case 'f': {
                String string4 = string2.substring(1);
                return "%" + string4 + "f";
            }
            case 'E': 
            case 'e': {
                String string5 = string2.substring(1);
                return "%" + string5 + "e";
            }
        }
        return null;
    }
}

