/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFData;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public class CDF2Json
implements CDFConstants {
    private static CDF cdf = null;
    private static boolean debug = false;
    private static String inFile = null;
    private static String outFile = null;
    private static String varData = "yes";
    private static String globalAttrs = "yes";
    private static String format = "prefer";
    private static String encodeEpoch = "yes";
    private static String varAttrs = "yes";
    private static boolean showProgress = false;
    private static boolean withz = false;
    private static boolean delete = false;
    private static boolean fullpath = true;
    private static boolean encodeEp = true;
    private static boolean showfile = false;
    private static JsonObjectBuilder CDFJsonObject0 = Json.createObjectBuilder();
    private static JsonObjectBuilder CDFJsonObject = null;
    private static int varCount = -1;
    private static String[] varNames;
    private static String[] fileNames;
    private static int numFiles;
    private static String item0;
    private static String item1;
    private static String item2;
    private static String item3;
    private static String item4;
    private static String item5;
    private static String item6;
    private static String item7;
    private static String item8;
    private static String item9;
    private static String separator;
    private static long numDimsN;

    public static void main(String[] stringArray) throws Exception {
        try {
            JsonWriter jsonWriter;
            Object object;
            CDF2Json.parseCmdLine(stringArray);
            if (outFile == null) {
                outFile = CDF2Json.getDefaultOutputFileName();
            }
            if (!delete && new File(outFile).exists()) {
                System.out.println("ERROR... output file:" + outFile + " already exists. ");
                System.exit(1);
            }
            for (int i = 0; i < numFiles; ++i) {
                String string;
                int n;
                JsonArrayBuilder jsonArrayBuilder;
                JsonArrayBuilder jsonArrayBuilder2;
                object = fileNames[i];
                if (showfile) {
                    System.out.println(fileNames[i]);
                }
                cdf = CDF.open((String)object, (long)0L);
                CDFJsonObject = Json.createObjectBuilder();
                jsonWriter = CDF2Json.printCDFFileInfo((String)object);
                if (jsonWriter != null) {
                    CDFJsonObject.add(item1, (JsonArrayBuilder)jsonWriter);
                }
                if (globalAttrs.equalsIgnoreCase("yes") && (jsonArrayBuilder2 = CDF2Json.printGlobalAttributes()) != null) {
                    CDFJsonObject.add(item2, jsonArrayBuilder2);
                }
                if ((jsonArrayBuilder2 = CDF2Json.printVariables()) != null) {
                    CDFJsonObject.add(item3, jsonArrayBuilder2);
                }
                if ((jsonArrayBuilder = CDF2Json.printEmptyAttributes()) != null) {
                    CDFJsonObject.add(item7, jsonArrayBuilder);
                }
                cdf.close();
                Object object2 = null;
                object2 = fullpath ? (!((String)object).endsWith(".cdf") && !((String)object).endsWith(".CDF") ? (String)object + ".cdf" : object) : ((n = ((String)object).lastIndexOf(separator)) == -1 ? (!((String)object).endsWith(".cdf") && !((String)object).endsWith(".CDF") ? (String)object + ".cdf" : object) : (!(string = ((String)object).substring(n + 1)).endsWith(".cdf") && !string.endsWith(".CDF") ? string + ".cdf" : string));
                CDFJsonObject0.add((String)object2, CDFJsonObject);
            }
            object = new FileOutputStream(outFile);
            jsonWriter = Json.createWriter((OutputStream)object);
            jsonWriter.writeObject(CDFJsonObject0.build());
            jsonWriter.close();
        }
        catch (Exception exception) {
            if (cdf != null) {
                cdf.close();
            }
            System.out.println("Exception occurred in main.\n" + exception);
        }
    }

    private static void parseCmdLine(String[] stringArray) {
        int n;
        Object var1_1 = null;
        int n2 = 0;
        String[] stringArray2 = new String[100];
        if (stringArray.length == 0) {
            CDF2Json.exit("");
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                String string;
                if (stringArray[n].indexOf(":") == -1 && stringArray[n].charAt(0) != '-') {
                    if (n2 == 0) {
                        n2 = 1;
                    }
                    if (n2 == 1) {
                        stringArray2[CDF2Json.numFiles] = stringArray[n];
                        ++numFiles;
                        if (!CDFUtils.cdfFileExists((String)stringArray[n])) {
                            System.out.println("** Error: file '" + stringArray[n] + "' does not exist **");
                            System.exit(1);
                        }
                        if (numFiles != 1) continue;
                        inFile = stringArray[n];
                        continue;
                    }
                    System.out.println("** Error: File(s) already specified in option \"fileNames\"...");
                    System.exit(1);
                }
                int n3 = stringArray[n].indexOf(":");
                if (stringArray[n].toLowerCase().startsWith("-filenames:")) {
                    if (n2 == 0) {
                        n2 = 2;
                    }
                    if (n2 == 2) {
                        string = stringArray[n].substring(n3 + 1);
                        inFile = string.toLowerCase().endsWith(".txt") ? string.substring(0, string.length() - 4) : (string.toLowerCase().endsWith(".text") ? string.substring(0, string.length() - 5) : string);
                        CDF2Json.readFileNames(string);
                        continue;
                    }
                    System.out.println("** Error: File(s) already specified in the command line...");
                    System.exit(1);
                    continue;
                }
                if (stringArray[n].toLowerCase().startsWith("-vardata:")) {
                    varData = stringArray[n].substring(n3 + 1);
                    if (varData.equalsIgnoreCase("yes") || varData.equalsIgnoreCase("no")) continue;
                    CDF2Json.exit("** Error: Invalid -varData entered **");
                    continue;
                }
                if (stringArray[n].toLowerCase().startsWith("-globalattrs:")) {
                    globalAttrs = stringArray[n].substring(n3 + 1);
                    if (globalAttrs.equalsIgnoreCase("yes") || globalAttrs.equalsIgnoreCase("no")) continue;
                    CDF2Json.exit("** Error: Invalid -globalattrs entered **");
                    continue;
                }
                if (stringArray[n].toLowerCase().startsWith("-varattrs:")) {
                    varAttrs = stringArray[n].substring(n3 + 1);
                    if (varAttrs.equalsIgnoreCase("yes") || varAttrs.equalsIgnoreCase("no")) continue;
                    CDF2Json.exit("** Error: Invalid -varattrs entered **");
                    continue;
                }
                if (stringArray[n].toLowerCase().startsWith("-format:")) {
                    format = stringArray[n].substring(n3 + 1);
                    if (format.equalsIgnoreCase("yes") || format.equalsIgnoreCase("no") || format.equalsIgnoreCase("prefer")) continue;
                    CDF2Json.exit("** Error: Invalid -format entered **");
                    continue;
                }
                if (stringArray[n].toLowerCase().startsWith("-encodeepoch:")) {
                    encodeEpoch = stringArray[n].substring(n3 + 1);
                    if (!encodeEpoch.equalsIgnoreCase("yes") && !encodeEpoch.equalsIgnoreCase("no")) {
                        CDF2Json.exit("** Error: Invalid -encodeepoch entered **");
                        continue;
                    }
                    if (!encodeEpoch.equalsIgnoreCase("no")) continue;
                    encodeEp = false;
                    continue;
                }
                if (stringArray[n].toLowerCase().startsWith("-vars:")) {
                    int n4;
                    string = stringArray[n].substring(6);
                    varCount = 1;
                    for (n4 = 0; n4 < string.length(); ++n4) {
                        if (string.charAt(n4) != ',') continue;
                        ++varCount;
                    }
                    varNames = new String[varCount];
                    StringBuffer stringBuffer = new StringBuffer(string);
                    for (n4 = 0; n4 < varCount; ++n4) {
                        int n5 = stringBuffer.indexOf(",");
                        if (n5 != -1) {
                            CDF2Json.varNames[n4] = stringBuffer.substring(0, n5).toString();
                            stringBuffer = new StringBuffer(stringBuffer.substring(n5 + 1));
                            continue;
                        }
                        CDF2Json.varNames[n4] = new String(stringBuffer);
                    }
                    continue;
                }
                if (stringArray[n].toLowerCase().startsWith("-output:") || stringArray[n].toLowerCase().startsWith("-json:")) {
                    outFile = stringArray[n].substring(n3 + 1);
                    if (outFile.equalsIgnoreCase("stdout")) {
                        outFile = "STDOUT";
                        continue;
                    }
                    if (outFile.toLowerCase().endsWith(".json")) continue;
                    outFile = outFile + ".json";
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-showprogress") || stringArray[n].equalsIgnoreCase("-progress")) {
                    showProgress = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-withz")) {
                    withz = true;
                    continue;
                }
                if (stringArray[n].toLowerCase().startsWith("-debug")) {
                    debug = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-delete")) {
                    delete = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-nofullpath")) {
                    fullpath = false;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-showfile")) {
                    showfile = true;
                    continue;
                }
                CDF2Json.exit("** Error: Invalid option entered **");
            }
        }
        if (debug) {
            for (n = 0; n < stringArray.length; ++n) {
                System.out.println("args[" + n + "] = " + stringArray[n]);
            }
            System.out.println("inFile=" + inFile + ", outputFile=" + outFile + ", globalattrs= " + globalAttrs + ", varAttrs= " + varAttrs + ", vars= all" + ", vardata= " + varData + ", showProgress=" + showProgress + ", withz=" + withz + ", showfile=" + showfile + ", delete=" + delete);
        }
        if (inFile == null) {
            CDF2Json.exit("** Error: CDF file name not specified **");
        }
        if (n2 == 1) {
            fileNames = new String[numFiles];
            System.arraycopy(stringArray2, 0, fileNames, 0, numFiles);
        }
    }

    private static String printCompression(long l, long[] lArray) {
        if (l != 0L) {
            String string = CDFUtils.getStringCompressionType((long)l);
            if (l != 5L) {
                return string;
            }
            return string + "." + lArray[0];
        }
        return null;
    }

    private static JsonArrayBuilder printCDFFileInfo(String string) {
        try {
            JsonObjectBuilder jsonObjectBuilder;
            String string2 = cdf.getVersion();
            String string3 = CDFUtils.getStringFormat((CDF)cdf);
            String string4 = CDFUtils.getStringMajority((CDF)cdf);
            String string5 = CDFUtils.getStringEncoding((CDF)cdf);
            String string6 = CDFUtils.getStringChecksum((CDF)cdf);
            long l = CDFUtils.getLeapSecondLastUpdated((CDF)cdf);
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder().add("FileVersion", string2);
            jsonArrayBuilder.add((JsonValue)jsonObjectBuilder2.build());
            JsonObjectBuilder jsonObjectBuilder3 = Json.createObjectBuilder().add("Format", string3);
            jsonArrayBuilder.add((JsonValue)jsonObjectBuilder3.build());
            long l2 = cdf.getCompressionType();
            long[] lArray = cdf.getCompressionParms();
            String string7 = CDF2Json.printCompression(l2, lArray);
            if (string7 != null) {
                jsonObjectBuilder = Json.createObjectBuilder().add("Compression", string7);
                jsonArrayBuilder.add((JsonValue)jsonObjectBuilder.build());
            }
            jsonObjectBuilder = Json.createObjectBuilder().add("Majority", string4);
            jsonArrayBuilder.add((JsonValue)jsonObjectBuilder.build());
            JsonObjectBuilder jsonObjectBuilder4 = Json.createObjectBuilder().add("Encoding", string5);
            jsonArrayBuilder.add((JsonValue)jsonObjectBuilder4.build());
            return jsonArrayBuilder;
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printCDFFileInfo");
            System.out.println(exception);
            System.exit(1);
            return null;
        }
    }

    private static JsonArrayBuilder printGlobalAttributes() {
        try {
            Attribute attribute = null;
            String string = null;
            long l = cdf.getNumGattrs();
            Vector vector = cdf.getGlobalAttributes();
            if (l > 0L) {
                JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    attribute = (Attribute)enumeration.nextElement();
                    string = attribute.getName();
                    long l2 = attribute.getNumEntries();
                    if (l2 == 0L) continue;
                    Vector vector2 = attribute.getEntries();
                    JsonObjectBuilder jsonObjectBuilder = vector2.elements();
                    while (jsonObjectBuilder.hasMoreElements()) {
                        Entry entry = (Entry)jsonObjectBuilder.nextElement();
                        if (entry == null) continue;
                        long l3 = entry.getDataType();
                        long l4 = entry.getNumElements();
                        Object object = entry.getData();
                        int n = l3 == 31L ? 1 : (l3 == 32L ? 2 : (l3 == 33L ? 3 : 0));
                        String string2 = String.valueOf(entry.getID());
                        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
                        jsonObjectBuilder2 = (JsonObjectBuilder)CDF2Json.printSingleData(jsonObjectBuilder2, string2, object, l3, l4, -1L, withz ? "Z" : "", null, null, false);
                        jsonArrayBuilder.add((JsonValue)jsonObjectBuilder2.build());
                    }
                    jsonObjectBuilder = Json.createObjectBuilder().add(string, jsonArrayBuilder);
                    jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder.build());
                }
                return jsonArrayBuilder2;
            }
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printGlobalAttributes");
            System.out.println(exception);
            System.exit(1);
        }
        return null;
    }

    private static JsonArrayBuilder printVariables() {
        block17: {
            long l = 0L;
            Variable variable = null;
            try {
                int n = 1;
                l = cdf.getNumVars();
                if (l <= 0L) break block17;
                JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                Vector vector = cdf.getVariables();
                String string = null;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    JsonArrayBuilder jsonArrayBuilder2;
                    variable = (Variable)enumeration.nextElement();
                    String string2 = variable.getName();
                    Object object = null;
                    if (!format.toLowerCase().equals("no")) {
                        String string3;
                        try {
                            String string4 = (String)variable.getEntryData("FORMAT");
                            string3 = string4.trim().length() == 0 ? null : string4.trim();
                        }
                        catch (CDFException cDFException) {
                            string3 = null;
                        }
                        if (string3 != null) {
                            string = CDF2Json.toCformat(string3);
                        }
                    }
                    try {
                        object = variable.getEntryData("FILLVAL");
                    }
                    catch (CDFException cDFException) {
                        try {
                            object = variable.getPadValue();
                        }
                        catch (CDFException cDFException2) {
                            object = null;
                        }
                    }
                    boolean bl = true;
                    if (varCount > 0) {
                        bl = false;
                        for (int i = 0; i < varCount; ++i) {
                            if (!string2.equals(varNames[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) continue;
                    if (showProgress) {
                        long l2 = variable.getMaxWrittenRecord() + 1L;
                        System.out.print("Variable " + n + ": " + string2 + " of " + (varCount > 0 ? (long)varCount : l) + " (" + (l2 < 10L ? " " : "") + l2 + " records): ");
                        ++n;
                    }
                    JsonArrayBuilder jsonArrayBuilder3 = Json.createArrayBuilder();
                    JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
                    JsonArrayBuilder jsonArrayBuilder4 = CDF2Json.printVarInfo(variable, string);
                    if (jsonArrayBuilder4 != null) {
                        jsonArrayBuilder3.add((JsonValue)Json.createObjectBuilder().add(item4, jsonArrayBuilder4).build());
                    }
                    if (varAttrs.equalsIgnoreCase("yes") && (jsonArrayBuilder2 = CDF2Json.printVarAttributes(variable, string, object)) != null) {
                        jsonArrayBuilder3.add((JsonValue)Json.createObjectBuilder().add(item5, jsonArrayBuilder2).build());
                    }
                    if ((varData.equalsIgnoreCase("yes") || !variable.getRecVariance()) && (jsonArrayBuilder2 = CDF2Json.printVarData(variable, string, object)) != null) {
                        jsonArrayBuilder3.add((JsonValue)Json.createObjectBuilder().add(item6, jsonArrayBuilder2).build());
                    }
                    jsonObjectBuilder.add(string2, jsonArrayBuilder3);
                    jsonArrayBuilder.add(jsonObjectBuilder);
                }
                return jsonArrayBuilder;
            }
            catch (Exception exception) {
                System.out.println("** Error occurred in printVariables");
                System.out.println("** # of variables: " + l);
                System.out.println("** variable: " + variable.getName());
                System.out.println(exception);
                System.exit(1);
            }
        }
        return null;
    }

    private static JsonArrayBuilder printVarInfo(Variable variable, String string) {
        try {
            long l;
            JsonObjectBuilder jsonObjectBuilder;
            long[] lArray;
            long l2;
            String string2;
            JsonArrayBuilder jsonArrayBuilder;
            JsonObjectBuilder jsonObjectBuilder2;
            long[] lArray2 = new long[]{1L};
            Object object = null;
            JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
            long l3 = variable.getDataType();
            String string3 = CDFUtils.getStringDataType((long)l3);
            JsonObjectBuilder jsonObjectBuilder3 = Json.createObjectBuilder().add("DataType", string3);
            jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder3.build());
            if (showProgress) {
                if (variable.getName().length() < 9) {
                    System.out.print("\t\t" + string3 + "/");
                } else {
                    System.out.print("\t" + string3 + "/");
                }
            }
            long l4 = variable.getNumElements();
            JsonObjectBuilder jsonObjectBuilder4 = Json.createObjectBuilder().add("NumElements", l4);
            jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder4.build());
            if (showProgress) {
                System.out.print(l4);
                if (l3 == 33L) {
                    System.out.print("  ");
                } else {
                    System.out.print("\t");
                }
            }
            long l5 = variable.getNumDims();
            lArray2 = variable.getDimSizes();
            long[] lArray3 = variable.getDimVariances();
            long[] lArray4 = new long[10];
            numDimsN = 0L;
            int n = 0;
            while ((long)n < l5) {
                if (lArray3[n] == -1L && lArray2[n] > 1L) {
                    lArray4[(int)CDF2Json.numDimsN] = lArray2[n];
                    ++numDimsN;
                }
                ++n;
            }
            JsonObjectBuilder jsonObjectBuilder5 = Json.createObjectBuilder().add("NumDims", numDimsN);
            jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder5.build());
            if (showProgress) {
                System.out.print(numDimsN + ":[");
            }
            if (numDimsN > 0L) {
                jsonObjectBuilder2 = Json.createObjectBuilder();
                jsonArrayBuilder = Json.createArrayBuilder();
                n = 0;
                while ((long)n < numDimsN) {
                    if (n > 0 && showProgress) {
                        System.out.print(",");
                    }
                    jsonArrayBuilder.add(lArray4[n]);
                    if (showProgress) {
                        System.out.print(lArray4[n]);
                    }
                    ++n;
                }
                jsonObjectBuilder2.add("DimSizes", jsonArrayBuilder);
                jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder2.build());
            }
            if (showProgress) {
                System.out.print("]   " + (l5 == 0L ? " " : ""));
            }
            String string4 = variable.getRecVariance() ? "VARY" : "NOVARY";
            jsonObjectBuilder2 = Json.createObjectBuilder().add("RecVariance", string4);
            jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder2.build());
            if (showProgress) {
                if (string4.equalsIgnoreCase("vary")) {
                    System.out.print("T/");
                } else {
                    System.out.print("F/");
                }
            }
            if (numDimsN > 0L) {
                jsonArrayBuilder = Json.createObjectBuilder();
                JsonArrayBuilder jsonArrayBuilder3 = Json.createArrayBuilder();
                n = 0;
                while ((long)n < numDimsN) {
                    jsonArrayBuilder3.add("VARY");
                    if (showProgress) {
                        System.out.print("T");
                    }
                    ++n;
                }
                jsonArrayBuilder.add("DimVariances", jsonArrayBuilder3);
                jsonArrayBuilder2.add((JsonValue)jsonArrayBuilder.build());
            }
            if (showProgress) {
                System.out.println("");
            }
            if ((string2 = CDF2Json.printCompression(l2 = variable.getCompressionType(), lArray = variable.getCompressionParms())) != null) {
                jsonObjectBuilder = Json.createObjectBuilder().add("Compression", string2);
                jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder.build());
            }
            long l6 = variable.getNumWrittenRecords();
            String string5 = CDFUtils.getStringSparseRecord((Variable)variable);
            if (string5.equalsIgnoreCase("none")) {
                if (l6 > 0L) {
                    jsonObjectBuilder = Json.createObjectBuilder().add("NumWrittenRecords", l6);
                    jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder.build());
                }
            } else {
                long l7 = variable.getMaxWrittenRecord();
                jsonObjectBuilder = Json.createObjectBuilder().add("SparseRecords", string5);
                jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder.build());
                JsonObjectBuilder jsonObjectBuilder6 = Json.createObjectBuilder().add("NumWrittenRecords", l6);
                jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder6.build());
                JsonObjectBuilder jsonObjectBuilder7 = Json.createObjectBuilder().add("MaxWrittenRec", l7);
                jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder7.build());
            }
            if (variable.checkPadValueExistence()) {
                jsonObjectBuilder = Json.createObjectBuilder();
                object = variable.getPadValue();
                jsonObjectBuilder = (JsonObjectBuilder)CDF2Json.printSingleData(jsonObjectBuilder, "PadValue", object, l3, l4, -1L, withz ? "Z" : "", string, null, false);
                jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder.build());
            }
            if ((l = variable.getBlockingFactor()) > 0L) {
                jsonObjectBuilder = Json.createObjectBuilder().add("BlockingFactor", l);
                jsonArrayBuilder2.add((JsonValue)jsonObjectBuilder.build());
            }
            return jsonArrayBuilder2;
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVariables");
            System.out.println(exception);
            System.exit(1);
            return null;
        }
    }

    private static JsonArrayBuilder printVarAttributes(Variable variable, String string, Object object) {
        Attribute attribute = null;
        Entry entry = null;
        String string2 = null;
        try {
            Vector vector = variable.getAttributes();
            if (vector.size() == 0) {
                return null;
            }
            long l = variable.getDataType();
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                string2 = attribute.getName();
                try {
                    entry = attribute.getEntry(variable);
                    if (entry == null) continue;
                    long l2 = entry.getDataType();
                    long l3 = entry.getNumElements();
                    Object object2 = entry.getData();
                    JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
                    jsonObjectBuilder = (JsonObjectBuilder)CDF2Json.printSingleData(jsonObjectBuilder, string2, object2, l2, l3, l, withz ? "Z" : "", string, object, false);
                    jsonArrayBuilder.add((JsonValue)jsonObjectBuilder.build());
                }
                catch (CDFException cDFException) {}
            }
            return jsonArrayBuilder;
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVarAttributes");
            System.out.println("attr= " + string2 + " entry =" + entry.getName());
            System.out.println(exception);
            System.exit(1);
            return null;
        }
    }

    private static JsonArrayBuilder printEmptyAttributes() {
        long l;
        Attribute attribute;
        Vector vector = cdf.getGlobalAttributes();
        Vector vector2 = cdf.getVariableAttributes();
        JsonArrayBuilder jsonArrayBuilder = null;
        JsonArrayBuilder jsonArrayBuilder2 = null;
        JsonArrayBuilder jsonArrayBuilder3 = null;
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            attribute = (Attribute)enumeration.nextElement();
            l = attribute.getNumEntries();
            if (l != 0L) continue;
            if (++n == 1) {
                jsonArrayBuilder2 = Json.createArrayBuilder();
            }
            jsonArrayBuilder2.add(attribute.getName());
        }
        if (n != 0) {
            jsonArrayBuilder = Json.createArrayBuilder();
            jsonArrayBuilder.add((JsonValue)Json.createObjectBuilder().add("GlobalAttributes", jsonArrayBuilder2).build());
        }
        n = 0;
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            attribute = (Attribute)enumeration.nextElement();
            l = attribute.getNumEntries();
            if (l != 0L) continue;
            if (++n == 1) {
                jsonArrayBuilder3 = Json.createArrayBuilder();
            }
            jsonArrayBuilder3.add(attribute.getName());
        }
        if (n != 0) {
            if (jsonArrayBuilder == null) {
                jsonArrayBuilder = Json.createArrayBuilder();
            }
            jsonArrayBuilder.add((JsonValue)Json.createObjectBuilder().add("VariableAttributes", jsonArrayBuilder3).build());
        }
        return jsonArrayBuilder;
    }

    private static JsonArrayBuilder printVarData(Variable variable, String string, Object object) {
        try {
            long[] lArray = new long[]{1L};
            long[] lArray2 = new long[]{0L};
            long[] lArray3 = new long[]{1L};
            long[] lArray4 = null;
            long l = variable.getMaxWrittenRecord();
            if (l < 0L) {
                return null;
            }
            boolean bl = variable.getRecVariance();
            long l2 = variable.getNumDims();
            lArray = variable.getDimSizes();
            long l3 = variable.getNumElements();
            long l4 = variable.getDataType();
            long[] lArray5 = variable.getDimVariances();
            long l5 = 1L;
            if (numDimsN > 0L) {
                lArray3 = new long[(int)numDimsN];
                lArray2 = new long[(int)numDimsN];
                lArray4 = new long[(int)numDimsN];
                int n = 0;
                int n2 = 0;
                while ((long)n2 < numDimsN) {
                    if (lArray5[n2] == -1L) {
                        lArray4[n] = lArray[n2];
                        ++n;
                    }
                    lArray3[n2] = 1L;
                    lArray2[n2] = 0L;
                    l5 *= lArray[n2];
                    ++n2;
                }
            }
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            long l6 = variable.getSparseRecords();
            long l7 = l6 == 0L ? (long)(numDimsN == 0L ? 1000 : 200) : 1L;
            int n = 0;
            while ((long)n <= l) {
                long l8 = (long)n + l7 > l ? l - (long)n + 1L : l7;
                CDFData cDFData = numDimsN > 0L ? variable.getHyperDataObject((long)n, l8, 1L, lArray2, lArray, lArray3) : variable.getRecordsObject((long)n, l8);
                long l9 = cdf.getStatus();
                Object object2 = cDFData.getData();
                int n3 = 0;
                while ((long)n3 < l8) {
                    Object object3;
                    Object object4;
                    if (l8 > 1L) {
                        if (l4 != 32L) {
                            object4 = Array.get(object2, n3);
                        } else {
                            object3 = new double[]{(Double)Array.get(object2, 2 * n3), (Double)Array.get(object2, 2 * n3 + 1)};
                            object4 = object3;
                        }
                    } else {
                        object4 = object2;
                    }
                    if (numDimsN > 0L && l2 != numDimsN) {
                        for (long i = l2; i != numDimsN; --i) {
                            object4 = Array.get(object4, 0);
                        }
                    }
                    if (numDimsN < 2L) {
                        boolean bl2 = false;
                        if (!bl || l == 0L) {
                            bl2 = true;
                        }
                        jsonArrayBuilder = (JsonArrayBuilder)CDF2Json.printSingleData(jsonArrayBuilder, null, object4, l4, numDimsN, -1L, withz ? "Z" : "", string, object, bl2);
                    } else {
                        object3 = CDF2Json.printMultipleData(object4, l4, (int)numDimsN, lArray, withz ? "Z" : "", string, object);
                        if (!bl || l == 0L) {
                            return object3;
                        }
                        jsonArrayBuilder.add((JsonArrayBuilder)object3);
                    }
                    ++n3;
                }
                n = (int)((long)n + l7);
            }
            return jsonArrayBuilder;
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVarData");
            System.out.println("variable: " + variable.getName());
            System.out.println(exception);
            System.exit(1);
            return null;
        }
    }

    private static String getDefaultOutputFileName() {
        int n;
        String string;
        boolean bl;
        int n2 = inFile.lastIndexOf(".cdf");
        int n3 = inFile.lastIndexOf(".CDF");
        boolean bl2 = bl = inFile.endsWith(".cdf") || inFile.endsWith(".CDF");
        if (!bl) {
            string = inFile + ".json";
        } else if (n2 != -1) {
            string = inFile.substring(0, n2);
            string = string + ".json";
        } else {
            string = inFile.substring(0, n3);
            string = string + ".json";
        }
        if (!fullpath && (n = string.lastIndexOf(separator)) != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private static String removeFilePath(String string) {
        int n = string.lastIndexOf(separator);
        string = string.substring(n + 1);
        return string;
    }

    private static void exit(String string) {
        if (!string.equals("")) {
            System.out.println(string);
        }
        CDF2Json.usage();
        System.exit(1);
    }

    private static void usage() {
        System.out.println("\nDescription:");
        System.out.println("    This program exports the contents of a CDF file(s) into a single Json file.");
        System.out.println("    The Json file will have an \".json\" extension if it is not specified. ");
        System.out.println(" ");
        System.out.println("Usage: java CDF2Json [Options] [cdfFile1 cdfFile2 ...]");
        System.out.println("");
        System.out.println("    cdfFile1 cdfFile2 .... ");
        System.out.println("       Command line input CDF file(s) for conversion. A maximum of 100 ");
        System.out.println("       files can be specified.");
        System.out.println("       If the \"output\" option is not specified, the first file in the list is");
        System.out.println("       used as the the output Json file name.");
        System.out.println("       Alternatively, use \"fileNames\" option to specify a text file");
        System.out.println("       that contains the CDF name(s) for conversion. Command line file(s) and");
        System.out.println("       fileNames option are mutually exclusive.");
        System.out.println(" ");
        System.out.println("Options:");
        System.out.println(" ");
        System.out.println("   -fileNames:fileNames");
        System.out.println("       fileNames is a text file that contains the input CDF file name(s)");
        System.out.println("       for converting into a Json file. With this option, there is no need to");
        System.out.println("       enter the file(s) in the command line.If the output Json file is not");
        System.out.println("       specified, this file is used as the name of the Json output.");
        System.out.println(" ");
        System.out.println("   -globalAttrs:[yes | no].  -globalAttrs:yes is the default.");
        System.out.println("      -globalAttrs:yes extracts all global attributes.");
        System.out.println("      -globalAttrs:no doesn't extract global attributes.");
        System.out.println(" ");
        System.out.println("   -varAttrs:[yes | no].  -varAttrs:yes is the default.");
        System.out.println("      -varAttrs:yes extracts each variable's attributes.");
        System.out.println("      -varAttrs:no doesn't extract variable's attributes.");
        System.out.println(" ");
        System.out.println("   -vars:var1,var2,....");
        System.out.println("      -vars:var1,var2,... extracts only the specified variables with");
        System.out.println("                           variable names separated by a single ','.");
        System.out.println(" ");
        System.out.println("   -varData:[yes | no].  -varData:yes is the default.");
        System.out.println("      -varData:yes extracts each variable's data");
        System.out.println("      -varData:no doesn't extract record-varying variable's data");
        System.out.println(" ");
        System.out.println("   -format:[yes | no | prefer].  -format:prefer is the default.");
        System.out.println("      -format:yes uses variable attribute FORMAT to encode data");
        System.out.println("      -format:prefer uses variable attribute FORMAT to encode data.");
        System.out.println("                     However, if its FORMAT is not properly defined, it");
        System.out.println("                     is treated as \"no\".");
        System.out.println("      -format:no uses Java internal encoding to encode data");
        System.out.println("      Note: The format is only relevant to floating-point values.");
        System.out.println(" ");
        System.out.println("   -encodeepoch:[yes | no].  -encodeepoch:yes is the default.");
        System.out.println("      -encodeepoch:yes encodes CDF epoch data values in time string");
        System.out.println("      -encodeepoch:no  shows CDF epoch values in their original data form");
        System.out.println(" ");
        System.out.println("   -[output | json]:outputFileName");
        System.out.println("      The name of the input CDF file is used as the default output file");
        System.out.println("      name.  Use this option to specify a different output file name.");
        System.out.println(" ");
        System.out.println("   -[showProgress | Progress]");
        System.out.println("      This option displays the processing progress on the screen.");
        System.out.println("      It shows how many CDF variables are there to process and which");
        System.out.println("      variable is being processed.");
        System.out.println(" ");
        System.out.println("   -debug");
        System.out.println("      Displays the specifications to run the application.");
        System.out.println(" ");
        System.out.println("   -withZ");
        System.out.println("      Adding \"Z\" to the encoded CDF epoch data of ISO 8601 form.");
        System.out.println("");
        System.out.println("   -delete");
        System.out.println("      Over-ride the existing Json file.");
        System.out.println("");
        System.out.println("   -nofullpath");
        System.out.println("      Only use the file name portion of the entered full path name as");
        System.out.println("      the key to each CDF in the Json output. ");
        System.out.println("");
        System.out.println("   -showfile");
        System.out.println("      Display the file name(s) being processed.");
        System.out.println("");
        System.out.println("NOTE:");
        System.out.println("");
        System.out.println("  1. Variable's non-varying dimension(s) is ignored. A varying dimension");
        System.out.println("     with a size of only 1 is also considered a non-varying dimension.");
        System.out.println("  2. NaN|-NaN and INF|-INF, valid floating-point values in CDF, but are not");
        System.out.println("     allowed in Json. They are replaced by strings \"NaN\"|\"-NaN\" and ");
        System.out.println("     \"INF\"|\"-INF\". Try to avoid using any of these as it might cause");
        System.out.println("     unexpected results if such Json file is converted back to CDF.");
        System.out.println("  3. Only value, without the data type, from meta-data is presented in the");
        System.out.println("     Json output.");
        System.out.println("  4. Use CDFJsonReader to display the Json file in a easy to read form.");
        System.out.println("");
        System.out.println("Examples: ");
        System.out.println("   java CDF2Json test.cdf (same as java CDF2Json -json:test.json test.cdf)");
        System.out.println("   java CDFJsonReader test.json ");
        System.out.println(" ");
        System.out.println("The CDF's Json file has the following form: ");
        System.out.println(" ");
        System.out.println(" CDFname1:    <== CDF file name key\n   CDFFileInfo:\n     FileVersion:.....\n     Format:.....\n     Majority:...\n     Encoding:.....\n   CDFglobalAttributes:\n     Gattr_name1:\n       entry#:value\n       ...\n       ...\n     Gattr_name2:\n       entry#:value\n       ...\n       ...\n   ...\n   ...\n   CDFVariables:\n     VarName1:  <== Variable name key\n       VarDescription:\n         DataType:....\n         ...\n         ...\n       VarAttributes:\n         VALIDMIN:....\n         VALIDMAX:....\n         ...\n         ...\n       VarData:\n       ...\n     VarName2:\n       VarDescription:\n         DataType:....\n         ...\n         ...\n       VarAttributes:\n         VALIDMIN:....\n         VALIDMAX:....\n         ...\n         ...\n       VarData:\n         ...\n   EmptyAttributes:  <== Exists if there are attributes defined but no values\n     GlobalAttributes: [...]\n     VariableAttributes: [...]\n \n CDFname2:\n   ...\n   ...\n ...\n ...\n ");
    }

    private static JsonArrayBuilder printMultipleData(Object object, long l, int n, long[] lArray, String string, String string2, Object object2) {
        int n2;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)lArray[i];
        }
        Object[] objectArray = null;
        Object[] objectArray2 = new Object[n - 1];
        int[] nArray2 = new int[n - 1];
        long[] lArray2 = new long[n - 1];
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        objectArray2[0] = object;
        nArray2[0] = 0;
        lArray2[0] = CDF2Json.product(nArray, 0, n);
        for (n2 = 1; n2 < n - 1; ++n2) {
            objectArray2[n2] = Array.get(objectArray2[n2 - 1], 0);
            lArray2[n2] = CDF2Json.product(nArray, n2, n);
            nArray2[n2] = 0;
        }
        n2 = 0;
        Object object3 = object;
        while ((long)n2 < lArray2[0]) {
            int n3;
            int n4;
            if (n2 != 0) {
                for (n4 = 0; n4 < n - 1; ++n4) {
                    boolean bl;
                    boolean bl2 = bl = (long)n2 % lArray2[n4] == 0L;
                    if (bl) {
                        int n5 = n4;
                        nArray2[n5] = nArray2[n5] + 1;
                        objectArray2[n4] = object3 = Array.get(object3, nArray2[n4]);
                        for (n3 = n4 + 1; n3 < n - 1; ++n3) {
                            nArray2[n3] = 0;
                            objectArray2[n3] = Array.get(objectArray2[n3 - 1], nArray2[n3]);
                        }
                        break;
                    }
                    object3 = objectArray2[n4];
                }
            }
            for (n4 = 0; n4 < nArray[n - 2]; ++n4) {
                switch ((int)l) {
                    case 51: 
                    case 52: {
                        objectArray = (String[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            jsonArrayBuilder.add(objectArray[n3]);
                        }
                        break;
                    }
                    case 1: 
                    case 41: {
                        objectArray = (byte[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            jsonArrayBuilder.add(new Byte(((byte[])objectArray)[n3]).intValue());
                        }
                        break;
                    }
                    case 2: {
                        objectArray = (short[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            jsonArrayBuilder.add(new Short(((short[])objectArray)[n3]).intValue());
                        }
                        break;
                    }
                    case 11: {
                        objectArray = (short[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            if (((short[])objectArray)[n3] >= 0) {
                                jsonArrayBuilder.add(new Short(((short[])objectArray)[n3]).intValue());
                                continue;
                            }
                            short s = (short)(((short[])objectArray)[n3] + 256);
                            jsonArrayBuilder.add((int)s);
                        }
                        break;
                    }
                    case 4: {
                        objectArray = (int[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            jsonArrayBuilder.add(((int[])objectArray)[n3]);
                        }
                        break;
                    }
                    case 12: {
                        objectArray = (int[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            if (((int[])objectArray)[n3] >= 0) {
                                jsonArrayBuilder.add(((int[])objectArray)[n3]);
                                continue;
                            }
                            int n6 = ((int[])objectArray)[n3] + 65536;
                            jsonArrayBuilder.add(n6);
                        }
                        break;
                    }
                    case 14: {
                        objectArray = (long[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            if (((long[])objectArray)[n3] >= 0L) {
                                jsonArrayBuilder.add(((long[])objectArray)[n3]);
                                continue;
                            }
                            long l2 = ((long[])objectArray)[n3] + 0x100000000L;
                            jsonArrayBuilder.add(l2);
                        }
                        break;
                    }
                    case 8: 
                    case 33: {
                        objectArray = (long[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            if (l == 8L) {
                                jsonArrayBuilder.add(((long[])objectArray)[n3]);
                                continue;
                            }
                            jsonArrayBuilder.add(CDFTT2000.encode((long)((long[])objectArray)[n3]) + string);
                        }
                        break;
                    }
                    case 21: 
                    case 44: {
                        Object object4;
                        objectArray = (float[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            float f = ((float[])objectArray)[n3];
                            if (string2 == null || f == -1.0E31f || f == 1.0E30f) {
                                jsonArrayBuilder.add((double)f);
                                continue;
                            }
                            if (Float.isNaN(f)) {
                                jsonArrayBuilder.add("NaN");
                                continue;
                            }
                            if (Float.isNaN(-f)) {
                                jsonArrayBuilder.add("-NaN");
                                continue;
                            }
                            if (Float.isInfinite(f)) {
                                jsonArrayBuilder.add("INF");
                                continue;
                            }
                            if (Float.isInfinite(-f)) {
                                jsonArrayBuilder.add("-INF");
                                continue;
                            }
                            try {
                                object4 = String.format(string2, Float.valueOf(f));
                                jsonArrayBuilder.add(new Double((String)object4).doubleValue());
                                continue;
                            }
                            catch (Exception exception) {
                                jsonArrayBuilder.add((double)f);
                            }
                        }
                        break;
                    }
                    case 22: 
                    case 45: {
                        objectArray = (double[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            double d = ((double[])objectArray)[n3];
                            if (string2 == null || d == -1.0E31 || d == 1.0E30) {
                                jsonArrayBuilder.add(d);
                                continue;
                            }
                            if (Double.isNaN(d)) {
                                jsonArrayBuilder.add("NaN");
                                continue;
                            }
                            if (Double.isNaN(-d)) {
                                jsonArrayBuilder.add("-NaN");
                                continue;
                            }
                            if (Double.isInfinite(d)) {
                                jsonArrayBuilder.add("INF");
                                continue;
                            }
                            if (Double.isInfinite(-d)) {
                                jsonArrayBuilder.add("-INF");
                                continue;
                            }
                            try {
                                String string3 = String.format(string2, d);
                                jsonArrayBuilder.add(new Double(string3).doubleValue());
                                continue;
                            }
                            catch (Exception exception) {
                                jsonArrayBuilder.add(d);
                            }
                        }
                        break;
                    }
                    case 31: {
                        objectArray = (double[])Array.get(objectArray2[n - 2], n4);
                        for (n3 = 0; n3 < nArray[n - 1]; ++n3) {
                            if (encodeEp) {
                                jsonArrayBuilder.add(Epoch.encode4((double)((double[])objectArray)[n3]) + string);
                                continue;
                            }
                            jsonArrayBuilder.add(((double[])objectArray)[n3]);
                        }
                        break;
                    }
                    case 32: {
                        Object object4;
                        double[] dArray = new double[2];
                        objectArray = (double[])Array.get(objectArray2[n - 2], n4);
                        for (int i = 0; i < nArray[n - 1]; ++i) {
                            dArray[0] = ((double[])objectArray)[2 * i];
                            dArray[1] = ((double[])objectArray)[2 * i + 1];
                            if (encodeEp) {
                                jsonArrayBuilder.add(Epoch16.encode4((Object)dArray) + string);
                                continue;
                            }
                            object4 = Json.createArrayBuilder();
                            object4.add(dArray[0]);
                            object4.add(dArray[1]);
                            jsonArrayBuilder.add((JsonValue)object4.build());
                        }
                        break;
                    }
                }
                n2 += nArray[n - 1];
            }
        }
        return jsonArrayBuilder;
    }

    private static long product(int[] nArray, int n, int n2) {
        long l = 1L;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] <= 1) continue;
            l *= (long)nArray[i];
        }
        return l;
    }

    private static boolean validORscaleORfill(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).equals("validmin") || string.equals("validmax") || string.equals("scalemin") || string.equals("scalemax") || string.equals("fillval");
    }

    private static boolean isEpochDataType(long l) {
        return l == 31L || l == 31L || l == 33L;
    }

    private static Object printSingleData(Object object, String string, Object object2, long l, long l2, long l3, String string2, String string3, Object object3, boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = l == 31L ? 1 : (l == 32L ? 2 : (l == 33L ? 3 : 0));
        int n3 = 1;
        if (n2 == 2) {
            n3 = 2;
        }
        boolean bl3 = false;
        String string4 = CDFUtils.getSignature((Object)object2);
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        if (object instanceof JsonObjectBuilder) {
            jsonObjectBuilder = (JsonObjectBuilder)object;
        } else {
            jsonArrayBuilder = (JsonArrayBuilder)object;
        }
        if (string4.charAt(0) == '[') {
            n = Array.getLength(object2);
            if (n2 == 2) {
                n /= 2;
            }
            if (n > 1) {
                bl3 = true;
            }
            if (n2 != 2) {
                bl2 = true;
            }
        }
        if (bl3) {
            JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
            n = Array.getLength(object2);
            for (int i = 0; i < n; i += n3) {
                String string5;
                if (string4.charAt(1) == 'B') {
                    jsonArrayBuilder2.add((int)Array.getByte(object2, i));
                    continue;
                }
                if (string4.charAt(1) == 'S') {
                    jsonArrayBuilder2.add((int)Array.getShort(object2, i));
                    continue;
                }
                if (string4.charAt(1) == 'I') {
                    jsonArrayBuilder2.add(Array.getInt(object2, i));
                    continue;
                }
                if (string4.charAt(1) == 'J') {
                    if (n2 == 3 || CDF2Json.isEpochDataType(l3) && CDF2Json.validORscaleORfill(string)) {
                        if (encodeEp) {
                            jsonArrayBuilder2.add(CDFTT2000.encode((long)Array.getLong(object2, i)) + string2);
                            continue;
                        }
                        jsonArrayBuilder2.add(Array.getLong(object2, i));
                        continue;
                    }
                    jsonArrayBuilder2.add(Array.getLong(object2, i));
                    continue;
                }
                if (string4.charAt(1) == 'F') {
                    float f = Array.getFloat(object2, i);
                    if (Float.isNaN(f)) {
                        jsonArrayBuilder2.add("NaN");
                        continue;
                    }
                    if (Float.isNaN(-f)) {
                        jsonArrayBuilder2.add("-NaN");
                        continue;
                    }
                    if (Float.isInfinite(f)) {
                        jsonArrayBuilder2.add("INF");
                        continue;
                    }
                    if (Float.isInfinite(-f)) {
                        jsonArrayBuilder2.add("-INF");
                        continue;
                    }
                    double d = f == -1.0E30f ? -1.0E30 : (f == -1.0E31f ? -1.0E31 : (f == 1.0E30f ? 1.0E30 : (f == 1.0E31f ? 1.0E31 : (double)f)));
                    if (string3 == null) {
                        jsonArrayBuilder2.add(d);
                        continue;
                    }
                    try {
                        string5 = String.format(string3, d);
                        jsonArrayBuilder2.add(new Double(string5).doubleValue());
                    }
                    catch (Exception exception) {
                        jsonArrayBuilder2.add(d);
                    }
                    continue;
                }
                if (string4.charAt(1) == 'D') {
                    Object object4;
                    double d = Array.getDouble(object2, i);
                    if (n2 == 1 || CDF2Json.isEpochDataType(l3) && CDF2Json.validORscaleORfill(string)) {
                        if (encodeEp) {
                            jsonArrayBuilder2.add(Epoch.encode4((double)d) + string2);
                            continue;
                        }
                        jsonArrayBuilder2.add(d);
                        continue;
                    }
                    if (n2 == 2 || CDF2Json.isEpochDataType(l3) && CDF2Json.validORscaleORfill(string)) {
                        object4 = new double[]{Array.getDouble(object2, i), Array.getDouble(object2, i + 1)};
                        if (encodeEp) {
                            jsonArrayBuilder2.add(Epoch16.encode4((Object)object4) + string2);
                            continue;
                        }
                        string5 = Json.createArrayBuilder();
                        string5.add(object4[0]);
                        string5.add(object4[1]);
                        jsonArrayBuilder2.add((JsonValue)string5.build());
                        continue;
                    }
                    if (Double.isNaN(d)) {
                        jsonArrayBuilder2.add("NaN");
                        continue;
                    }
                    if (Double.isNaN(-d)) {
                        jsonArrayBuilder2.add("-NaN");
                        continue;
                    }
                    if (Double.isInfinite(d)) {
                        jsonArrayBuilder2.add("INF");
                        continue;
                    }
                    if (Double.isInfinite(-d)) {
                        jsonArrayBuilder2.add("-INF");
                        continue;
                    }
                    if (string3 == null) {
                        jsonArrayBuilder2.add(d);
                        continue;
                    }
                    try {
                        object4 = String.format(string3, d);
                        jsonArrayBuilder2.add(new Double((String)object4).doubleValue());
                    }
                    catch (Exception exception) {
                        jsonArrayBuilder2.add(d);
                    }
                    continue;
                }
                if (string4.indexOf("String") == -1) continue;
                jsonArrayBuilder2.add(((String[])object2)[i]);
            }
            if (string != null) {
                return jsonObjectBuilder.add(string, jsonArrayBuilder2);
            }
            if (bl) {
                return jsonArrayBuilder2;
            }
            return jsonArrayBuilder.add(jsonArrayBuilder2);
        }
        if (string4.charAt(0) == '[' && n2 != 2) {
            object2 = Array.get(object2, 0);
        }
        if (n2 == 1) {
            if (string != null) {
                if (encodeEp) {
                    return jsonObjectBuilder.add(string, Epoch.encode4((double)((Double)object2)) + string2);
                }
                return jsonObjectBuilder.add(string, ((Double)object2).doubleValue());
            }
            if (encodeEp) {
                return jsonArrayBuilder.add(Epoch.encode4((double)((Double)object2)) + string2);
            }
            return jsonArrayBuilder.add(((Double)object2).doubleValue());
        }
        if (n2 == 2) {
            if (string != null) {
                if (encodeEp) {
                    return jsonObjectBuilder.add(string, Epoch16.encode4((Object)((double[])object2)) + string2);
                }
                JsonArrayBuilder jsonArrayBuilder3 = Json.createArrayBuilder();
                jsonArrayBuilder3.add(((double[])object2)[0]);
                jsonArrayBuilder3.add(((double[])object2)[1]);
                return jsonObjectBuilder.add(string, (JsonValue)jsonArrayBuilder3.build());
            }
            if (encodeEp) {
                return jsonArrayBuilder.add(Epoch16.encode4((Object)((double[])object2)) + string2);
            }
            JsonArrayBuilder jsonArrayBuilder4 = Json.createArrayBuilder();
            jsonArrayBuilder4.add(((double[])object2)[0]);
            jsonArrayBuilder4.add(((double[])object2)[1]);
            return jsonArrayBuilder.add((JsonValue)jsonArrayBuilder4.build());
        }
        if (n2 == 3) {
            if (string != null) {
                if (encodeEp) {
                    return jsonObjectBuilder.add(string, CDFTT2000.encode((long)((Long)object2)) + string2);
                }
                return jsonObjectBuilder.add(string, ((Long)object2).longValue());
            }
            if (encodeEp) {
                return jsonArrayBuilder.add(CDFTT2000.encode((long)((Long)object2)) + string2);
            }
            return jsonArrayBuilder.add(((Long)object2).longValue());
        }
        if (string4.indexOf("Byte") != -1) {
            int n4 = ((Byte)object2).intValue();
            if (string != null) {
                return jsonObjectBuilder.add(string, n4);
            }
            return jsonArrayBuilder.add(n4);
        }
        if (string4.indexOf("Short") != -1) {
            int n5 = ((Short)object2).intValue();
            if (string != null) {
                return jsonObjectBuilder.add(string, n5);
            }
            return jsonArrayBuilder.add(n5);
        }
        if (string4.indexOf("Int") != -1) {
            int n6 = (Integer)object2;
            if (string != null) {
                return jsonObjectBuilder.add(string, n6);
            }
            return jsonArrayBuilder.add(n6);
        }
        if (string4.indexOf("Long") != -1) {
            long l4 = (Long)object2;
            if (string != null) {
                if (CDF2Json.isEpochDataType(l3) && CDF2Json.validORscaleORfill(string)) {
                    return jsonObjectBuilder.add(string, CDFTT2000.encode((long)l4) + string2);
                }
                return jsonObjectBuilder.add(string, l4);
            }
            if (CDF2Json.isEpochDataType(l3) && CDF2Json.validORscaleORfill(string)) {
                return jsonArrayBuilder.add(CDFTT2000.encode((long)l4) + string2);
            }
            return jsonArrayBuilder.add(l4);
        }
        if (string4.indexOf("Float") != -1) {
            float f = ((Float)object2).floatValue();
            if (Float.isNaN(f)) {
                if (string != null) {
                    return jsonObjectBuilder.add(string, "NaN");
                }
                return jsonArrayBuilder.add("NaN");
            }
            if (Float.isNaN(-f)) {
                if (string != null) {
                    return jsonObjectBuilder.add(string, "-NaN");
                }
                return jsonArrayBuilder.add("-NaN");
            }
            if (Float.isInfinite(f)) {
                if (string != null) {
                    return jsonObjectBuilder.add(string, "INF");
                }
                return jsonArrayBuilder.add("INF");
            }
            if (Float.isInfinite(-f)) {
                if (string != null) {
                    return jsonObjectBuilder.add(string, "-INF");
                }
                return jsonArrayBuilder.add("-INF");
            }
            double d = f == -1.0E30f ? -1.0E30 : (f == -1.0E31f ? -1.0E31 : (f == 1.0E30f ? 1.0E30 : (f == 1.0E31f ? 1.0E31 : (double)f)));
            if (string != null) {
                if (string3 == null) {
                    return jsonObjectBuilder.add(string, d);
                }
                try {
                    String string6 = String.format(string3, d);
                    return jsonObjectBuilder.add(string, new Double(string6).doubleValue());
                }
                catch (Exception exception) {
                    return jsonObjectBuilder.add(string, d);
                }
            }
            if (string3 == null) {
                return jsonArrayBuilder.add(d);
            }
            try {
                String string7 = String.format(string3, d);
                return jsonArrayBuilder.add(new Double(string7).doubleValue());
            }
            catch (Exception exception) {
                return jsonArrayBuilder.add(d);
            }
        }
        if (string4.indexOf("Double") != -1) {
            double d = (Double)object2;
            if (Double.isNaN(d)) {
                if (string != null) {
                    return jsonObjectBuilder.add(string, "NaN");
                }
                return jsonArrayBuilder.add("NaN");
            }
            if (Double.isNaN(-d)) {
                if (string != null) {
                    return jsonObjectBuilder.add(string, "NaN");
                }
                return jsonArrayBuilder.add("-NaN");
            }
            if (Double.isInfinite(d)) {
                if (string != null) {
                    return jsonObjectBuilder.add(string, "INF");
                }
                return jsonArrayBuilder.add("INF");
            }
            if (Double.isInfinite(-d)) {
                if (string != null) {
                    return jsonObjectBuilder.add(string, "-INF");
                }
                return jsonArrayBuilder.add("-INF");
            }
            if (string != null) {
                if (string3 == null) {
                    if (CDF2Json.isEpochDataType(l3) && CDF2Json.validORscaleORfill(string)) {
                        return jsonObjectBuilder.add(string, Epoch.encode4((double)d) + string2);
                    }
                    return jsonObjectBuilder.add(string, d);
                }
                try {
                    String string8 = String.format(string3, d);
                    if (CDF2Json.isEpochDataType(l3) && CDF2Json.validORscaleORfill(string)) {
                        return jsonObjectBuilder.add(string, Epoch.encode4((double)new Double(string8)) + string2);
                    }
                    return jsonObjectBuilder.add(string, new Double(string8).doubleValue());
                }
                catch (Exception exception) {
                    if (CDF2Json.isEpochDataType(l3) && CDF2Json.validORscaleORfill(string)) {
                        return jsonObjectBuilder.add(string, Epoch.encode4((double)d) + string2);
                    }
                    return jsonObjectBuilder.add(string, d);
                }
            }
            if (string3 == null) {
                return jsonArrayBuilder.add(d);
            }
            try {
                String string9 = String.format(string3, d);
                return jsonArrayBuilder.add(new Double(string9).doubleValue());
            }
            catch (Exception exception) {
                return jsonArrayBuilder.add(d);
            }
        }
        if (string4.indexOf("String") != -1) {
            if (string != null) {
                return jsonObjectBuilder.add(string, (String)object2);
            }
            return jsonArrayBuilder.add((String)object2);
        }
        return null;
    }

    private static String toCformat(String string) {
        if (string.charAt(0) == '%') {
            return string;
        }
        if ((string = string.trim()) == null) {
            return null;
        }
        int n = string.length();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || c == '(') continue;
            string2 = string.substring(i);
            if (!string2.endsWith(")")) break;
            string2 = string2.substring(0, string2.length() - 1);
            break;
        }
        if (string2 == null) {
            return null;
        }
        switch (string2.charAt(0)) {
            case 'I': 
            case 'i': {
                String string3 = string2.substring(1);
                return "%" + string3 + "d";
            }
            case 'F': 
            case 'f': {
                String string4 = string2.substring(1);
                return "%" + string4 + "f";
            }
            case 'E': 
            case 'e': {
                String string5 = string2.substring(1);
                return "%" + string5 + "e";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFileNames(String string) {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            numFiles = 0;
            fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (CDFUtils.cdfFileExists((String)string2)) {
                    ++numFiles;
                }
                string2 = bufferedReader.readLine();
            }
            if (numFiles == 0) {
                System.out.println("*** No CDF file(s) is found... ");
                System.exit(1);
            }
            fileNames = new String[numFiles];
            int n = 0;
            fileInputStream.getChannel().position(0L);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (CDFUtils.cdfFileExists((String)string2)) {
                    CDF2Json.fileNames[n] = string2;
                    ++n;
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            System.out.println("error: " + exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static {
        fileNames = null;
        numFiles = 0;
        item0 = "CDF";
        item1 = "CDFFileInfo";
        item2 = "CDFglobalAttributes";
        item3 = "CDFVariables";
        item4 = "VarDescription";
        item5 = "VarAttributes";
        item6 = "VarData";
        item7 = "EmptyAttributes";
        item8 = "GlobalAttributes";
        item9 = "VariableAttributes";
        separator = System.getProperty("file.separator");
    }
}

