/*****************************************************************************e
*
*  NSSDC/CDF                   Quick Start Test Program(C# interface).
*
*  Version 1.0,15-Oct-09,Mike Liu
*
*  Modification history:
*
*   V1.0   15-Oct-09,M Liu     Original version(for CDF V3.3).
*                              Using "out" modifier for arguments for
*                              retrieving data fields and values to C# APIs.
*
******************************************************************************/

using System;
using System.Runtime.InteropServices;
using CDF;

public class Qst2cs2 : CDFAPIs {

unsafe public static void Main() {
  void* id;
  int status;

  int N_DIMS = 2;
  int DIM_0_SIZE = 2;
  int DIM_1_SIZE = 3;

  int zN_DIMSa = 1;
  int zDIM_0_SIZEa = 5;
  int zNUM_ELEMSa = 8;

  int    dim_n;
  int    encoding = NETWORK_ENCODING;
  int    actual_encoding = NETWORK_ENCODING;
  int    majority = ROW_MAJOR;
  int    numDims = N_DIMS;
  int[]  dimSizes = new int[2] { 2,3 };
  int    zNumDimsA = zN_DIMSa;
  int[]  zDimSizesA = new int[1] { 5 };
  int    var1DataType = CDF_INT2;
  int    var1DataTypeNew = CDF_UINT2;
  int    var2DataType = CDF_REAL4;
  int    var3DataType = CDF_CHAR;
  int    var3DataTypeNew = CDF_UCHAR;
  int    var1NumElements = 1;
  int    var2NumElements = 1;
  int    var3NumElements = zNUM_ELEMSa;
  int    var3NumElementsNew = zNUM_ELEMSa;
  short[,] var1Values = new short[2,3] {{1,2,3},{4,5,6}};
  float[,] var2Values = new float[2,3] {{1.0F,2.0F,3.0F},
                                      {4.0F,5.0F,6.0F}};
  string[] var3Values = new string[5] {
    "11111111","22222222","33333333","44444444","55555555"};
  int    recNum = 0;
  int    recStart = 2;
  int    recCount = 1;
  int    recInterval = 1;
  int[]  indices = new int[2];
  int[]  counts = new int[2] { 2,3 };
  int[]  intervals = new int[2] { 1,1 };
  int[]  zIndicesA = new int[1];
  int[]  zCounts = new int[1] { 5 };
  int[]  zIntervals = new int[1] { 1 };
  int    entryNum = 2;
  int    attrScope = GLOBAL_SCOPE;
  int    attrScope2 = VARIABLE_SCOPE;
  int    attrScope3 = VARIABLE_SCOPE;
  int    entryDataType = CDF_INT2;
  int    entryDataTypeNew = CDF_UINT2;
  int    entryNumElems = 1;
  short  entryValue = 1;
  int    x0,x1;
  int    var1Num_out,var2Num_out,var3Num_out,attrNum_out;
  int    var1RecVariance = VARY;
  int    var1RecVarianceNew = NOVARY;
  int    var2RecVariance = VARY;
  int    var3RecVariance = VARY;
  int    var3RecVarianceNew = NOVARY;
  int[]  var1DimVariances = new int[2] { VARY,VARY };
  int[]  var1DimVariancesNew = new int[2] { NOVARY,NOVARY };
  int[]  var2DimVariances = new int[2] { VARY,VARY };
  int[]  var3DimVariances = new int[1] { VARY };
  int[]  var3DimVariancesNew = new int[1] { NOVARY };
  string var1Name = "VAR1a";
  string var2Name = "VAR2a";
  string var3Name = "zVARa1";
  string new_var1Name = "VAR1b";
  string new_var2Name = "VAR2b";
  string new_var3Name = "zVARa2";
  string attrName = "ATTR1";
  string attrName2 = "ATTR2";
  string attrName3 = "ATTR3";
  string new_attrName = "ATTR1a";
  string CopyrightText;
  string errorText;
  sbyte  zEntryValue1 = 4;
  double zEntryValue2 = 5.0;
  short  pad1 = -999;
  float  pad2 = -8.0F;
  string pad3 = "********";
  int    blockingfactor1 = 3;
  int    blockingfactor2 = 4;
  int    blockingfactor3 = 5;
  int    allocRecs1 = 10;
  int    allocRecs2 = 15;
  int    allocRecs3 = 8;
  int    cType = GZIP_COMPRESSION;
  int[]  cParms = new int[] {9};
  int[]  varNs1 = new int[1] {0},varNs2 = new int[1] {2};
  string[] varsRecBuffer2 = new string[5] {
    "%%%%%%%%","%%%%%%%%","%%%%%%%%","%%%%%%%%","%%%%%%%%"
  };

/******************************************************************************
* Display title.
******************************************************************************/

Console.WriteLine("Testing C#-CDF Interface... using Objects");

/******************************************************************************
* Create CDF.
******************************************************************************/
id =(void*) 0;
try {
status = CDFcreate("TEST",numDims,dimSizes,encoding,majority,&id);
} catch(CDFException ex) {
  int stat = ex.CDFgetCurrentStatus();
  if(stat < CDF_OK) {
    id = null;
    if(stat == CDF_EXISTS) {
      status = CDFopen("TEST",&id);

      status = CDFdeleteCDF(id);

      status = CDFcreate("TEST",numDims,dimSizes,encoding,majority,&id);
      status = CDFsetFormat(id,MULTI_FILE);
    } else 
      QuitCDF("1.4",stat,id);
  } 
}

try {
status = CDFsetFormat(id,MULTI_FILE);

/******************************************************************************
* Create variables and set/confirm cache sizes,etc.
******************************************************************************/

status = CDFcreatezVar(id,var1Name,var1DataType,var1NumElements,
                       numDims,dimSizes,var1RecVariance,
                       var1DimVariances,out var1Num_out);

status = CDFputzVarPadValue(id,var1Num_out,pad1);

status = CDFcreatezVar(id,var2Name,var2DataType,var2NumElements,
                       numDims,dimSizes,var2RecVariance,
                       var2DimVariances,out var2Num_out);

status = CDFputzVarPadValue(id,var2Num_out,pad2);

status = CDFcreatezVar(id,var3Name,var3DataType,var3NumElements,
		       zNumDimsA,zDimSizesA,var3RecVariance,
		       var3DimVariances,out var3Num_out);

status = CDFputzVarPadValue(id,var3Num_out,pad3);

status = CDFsetzVarsCacheSize(id,5);

int cacheOut1o,cacheOut2o,cacheOut3o;
object pad1outo;
object pad2outo;
object pad3outo;

status = CDFgetzVarCacheSize(id,0,out cacheOut1o);

status = CDFgetzVarPadValue(id,0,out pad1outo);
short pad1outoo = (short) pad1outo;

status = CDFgetzVarCacheSize(id,1,out cacheOut2o); 

status = CDFgetzVarPadValue(id,1,out pad2outo); 
float pad2outoo = (float) pad2outo;

status = CDFgetzVarCacheSize(id,2,out cacheOut3o); 

status = CDFgetzVarPadValue(id,2,out pad3outo);
string pad3outoo = (string) pad3outo;

if(cacheOut1o != 5) QuitCDF("2.14",status,id);
if(cacheOut2o != 5) QuitCDF("2.15",status,id);
if(cacheOut3o != 5) QuitCDF("2.16",status,id);
if(pad1outoo != pad1) QuitCDF("2.17",status,id);
if(pad2outoo != pad2) QuitCDF("2.18",status,id);
if(String.Compare(pad3outoo,pad3) != 0) QuitCDF("2.19",status,id);

status = CDFsetzVarCacheSize(id,0,4);

status = CDFsetzVarCacheSize(id,2,8);

status = CDFgetzVarCacheSize(id,0,out cacheOut1o);

status = CDFgetzVarCacheSize(id,1,out cacheOut2o);

status = CDFgetzVarCacheSize(id,2,out cacheOut3o);

if((int) cacheOut1o != 4) QuitCDF("2.25",status,id);
if((int) cacheOut2o != 5) QuitCDF("2.26",status,id);
if((int) cacheOut3o != 8) QuitCDF("2.27",status,id);

/******************************************************************************
* Modify variables.
******************************************************************************/

status = CDFsetzVarDataSpec(id,0,var1DataTypeNew);

status = CDFsetzVarRecVariance(id,0,var1RecVarianceNew);

status = CDFsetzVarDimVariances(id,0,var1DimVariancesNew);

status = CDFsetzVarInitialRecs(id,0,1);

status = CDFsetzVarDataSpec(id,2,var3DataTypeNew);

status = CDFsetzVarRecVariance(id,2,var3RecVarianceNew);

status = CDFsetzVarDimVariances(id,2,var3DimVariancesNew);

status = CDFsetzVarInitialRecs(id,2,1);

/******************************************************************************
* Close CDF.
******************************************************************************/

status = CDFcloseCDF(id);

/******************************************************************************
* Reopen CDF.
******************************************************************************/

status = CDFopen("TEST",&id);

status = CDFsetDecoding(id,HOST_DECODING);

/******************************************************************************
* Delete CDF.
******************************************************************************/

status = CDFdeleteCDF(id);

/******************************************************************************
* Create CDF again(previous delete will allow this).
******************************************************************************/

status = CDFcreateCDF("TEST",&id);

status = CDFsetEncoding(id,NETWORK_ENCODING);

status = CDFsetMajority(id,ROW_MAJOR);

status = CDFsetFormat(id,SINGLE_FILE);

status = CDFsetDecoding(id,HOST_DECODING);

status = CDFsetCompression(id,cType,cParms);
/******************************************************************************
* Create variables.
******************************************************************************/

status = CDFcreatezVar(id,var1Name,var1DataType,var1NumElements,
                       numDims,dimSizes,var1RecVariance,
                       var1DimVariances,out var1Num_out);

status = CDFsetzVarAllocRecords(id,var1Num_out,allocRecs1);

status = CDFsetzVarBlockingFactor (id,var1Num_out,blockingfactor1);

status = CDFcreatezVar(id,var2Name,var2DataType,var2NumElements,
                       numDims,dimSizes,var2RecVariance,
                       var2DimVariances,out var2Num_out);

status = CDFsetzVarAllocRecords(id,var2Num_out,allocRecs2);

status = CDFsetzVarBlockingFactor (id,var2Num_out,blockingfactor2);

status = CDFcreatezVar(id,var3Name,var3DataType,var3NumElements,
                       zNumDimsA,zDimSizesA,var3RecVariance,
                       var3DimVariances,out var3Num_out);

status = CDFsetzVarAllocRecords(id,var3Num_out,allocRecs3);

status = CDFsetzVarBlockingFactor (id,var3Num_out,blockingfactor3);

/******************************************************************************
* PUT to variables.
******************************************************************************/

for(x0 = 0; x0 < DIM_0_SIZE; x0++)
   for(x1 = 0; x1 < DIM_1_SIZE; x1++) {
      indices[0] = x0;
      indices[1] = x1;
      status = CDFputzVarData(id,var1Num_out,recNum,indices,var1Values[x0,x1]);

      status = CDFputzVarData(id,var2Num_out,recNum,indices,var2Values[x0,x1]);
   }

for(x0 = 0; x0 < zDIM_0_SIZEa; x0++) {
   zIndicesA[0] = x0;
   status = CDFputzVarData(id,var3Num_out,recNum,zIndicesA,var3Values[x0]);
}

/******************************************************************************
* GET from the variables.
******************************************************************************/
object pvalue1o,pvalue2o,pvalue3o;
short pvalue1oo;
float pvalue2oo;
string pvalue3oo;

for(x0 = 0; x0 < DIM_0_SIZE; x0++)
   for(x1 = 0; x1 < DIM_1_SIZE; x1++) {
      indices[0] = x0;
      indices[1] = x1;
      status = CDFgetzVarData(id,var1Num_out,recNum,indices,out pvalue1o);
      Console.WriteLine("object="+pvalue1o);
      pvalue1oo = (short) pvalue1o;

      status = CDFgetzVarData(id,var2Num_out,recNum,indices,out pvalue2o);
      pvalue2oo = (float) pvalue2o;

      if(pvalue1oo != var1Values[x0,x1]) QuitCDF("10.2",status,id);
      if(pvalue2oo != var2Values[x0,x1]) QuitCDF("10.3",status,id);
   }

status = CDFgetzVarRecordData(id,var1Num_out,recNum,out pvalue1o);
short[,] pvalue1ooo = (short[,]) pvalue1o;

status = CDFgetzVarRecordData(id,var2Num_out,recNum,out pvalue2o);
float[,] pvalue2ooo = (float[,]) pvalue2o;

for(x0 = 0; x0 < DIM_0_SIZE; x0++)
   for(x1 = 0; x1 < DIM_1_SIZE; x1++) {
      if(pvalue1ooo[x0,x1] != var1Values[x0,x1]) 
        QuitCDF("10.2a",status,id);
      if(pvalue2ooo[x0,x1] != var2Values[x0,x1]) 
        QuitCDF("10.3a",status,id);
   }

for(x0 = 0; x0 < zDIM_0_SIZEa; x0++) {
   zIndicesA[0] = x0;
   status = CDFgetzVarData(id,var3Num_out,recNum,zIndicesA,out pvalue3o);
   pvalue3oo = (string) pvalue3o;
 
   if(String.Compare(pvalue3oo,var3Values[x0]) != 0)
     QuitCDF("10.5",status,id);
}

/******************************************************************************
* HyperPUT to the variables.
******************************************************************************/

for(x0 = 0; x0 < DIM_0_SIZE; x0++)
   for(x1 = 0; x1 < DIM_1_SIZE; x1++) {
      var1Values[x0,x1] =(short) -var1Values[x0,x1];
      var2Values[x0,x1] = -var2Values[x0,x1];
   }

indices[0] = 0;
indices[1] = 0;
status = CDFhyperPutzVarData(id,var1Num_out,recStart,recCount,
                             recInterval,indices,counts,
                             intervals,var1Values); 

status = CDFhyperPutzVarData(id,var2Num_out,recStart,recCount,
                             recInterval,indices,counts,
                             intervals,var2Values); 

for(x0 = 0; x0 < zDIM_0_SIZEa; x0++) {
   var3Values[x0] = new string((char)('2'+x0),zNUM_ELEMSa);
}

zIndicesA[0] = 0;
status = CDFhyperPutzVarData(id,var3Num_out,recStart,recCount,
                             recInterval,zIndicesA,zCounts,
                             zIntervals,var3Values); 

/******************************************************************************
* HyperGET from variables.
******************************************************************************/

object pvalues1o,pvalues2o,pvalues3o;
//short[] pvalues1o;
//float[] pvalues2o;
//string[] pvalues3o;

status = CDFhyperGetzVarData(id,var1Num_out,recStart,recCount,
                             recInterval,indices,counts,
                             intervals,out pvalues1o);
short[,] pvalues1oo = (short[,]) pvalues1o;

status = CDFhyperGetzVarData(id,var2Num_out,recStart,recCount,
                             recInterval,indices,counts,
                             intervals,out pvalues2o);
float[,] pvalues2oo = (float[,]) pvalues2o;

for(x0 = 0; x0 < DIM_0_SIZE; x0++)
   for(x1 = 0; x1 < DIM_1_SIZE; x1++) {
      if(((short[,])pvalues1o)[x0,x1] != var1Values[x0,x1])
	QuitCDF("12.2",status,id);
      if(((float[,])pvalues2o)[x0,x1] != var2Values[x0,x1])
	QuitCDF("12.3",status,id);
   }

status = CDFhyperGetzVarData(id,var3Num_out,recStart,recCount,
                             recInterval,zIndicesA,zCounts,
                             zIntervals,out pvalues3o);
string[] pvalues3oo = (string[]) pvalues3o;

for(x0 = 0; x0 < zDIM_0_SIZEa; x0++)
   if(String.Compare(pvalues3oo[x0],var3Values[x0]) != 0)
	QuitCDF("12.5",status,id);

/******************************************************************************
* Set/confirm sequential access position for a zVariable(and read/write a
* value).
******************************************************************************/

status = CDFsetzVarSeqPos(id,var3Num_out,recStart,zIndicesA);

string var3Valueo;
int recNumOuto;
int[] ptro;

status = CDFgetzVarSeqData(id,var3Num_out,out var3Valueo);
string var3Valueoo = var3Valueo;

status = CDFputzVarSeqData(id,var3Num_out,var3Valueo);

int[] v3Indices = new int[1] {zIndicesA[0]+1};
object var3Valuea;
status = CDFgetzVarData(id,var3Num_out,recStart,v3Indices,out var3Valuea);
string var3Valueaa = (string) var3Valuea;

status = CDFgetzVarSeqPos(id,var3Num_out,out recNumOuto,out ptro);

if(recNumOuto != recStart) QuitCDF("14.4",status,id);
if(ptro[0] != zIndicesA[0] + 2) QuitCDF("14.5",status,id);
if(String.Compare(var3Valueoo,var3Valueaa) != 0)
  QuitCDF("14.6",status,id);

/******************************************************************************
* Create attributes.
******************************************************************************/

status = CDFcreateAttr(id,attrName,attrScope,out attrNum_out);

status = CDFcreateAttr(id,attrName2,attrScope2,out attrNum_out);

status = CDFcreateAttr(id,attrName3,attrScope3,out attrNum_out);

/******************************************************************************
* PUT to attributes.
******************************************************************************/

status = CDFputAttrgEntry(id,0,entryNum,entryDataType,entryNumElems,entryValue);

status = CDFputAttrzEntry(id,1,CDFgetVarNum(id,var1Name),
                          CDF_BYTE,1,zEntryValue1);

status = CDFputAttrzEntry(id,2,CDFgetVarNum(id,var2Name),
                          CDF_REAL8,1,zEntryValue2);

/******************************************************************************
* GET from attributes.
******************************************************************************/

object entryValueo,zEntryValue1o,zEntryValue2o;

status = CDFgetAttrgEntry(id,0,entryNum,out entryValueo);
short entryValueoo = (short) entryValueo;

status = CDFgetAttrzEntry(id,1,CDFgetVarNum(id,var1Name),out zEntryValue1o);
sbyte zEntryValue1oo = (sbyte) zEntryValue1o;

status = CDFgetAttrzEntry(id,2,CDFgetVarNum(id,var2Name),out zEntryValue2o);
double zEntryValue2oo = (double) zEntryValue2o;

if(entryValueoo != entryValue) QuitCDF("19.6",status,id);
if(zEntryValue1oo != zEntryValue1) QuitCDF("19.7",status,id);
if(zEntryValue2oo != zEntryValue2) QuitCDF("19.8",status,id);

/******************************************************************************
* Confirm existence of variables/attributes/entries.
******************************************************************************/

status = CDFconfirmzVarExistence(id,var3Name);
if(status < CDF_OK) QuitCDF("20.1",status,id);

status = CDFconfirmzVarExistence(id,var1Name);
if(status < CDF_OK) QuitCDF("20.2",status,id);

status = CDFconfirmAttrExistence(id,attrName3);
if(status < CDF_OK) QuitCDF("20.3",status,id);

status = CDFconfirmgEntryExistence(id,0,entryNum);
if(status < CDF_OK) QuitCDF("20.4",status,id);

status = CDFconfirmzEntryExistence(id,1,CDFgetVarNum(id,var1Name));
if(status < CDF_OK) QuitCDF("20.5",status,id);

/******************************************************************************
* Get CDF documentation.
******************************************************************************/

int versiono,releaseo,incremento;
string subincremento;

status = CDFgetLibraryVersion(out versiono,out releaseo,
                              out incremento,out subincremento);
Console.WriteLine("CDF version:"+versiono+" release="+releaseo+" increment="+incremento);

status = CDFgetLibraryCopyright(out CopyrightText);

/******************************************************************************
* Inquire CDF.
******************************************************************************/

int formato,encodingo,majorityo,maxReco,numZvarso,numAttrso;

status = CDFgetFormat(id,out formato);

status = CDFgetEncoding(id,out encodingo);

status = CDFgetMajority(id,out majorityo);

status = CDFgetzVarsMaxWrittenRecNum(id,out maxReco);

status = CDFgetNumzVars(id,out numZvarso);

status = CDFgetNumAttributes(id,out numAttrso);

if(formato != SINGLE_FILE) QuitCDF("22.9",status,id);
if(encodingo != actual_encoding) QuitCDF("22.12",status,id);
if(majorityo != majority) QuitCDF("22.13",status,id);
if(maxReco != 2) QuitCDF("22.14",status,id);
if(numZvarso != 3) QuitCDF("22.16",status,id);
if(numAttrso != 3) QuitCDF("22.17",status,id);

/******************************************************************************
* Inquire numbers.
******************************************************************************/

attrNum_out = CDFgetAttrNum(id,attrName3);

int varNum_out1 = CDFgetVarNum(id,var2Name);

int varNum_out2 = CDFgetVarNum(id,var3Name);

if(attrNum_out != 2) QuitCDF("23.3",status,id);
if(varNum_out1 != 1) QuitCDF("23.4",status,id);
if(varNum_out2 != 2) QuitCDF("23.5",status,id);

/******************************************************************************
* Rename variables.
******************************************************************************/

status = CDFrenamezVar(id,CDFgetVarNum(id,var1Name),new_var1Name);

status = CDFrenamezVar(id,CDFgetVarNum(id,var2Name),new_var2Name);

status = CDFrenamezVar(id,CDFgetVarNum(id,var3Name),new_var3Name);

/******************************************************************************
* Inquire variables.
******************************************************************************/

string var1Nameo;
int var1DataTypeo,var1NumElementso,var1RecVarianceo;
int[] var1DimVarianceso;
int blockingfactor1o,max1Alloco,max1Reco;

status = CDFgetzVarName(id,var1Num_out,out var1Nameo);

status = CDFgetzVarDataType(id,var1Num_out,out var1DataTypeo);

status = CDFgetzVarNumElements(id,var1Num_out,out var1NumElementso);

status = CDFgetzVarRecVariance(id,var1Num_out,out var1RecVarianceo);

status = CDFgetzVarDimVariances(id,var1Num_out,out var1DimVarianceso);

status = CDFgetzVarBlockingFactor(id,var1Num_out,out blockingfactor1o);

status = CDFgetzVarMaxAllocRecNum(id,var1Num_out,out max1Alloco);

status = CDFgetzVarMaxWrittenRecNum(id,var1Num_out,out max1Reco);

if(String.Compare(var1Nameo,new_var1Name) != 0) 
  QuitCDF("26.11",status,id);
if(var1DataTypeo != var1DataType) QuitCDF("26.12",status,id);
if(var1NumElementso != var1NumElements) QuitCDF("26.13",status,id);
if(var1RecVarianceo != var1RecVariance) QuitCDF("26.14",status,id);
if(var1Num_out != 0) QuitCDF("26.15",status,id);
if(blockingfactor1o != blockingfactor1) QuitCDF("26.16",status,id);
if(max1Alloco + 1 != allocRecs1) QuitCDF("26.17",status,id);
if(max1Reco != 2) QuitCDF("26.18",status,id);

for(dim_n = 0; dim_n < numDims; dim_n++) {
   if(var1DimVariances[dim_n] != var1DimVariances[dim_n]) {
     QuitCDF("26.19",status,id);
   }
}

string var2Nameo;
int var2DataTypeo,var2NumElementso,var2RecVarianceo;
int blockingfactor2o,max2Alloco,max2Reco;
int[] var2DimVarianceso;

status = CDFgetzVarName(id,var2Num_out,out var2Nameo);

status = CDFgetzVarDataType(id,var2Num_out,out var2DataTypeo);

status = CDFgetzVarNumElements(id,var2Num_out,out var2NumElementso);

status = CDFgetzVarRecVariance(id,var2Num_out,out var2RecVarianceo);

status = CDFgetzVarDimVariances(id,var2Num_out,out var2DimVarianceso);

status = CDFgetzVarBlockingFactor(id,var2Num_out,out blockingfactor2o);

status = CDFgetzVarMaxAllocRecNum(id,var2Num_out,out max2Alloco);

status = CDFgetzVarMaxWrittenRecNum(id,var2Num_out,out max2Reco);

if(String.Compare(var2Nameo,new_var2Name) != 0) 
  QuitCDF("26.31",status,id);
if(var2DataTypeo != var2DataType) QuitCDF("26.32",status,id);
if(var2NumElementso != var2NumElements) QuitCDF("26.33",status,id);
if(var2RecVarianceo != var2RecVariance) QuitCDF("26.34",status,id);
if(var2Num_out != 1) QuitCDF("26.35",status,id);
if(blockingfactor2o != blockingfactor2) QuitCDF("26.36",status,id);
if(max2Alloco + 1 != allocRecs2) QuitCDF("26.37",status,id);
if(max2Reco != 2) QuitCDF("26.38",status,id);


for(dim_n = 0; dim_n < numDims; dim_n++) {
   if(var2DimVarianceso[dim_n] != var2DimVariances[dim_n]) {
     QuitCDF("26.39",status,id);
   }
}

string var3Nameo;
int var3DataTypeo,var3NumElementso,var3RecVarianceo;
int blockingfactor3o,max3Alloco,max3Reco;
int[] var3DimVarianceso;
int zNumDimsAo;
int[] zDimSizesAo;

status = CDFgetzVarName(id,var3Num_out,out var3Nameo);

status = CDFgetzVarDataType(id,var3Num_out,out var3DataTypeo);

status = CDFgetzVarNumElements(id,var3Num_out,out var3NumElementso);

status = CDFgetzVarRecVariance(id,var3Num_out,out var3RecVarianceo);

status = CDFgetzVarDimVariances(id,var3Num_out,out var3DimVarianceso);

status = CDFgetzVarNumDims(id,var3Num_out,out zNumDimsAo);

status = CDFgetzVarDimSizes(id,var3Num_out,out zDimSizesAo);

status = CDFgetzVarBlockingFactor(id,var3Num_out,out blockingfactor3o);

status = CDFgetzVarMaxAllocRecNum(id,var3Num_out,out max3Alloco);

status = CDFgetzVarMaxWrittenRecNum(id,var3Num_out,out max3Reco);

if(String.Compare(var3Nameo,new_var3Name) != 0) 
  QuitCDF("26.53",status,id);
if(var3DataTypeo != var3DataType) QuitCDF("26.54",status,id);
if(var3NumElementso != var3NumElements) QuitCDF("26.55",status,id);
if(var3RecVarianceo != var3RecVariance) QuitCDF("26.56",status,id);
if(zNumDimsAo != zNumDimsA) QuitCDF("26.57",status,id);
if(var3Num_out != 2) QuitCDF("26.58",status,id);
if(blockingfactor3o != blockingfactor3) QuitCDF("26.59",status,id);
if(max3Alloco + 1 != allocRecs3) QuitCDF("26.60",status,id);
if(max3Reco != 2) QuitCDF("26.61",status,id);

for(dim_n = 0; dim_n < zNumDimsA; dim_n++) {
   if(zDimSizesAo[dim_n] != zDimSizesA[dim_n]) {
     QuitCDF("26.62",status,id);
   }
   if(var3DimVarianceso[dim_n] != var3DimVariances[dim_n]) {
     QuitCDF("26.63",status,id);
   }
}

/******************************************************************************
* Rename attribute.
******************************************************************************/

status = CDFrenameAttr(id,CDFgetAttrNum(id,attrName),new_attrName);

/******************************************************************************
* Inquire attribute.
******************************************************************************/

string attrNameo;
int attrScopeo,maxEntryo;

status = CDFgetAttrName(id,CDFgetAttrNum(id,new_attrName),out attrNameo);

status = CDFgetAttrScope(id,CDFgetAttrNum(id,new_attrName),out attrScopeo);

status = CDFgetAttrMaxgEntry(id,CDFgetAttrNum(id,new_attrName),out maxEntryo);

if(String.Compare(attrNameo,new_attrName) != 0) 
  QuitCDF("28.4",status,id);
if(attrScopeo != attrScope) QuitCDF("28.5",status,id);
if(maxEntryo != entryNum) QuitCDF("28.6",status,id);

/******************************************************************************
* Inquire attribute entries.
******************************************************************************/

int entryDataTypeo,entryNumElemso;

status = CDFgetAttrgEntryDataType(id,0,entryNum,out entryDataTypeo);

status = CDFgetAttrgEntryNumElements(id,0,entryNum,out entryNumElemso);

if(entryDataTypeo != entryDataType) QuitCDF("29.2",status,id);
if(entryNumElemso != entryNumElems) QuitCDF("29.3",status,id);

status = CDFgetAttrzEntryDataType(id,1,0,out entryDataTypeo);

status = CDFgetAttrzEntryNumElements(id,1,0,out entryNumElemso);

if(entryDataTypeo != CDF_BYTE) QuitCDF("29.6",status,id);
if(entryNumElemso != 1) QuitCDF("29.7",status,id);

status = CDFgetAttrzEntryDataType(id,2,1,out entryDataTypeo);

status = CDFgetAttrzEntryNumElements(id,2,1,out entryNumElemso);

if(entryDataTypeo != CDF_REAL8) QuitCDF("29.10",status,id);
if(entryNumElemso != 1) QuitCDF("29.11",status,id);

/******************************************************************************
* Get error text.
******************************************************************************/

status = CDFgetStatusText(CDF_OK,out errorText);

/******************************************************************************
* Select zMode and inquire CDF.
******************************************************************************/

status = CDFsetzMode(id,zMODEon2);

int numGattrso,numVattrso,maxGentryo,numGentrieso,
    maxZentryo,numZentrieso;
int numDimsXo,encodingXo,majorityXo,maxrRecXo,nrVarsXo,nAttrsXo;
int[] dimSizesXo;
int numDimsYo,encodingYo,majorityYo,maxrRecYo,nrVarsYo,nAttrsYo;
int[] dimSizesYo;
int maxzRecYo,nzVarsYo;

status = CDFgetNumgAttributes(id,out numGattrso);

status = CDFgetNumvAttributes(id,out numVattrso);

status = CDFgetNumzVars(id,out numZvarso);

status = CDFgetAttrMaxgEntry(id,0,out maxGentryo);

status = CDFgetNumAttrgEntries(id,0,out numGentrieso);

status = CDFgetzVarsMaxWrittenRecNum(id,out maxReco);

status = CDFgetAttrMaxzEntry(id,1,out maxZentryo);

status = CDFgetNumAttrzEntries(id,1,out numZentrieso);

status = CDFsetzMode(id,zMODEoff);

status = CDFinquire(id,out numDimsXo,out dimSizesXo,out encodingXo,
                    out majorityXo,out maxrRecXo,out nrVarsXo,out nAttrsXo);

status = CDFinquireCDF(id,out numDimsYo,out dimSizesYo,out encodingYo,
                       out majorityYo,out maxrRecYo,out nrVarsYo,
                       out maxzRecYo,out nzVarsYo,out nAttrsYo);

if(numGattrso != 1) QuitCDF("31.13",status,id);
if(numVattrso != 2) QuitCDF("31.14",status,id);
if(numZvarso != 3) QuitCDF("31.16",status,id);
if(maxGentryo != entryNum) QuitCDF("31.17",status,id);
if(numGentrieso != 1) QuitCDF("31.18",status,id);
if(maxZentryo != 0) QuitCDF("31.21",status,id);
if(numZentrieso != 1) QuitCDF("31.22",status,id);
if(maxReco != 2) QuitCDF("31.23",status,id);
if(numDimsXo != numDimsYo ||(int)numDimsXo != 0) 
  QuitCDF("31.24",status,id);
if(encodingXo != encodingYo ||(int)encodingXo != NETWORK_ENCODING) 
  QuitCDF("31.25",status,id);
if(majorityXo != majorityYo ||(int)majorityXo != ROW_MAJOR) 
  QuitCDF("31.26",status,id);
/* 
if(maxrRecXo != maxrRecY ||(int)maxrRecXo != 0) 
  QuitCDF("31.27",status,id); 
*/
if(nrVarsXo != nrVarsYo || nrVarsXo != 0) 
  QuitCDF("31.28",status,id);
if(nAttrsXo != nAttrsYo || nAttrsXo != 3) 
  QuitCDF("31.29",status,id);
if(nzVarsYo != 3) QuitCDF("31.30",status,id);
if(maxzRecYo != 2) QuitCDF("31.31",status,id);

/******************************************************************************
* Attempt to close variables.
******************************************************************************/

status = CDFclosezVar(id,0);
if(status != SINGLE_FILE_FORMAT) QuitCDF("32.0",status,id);

status = CDFclosezVar(id,2);
if(status != SINGLE_FILE_FORMAT) QuitCDF("32.1",status,id);

/******************************************************************************
* Modify entries/attribute.
******************************************************************************/

status = CDFsetAttrgEntryDataSpec(id,0,entryNum,entryDataTypeNew);

status = CDFsetAttrzEntryDataSpec(id,1,CDFgetVarNum(id,new_var1Name),CDF_UINT1);

status = CDFsetAttrzEntryDataSpec(id,2,CDFgetVarNum(id,new_var2Name),CDF_EPOCH);

status = CDFsetAttrScope(id,0,VARIABLE_SCOPE);

status = CDFsetAttrScope(id,0,GLOBAL_SCOPE);

/******************************************************************************
* Delete entries/attribute/variables.
******************************************************************************/

status = CDFdeleteAttrgEntry(id,0,entryNum);

status = CDFdeleteAttrzEntry(id,1,0);

status = CDFdeleteAttrzEntry(id,2,1);

status = CDFdeleteAttr(id,CDFgetAttrNum(id,new_attrName));

status = CDFdeletezVar(id,CDFgetVarNum(id,new_var1Name));

status = CDFdeletezVar(id,CDFgetVarNum(id,new_var3Name));

/******************************************************************************
* Close CDF.
******************************************************************************/

status = CDFcloseCDF(id);  

int cTypeo;
int[] cParmso;
long cSizeo,uSizeo;
status = CDFgetCompressionInfo("TEST",out cTypeo,out cParmso,out cSizeo,
                               out uSizeo);
Console.WriteLine(" Compression:"+
		  CDFUtils.CDFgetStringCompressionType((int)cType)+
                  "."+((int[])cParms)[0]+" Size- Compressed:"+(long)cSizeo+
                  " Uncompressed:"+(long)uSizeo);

/******************************************************************************
* Successful completion.
******************************************************************************/
} catch(CDFException ex) {
  Console.WriteLine("Error... "+ex);
} finally {
  try {
    status = CDFselect(id);
    status = CDFcloseCDF(id);
  } catch(CDFException ex) { }
}

}


/******************************************************************************
* QuitCDF.
******************************************************************************/

unsafe static void QuitCDF(string where, int status, void* id)
{
  string text;
  Console.WriteLine("Aborting at "+where);
  if(status < 0) {
    status = CDFgetStatusText(status,out text); 
    Console.WriteLine(" "+text);
  }
  if(id != null) status = CDFcloseCDF(id);
  Console.WriteLine("...test aborted.");
}

}

