/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class CDFML2CDF
extends DefaultHandler
implements CDFConstants {
    private static final int NONE = 0;
    private static final int GAttributes = 1;
    private static final int VAttributes = 2;
    private static final int VarRecordData = 3;
    private static final int VarElementData = 4;
    private static final int VarRecordTypeData = 5;
    private static final int VarAttributeEntryData = 6;
    private static final int GlobalAttributeEntryData = 7;
    private static String[] CDFelements = new String[]{"record", "element", "entry", "variable", "attribute", "cdfVarInfo", "cdfVAttributes", "cdfVarData", "cdfGAttributes", "CDF", "cdfFileInfo", "Value", "array", "choice", "complextype"};
    private static String newCDFName = null;
    private static boolean removeOldCDF = false;
    private static boolean loadData = true;
    private static boolean backward = false;
    private static boolean progressReport = false;
    private static boolean validateCDFML = false;
    private static boolean entryNumFlag;
    private static boolean valueElement;
    private static String cdfmlFileName;
    private static String outputDir;
    private static String defaultStrDelimiter;
    private CDF cdf;
    private Variable var;
    private Entry entry;
    private Attribute attribute;
    private String cdfName;
    private String varName;
    private String attrName;
    private String elementDelimiter;
    private String indexString;
    private String multiDelimiter;
    private String xsdType = null;
    private long attrNum;
    private long varNum;
    private long scope;
    private long varDataType;
    private long entryDataType;
    private long numElements;
    private long recNum;
    private long[] dimSizes;
    private long[] dimVariances;
    private long[] dimIndex;
    private long[] dimIndices;
    private long[] dimCounts;
    private long[] dimIntervals;
    private long recCount;
    private long recInterval;
    private long dim;
    private long recVariance;
    private int phyDims;
    private int physicalSize;
    private Object dataObject;
    private long entryNum = -1L;
    private int inScope;
    private boolean entryBlock;
    private boolean recordBlock;
    private boolean elementBlock;
    private boolean processElement;
    private boolean arrayBlock;
    private boolean choiceBlock;
    private Stack stack;
    private CDFML2CDF aXML2CDF = this;
    private StringBuffer dataBuffer;
    private StringBuffer dataBuffer2;
    private long lastUpdated = -1L;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            CDFML2CDF.howto();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '-' || n != stringArray.length - 1 && stringArray[n].charAt(0) == '/') {
                if (stringArray[n].substring(1).equalsIgnoreCase("delete")) {
                    removeOldCDF = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("nodelete")) {
                    removeOldCDF = false;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("validate")) {
                    validateCDFML = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("novalidate")) {
                    validateCDFML = false;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("progress")) {
                    progressReport = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].length() > 4 && stringArray[n].substring(1, 4).equalsIgnoreCase("cdf")) {
                    newCDFName = stringArray[n].substring(5);
                    ++n;
                    continue;
                }
                if (stringArray[n].length() > 7 && stringArray[n].substring(1, 7).equalsIgnoreCase("output")) {
                    newCDFName = stringArray[n].substring(8);
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("data")) {
                    loadData = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("nodata")) {
                    loadData = false;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("backward")) {
                    backward = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("nobackward")) {
                    backward = false;
                    ++n;
                    continue;
                }
                CDFML2CDF.howto();
                continue;
            }
            cdfmlFileName = stringArray[n++];
        }
        if (cdfmlFileName == null) {
            CDFML2CDF.howto();
        }
        CDFML2CDF.checkCDFMLFile(cdfmlFileName);
        if (newCDFName != null) {
            CDFML2CDF.checkCDFFile(newCDFName);
        }
        CDFML2CDF cDFML2CDF = new CDFML2CDF();
    }

    CDFML2CDF() {
        System.err.println("\nStart processing");
        this.multiDelimiter = null;
        valueElement = false;
        this.aXML2CDF.startProcessing();
    }

    private static void checkCDFMLFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("*** Error: cdfml file:" + file + " does not exist! ***");
            System.exit(1);
        }
    }

    private static void checkCDFFile(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            outputDir = string.endsWith(System.getProperty("file.separator")) ? string : string + System.getProperty("file.separator");
            return;
        }
        String string2 = null;
        String string3 = null;
        if (string.indexOf(".cdf") == -1 && string.indexOf(".CDF") == -1) {
            string2 = new StringBuffer(string).append(".cdf").toString();
            string3 = new StringBuffer(string).append(".CDF").toString();
        } else {
            string2 = string;
        }
        File file2 = new File(string2);
        boolean bl = true;
        if (file2.exists()) {
            if (removeOldCDF) {
                file2.delete();
                bl = false;
            } else {
                System.err.println("\nError... CDF: " + string2 + " already exists...");
                System.exit(1);
            }
        }
        if (bl && string3 != null) {
            bl = false;
            File file3 = new File(string3);
            if (file3.exists()) {
                if (removeOldCDF) {
                    file3.delete();
                } else {
                    System.err.println("\nError... CDF: " + string3 + " already exists...");
                    System.exit(1);
                }
            }
        }
    }

    private void startProcessing() {
        Object object;
        this.dimSizes = null;
        this.dimVariances = null;
        this.dimIndices = null;
        this.inScope = 0;
        this.dataBuffer = new StringBuffer();
        this.dataBuffer2 = new StringBuffer();
        this.stack = new Stack();
        try {
            object = XMLReaderFactory.createXMLReader();
            if (validateCDFML) {
                object.setFeature("http://xml.org/sax/features/validation", true);
            }
            object.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            object.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            object.setFeature("http://xml.org/sax/features/external-general-entities", false);
            object.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            object.setErrorHandler(this.aXML2CDF);
            object.setContentHandler(this.aXML2CDF);
            object.parse(new InputSource(CDFML2CDF.fileToURL(new File(cdfmlFileName))));
        }
        catch (Throwable throwable) {
            System.err.println("**ERROR**: unable to handle/accept the XML file: " + cdfmlFileName);
            System.exit(1);
        }
        object = new StringBuffer(this.cdfName);
        if (this.cdfName.indexOf(".cdf") == -1 && this.cdfName.indexOf(".CDF") == -1) {
            ((StringBuffer)object).append(".cdf");
        }
        System.err.println("Completed!  CDF file: " + ((StringBuffer)object).toString() + " is created.");
        System.err.println("");
        System.exit(0);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        String string4 = string2;
        this.xsdType = null;
        if (attributes != null) {
            for (n = 0; n < attributes.getLength(); ++n) {
                String string5;
                String string6 = attributes.getLocalName(n);
                if ("".equals(string6)) {
                    string6 = attributes.getQName(n);
                }
                if ((string5 = attributes.getValue(n)).toLowerCase().indexOf("xsd:") != 0) continue;
                this.xsdType = string5.toLowerCase().substring(4);
            }
        }
        if ("".equals(string4)) {
            string4 = string3;
        }
        for (n = 0; n < CDFelements.length; ++n) {
            if (!string4.equalsIgnoreCase(CDFelements[n])) continue;
            try {
                this.dataBuffer.setLength(0);
                this.handleStartCDFelement(string4, attributes);
                break;
            }
            catch (CDFException cDFException) {
                System.err.println("\n ***** CDFException 1..: " + (Object)((Object)cDFException));
                System.exit(1);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = "".equals(string2) ? string3 : string2;
        for (int i = 0; i < CDFelements.length; ++i) {
            if (!string4.equalsIgnoreCase(CDFelements[i])) continue;
            try {
                this.handleEndCDFelement(string4);
                break;
            }
            catch (CDFException cDFException) {
                System.err.println("\n ****** CDFException 2..: " + (Object)((Object)cDFException));
                System.exit(1);
            }
        }
        this.dataBuffer.setLength(0);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.dataBuffer.append(cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    private void handleStartCDFelement(String string, Attributes attributes) throws CDFException, SAXException {
        this.stack.push(string);
        if (string.equalsIgnoreCase("variable")) {
            this.setVariable(attributes);
        } else if (string.equalsIgnoreCase("cdfVarInfo")) {
            this.createVariable(attributes);
        } else if (string.equalsIgnoreCase("cdfVAttributes")) {
            this.scope = 2L;
            this.inScope = 2;
        } else if (string.equalsIgnoreCase("cdfVarData")) {
            this.recNum = 0L;
        } else if (string.equalsIgnoreCase("attribute")) {
            this.createAttribute(attributes);
        } else if (string.equalsIgnoreCase("entry")) {
            if (this.entryBlock) {
                throw new SAXException("entry element error: previous entry not closed");
            }
            this.entryBlock = true;
            this.entryDataType = -1L;
            this.setEntry(attributes);
            if (this.multiDelimiter == null) {
                this.multiDelimiter = this.entryDataType == 51L || this.entryDataType == 52L ? defaultStrDelimiter : new String(" ");
            }
        } else if (string.equalsIgnoreCase("value")) {
            valueElement = true;
            this.processElement = false;
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string2 = attributes.getLocalName(i);
                    if (!"".equals(string2)) continue;
                    string2 = attributes.getQName(i);
                }
            }
            if (this.scope == 1L) {
                this.inScope = 7;
            } else if (this.inScope != 3) {
                this.inScope = 6;
            }
        } else if (string.equalsIgnoreCase("record")) {
            if (this.recordBlock) {
                throw new SAXException("record element error: previous record not closed");
            }
            this.elementDelimiter = null;
            this.recordBlock = true;
            this.processElement = false;
            this.setRecord(attributes);
            if (this.multiDelimiter == null) {
                this.multiDelimiter = this.varDataType == 51L || this.varDataType == 52L ? defaultStrDelimiter : new String(" ");
            }
            this.inScope = 3;
        } else if (string.equalsIgnoreCase("array")) {
            if (!this.arrayBlock) {
                this.multiDelimiter = this.elementDelimiter != null ? new String(this.elementDelimiter) : (this.entryBlock && (this.entryDataType == 51L || this.entryDataType == 52L) || this.recordBlock && (this.varDataType == 51L || this.varDataType == 52L) ? defaultStrDelimiter : new String(" "));
                this.arrayBlock = true;
                this.processElement = false;
            }
        } else if (string.equalsIgnoreCase("element")) {
            if (this.elementBlock) {
                throw new SAXException("element error: previous data element not closed");
            }
            this.elementBlock = true;
            this.processElement = true;
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string3 = attributes.getLocalName(i);
                    if ("".equals(string3)) {
                        string3 = attributes.getQName(i);
                    }
                    if (string3.equalsIgnoreCase("index")) {
                        this.indexString = attributes.getValue(i);
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("elementDelimiter")) continue;
                    this.elementDelimiter = attributes.getValue(i);
                }
            } else {
                throw new SAXException("Index is missing for single element data");
            }
            this.inScope = 4;
        } else if (string.equalsIgnoreCase("CDF")) {
            this.createCDF(attributes);
        } else if (string.equalsIgnoreCase("cdfFileInfo")) {
            this.setCDF(attributes);
        } else if (string.equalsIgnoreCase("cdfGAttributes")) {
            this.scope = 1L;
            this.inScope = 1;
        } else {
            if (string.equalsIgnoreCase("choice")) {
                return;
            }
            if (string.equalsIgnoreCase("complexType")) {
                return;
            }
        }
    }

    private void handleEndCDFelement(String string) throws CDFException, SAXException {
        if (!this.stack.peek().equals(string)) {
            throw new SAXException("parsing problem...the start element:" + this.stack.peek() + " doesn't match to the close element " + string);
        }
        this.stack.pop();
        if (string.equalsIgnoreCase("value")) {
            this.packData();
        } else if (string.equalsIgnoreCase("record")) {
            if (this.processElement) {
                ++this.recNum;
                return;
            }
            if (!valueElement) {
                this.packData();
            }
            this.inScope = 3;
            if (this.varDataType == -1L) {
                this.varDataType = GetMyCDFData.xsdTypeToCDFType(this.xsdType);
            }
            if (this.varDataType == 100L) {
                this.varDataType = this.xsdDateTimeToCDFEpoch(this.dataBuffer2.toString());
            }
            if (this.varDataType == -1L) {
                System.err.println("ERROR... Variable data type can not be defined...");
                System.err.println("Abort...");
                System.exit(1);
            }
            try {
                this.processCDFEntryORVarData();
                this.inScope = 0;
                this.elementDelimiter = null;
                this.multiDelimiter = null;
                valueElement = false;
                this.dataBuffer2.setLength(0);
            }
            catch (SAXException sAXException) {
                System.err.println("\n SAXException....: " + sAXException);
                System.exit(1);
            }
            if (this.choiceBlock) {
                this.choiceBlock = false;
                this.recordBlock = false;
            } else {
                this.recordBlock = false;
            }
            this.arrayBlock = false;
        } else if (!string.equalsIgnoreCase("array")) {
            if (string.equalsIgnoreCase("entry")) {
                if (!valueElement) {
                    this.packData();
                }
                if (this.entryDataType == -1L) {
                    this.entryDataType = GetMyCDFData.xsdTypeToCDFType(this.xsdType);
                }
                if (this.entryDataType == 100L) {
                    this.entryDataType = this.xsdDateTimeToCDFEpoch(this.dataBuffer2.toString());
                }
                if (this.entryDataType == -1L) {
                    System.err.println("ERROR... Entry data type can not be defined...");
                    System.err.println("Abort...");
                    System.exit(1);
                }
                this.multiDelimiter = this.elementDelimiter != null ? this.elementDelimiter : (this.entryDataType == 51L || this.entryDataType == 52L ? defaultStrDelimiter : " ");
                try {
                    this.processCDFEntryORVarData();
                    this.elementDelimiter = null;
                    this.entryBlock = false;
                    this.choiceBlock = false;
                    this.arrayBlock = false;
                    this.dataBuffer2.setLength(0);
                    valueElement = false;
                    this.multiDelimiter = null;
                }
                catch (SAXException sAXException) {
                    System.err.println("\n SAXException....: " + sAXException);
                    System.exit(1);
                }
            } else if (string.equalsIgnoreCase("element")) {
                this.elementBlock = false;
                if (this.dataBuffer.length() == 0) {
                    return;
                }
                try {
                    this.processCDFEntryORVarData();
                    this.inScope = 0;
                    this.elementDelimiter = null;
                }
                catch (SAXException sAXException) {
                    System.err.println("\n SAXException....: " + sAXException);
                    System.exit(1);
                }
            } else if (string.equalsIgnoreCase("variable")) {
                this.dimSizes = null;
                this.dimVariances = null;
                this.dimIndices = null;
                this.dimCounts = null;
                this.dimIntervals = null;
            } else {
                if (string.equalsIgnoreCase("cdfVariables")) {
                    this.inScope = 0;
                    return;
                }
                if (string.equalsIgnoreCase("cdfVAttributes")) {
                    this.inScope = 0;
                    return;
                }
                if (string.equalsIgnoreCase("attribute")) {
                    return;
                }
                if (string.equalsIgnoreCase("cdfGAttributes")) {
                    return;
                }
                if (string.equalsIgnoreCase("cdfVarData")) {
                    if (progressReport) {
                        System.err.println("    Completed loading the data");
                    }
                    return;
                }
                if (string.equalsIgnoreCase("cdfFileInfo")) {
                    return;
                }
                if (string.equalsIgnoreCase("CDF")) {
                    this.closeCDF();
                } else {
                    if (string.equalsIgnoreCase("choice")) {
                        return;
                    }
                    if (string.equalsIgnoreCase("complextype")) {
                        return;
                    }
                }
            }
        }
    }

    private void processCDFEntryORVarData() throws SAXException {
        if (this.dataBuffer2.length() == 0) {
            return;
        }
        String string = this.dataBuffer2.toString();
        if (((this.inScope == 1 || this.inScope == 2) && this.entryDataType != 51L && this.entryDataType != 52L || loadData && (this.inScope == 3 || this.inScope == 4) && this.varDataType != 51L && this.varDataType != 52L) && (string = string.trim()).length() > 0 && !valueElement) {
            string = this.handleNumbers(string);
        }
        try {
            if (this.inScope == 1 || this.inScope == 2 || this.inScope == 7 || this.inScope == 6) {
                this.createEntry(string);
            } else if (loadData) {
                if (this.inScope == 3) {
                    this.loadVarRecordData(string);
                } else if (this.inScope == 4) {
                    this.loadVarElementData(string);
                } else if (this.inScope == 6) {
                    this.loadAttributeEntryData(string, false);
                } else if (this.inScope == 6) {
                    this.loadAttributeEntryData(string, true);
                }
            }
        }
        catch (CDFException cDFException) {
            System.err.println("\n CDFException 3..: " + (Object)((Object)cDFException));
            System.exit(1);
        }
        this.dataBuffer.setLength(0);
    }

    private String handleNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.elementDelimiter != null) {
            string = this.removeSpaces(string, this.elementDelimiter);
            String[] stringArray = string.split(this.elementDelimiter, -1);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.length() == 0) continue;
                stringBuffer.append(string2).append(" ");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken()).append(" ");
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        return stringBuffer.toString();
    }

    private void createCDF(Attributes attributes) throws CDFException {
        if (newCDFName != null && outputDir == null) {
            this.cdfName = newCDFName;
        } else {
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string = attributes.getLocalName(i);
                    if ("".equals(string)) {
                        string = attributes.getQName(i);
                    }
                    if (!string.equalsIgnoreCase("name")) continue;
                    this.cdfName = attributes.getValue(i);
                }
            }
            this.cdfName = this.cdfName.substring(this.cdfName.lastIndexOf(System.getProperty("file.separator")) + 1);
            if (outputDir != null) {
                this.cdfName = outputDir + this.cdfName;
            }
            CDFML2CDF.checkCDFFile(this.cdfName);
        }
        if (backward) {
            CDF.setFileBackward((long)1L);
        }
        this.cdf = CDF.create((String)this.cdfName);
        this.entryBlock = false;
        this.recordBlock = false;
    }

    private void closeCDF() throws CDFException {
        this.cdf.close();
    }

    private void setCDF(Attributes attributes) throws CDFException {
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                long l;
                long l2;
                String string = attributes.getLocalName(i);
                if ("".equals(string)) {
                    string = attributes.getQName(i);
                }
                if (string.equalsIgnoreCase("fileFormat")) {
                    long l3 = CDFUtils.getLongFormat((String)attributes.getValue(i));
                    this.cdf.setFormat(l3);
                    continue;
                }
                if (string.equalsIgnoreCase("compression")) {
                    String string2 = attributes.getValue(i);
                    if (string2.length() > 4 && string2.substring(0, 4).equalsIgnoreCase("gzip")) {
                        l2 = CDFUtils.getLongCompressionType((String)string2.substring(0, 4));
                        l = new Long(string2.substring(5));
                    } else {
                        l2 = CDFUtils.getLongCompressionType((String)string2);
                        l = l2 == 0L ? 0L : 1L;
                    }
                    this.cdf.setCompression(l2, new long[]{l});
                    continue;
                }
                if (string.equalsIgnoreCase("majority")) {
                    long l4 = CDFUtils.getLongMajority((String)attributes.getValue(i));
                    this.cdf.setMajority(l4);
                    continue;
                }
                if (string.equalsIgnoreCase("encoding")) {
                    long l5 = CDFUtils.getLongEncoding((String)attributes.getValue(i));
                    this.cdf.setEncoding(l5);
                    continue;
                }
                if (string.equalsIgnoreCase("NEGtoPOSfp0")) {
                    long l6 = attributes.getValue(i).equalsIgnoreCase("ENABLE") ? -1L : 0L;
                    this.cdf.selectNegtoPosfp0(l6);
                    continue;
                }
                if (string.equalsIgnoreCase("checksum")) {
                    long l7 = CDFUtils.getLongChecksum((String)attributes.getValue(i));
                    this.cdf.setChecksum(l7);
                    continue;
                }
                if (string.equalsIgnoreCase("leapsecondlastupdated")) {
                    String string3 = attributes.getValue(i);
                    if (string3.indexOf("-") == -1) {
                        this.lastUpdated = new Long(string3);
                    } else {
                        l2 = new Long(string3.substring(0, 4));
                        l = new Long(string3.substring(5, 7));
                        long l8 = new Long(string3.substring(8, 10));
                        this.lastUpdated = l2 * 10000L + l * 100L + l8;
                    }
                    this.cdf.setLeapSecondLastUpdated(this.lastUpdated);
                    continue;
                }
                if (string.equalsIgnoreCase("CDFCacheSize")) {
                    long l9 = new Long(attributes.getValue(i));
                    this.cdf.selectCDFCacheSize(l9);
                    continue;
                }
                if (string.equalsIgnoreCase("CompressCacheSize")) {
                    long l10 = new Long(attributes.getValue(i));
                    this.cdf.selectCompressCacheSize(l10);
                    continue;
                }
                if (!string.equalsIgnoreCase("StageCacheSize")) continue;
                long l11 = new Long(attributes.getValue(i));
                this.cdf.selectStageCacheSize(l11);
            }
        }
    }

    private void createAttribute(Attributes attributes) throws CDFException {
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                if ("".equals(string)) {
                    string = attributes.getQName(i);
                }
                if (!string.equalsIgnoreCase("name")) continue;
                this.attrName = attributes.getValue(i);
            }
        }
        this.elementDelimiter = null;
        if (this.scope == 1L) {
            this.attribute = Attribute.create((CDF)this.cdf, (String)this.attrName, (long)1L);
            if (progressReport) {
                System.err.println("  Created global attribute: " + this.attrName + " and start loading entries");
            }
        } else {
            long l = this.cdf.getAttributeID(this.attrName);
            this.attribute = l == -1L ? Attribute.create((CDF)this.cdf, (String)this.attrName, (long)2L) : this.cdf.getAttribute(l);
        }
    }

    private void setEntry(Attributes attributes) {
        entryNumFlag = false;
        this.entryDataType = -1L;
        this.elementDelimiter = null;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                if ("".equals(string)) {
                    string = attributes.getQName(i);
                }
                if (string.equalsIgnoreCase("entryNum")) {
                    entryNumFlag = true;
                    this.entryNum = new Long(attributes.getValue(i));
                    continue;
                }
                if (string.equalsIgnoreCase("cdfDatatype")) {
                    this.entryDataType = CDFUtils.getDataTypeValue((String)attributes.getValue(i));
                    continue;
                }
                if (string.equalsIgnoreCase("numElements")) {
                    this.numElements = new Long(attributes.getValue(i));
                    continue;
                }
                if (!string.equalsIgnoreCase("elementDelimiter")) continue;
                this.elementDelimiter = attributes.getValue(i);
            }
        }
    }

    private void setRecord(Attributes attributes) {
        this.elementDelimiter = null;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                if ("".equals(string)) {
                    string = attributes.getQName(i);
                }
                if (string.equalsIgnoreCase("recNum")) {
                    this.recNum = new Long(attributes.getValue(i));
                    continue;
                }
                if (!string.equalsIgnoreCase("elementDelimiter")) continue;
                this.elementDelimiter = attributes.getValue(i);
            }
        }
    }

    private void createEntry(String string) throws CDFException {
        Object object = this.createEntryObject(string);
        if (object != null) {
            if (this.scope == 1L) {
                if (!entryNumFlag) {
                    ++this.entryNum;
                }
                Entry.create((Attribute)this.attribute, (long)this.entryNum, (long)this.entryDataType, (Object)object);
            } else {
                Entry.create((Attribute)this.attribute, (long)this.var.getID(), (long)this.entryDataType, (Object)object);
            }
        }
    }

    private Object createEntryObject(String string) throws CDFException {
        String[] stringArray = string.split(this.multiDelimiter, -1);
        int n = stringArray.length;
        Object object = null;
        if (this.entryDataType == 1L || this.entryDataType == 41L) {
            object = new byte[n];
            for (int i = 0; i < n; ++i) {
                object[i] = new Byte(stringArray[i]);
            }
        } else if (this.entryDataType == 2L || this.entryDataType == 11L) {
            object = new short[n];
            for (int i = 0; i < n; ++i) {
                ((short[])object)[i] = new Short(stringArray[i]);
            }
        } else if (this.entryDataType == 4L || this.entryDataType == 12L) {
            object = new int[n];
            for (int i = 0; i < n; ++i) {
                ((int[])object)[i] = new Integer(stringArray[i]);
            }
        } else if (this.entryDataType == 14L || this.entryDataType == 8L) {
            object = new long[n];
            for (int i = 0; i < n; ++i) {
                ((long[])object)[i] = new Long(stringArray[i]);
            }
        } else if (this.entryDataType == 21L || this.entryDataType == 44L) {
            object = new float[n];
            for (int i = 0; i < n; ++i) {
                ((float[])object)[i] = new Float(stringArray[i]).floatValue();
            }
        } else if (this.entryDataType == 22L || this.entryDataType == 45L) {
            object = new double[n];
            for (int i = 0; i < n; ++i) {
                ((double[])object)[i] = new Double(stringArray[i]);
            }
        } else if (this.entryDataType == 51L || this.entryDataType == 52L) {
            String string2 = (String)GetMyCDFData.replaceFromXMLStringData(string);
            stringArray = string2.split(this.multiDelimiter, -1);
            String string3 = string2;
            if (n > 1) {
                String[] stringArray2 = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray2[i] = stringArray[i];
                }
                object = stringArray2;
            } else {
                object = string2;
            }
        } else if (this.entryDataType == 31L) {
            double[] dArray;
            String string4 = stringArray[0];
            if (string4.indexOf("-") == -1) {
                dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[0] = new Double(stringArray[i]);
                }
            } else if (string4.length() == 11) {
                dArray = new double[n / 2];
                for (int i = 0; i < n / 2; ++i) {
                    string4 = new String(stringArray[2 * i] + " " + stringArray[2 * i + 1]);
                    dArray[i] = Epoch.parse((String)string4);
                }
            } else {
                dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    if (string4.length() == 24) {
                        dArray[i] = Epoch.parse3((String)stringArray[i]);
                        continue;
                    }
                    if (string4.length() != 23) continue;
                    dArray[i] = Epoch.parse4((String)stringArray[i]);
                }
            }
            object = dArray;
        } else if (this.entryDataType == 32L) {
            double[] dArray;
            String string5 = stringArray[0];
            if (string5.indexOf("-") == -1) {
                dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = new Double(stringArray[i]);
                }
            } else {
                double[] dArray2 = new double[2];
                if (string5.indexOf("\"") > -1) {
                    string5 = string5.replaceAll("\"", " ").trim();
                }
                if (string5.length() == 11) {
                    dArray = new double[n];
                    String string6 = string5 + " " + stringArray[1];
                    if (string6.indexOf("\"") > -1) {
                        string6 = string6.replaceAll("\"", " ").trim();
                    }
                    for (int i = 0; i < n / 2; ++i) {
                        dArray2 = (double[])Epoch16.parse((String)string6);
                        dArray[2 * i] = dArray2[0];
                        dArray[2 * i + 1] = dArray2[1];
                    }
                } else {
                    dArray = new double[2 * n];
                    for (int i = 0; i < n; ++i) {
                        if (string5.length() == 36) {
                            dArray2 = (double[])Epoch16.parse3((String)string5);
                        } else if (string5.length() == 32) {
                            dArray2 = (double[])Epoch16.parse4((String)string5);
                        } else if (string5.length() == 33) {
                            dArray2 = (double[])Epoch16.parse4((String)string5.substring(0, 33));
                        } else {
                            System.err.println("*** Error: cdfml file has an invalid epoch16 data: " + string5);
                            System.exit(1);
                        }
                        dArray[2 * i] = dArray2[0];
                        dArray[2 * i + 1] = dArray2[1];
                    }
                }
            }
            object = dArray;
        } else if (this.entryDataType == 33L) {
            object = new long[n];
            for (int i = 0; i < n; ++i) {
                String string7 = stringArray[i].indexOf("\"") > -1 ? stringArray[i].replaceAll("\"", " ").trim() : stringArray[i];
                ((long[])object)[i] = string7.indexOf("-") == -1 ? new Long(string) : ((int)this.lastUpdated == -1 || (int)this.lastUpdated == 0 ? CDFTT2000.fromUTCstring((String)string7) : CDFTT2000.parseTT2000withBasedLeapDay((String)stringArray[i], (int)((int)this.lastUpdated)));
            }
        } else {
            object = null;
        }
        return object;
    }

    private void setVariable(Attributes attributes) {
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                if ("".equals(string)) {
                    string = attributes.getQName(i);
                }
                if (!string.equalsIgnoreCase("name")) continue;
                this.varName = attributes.getValue(i);
            }
        }
    }

    private void createVariable(Attributes attributes) throws CDFException {
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        long l3 = -1L;
        long l4 = -1L;
        long l5 = -1L;
        long l6 = -1L;
        long l7 = -1L;
        long l8 = -1L;
        if (attributes != null) {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            this.varDataType = -1L;
            this.dim = -1L;
            for (n = 0; n < attributes.getLength(); ++n) {
                int n2;
                int n3;
                StringTokenizer stringTokenizer;
                String string = attributes.getLocalName(n);
                if ("".equals(string)) {
                    string = attributes.getQName(n);
                }
                if (string.equalsIgnoreCase("cdfDatatype")) {
                    this.varDataType = CDFUtils.getDataTypeValue((String)attributes.getValue(n));
                    continue;
                }
                if (string.equalsIgnoreCase("dim")) {
                    this.dim = new Long(attributes.getValue(n));
                    int n4 = (int)(this.dim > 0L ? this.dim : 1L);
                    this.dimSizes = new long[n4];
                    this.dimVariances = new long[n4];
                    this.dimIndex = new long[n4];
                    continue;
                }
                if (string.equalsIgnoreCase("dimSizes")) {
                    bl = true;
                    String string2 = attributes.getValue(n);
                    stringTokenizer = new StringTokenizer(string2, ",");
                    n3 = stringTokenizer.countTokens();
                    if (this.dim != -1L && this.dim != (long)n3 && this.dim != (long)(n3 = (stringTokenizer = new StringTokenizer(string2, " ")).countTokens())) {
                        System.err.println("Var:" + this.varName + " dim=" + this.dim + " dimSizes=" + n3 + " don't match");
                        return;
                    }
                    if (this.dimSizes == null) {
                        this.dimSizes = new long[stringTokenizer.countTokens()];
                    }
                    if (!"".equals(string2) && n3 > 0) {
                        n2 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            this.dimSizes[n2++] = new Long(stringTokenizer.nextToken());
                        }
                        continue;
                    }
                    this.dimSizes[0] = 0L;
                    continue;
                }
                if (string.equalsIgnoreCase("dimVariances")) {
                    bl2 = true;
                    String string3 = attributes.getValue(n);
                    stringTokenizer = new StringTokenizer(string3, ",");
                    n3 = stringTokenizer.countTokens();
                    if (this.dim != -1L && this.dim != (long)n3 && this.dim != (long)(n3 = (stringTokenizer = new StringTokenizer(string3, " ")).countTokens())) {
                        System.err.println("Var:" + this.varName + " dim=" + this.dim + " dimVariances=" + n3 + " don't match");
                        return;
                    }
                    if (this.dimVariances == null) {
                        this.dimVariances = new long[stringTokenizer.countTokens()];
                    }
                    if (!"".equals(string3) && n3 > 0) {
                        n2 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            this.dimVariances[n2] = stringTokenizer.nextToken().equalsIgnoreCase("VARY") ? -1L : 0L;
                            ++n2;
                        }
                        continue;
                    }
                    this.dimVariances[0] = 0L;
                    continue;
                }
                if (string.equalsIgnoreCase("recVariance")) {
                    if (attributes.getValue(n).equalsIgnoreCase("VARY")) {
                        this.recVariance = -1L;
                        continue;
                    }
                    this.recVariance = 0L;
                    continue;
                }
                if (string.equalsIgnoreCase("numElements")) {
                    this.numElements = new Long(attributes.getValue(n));
                    continue;
                }
                if (string.equalsIgnoreCase("compression")) {
                    String string4 = attributes.getValue(n);
                    if (string4.length() > 4 && string4.substring(0, 4).equalsIgnoreCase("gzip")) {
                        l = CDFUtils.getLongCompressionType((String)string4.substring(0, 4));
                        l2 = new Long(string4.substring(5));
                    } else {
                        l = CDFUtils.getLongCompressionType((String)string4);
                        l2 = l == 0L ? 0L : 1L;
                    }
                    bl3 = true;
                    continue;
                }
                if (string.equalsIgnoreCase("sparseRecords")) {
                    bl5 = true;
                    l3 = CDFUtils.getLongSparseRecord((String)attributes.getValue(n));
                    continue;
                }
                if (string.equalsIgnoreCase("blockingFactor")) {
                    bl6 = true;
                    l4 = new Long(attributes.getValue(n));
                    continue;
                }
                if (string.equalsIgnoreCase("numInitialRecords")) {
                    bl7 = true;
                    l5 = new Long(attributes.getValue(n));
                    continue;
                }
                if (string.equalsIgnoreCase("numRecordsAllocate")) {
                    if (bl3) continue;
                    bl8 = true;
                    l6 = new Long(attributes.getValue(n));
                    continue;
                }
                if (string.equalsIgnoreCase("cacheSize")) {
                    bl9 = true;
                    l7 = new Long(attributes.getValue(n));
                    continue;
                }
                if (string.equalsIgnoreCase("reservePercent")) {
                    if (!bl3) continue;
                    bl10 = true;
                    l8 = new Long(attributes.getValue(n));
                    continue;
                }
                if (!string.equalsIgnoreCase("padValue")) continue;
                bl4 = true;
                String string5 = attributes.getValue(n);
                if (this.varDataType == 1L || this.varDataType == 41L) {
                    object = new Byte(string5);
                    continue;
                }
                if (this.varDataType == 2L || this.varDataType == 11L) {
                    object = new Short(string5);
                    continue;
                }
                if (this.varDataType == 4L || this.varDataType == 12L) {
                    object = new Integer(string5);
                    continue;
                }
                if (this.varDataType == 14L || this.varDataType == 8L) {
                    object = new Long(string5);
                    continue;
                }
                if (this.varDataType == 21L || this.varDataType == 44L) {
                    object = new Float(string5);
                    continue;
                }
                if (this.varDataType == 22L || this.varDataType == 45L) {
                    object = new Double(string5);
                    continue;
                }
                if (this.varDataType == 51L || this.varDataType == 52L) {
                    object = (String)GetMyCDFData.replaceFromXMLStringData(string5);
                    continue;
                }
                if (this.varDataType == 31L) {
                    if (string5.indexOf("-") == -1) {
                        object = new Double(string5);
                        continue;
                    }
                    if (string5.length() == 24 && !string5.substring(23).equalsIgnoreCase("Z")) {
                        object = new Double(Epoch.parse((String)string5));
                        continue;
                    }
                    if (string5.length() == 24) {
                        object = new Double(Epoch.parse3((String)string5));
                        continue;
                    }
                    if (string5.length() == 23) {
                        object = new Double(Epoch.parse4((String)string5));
                        continue;
                    }
                    object = new Double(string5);
                    continue;
                }
                if (this.varDataType == 32L) {
                    object = new double[2];
                    if (string5.length() == 36 && !string5.substring(35).equalsIgnoreCase("Z")) {
                        object = Epoch16.parse((String)string5);
                        continue;
                    }
                    if (string5.length() == 36) {
                        object = Epoch16.parse3((String)string5);
                        continue;
                    }
                    if (string5.length() == 32) {
                        object = Epoch16.parse4((String)string5);
                        continue;
                    }
                    if (string5.length() == 33) {
                        object = Epoch16.parse4((String)string5.substring(0, 33));
                        continue;
                    }
                    System.err.println("*** Error: cdfml file has an invalid epoch16 data: " + string5);
                    System.exit(1);
                    continue;
                }
                if (this.varDataType != 33L) continue;
                object = string5.indexOf("-") == -1 ? new Long(string5) : ((int)this.lastUpdated == -1 || (int)this.lastUpdated == 0 ? new Long(CDFTT2000.fromUTCstring((String)string5)) : new Long(CDFTT2000.parseTT2000withBasedLeapDay((String)string5, (int)((int)this.lastUpdated))));
            }
            if (this.dim > 0L) {
                if (!bl || !bl2) {
                    System.err.println("\nError... dimSizes or dimVariances not provided for variable:" + this.varName + "!");
                    return;
                }
                this.phyDims = (int)this.dim;
                this.physicalSize = 1;
                n = 0;
                while ((long)n < this.dim) {
                    this.physicalSize *= (int)this.dimSizes[n];
                    ++n;
                }
            } else {
                this.dimSizes[0] = 1L;
                this.dimVariances[0] = -1L;
                this.phyDims = 1;
                this.physicalSize = 1;
            }
            this.var = Variable.create((CDF)this.cdf, (String)this.varName, (long)this.varDataType, (long)this.numElements, (long)this.dim, (long[])this.dimSizes, (long)this.recVariance, (long[])this.dimVariances);
            if (progressReport) {
                String string = loadData ? " and start loading its data" : " ";
                System.err.println("  Created variable " + this.var.getID() + ": " + this.varName + string);
            }
            if (bl3) {
                this.var.setCompression(l, new long[]{l2});
            }
            if (bl4) {
                this.var.setPadValue(object);
            }
            if (bl5) {
                this.var.setSparseRecords(l3);
            }
            if (bl6) {
                this.var.setBlockingFactor(l4);
            }
            if (bl9) {
                this.var.selectCacheSize(l7);
            }
            if (bl10) {
                this.var.selectReservePercent(l8);
            }
            if (bl7 && l5 > 0L) {
                this.var.setInitialRecords(l5);
            }
            if (bl8 && l6 > 0L) {
                this.var.allocateRecords(l6);
            }
        }
    }

    private void loadVarRecordData(String string) throws CDFException {
        String string2 = new String(string);
        String[] stringArray = string.split(this.multiDelimiter, -1);
        int n = stringArray.length;
        this.recInterval = 1L;
        this.recCount = 1L;
        if (this.dimIndices == null) {
            this.dimIndices = new long[this.phyDims];
            this.dimCounts = new long[this.phyDims];
            this.dimIntervals = new long[this.phyDims];
            for (int i = 0; i < this.phyDims; ++i) {
                this.dimIndices[i] = 0L;
                this.dimCounts[i] = this.dimSizes[i];
                this.dimIntervals[i] = 1L;
            }
            this.dataObject = this.createObject(this.phyDims, this.dimSizes, this.varDataType);
        }
        Object[] objectArray = null;
        if (this.varDataType == 1L || this.varDataType == 41L) {
            objectArray = (byte[])this.convertNumberData(n, stringArray, this.varDataType);
        } else if (this.varDataType == 2L || this.varDataType == 11L) {
            objectArray = (short[])this.convertNumberData(n, stringArray, this.varDataType);
        } else if (this.varDataType == 4L || this.varDataType == 12L) {
            objectArray = (int[])this.convertNumberData(n, stringArray, this.varDataType);
        } else if (this.varDataType == 14L || this.varDataType == 8L) {
            objectArray = (long[])this.convertNumberData(n, stringArray, this.varDataType);
        } else if (this.varDataType == 21L || this.varDataType == 44L) {
            objectArray = (float[])this.convertNumberData(n, stringArray, this.varDataType);
        } else if (this.varDataType == 22L || this.varDataType == 45L) {
            objectArray = (double[])this.convertNumberData(n, stringArray, this.varDataType);
        } else if (this.varDataType == 51L || this.varDataType == 52L) {
            objectArray = new byte[(int)((long)this.physicalSize * this.numElements)];
            byte by = 0;
            int n2 = 0;
            while ((long)n2 < (long)this.physicalSize * this.numElements) {
                objectArray[n2] = by;
                ++n2;
            }
            if (this.elementDelimiter != null) {
                if (!valueElement) {
                    string = this.removeSpaces(string, this.elementDelimiter);
                }
                String[] stringArray2 = string.split(this.multiDelimiter, -1);
                n2 = 0;
                n = 0;
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string3 = stringArray2[i];
                    if (string3.length() == 0) continue;
                    System.arraycopy(string3.getBytes(), 0, objectArray, (int)((long)n2 * this.numElements), string3.length());
                    ++n;
                    if (++n2 != this.physicalSize) {
                        continue;
                    }
                    break;
                }
            } else {
                String[] stringArray3 = string.split(this.multiDelimiter, -1);
                n2 = 0;
                n = 0;
                for (int i = 0; i < stringArray3.length; ++i) {
                    String string4 = stringArray3[i];
                    if (string4.length() == 0) continue;
                    System.arraycopy(string4.getBytes(), 0, objectArray, (int)((long)n2 * this.numElements), string4.length());
                    ++n;
                    if (++n2 != this.physicalSize) {
                        continue;
                    }
                    break;
                }
            }
        } else if (this.varDataType == 31L) {
            double[] dArray;
            String[] stringArray4 = string.split(this.multiDelimiter, -1);
            String string5 = stringArray4[0];
            if (string5.indexOf("-") == -1) {
                dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = new Double(stringArray4[i]);
                }
            } else if (string5.length() == 11) {
                int n3 = n / 2;
                dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    String string6 = stringArray4[2 * i] + " " + stringArray4[2 * i + 1];
                    dArray[i] = Epoch.parse((String)string6);
                }
            } else {
                dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    String string7 = stringArray4[i];
                    dArray[i] = string7.length() == 24 ? Epoch.parse3((String)string7) : Epoch.parse4((String)string7);
                }
            }
            objectArray = dArray;
        } else if (this.varDataType == 32L) {
            String[] stringArray5 = string.split(this.multiDelimiter, -1);
            Object object = new double[2];
            String string8 = stringArray5[0];
            if (string8.length() == 11) {
                int n4 = n / 2;
                objectArray = new double[n];
                for (int i = 0; i < n4; ++i) {
                    String string9 = stringArray5[2 * i] + " " + stringArray5[2 * i + 1];
                    object = Epoch16.parse((String)string9);
                    ((double[])objectArray)[2 * i] = object[0];
                    ((double[])objectArray)[2 * i + 1] = object[1];
                }
            } else {
                String string10 = stringArray5[0];
                objectArray = new double[n * 2];
                int n5 = 0;
                for (int i = 0; i < n; ++i) {
                    if (string10.length() == 32) {
                        object = Epoch16.parse4((String)string10);
                    } else if (string10.length() == 33) {
                        object = Epoch16.parse4((String)string10.substring(0, 33));
                    } else {
                        System.err.println("*** Error: cdfml file has an invalid epoch16 data: " + string10);
                        System.exit(1);
                    }
                    ((double[])objectArray)[n5++] = object[0];
                    ((double[])objectArray)[n5++] = object[1];
                }
            }
        } else if (this.varDataType == 33L) {
            objectArray = new long[n];
            String[] stringArray6 = string.split(this.multiDelimiter, -1);
            String string11 = stringArray6[0];
            if (string11.indexOf("-") == -1) {
                for (int i = 0; i < n; ++i) {
                    ((long[])objectArray)[i] = new Long(stringArray6[i]);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    ((long[])objectArray)[i] = (int)this.lastUpdated == -1 || (int)this.lastUpdated == 0 ? CDFTT2000.fromUTCstring((String)stringArray6[i]) : CDFTT2000.parseTT2000withBasedLeapDay((String)stringArray6[i], (int)((int)this.lastUpdated));
                }
            }
        }
        if (objectArray != null) {
            this.var.putHyperData(this.recNum, this.recCount, this.recInterval, this.dimIndices, this.dimCounts, this.dimIntervals, (Object)objectArray);
            ++this.recNum;
        }
    }

    private void loadVarElementData(String string) throws CDFException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.indexString, ",");
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < this.phyDims; ++i) {
            this.dimIndex[i] = new Long(stringTokenizer.nextToken());
        }
        Object object = null;
        if (this.varDataType == 1L || this.varDataType == 41L) {
            object = new Byte(string);
        } else if (this.varDataType == 2L || this.varDataType == 11L) {
            object = new Short(string);
        } else if (this.varDataType == 4L || this.varDataType == 12L) {
            object = new Integer(string);
        } else if (this.varDataType == 14L || this.varDataType == 8L) {
            object = new Long(string);
        } else if (this.varDataType == 21L || this.varDataType == 44L) {
            object = new Float(string);
        } else if (this.varDataType == 22L || this.varDataType == 45L) {
            object = new Double(string);
        } else if (this.varDataType == 51L || this.varDataType == 52L) {
            object = (long)(string = (String)GetMyCDFData.replaceFromXMLStringData(string)).length() > this.numElements ? string.substring(0, (int)this.numElements) : string;
        } else if (this.varDataType == 31L) {
            object = string.indexOf("-") == -1 ? new Double(string.trim()) : (string.trim().length() != 23 ? new Double(Epoch.parse((String)string)) : new Double(Epoch.parse4((String)string)));
        } else if (this.varDataType == 32L) {
            object = new double[2];
            if (string.trim().length() != 32 && string.trim().length() != 33) {
                object = Epoch16.parse((String)string);
            } else if (string.trim().length() == 32) {
                object = Epoch16.parse4((String)string);
            } else if (string.trim().length() == 33) {
                object = Epoch16.parse4((String)string.substring(0, 33));
            } else {
                System.err.println("*** Error: cdfml file has an invalid epoch16 data: " + string);
                System.exit(1);
            }
        } else if (this.varDataType == 33L) {
            object = string.indexOf("-") == -1 ? new Long(string.trim()) : ((int)this.lastUpdated == -1 || (int)this.lastUpdated == 0 ? new Long(CDFTT2000.fromUTCstring((String)string)) : new Long(CDFTT2000.parseTT2000withBasedLeapDay((String)string, (int)((int)this.lastUpdated))));
        }
        if (object != null) {
            this.var.putSingleData(this.recNum, this.dimIndex, object);
        }
    }

    private long findDateValueDataType(String string) {
        string = string.trim();
        int n = string.length();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n2 = stringTokenizer.countTokens();
        long l = -1L;
        if (n <= 24) {
            l = 31L;
        } else if (n <= 30) {
            l = 33L;
        } else if (n <= 36) {
            l = 32L;
        } else {
            String string2 = stringTokenizer.nextToken();
            int n3 = string2.length();
            if (n3 == 11) {
                int n4 = (n - (n2 / 2 - 1)) / (n2 / 2);
                l = n == 24 ? 31L : 32L;
            } else {
                int n5 = (n - 1) / n2;
                if (n5 <= 24) {
                    l = 31L;
                } else if (n5 <= 30) {
                    l = 33L;
                } else if (n5 <= 36) {
                    l = 32L;
                }
            }
        }
        return l;
    }

    private void loadAttributeEntryData(String string, boolean bl) throws CDFException {
        string = string.trim();
        int n = string.length();
        String[] stringArray = string.split(this.multiDelimiter, -1);
        int n2 = stringArray.length;
        Object object = null;
        if (this.entryDataType == 1L || this.entryDataType == 41L) {
            if (n2 == 1) {
                object = new Byte(string);
            } else {
                byte[] byArray = new byte[n2];
                for (int i = 0; i < n2; ++i) {
                    byArray[i] = new Byte(stringArray[i]);
                }
                object = byArray;
            }
        } else if (this.entryDataType == 2L || this.entryDataType == 11L) {
            if (n2 == 1) {
                object = new Short(string);
            } else {
                short[] sArray = new short[n2];
                for (int i = 0; i < n2; ++i) {
                    sArray[i] = new Short(stringArray[i]);
                }
                object = sArray;
            }
        } else if (this.entryDataType == 4L || this.entryDataType == 12L) {
            if (n2 == 1) {
                object = new Integer(string);
            } else {
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = new Integer(stringArray[i]);
                }
                object = nArray;
            }
        } else if (this.entryDataType == 14L || this.entryDataType == 8L) {
            if (n2 == 1) {
                object = new Long(string);
            } else {
                long[] lArray = new long[n2];
                for (int i = 0; i < n2; ++i) {
                    lArray[i] = new Long(stringArray[i]);
                }
                object = lArray;
            }
        } else if (this.entryDataType == 21L || this.entryDataType == 44L) {
            if (n2 == 1) {
                object = new Float(string);
            } else {
                float[] fArray = new float[n2];
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = new Float(stringArray[i]).floatValue();
                }
                object = fArray;
            }
        } else if (this.entryDataType == 22L || this.entryDataType == 45L) {
            if (n2 == 1) {
                object = new Double(string);
            } else {
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = new Double(stringArray[i]);
                }
                object = dArray;
            }
        } else if (this.entryDataType == 51L || this.entryDataType == 52L) {
            object = (String)GetMyCDFData.replaceFromXMLStringData(string);
        } else if (this.entryDataType == 31L) {
            if (string.indexOf("-") == -1) {
                if (n2 == 1) {
                    object = new Double(string.trim());
                } else {
                    double[] dArray = new double[n2];
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = new Double(stringArray[i]);
                    }
                    object = dArray;
                }
            } else if (string.substring(n - 1).toLowerCase().equals("z")) {
                if (n2 == 1) {
                    object = new Double(Epoch.parse3((String)string));
                } else {
                    double[] dArray = new double[n2];
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = Epoch.parse3((String)stringArray[i]);
                    }
                    object = dArray;
                }
            } else if (!string.substring(10, 11).toLowerCase().equals("t")) {
                if ((n2 /= 2) == 1) {
                    object = new Double(Epoch.parse((String)string));
                } else {
                    double[] dArray = new double[n2];
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = Epoch.parse((String)(stringArray[2 * i] + " " + stringArray[2 * i + 1]));
                    }
                    object = dArray;
                }
            } else if (n2 == 1) {
                object = new Double(Epoch.parse4((String)string));
            } else {
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = Epoch.parse4((String)stringArray[i]);
                }
                object = dArray;
            }
        } else if (this.entryDataType == 32L) {
            double[] dArray = new double[2];
            if (string.substring(n - 1).toLowerCase().equals("z")) {
                if (n2 == 1) {
                    object = n == 36 ? Epoch16.parse3((String)string) : Epoch16.parse4((String)string.substring(0, 32));
                } else {
                    double[] dArray2 = new double[2 * n2];
                    if ((n - n2 + 1) % 36 == 0) {
                        for (int i = 0; i < n2; ++i) {
                            dArray = (double[])Epoch16.parse3((String)stringArray[i]);
                            dArray2[i * 2] = dArray[0];
                            dArray2[i * 2 + 1] = dArray[1];
                        }
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            dArray = (double[])Epoch16.parse4((String)stringArray[i].substring(0, 32));
                            dArray2[i * 2] = dArray[0];
                            dArray2[i * 2 + 1] = dArray[1];
                        }
                    }
                    object = dArray2;
                }
            } else if (!string.substring(10, 11).toLowerCase().equals("t")) {
                if ((n2 /= 2) == 1) {
                    object = Epoch16.parse((String)string);
                } else {
                    double[] dArray3 = new double[n2 * 2];
                    for (int i = 0; i < n2; ++i) {
                        dArray = (double[])Epoch16.parse((String)(stringArray[2 * i] + " " + stringArray[2 * i + 1]));
                        dArray3[i * 2] = dArray[0];
                        dArray3[i * 2 + 1] = dArray[1];
                    }
                    object = dArray3;
                }
            } else if (n2 == 1) {
                object = Epoch16.parse4((String)string);
            } else {
                double[] dArray4 = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray = (double[])Epoch16.parse4((String)stringArray[i]);
                    dArray4[i * 2] = dArray[0];
                    dArray4[i * 2 + 1] = dArray[1];
                }
                object = dArray4;
            }
        } else if (this.entryDataType == 33L) {
            if (string.indexOf("-") == -1) {
                if (n2 == 1) {
                    object = new Long(string.trim());
                } else {
                    long[] lArray = new long[n2];
                    for (int i = 0; i < n2; ++i) {
                        lArray[i] = new Long(stringArray[i]);
                    }
                    object = lArray;
                }
            } else if (n2 == 1) {
                object = string.substring(n - 1).toLowerCase().equals("z") ? new Long(CDFTT2000.parse((String)string.substring(0, 29))) : new Long(CDFTT2000.parse((String)string));
            } else {
                long[] lArray = new long[n2];
                if ((n - n2) % 29 == 0) {
                    for (int i = 0; i < n2; ++i) {
                        lArray[i] = CDFTT2000.parse((String)stringArray[i]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        lArray[i] = CDFTT2000.parse((String)stringArray[i].substring(0, 29));
                    }
                }
                object = lArray;
            }
        }
        if (object != null) {
            if (bl) {
                Entry.create((Attribute)this.attribute, (long)this.entry.getID(), (long)this.entryDataType, (Object)object);
            } else {
                Entry.create((Attribute)this.attribute, (long)this.var.getID(), (long)this.entryDataType, (Object)object);
            }
        }
    }

    private Object createObject(long l, long[] lArray, long l2) throws CDFException {
        Object object = null;
        Class<Number> clazz = null;
        int[] nArray = new int[(int)l];
        int n = 0;
        while ((long)n < l) {
            nArray[n] = (int)lArray[n];
            ++n;
        }
        if (l2 == 32L) {
            if (l == 0L) {
                nArray[0] = 2;
            } else {
                nArray[(int)l - 1] = 2 * nArray[(int)l - 1];
            }
        }
        switch ((int)l2) {
            case 51: 
            case 52: {
                clazz = new String().getClass();
                break;
            }
            case 1: 
            case 41: {
                clazz = Byte.TYPE;
                break;
            }
            case 2: 
            case 11: {
                clazz = Short.TYPE;
                break;
            }
            case 4: 
            case 12: {
                clazz = Integer.TYPE;
                break;
            }
            case 8: 
            case 14: 
            case 33: {
                clazz = Long.TYPE;
                break;
            }
            case 21: 
            case 44: {
                clazz = Float.TYPE;
                break;
            }
            case 22: 
            case 31: 
            case 32: 
            case 45: {
                clazz = Double.TYPE;
                break;
            }
        }
        try {
            object = Array.newInstance(clazz, nArray);
        }
        catch (Exception exception) {
            throw new CDFException(-2022L);
        }
        return object;
    }

    private Object convertNumberData(int n, String[] stringArray, long l) throws CDFException {
        Object[] objectArray = null;
        switch ((int)l) {
            case 51: 
            case 52: {
                objectArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    objectArray[i] = (String)GetMyCDFData.replaceFromXMLStringData(string);
                }
                break;
            }
            case 1: 
            case 41: {
                objectArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    ((byte[])objectArray)[i] = new Byte(stringArray[i]);
                }
                break;
            }
            case 2: 
            case 11: {
                objectArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    ((short[])objectArray)[i] = new Short(stringArray[i]);
                }
                break;
            }
            case 4: 
            case 12: {
                objectArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    ((int[])objectArray)[i] = new Integer(stringArray[i]);
                }
                break;
            }
            case 8: 
            case 14: {
                objectArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    ((long[])objectArray)[i] = new Long(stringArray[i]);
                }
                break;
            }
            case 21: 
            case 44: {
                objectArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    ((float[])objectArray)[i] = new Float(stringArray[i]).floatValue();
                }
                break;
            }
            case 22: 
            case 45: {
                objectArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    ((double[])objectArray)[i] = new Double(stringArray[i]);
                }
                break;
            }
        }
        return objectArray;
    }

    private static String fileToURL(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("No such file: " + file.getName());
        }
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return "file:" + string;
    }

    private String removeSpaces(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf(string2) == -1) {
            return string;
        }
        int n = string2.length();
        int n2 = 0;
        int n3 = -1;
        int n4 = string.length();
        int n5 = -1;
        if (n4 == 0) {
            return null;
        }
        while (n2 < n4 && (n5 = string.substring(n2).indexOf(string2)) != -1 && (n5 = string.substring((n2 += n5) + n).indexOf(string2)) != -1) {
            n3 = n2 + n + n5;
            stringBuffer.append(string.substring(n2, n3 + n));
            n2 = n3 + n;
        }
        return stringBuffer.toString();
    }

    private static void howto() {
        System.err.println(" ");
        System.err.println("Description:");
        System.err.println("    This program converts a cdfml (an XML) file that conforms to the");
        System.err.println("    cdf.dtd or cdf.xsd into a CDF file.");
        System.err.println(" ");
        System.err.println("Usage: java [-Dorg.xml.sax.driver=...] CDFML2CDF [Options] xmlFileName");
        System.err.println(" ");
        System.err.println("    The SAX2 parser is used to parse the XML document. ");
        System.err.println("    The default SAX2 parser can be set up through a system resource ");
        System.err.println("    at SAX2 JAR file's META-INF/services/org.xml.sax.driver if ");
        System.err.println("    your SAX2 distribution supports it through the class loader.");
        System.err.println("    Otherwise, the system property for org.xml.sax.driver has to be");
        System.err.println("    set for the parser. The parser classes are JVM/SAX2-dependent.");
        System.err.println("    If Sun's Java V1.4 and above is used, you don't have to specify");
        System.err.println("    the parser as its Crimson will be used as the default.\n");
        System.err.println("    For Xerces: org.apache.xerces.parsers.SAXParser");
        System.err.println("        Crimson (SUN 1.4): org.apache.crimson.parser.XMLReaderImpl");
        System.err.println("        AElfred2: gnu.xml.aelfred2.XmlReader (validating) or ");
        System.err.println("                  gnu.xml.aelfred2.SAXDriver (non-validating)");
        System.err.println("        Oracle: oracle.xml.parser.v2.SAXParser");
        System.err.println(" ");
        System.err.println("Options: ");
        System.err.println("   -[no]Validate       Whether to validate the XML file during the process. ");
        System.err.println("                       It's parser dependent. -noValidate is the default. ");
        System.err.println("   -[no]Delete         Whether to delete the CDF file if it already exists. ");
        System.err.println("                       -noDelete is the default. ");
        System.err.println("   -[cdf | output]:[cdfFileName | cdfDirecotry]");
        System.err.println("                       A new CDF file name or directory to replace the given");
        System.err.println("                       name at element's name attribute in the XML file. No");
        System.err.println("                       \".cdf\" extension is needed. If providing an existing");
        System.err.println("                       directory, the directory is to combine with the XML's");
        System.err.println("                       CDF element's name attribute to constitute the full");
        System.err.println("                       pathname.");
        System.err.println("   -[no]Data           Whether to load the variable record data values if they");
        System.err.println("                       are in the XML file to the CDF file. -Data is the");
        System.err.println("                       default.");
        System.err.println("   -[no]Backward       Whether to create the CDF in an older, V2.7, version,");
        System.err.println("                       instead of the current library V3.* version. -noBackward");
        System.err.println("                       is the default. ");
        System.err.println("   -[no]Progress       Whether to display the progress.");
        System.err.println("                       -noProgress is the default. ");
        System.err.println(" ");
        System.err.println("Examples: \n");
        System.err.println(" 1) java CDFML2CDF -Validate testcdfml.xml ");
        System.err.println("         if your JAR file's META-INF/services/org.xml.sax.driver is defined,");
        System.err.println("         such as Xerces and AElfred2's parsers. ");
        System.err.println(" 2) java -Dorg.xml.sax.driver=org.apache.xerces.parsers.SAXParser CDFML2CDF");
        System.err.println("         -Delete -CDF:test1 testcdfml.xml ");
        System.err.println("         use Xerces's Parser and create a CDF file, test1.cdf. ");
        System.err.println(" 3) java -Dorg.xml.sax.driver=org.apache.crimson.parser.XMLReaderImpl CDFML2CDF");
        System.err.println("         -CDF:test1 -noData testcdfml.xml ");
        System.err.println("         use Sun's Java V1.4 and create test1.cdf but passing the variable");
        System.err.println("         record data.");
        System.err.println(" 4) java -Dorg.xml.sax.driver=oracle.xml.parser.v2.SAXParser CDFML2CDF");
        System.err.println("         -CDF:/home/mydir -delete -noData myCDFML.xml ");
        System.err.println("          use Oracle's parser and create /home/mydir/xxxx.cdf where xxxx comes");
        System.err.println("          from the name attribute at the CDF element in myCDFML.xml.");
        System.err.println(" ");
        System.exit(0);
    }

    private void packData() {
        String string = this.dataBuffer.toString().trim();
        if (this.dataBuffer2.length() == 0) {
            if (string.length() > 0) {
                this.dataBuffer2.append(string);
            }
        } else if (string.length() > 0) {
            this.dataBuffer2.append(this.multiDelimiter).append(string);
        }
    }

    private long xsdDateTimeToCDFEpoch(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.toLowerCase(), " ");
        String string2 = stringTokenizer.nextToken();
        int n = string2.length();
        if (n == 11) {
            string2 = new StringBuffer(string2).append(" ").append(stringTokenizer.nextToken()).toString();
        }
        if (string2.endsWith("z")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((n = string2.length()) == 23 || n == 24) {
            return 31L;
        }
        if (n == 29) {
            return 33L;
        }
        if (n == 32 || n == 36) {
            return 32L;
        }
        return 31L;
    }

    static {
        outputDir = null;
        defaultStrDelimiter = "@~";
    }
}

