/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Vector;

public class CDFData
implements CDFObject,
CDFConstants {
    private Variable _myVar;
    private Object _data = null;
    private Object _dataArray = null;
    private long id;
    private long cdfID;
    private long numValues;
    private long numElements;
    private long numDims;
    private long[] varDimSizes;
    private String dataSignature;
    private long dataType;
    private int nDims = 0;
    private int[] dimSizes;
    private long recStart;
    private long recCount;
    private long recInterval;
    private long[] dimIndices;
    private long[] dimCounts;
    private long[] dimIntervals;

    public Object getData() {
        return this._dataArray;
    }

    public Object getRawData() {
        return this._data;
    }

    public int getnDims() {
        return this.nDims;
    }

    public int[] getDimSizes() {
        return this.dimSizes;
    }

    public long getRecStart() {
        return this.recStart;
    }

    public long getRecCount() {
        return this.recCount;
    }

    public long getRecInterval() {
        return this.recInterval;
    }

    public long[] getDimIndices() {
        return this.dimIndices;
    }

    public long[] getDimCounts() {
        return this.dimCounts;
    }

    public long[] getDimIntervals() {
        return this.dimIntervals;
    }

    private CDFData(Variable variable) {
        this._myVar = variable;
        this.id = this._myVar.getID();
        this.cdfID = this._myVar.getMyCDF().getID();
        this.dataType = this._myVar.getDataType();
        this.numElements = this._myVar.getNumElements();
        this.numDims = this._myVar.getNumDims();
        this.varDimSizes = this._myVar.getDimSizes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final CDFData get(Variable variable, long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        Variable variable2 = variable;
        synchronized (variable2) {
            CDFData cDFData = new CDFData(variable);
            cDFData.recStart = l;
            cDFData.recCount = l2;
            cDFData.recInterval = l3;
            if (variable.getNumDims() > 0L) {
                cDFData.dimIndices = lArray;
                cDFData.dimCounts = lArray2;
                cDFData.dimIntervals = lArray3;
            } else {
                cDFData.dimIndices = new long[]{0L};
                cDFData.dimCounts = new long[]{1L};
                cDFData.dimIntervals = new long[]{1L};
            }
            cDFData.initDimAndSizes();
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            Vector<String> vector5 = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            Vector<String> vector7 = new Vector<String>();
            Vector<String> vector8 = new Vector<String>();
            Vector<String> vector9 = new Vector<String>();
            Vector<String> vector10 = new Vector<String>();
            cDFData.buildDataObject();
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector10.addElement("cdfID");
            vector10.addElement("J");
            vector.addElement(vector10);
            vector.addElement(new Long(57L));
            vector2.addElement("id");
            vector2.addElement("J");
            vector.addElement(vector2);
            vector.addElement(new Long(79L));
            vector3.addElement("recStart");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector.addElement(new Long(80L));
            vector4.addElement("recCount");
            vector4.addElement("J");
            vector.addElement(vector4);
            vector.addElement(new Long(81L));
            vector5.addElement("recInterval");
            vector5.addElement("J");
            vector.addElement(vector5);
            vector.addElement(new Long(82L));
            vector6.addElement("dimIndices");
            vector6.addElement("[J");
            vector.addElement(vector6);
            vector.addElement(new Long(83L));
            vector7.addElement("dimCounts");
            vector7.addElement("[J");
            vector.addElement(vector7);
            vector.addElement(new Long(84L));
            vector8.addElement("dimIntervals");
            vector8.addElement("[J");
            vector.addElement(vector8);
            vector.addElement(new Long(1007L));
            vector.addElement(new Long(67L));
            vector9.addElement("_data");
            vector9.addElement("Ljava/lang/Object;");
            vector.addElement(vector9);
            vector.addElement(new Long(1000L));
            cDFData._myVar.getMyCDF().executeCommand(cDFData, vector);
            cDFData.arrayify();
            return cDFData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final CDFData put(Variable variable, long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3, Object object) throws CDFException {
        Variable variable2 = variable;
        synchronized (variable2) {
            String string = object.getClass().getName();
            switch ((int)variable.getDataType()) {
                case 51: 
                case 52: {
                    if (string.indexOf("java.lang.String") != -1 || string.indexOf("[B") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 1: 
                case 41: {
                    if (string.indexOf("[B") != -1 || string.indexOf("Byte") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 2: 
                case 11: {
                    if (string.indexOf("[S") != -1 || string.indexOf("Short") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 4: 
                case 12: {
                    if (string.indexOf("[I") != -1 || string.indexOf("Integer") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 14: {
                    if (string.indexOf("[J") != -1 || string.indexOf("Long") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 8: 
                case 33: {
                    if (string.indexOf("[J") != -1 || string.indexOf("Long") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 21: 
                case 44: {
                    if (string.indexOf("[F") != -1 || string.indexOf("Float") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 22: 
                case 31: 
                case 45: {
                    if (string.indexOf("[D") != -1 || string.indexOf("Double") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 32: {
                    if (string.indexOf("[D") != -1) break;
                }
            }
            CDFData cDFData = new CDFData(variable);
            cDFData._dataArray = object;
            cDFData.recStart = l;
            cDFData.recCount = l2;
            cDFData.recInterval = l3;
            cDFData.dimIndices = lArray;
            cDFData.dimCounts = lArray2;
            cDFData.dimIntervals = lArray3;
            cDFData.initDimAndSizes();
            cDFData.vectorize();
            cDFData.dataSignature = CDFUtils.getSignature(cDFData._data);
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            Vector<String> vector5 = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            Vector<String> vector7 = new Vector<String>();
            Vector<String> vector8 = new Vector<String>();
            Vector<String> vector9 = new Vector<String>();
            Vector<String> vector10 = new Vector<String>();
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector10.addElement("cdfID");
            vector10.addElement("J");
            vector.addElement(vector10);
            vector.addElement(new Long(57L));
            vector2.addElement("id");
            vector2.addElement("J");
            vector.addElement(vector2);
            vector.addElement(new Long(79L));
            vector3.addElement("recStart");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector.addElement(new Long(80L));
            vector4.addElement("recCount");
            vector4.addElement("J");
            vector.addElement(vector4);
            vector.addElement(new Long(81L));
            vector5.addElement("recInterval");
            vector5.addElement("J");
            vector.addElement(vector5);
            vector.addElement(new Long(82L));
            vector6.addElement("dimIndices");
            vector6.addElement("[J");
            vector.addElement(vector6);
            vector.addElement(new Long(83L));
            vector7.addElement("dimCounts");
            vector7.addElement("[J");
            vector.addElement(vector7);
            vector.addElement(new Long(84L));
            vector8.addElement("dimIntervals");
            vector8.addElement("[J");
            vector.addElement(vector8);
            vector.addElement(new Long(1008L));
            vector.addElement(new Long(67L));
            vector9.addElement("_data");
            vector9.addElement("Ljava/lang/Object;");
            vector.addElement(vector9);
            vector.addElement(new Long(1000L));
            cDFData._myVar.getMyCDF().executeCommand(cDFData, vector);
            return cDFData;
        }
    }

    private long product(int[] nArray, int n, int n2) {
        long l = 1L;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] <= 1) continue;
            l *= (long)nArray[i];
        }
        return l;
    }

    private void arrayify() throws CDFException {
        if (this.nDims <= 1 || this.numValues == 1L) {
            if (this.dataType == 51L || this.dataType == 52L) {
                if (this.nDims == 0) {
                    this._dataArray = new String((byte[])this._data);
                } else {
                    this.buildDataArray();
                    int n = 0;
                    byte[] byArray = new byte[(int)this.numElements];
                    for (int i = 0; i < this.dimSizes[0]; ++i) {
                        System.arraycopy(this._data, n, byArray, 0, (int)this.numElements);
                        int n2 = (int)this.numElements;
                        for (int j = 0; j < (int)this.numElements; ++j) {
                            if (byArray[j] != 0) continue;
                            n2 = j;
                            break;
                        }
                        Array.set(this._dataArray, i, new String(byArray, 0, n2));
                        n = (int)((long)n + this.numElements);
                    }
                }
            } else {
                this._dataArray = this._data;
            }
        } else {
            int n;
            this.buildDataArray();
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            for (n = 1; n < this.nDims - 1; ++n) {
                objectArray2[n] = Array.get(objectArray2[n - 1], 0);
                lArray[n] = this.product(this.dimSizes, n, this.nDims);
                nArray[n] = 0;
            }
            n = 0;
            Object object = this._dataArray;
            while ((long)n < this.numValues) {
                int n3;
                if (n != 0) {
                    for (n3 = 0; n3 < this.nDims - 1; ++n3) {
                        boolean bl;
                        boolean bl2 = bl = (long)n % lArray[n3] == 0L;
                        if (bl) {
                            int n4 = n3;
                            nArray[n4] = nArray[n4] + 1;
                            objectArray2[n3] = object = Array.get(object, nArray[n3]);
                            for (int i = n3 + 1; i < this.nDims - 1; ++i) {
                                nArray[i] = 0;
                                objectArray2[i] = Array.get(objectArray2[i - 1], 0);
                            }
                            break;
                        }
                        object = objectArray2[n3];
                    }
                }
                for (n3 = 0; n3 < this.dimSizes[this.nDims - 2]; ++n3) {
                    switch ((int)this._myVar.getDataType()) {
                        case 51: 
                        case 52: {
                            byte[] byArray = new byte[(int)this.numElements];
                            objectArray = new String[this.dimSizes[this.nDims - 1]];
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                System.arraycopy(this._data, n, byArray, 0, (int)this.numElements);
                                int n5 = (int)this.numElements;
                                for (int j = 0; j < (int)this.numElements; ++j) {
                                    if (byArray[j] != 0) continue;
                                    n5 = j;
                                    break;
                                }
                                ((String[])objectArray)[i] = new String(byArray, 0, n5);
                                n = (int)((long)n + this.numElements);
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            objectArray = new byte[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 2: 
                        case 11: {
                            objectArray = new short[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 4: 
                        case 12: {
                            objectArray = new int[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 14: {
                            objectArray = new long[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 8: 
                        case 33: {
                            objectArray = new long[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 21: 
                        case 44: {
                            objectArray = new float[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 22: 
                        case 31: 
                        case 45: {
                            objectArray = new double[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 32: {
                            objectArray = new double[2 * this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, 2 * this.dimSizes[this.nDims - 1]);
                            n += 2 * this.dimSizes[this.nDims - 1];
                            break;
                        }
                    }
                    Array.set(objectArray2[this.nDims - 2], n3, objectArray);
                }
            }
        }
    }

    private void vectorize() throws CDFException {
        block29: {
            int n;
            block25: {
                block26: {
                    block27: {
                        int n2;
                        block28: {
                            if (this.nDims > 1 && this.numValues != 1L) break block25;
                            if (this.dataType != 51L && this.dataType != 52L) break block26;
                            String string = this._dataArray.getClass().getName();
                            if (string.indexOf("[B") != -1) break block27;
                            n2 = 0;
                            if (this.nDims != 0) break block28;
                            this._data = new byte[(int)this.numElements];
                            int n3 = 0;
                            while ((long)n3 < this.numElements) {
                                ((byte[])this._data)[n3] = 0;
                                ++n3;
                            }
                            if (((String)this._dataArray).length() == 0) break block29;
                            int n4 = ((String)this._dataArray).length();
                            System.arraycopy(((String)this._dataArray).getBytes(), 0, this._data, 0, (int)((long)n4 > this.numElements ? this.numElements : (long)n4));
                            break block29;
                        }
                        this.buildDataObject();
                        for (int i = 0; i < this.dimSizes[0]; ++i) {
                            int n5 = 0;
                            while ((long)n5 < this.numElements) {
                                ((byte[])this._data)[n2 + n5] = 0;
                                ++n5;
                            }
                            if (((String[])this._dataArray)[i].length() != 0) {
                                int n6 = ((String[])this._dataArray)[i].length();
                                System.arraycopy(((String[])this._dataArray)[i].getBytes(), 0, this._data, n2, (int)((long)n6 > this.numElements ? this.numElements : (long)n6));
                            }
                            n2 = (int)((long)n2 + this.numElements);
                        }
                        break block29;
                    }
                    this._data = this._dataArray;
                    break block29;
                }
                this._data = this._dataArray;
                break block29;
            }
            this.buildDataObject();
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            for (n = 1; n < this.nDims - 1; ++n) {
                objectArray2[n] = Array.get(objectArray2[n - 1], 0);
                lArray[n] = this.product(this.dimSizes, n, this.nDims);
                nArray[n] = 0;
            }
            n = 0;
            Object object = this._dataArray;
            while ((long)n < this.numValues) {
                int n7;
                int n8;
                if (n != 0) {
                    for (n8 = 0; n8 < this.nDims - 1; ++n8) {
                        boolean bl;
                        boolean bl2 = bl = (long)n % lArray[n8] == 0L;
                        if (bl) {
                            int n9 = n8;
                            nArray[n9] = nArray[n9] + 1;
                            objectArray2[n8] = object = Array.get(object, nArray[n8]);
                            for (n7 = n8 + 1; n7 < this.nDims - 1; ++n7) {
                                nArray[n7] = 0;
                                objectArray2[n7] = Array.get(objectArray2[n7 - 1], nArray[n7]);
                            }
                            break;
                        }
                        object = objectArray2[n8];
                    }
                }
                block18: for (n8 = 0; n8 < this.dimSizes[this.nDims - 2]; ++n8) {
                    switch ((int)this._myVar.getDataType()) {
                        case 51: 
                        case 52: {
                            objectArray = (String[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                int n10 = 0;
                                while ((long)n10 < this.numElements) {
                                    ((byte[])this._data)[n + n10] = 0;
                                    ++n10;
                                }
                                if (((String[])objectArray)[n7] != null) {
                                    n10 = ((String[])objectArray)[n7].length();
                                    System.arraycopy(((String[])objectArray)[n7].getBytes(), 0, this._data, n, (int)((long)n10 > this.numElements ? this.numElements : (long)n10));
                                }
                                n = (int)((long)n + this.numElements);
                            }
                            continue block18;
                        }
                        case 1: 
                        case 41: {
                            objectArray = (byte[])Array.get(objectArray2[this.nDims - 2], n8);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block18;
                        }
                        case 2: 
                        case 11: {
                            objectArray = new short[this.dimSizes[this.nDims - 1]];
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n8);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block18;
                        }
                        case 4: 
                        case 12: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n8);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block18;
                        }
                        case 14: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n8);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block18;
                        }
                        case 8: 
                        case 33: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n8);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block18;
                        }
                        case 21: 
                        case 44: {
                            objectArray = (float[])Array.get(objectArray2[this.nDims - 2], n8);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block18;
                        }
                        case 22: 
                        case 31: 
                        case 45: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n8);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block18;
                        }
                        case 32: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n8);
                            System.arraycopy(objectArray, 0, this._data, n, 2 * this.dimSizes[this.nDims - 1]);
                            n += 2 * this.dimSizes[this.nDims - 1];
                            continue block18;
                        }
                    }
                }
            }
        }
    }

    private void initDimAndSizes() {
        this.numValues = 1L;
        if (this._dataArray != null) {
            this.nDims = this._dataArray.getClass().getName().lastIndexOf("[") + 1;
            if (this._dataArray.getClass().isArray()) {
                Object object = this._dataArray;
                this.dimSizes = new int[this.nDims];
                for (int i = 0; i < this.nDims; ++i) {
                    this.dimSizes[i] = Array.getLength(object);
                    this.numValues *= (long)this.dimSizes[i];
                    object = Array.get(object, 0);
                }
            } else {
                this.dimSizes = new int[1];
                this.dimSizes[0] = 1;
            }
            this.numValues *= this.numElements;
        } else {
            int n;
            int n2;
            this.nDims = this.recCount > 1L ? 1 : 0;
            int n3 = this.dimCounts.length;
            if (n3 == 1) {
                if (this.dimCounts[0] > 1L || this.numDims > 0L && this.varDimSizes[0] == 1L) {
                    ++this.nDims;
                }
            } else {
                n2 = 0;
                for (n = 0; n < n3; ++n) {
                    if (this.dimCounts[n] <= 1L && this.varDimSizes[n] != 1L) continue;
                    ++this.nDims;
                }
            }
            if (this.nDims > 0) {
                this.dimSizes = new int[this.nDims];
                if (this.nDims == 1) {
                    this.dimSizes[0] = this.recCount > 1L ? (int)this.recCount : (int)this.dimCounts[0];
                } else if (this.recCount > 1L) {
                    n2 = 0;
                    this.dimSizes[0] = (int)this.recCount;
                    n = 0;
                    while ((long)n < this.numDims) {
                        if (this.dimCounts[n] > 1L || this.varDimSizes[n] == 1L) {
                            this.dimSizes[++n2] = (int)this.dimCounts[n];
                        }
                        ++n;
                    }
                } else {
                    n2 = -1;
                    n = 0;
                    while ((long)n < this.numDims) {
                        if (this.dimCounts[n] > 1L || this.varDimSizes[n] == 1L) {
                            this.dimSizes[++n2] = (int)this.dimCounts[n];
                        }
                        ++n;
                    }
                }
                for (n2 = 0; n2 < this.nDims; ++n2) {
                    this.numValues *= (long)this.dimSizes[n2];
                }
            } else {
                this.dimSizes = new int[1];
                this.dimSizes[0] = 1;
            }
            this.numValues *= this.numElements;
        }
    }

    private void buildDataArray() throws CDFException {
        int[] nArray = new int[this.nDims - 1];
        System.arraycopy(this.dimSizes, 0, nArray, 0, this.nDims - 1);
        String string = null;
        switch ((int)this._myVar.getDataType()) {
            case 51: 
            case 52: {
                string = "java.lang.String";
                nArray = this.dimSizes;
                break;
            }
            case 1: 
            case 41: {
                string = "[B";
                break;
            }
            case 2: 
            case 11: {
                string = "[S";
                break;
            }
            case 4: 
            case 12: {
                string = "[I";
                break;
            }
            case 8: 
            case 14: 
            case 33: {
                string = "[J";
                break;
            }
            case 21: 
            case 44: {
                string = "[F";
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                string = "[D";
                break;
            }
            case 32: {
                string = "[D";
                break;
            }
        }
        try {
            Class<?> clazz = Class.forName(string);
            this._dataArray = Array.newInstance(clazz, nArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CDFException(-2022L);
        }
    }

    private void buildDataObject() throws CDFException {
        int n = (int)this._myVar.getDataType();
        Object object = null;
        if (this._myVar.checkPadValueExistence()) {
            object = this._myVar.getPadValue();
        }
        switch (n) {
            case 51: 
            case 52: {
                int n2;
                this.dataSignature = "[B";
                this._data = new byte[(int)this.numValues];
                for (n2 = 0; n2 < (int)this.numValues; ++n2) {
                    ((byte[])this._data)[n2] = 0;
                }
                if (object == null) {
                    ((byte[])this._data)[0] = n == 51 ? new Character(' ').toString().getBytes()[0] : new Character(' ').toString().getBytes()[0];
                    n2 = 1;
                    while ((long)n2 < this.numValues) {
                        ((byte[])this._data)[n2] = 0;
                        ++n2;
                    }
                } else {
                    byte[] byArray = ((String)object).getBytes();
                    int n3 = byArray.length;
                    if (n3 <= 0) break;
                    int n4 = n3;
                    int n5 = (int)this._myVar.getNumElements();
                    int n6 = (int)this.numValues / n5;
                    if (n4 > n5) {
                        n4 = n5;
                    }
                    for (int i = 0; i < n6; ++i) {
                        for (n2 = 0; n2 < n4; ++n2) {
                            ((byte[])this._data)[i * n5 + n2] = byArray[n2];
                        }
                    }
                }
                break;
            }
            case 1: 
            case 41: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[B";
                    this._data = new byte[(int)this.numValues];
                    if (object == null) {
                        int n7 = 0;
                        while ((long)n7 < this.numValues) {
                            ((byte[])this._data)[n7] = n == 1 ? -127 : -127;
                            ++n7;
                        }
                    } else {
                        int n8 = 0;
                        while ((long)n8 < this.numValues) {
                            ((byte[])this._data)[n8] = (Byte)object;
                            ++n8;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Byte;";
                if (object == null) {
                    if (n == 1) {
                        this._data = new Byte(-127);
                        break;
                    }
                    this._data = new Byte(-127);
                    break;
                }
                this._data = new Byte((Byte)object);
                break;
            }
            case 2: 
            case 11: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[S";
                    this._data = new short[(int)this.numValues];
                    if (object == null) {
                        int n9 = 0;
                        while ((long)n9 < this.numValues) {
                            ((short[])this._data)[n9] = n == 2 ? -32767 : 254;
                            ++n9;
                        }
                    } else {
                        int n10 = 0;
                        while ((long)n10 < this.numValues) {
                            ((short[])this._data)[n10] = (Short)object;
                            ++n10;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Short;";
                if (object == null) {
                    if (n == 2) {
                        this._data = new Short(-32767);
                        break;
                    }
                    this._data = new Short(254);
                    break;
                }
                this._data = new Short((Short)object);
                break;
            }
            case 4: 
            case 12: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[I";
                    this._data = new int[(int)this.numValues];
                    if (object == null) {
                        int n11 = 0;
                        while ((long)n11 < this.numValues) {
                            ((int[])this._data)[n11] = n == 4 ? -2147483647 : 65534;
                            ++n11;
                        }
                    } else {
                        int n12 = 0;
                        while ((long)n12 < this.numValues) {
                            ((int[])this._data)[n12] = (Integer)object;
                            ++n12;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Integer;";
                if (object == null) {
                    if (n == 4) {
                        this._data = new Integer(-2147483647);
                        break;
                    }
                    this._data = new Integer(65534);
                    break;
                }
                this._data = new Integer((Integer)object);
                break;
            }
            case 8: 
            case 14: 
            case 33: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[J";
                    this._data = new long[(int)this.numValues];
                    if (object == null) {
                        int n13 = 0;
                        while ((long)n13 < this.numValues) {
                            ((long[])this._data)[n13] = n == 14 ? 0xFFFFFFFEL : (n == 8 ? -9223372036854775807L : -9223372036854775807L);
                            ++n13;
                        }
                    } else {
                        int n14 = 0;
                        while ((long)n14 < this.numValues) {
                            ((long[])this._data)[n14] = (Long)object;
                            ++n14;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Long;";
                if (object == null) {
                    this._data = new Long(n == 14 ? 0xFFFFFFFEL : (n == 8 ? -9223372036854775807L : -9223372036854775807L));
                    break;
                }
                this._data = new Long((Long)object);
                break;
            }
            case 21: 
            case 44: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[F";
                    this._data = new float[(int)this.numValues];
                    if (object == null) {
                        int n15 = 0;
                        while ((long)n15 < this.numValues) {
                            ((float[])this._data)[n15] = n == 21 ? -1.0E30f : -1.0E30f;
                            ++n15;
                        }
                    } else {
                        int n16 = 0;
                        while ((long)n16 < this.numValues) {
                            ((float[])this._data)[n16] = ((Float)object).floatValue();
                            ++n16;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Float;";
                if (object == null) {
                    if (n == 21) {
                        this._data = new Float(-1.0E30f);
                        break;
                    }
                    this._data = new Float(-1.0E30f);
                    break;
                }
                this._data = new Float(((Float)object).floatValue());
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[D";
                    this._data = new double[(int)this.numValues];
                    if (object == null) {
                        int n17 = 0;
                        while ((long)n17 < this.numValues) {
                            ((double[])this._data)[n17] = n == 22 ? -1.0E30 : (n == 45 ? -1.0E30 : 0.0);
                            ++n17;
                        }
                    } else {
                        int n18 = 0;
                        while ((long)n18 < this.numValues) {
                            ((double[])this._data)[n18] = (Double)object;
                            ++n18;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Double;";
                if (object == null) {
                    if (n == 22) {
                        this._data = new Double(-1.0E30);
                        break;
                    }
                    if (n == 45) {
                        this._data = new Double(-1.0E30);
                        break;
                    }
                    this._data = new Double(0.0);
                    break;
                }
                this._data = new Double((Double)object);
                break;
            }
            case 32: {
                this.dataSignature = "[D";
                this._data = new double[2 * (int)this.numValues];
                if (object == null) {
                    int n19 = 0;
                    while ((long)n19 < this.numValues) {
                        ((double[])this._data)[2 * n19] = 0.0;
                        ((double[])this._data)[2 * n19 + 1] = 0.0;
                        ++n19;
                    }
                } else {
                    int n20 = 0;
                    while ((long)n20 < this.numValues) {
                        ((double[])this._data)[2 * n20] = ((double[])object)[0];
                        ((double[])this._data)[2 * n20 + 1] = ((double[])object)[1];
                        ++n20;
                    }
                }
                break;
            }
        }
    }

    public void dumpData() {
        if (this.nDims <= 1 || this.numValues == 1L) {
            if (this.nDims == 0 || this.numValues == 1L) {
                if (this._myVar.getDataType() == 31L) {
                    Double d = (Double)this._dataArray;
                    System.out.println(Epoch.encode4(d));
                } else if (this._myVar.getDataType() == 32L) {
                    double[] dArray = (double[])this._dataArray;
                    System.out.println(Epoch16.encode4(dArray));
                } else if (this._myVar.getDataType() == 33L) {
                    Long l = (Long)this._dataArray;
                    System.out.println(CDFTT2000.encode(l));
                } else if (this._myVar.getDataType() == 51L || this._myVar.getDataType() == 52L) {
                    System.out.println("\"" + this._dataArray.toString() + "\"");
                } else {
                    System.out.println(this._dataArray.toString());
                }
            } else {
                System.out.print("[");
                int n = (int)this._myVar.getDataType();
                switch (n) {
                    case 51: 
                    case 52: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print("\"" + ((String[])this._dataArray)[i] + "\"");
                        }
                        break;
                    }
                    case 1: 
                    case 41: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((byte[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((short[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 11: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            if (((short[])this._dataArray)[i] >= 0) {
                                System.out.print(((short[])this._dataArray)[i]);
                                continue;
                            }
                            short s = (short)(((short[])this._dataArray)[i] + 256);
                            System.out.print(s);
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((int[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 12: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            if (((int[])this._dataArray)[i] >= 0) {
                                System.out.print(((int[])this._dataArray)[i]);
                                continue;
                            }
                            int n2 = ((int[])this._dataArray)[i] + 65536;
                            System.out.print(n2);
                        }
                        break;
                    }
                    case 14: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            if (((long[])this._dataArray)[i] >= 0L) {
                                System.out.print(((long[])this._dataArray)[i]);
                                continue;
                            }
                            long l = ((long[])this._dataArray)[i] + 0x100000000L;
                            System.out.print(l);
                        }
                        break;
                    }
                    case 8: 
                    case 33: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            if (n == 8) {
                                System.out.print(((long[])this._dataArray)[i]);
                                continue;
                            }
                            System.out.print(CDFTT2000.encode(((long[])this._dataArray)[i]));
                        }
                        break;
                    }
                    case 21: 
                    case 44: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((float[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 22: 
                    case 45: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((double[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 31: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(Epoch.encode4(((double[])this._dataArray)[i]));
                        }
                        break;
                    }
                    case 32: {
                        double[] dArray = new double[2];
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            dArray[0] = ((double[])this._dataArray)[2 * i];
                            dArray[1] = ((double[])this._dataArray)[2 * i + 1];
                            System.out.print(Epoch16.encode4(dArray));
                        }
                        break;
                    }
                }
                System.out.println("]");
            }
        } else {
            int n;
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            for (n = 1; n < this.nDims - 1; ++n) {
                objectArray2[n] = Array.get(objectArray2[n - 1], 0);
                lArray[n] = this.product(this.dimSizes, n, this.nDims);
                nArray[n] = 0;
            }
            n = 0;
            Object object = this._dataArray;
            while ((long)n < lArray[0]) {
                int n3;
                int n4;
                if (n != 0) {
                    for (n4 = 0; n4 < this.nDims - 1; ++n4) {
                        boolean bl;
                        boolean bl2 = bl = (long)n % lArray[n4] == 0L;
                        if (bl) {
                            int n5 = n4;
                            nArray[n5] = nArray[n5] + 1;
                            objectArray2[n4] = object = Array.get(object, nArray[n4]);
                            for (n3 = n4 + 1; n3 < this.nDims - 1; ++n3) {
                                nArray[n3] = 0;
                                objectArray2[n3] = Array.get(objectArray2[n3 - 1], nArray[n3]);
                            }
                            break;
                        }
                        object = objectArray2[n4];
                    }
                }
                for (n4 = 0; n4 < this.dimSizes[this.nDims - 2]; ++n4) {
                    System.out.print("[");
                    n3 = (int)this._myVar.getDataType();
                    switch (n3) {
                        case 51: 
                        case 52: {
                            objectArray = (String[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                System.out.print("\"" + objectArray[i] + "\"");
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            objectArray = (byte[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((byte[])objectArray)[i]);
                            }
                            break;
                        }
                        case 2: {
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((short[])objectArray)[i]);
                            }
                            break;
                        }
                        case 11: {
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                if (((short[])objectArray)[i] >= 0) {
                                    System.out.print(((short[])objectArray)[i]);
                                    continue;
                                }
                                short s = (short)(((short[])objectArray)[i] + 256);
                                System.out.print(s);
                            }
                            break;
                        }
                        case 4: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((int[])objectArray)[i]);
                            }
                            break;
                        }
                        case 12: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                if (((int[])objectArray)[i] >= 0) {
                                    System.out.print(((int[])objectArray)[i]);
                                    continue;
                                }
                                int n6 = ((int[])objectArray)[i] + 65536;
                                System.out.print(n6);
                            }
                            break;
                        }
                        case 14: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                if (((long[])objectArray)[i] >= 0L) {
                                    System.out.print(((long[])objectArray)[i]);
                                    continue;
                                }
                                long l = ((long[])objectArray)[i] + 0x100000000L;
                                System.out.print(l);
                            }
                            break;
                        }
                        case 8: 
                        case 33: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                if (n3 == 8) {
                                    System.out.print(((long[])objectArray)[i]);
                                    continue;
                                }
                                System.out.print(CDFTT2000.encode(((long[])objectArray)[i]));
                            }
                            break;
                        }
                        case 21: 
                        case 44: {
                            objectArray = (float[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((float[])objectArray)[i]);
                            }
                            break;
                        }
                        case 22: 
                        case 45: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((double[])objectArray)[i]);
                            }
                            break;
                        }
                        case 31: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(Epoch.encode4(((double[])objectArray)[i]));
                            }
                            break;
                        }
                        case 32: {
                            double[] dArray = new double[2];
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                dArray[0] = ((double[])objectArray)[2 * i];
                                dArray[1] = ((double[])objectArray)[2 * i + 1];
                                System.out.print(Epoch16.encode4(dArray));
                            }
                            break;
                        }
                    }
                    System.out.println("]");
                    n += this.dimSizes[this.nDims - 1];
                }
            }
        }
    }

    public void dump() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        System.err.println("Data dump for " + this._myVar + ": ");
        stringBuffer.append(CDFUtils.getStringDataType(this._myVar.getDataType()));
        stringBuffer.append("/");
        stringBuffer.append(this._myVar.getNumElements());
        int n2 = 12 - stringBuffer.length();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(" ");
        }
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer2.append(String.valueOf(this.nDims));
        stringBuffer2.append(":[");
        for (n = 0; n < this.nDims; ++n) {
            if (n > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimSizes[n]));
        }
        stringBuffer2.append("]\t");
        stringBuffer2.append(String.valueOf(this.recStart));
        stringBuffer2.append("/");
        stringBuffer2.append(String.valueOf(this.recCount));
        stringBuffer2.append("/");
        stringBuffer2.append(String.valueOf(this.recInterval));
        stringBuffer2.append("/[");
        for (n = 0; n < this.dimIndices.length; ++n) {
            if (n > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimIndices[n]));
        }
        stringBuffer2.append("]/[");
        for (n = 0; n < this.dimCounts.length; ++n) {
            if (n > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimCounts[n]));
        }
        stringBuffer2.append("]/[");
        for (n = 0; n < this.dimIntervals.length; ++n) {
            if (n > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimIntervals[n]));
        }
        stringBuffer2.append("]/");
        stringBuffer2.append(this._dataArray.getClass().getName());
        System.err.println(stringBuffer2.toString());
        this.dumpData();
    }

    @Override
    public String getName() {
        return "Data";
    }

    @Override
    public void rename(String string) throws CDFException {
    }

    @Override
    public void delete() throws CDFException {
    }
}

