/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.ArrayAttribute;
import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.ByteVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFFactory;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.DoubleVarContainer;
import gov.nasa.gsfc.spdf.cdfj.Extractor;
import gov.nasa.gsfc.spdf.cdfj.FloatVarContainer;
import gov.nasa.gsfc.spdf.cdfj.IntVarContainer;
import gov.nasa.gsfc.spdf.cdfj.LongVarContainer;
import gov.nasa.gsfc.spdf.cdfj.MetaData;
import gov.nasa.gsfc.spdf.cdfj.ShortVarContainer;
import gov.nasa.gsfc.spdf.cdfj.Stride;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;

public class GenericReader
extends MetaData {
    private ThreadGroup tgroup;
    private Hashtable threadMap = new Hashtable();
    static final Hashtable classMap = new Hashtable();

    GenericReader() {
    }

    void setImpl(CDFImpl cDFImpl) {
        this.thisCDF = cDFImpl;
    }

    public GenericReader(String string) throws CDFException.ReaderError {
        File file = new File(string);
        if (!file.exists()) {
            throw new CDFException.ReaderError(string + " does not exist.");
        }
        if (file.length() > Integer.MAX_VALUE) {
            throw new CDFException.ReaderError("Size of file " + string + " exceeds " + "Integer.MAX_VALUE. If data for individual variables is less " + "than this limit, you can use ReaderFactory.getReader(fileName) " + "to get a " + "GenericReader instance for this file.");
        }
        try {
            this.thisCDF = CDFFactory.getCDF(string);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    void setup() {
        this.tgroup = new ThreadGroup(Integer.toHexString(this.hashCode()));
    }

    public GenericReader(URL uRL) throws CDFException.ReaderError {
        try {
            this.thisCDF = CDFFactory.getCDF(uRL);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final Object get(String string) throws CDFException.ReaderError {
        Variable variable = this.thisCDF.getVariable(string);
        if (variable == null) {
            throw new CDFException.ReaderError("No such variable " + string);
        }
        try {
            Method method = Extractor.getMethod(variable, "Series");
            if (method == null || GenericReader.coreNeeded(variable)) {
                return this.thisCDF.get(string);
            }
            return method.invoke(null, this.thisCDF, variable);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final Object getLong(String string) throws CDFException.ReaderError {
        Variable variable = this.thisCDF.getVariable(string);
        if (variable == null) {
            throw new CDFException.ReaderError("No such variable " + string);
        }
        try {
            return this.thisCDF.getLong(string);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final double[] asDouble0(String string) throws CDFException.ReaderError {
        try {
            double[] dArray;
            int n = this.getEffectiveDimensions(string).length;
            if (n != 0) {
                throw new CDFException.ReaderError("Use asDouble" + n + "(" + string + ") for " + n + "-dimensional variable " + string);
            }
            Object object = this.get(string);
            ArrayAttribute arrayAttribute = new ArrayAttribute(object);
            if (arrayAttribute.getType() == Long.TYPE) {
                long[] lArray = (long[])object;
                dArray = new double[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    dArray[i] = lArray[i];
                }
            } else {
                dArray = (double[])object;
            }
            return dArray;
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final double[][] asDouble1(String string) throws CDFException.ReaderError {
        try {
            int n = this.getEffectiveDimensions(string).length;
            if (n != 1) {
                throw new CDFException.ReaderError("Use asDouble" + n + "(" + string + ") for " + n + "-dimensional variable " + string);
            }
            return (double[][])this.get(string);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final double[][][] asDouble2(String string) throws CDFException.ReaderError {
        try {
            int n = this.getEffectiveDimensions(string).length;
            if (n != 2) {
                throw new CDFException.ReaderError("Use asDouble" + n + "(" + string + ") for " + n + "-dimensional variable " + string);
            }
            return (double[][][])this.get(string);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final double[][][][] asDouble3(String string) throws CDFException.ReaderError {
        try {
            int n = this.getEffectiveDimensions(string).length;
            if (n != 3) {
                throw new CDFException.ReaderError("Use asDouble" + n + "(" + string + ") for " + n + "-dimensional variable " + string);
            }
            return (double[][][][])this.get(string);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final double[] getOneD(String string, boolean bl) throws CDFException.ReaderError {
        Variable variable = this.thisCDF.getVariable(string);
        if (variable == null) {
            throw new CDFException.ReaderError("No such variable " + string);
        }
        if (this.getNumberOfValues(string) == 0) {
            return new double[0];
        }
        try {
            return this.thisCDF.getOneD(string, bl);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final Object getRange(String string, int n, int n2) throws CDFException.ReaderError {
        Variable variable = this.thisCDF.getVariable(string);
        if (variable == null) {
            throw new CDFException.ReaderError("No such variable " + string);
        }
        try {
            Method method = Extractor.getMethod(variable, "Range");
            if (method == null || GenericReader.coreNeeded(variable)) {
                return this.thisCDF.getRange(string, n, n2);
            }
            return method.invoke(null, this.thisCDF, variable, new Integer(n), new Integer(n2));
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final double[] getRangeOneD(String string, int n, int n2, boolean bl) throws CDFException.ReaderError {
        Variable variable = this.thisCDF.getVariable(string);
        if (variable == null) {
            throw new CDFException.ReaderError("No such variable " + string);
        }
        try {
            return (double[])this.thisCDF.getRangeOneD(string, n, n2, bl);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final double[] getVectorComponent(String string, int n) throws CDFException.ReaderError {
        this.checkType(string);
        if (this.getEffectiveRank(string) != 1) {
            throw new CDFException.ReaderError(string + " is not a vector.");
        }
        try {
            Variable variable = this.thisCDF.getVariable(string);
            Method method = Extractor.getMethod(variable, "Element");
            if (method == null || GenericReader.coreNeeded(variable)) {
                return (double[])this.thisCDF.get(string, n);
            }
            return (double[])method.invoke(null, this.thisCDF, variable, new Integer(n));
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final double[][] getVectorComponents(String string, int[] nArray) throws Throwable {
        this.checkType(string);
        if (this.getEffectiveRank(string) != 1) {
            throw new CDFException.ReaderError(string + " is not a vector.");
        }
        try {
            Variable variable = this.thisCDF.getVariable(string);
            Method method = Extractor.getMethod(variable, "Elements");
            if (method == null || GenericReader.coreNeeded(variable)) {
                return (double[][])this.thisCDF.get(string, nArray);
            }
            return (double[][])method.invoke(null, this.thisCDF, variable, nArray);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final double[] getRangeForComponent(String string, int n, int n2, int n3) throws CDFException.ReaderError {
        this.checkType(string);
        if (this.getEffectiveRank(string) != 1) {
            throw new CDFException.ReaderError(string + " is not a vector.");
        }
        try {
            Variable variable = this.thisCDF.getVariable(string);
            Method method = Extractor.getMethod(variable, "RangeForElement");
            if (method == null || GenericReader.coreNeeded(variable, new int[]{n, n2})) {
                return (double[])this.thisCDF.getRange(string, n, n2, n3);
            }
            return (double[])method.invoke(null, this.thisCDF, variable, new Integer(n), new Integer(n2), new Integer(n3));
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final double[][] getRangeForComponents(String string, int n, int n2, int[] nArray) throws CDFException.ReaderError {
        this.checkType(string);
        if (this.getEffectiveRank(string) != 1) {
            throw new CDFException.ReaderError(string + " is not a vector.");
        }
        try {
            Variable variable = this.thisCDF.getVariable(string);
            Method method = Extractor.getMethod(variable, "RangeForElements");
            if (method == null || GenericReader.coreNeeded(variable)) {
                return (double[][])this.thisCDF.get(string, n, n2, nArray);
            }
            return (double[][])method.invoke(null, this.thisCDF, variable, new Integer(n), new Integer(n2), nArray);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final String startContainerThread(String string, String string2, int[] nArray, boolean bl) throws CDFException.ReaderError {
        try {
            return this.startContainerThread(string, string2, nArray, bl, ByteOrder.nativeOrder());
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    String startContainerThread(String string, String string2, int[] nArray, boolean bl, ByteOrder byteOrder) throws Throwable {
        String string3 = this.threadName(string, string2, nArray, bl, byteOrder);
        Class clazz = this.getContainerClass(string2);
        VDataContainer vDataContainer = this.getContainer(string, clazz, nArray, bl, byteOrder);
        if (this.tgroup == null) {
            this.setup();
        }
        Thread thread = new Thread(this.tgroup, vDataContainer, string3);
        thread.start();
        this.threadMap.put(string3, new ThreadMapEntry(vDataContainer, thread));
        return string3;
    }

    public final boolean threadFinished(String string) throws CDFException.ReaderError {
        Thread thread = ((ThreadMapEntry)this.threadMap.get(string)).getThread();
        if (thread == null) {
            throw new CDFException.ReaderError("Invalid thread name " + string);
        }
        return thread.getState() == Thread.State.TERMINATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ByteBuffer getBuffer(String string) throws Throwable {
        if (this.threadFinished(string)) {
            Hashtable hashtable = this.threadMap;
            synchronized (hashtable) {
                VDataContainer vDataContainer = ((ThreadMapEntry)this.threadMap.get(string)).getContainer();
                ByteBuffer byteBuffer = null;
                try {
                    byteBuffer = vDataContainer.getBuffer();
                }
                catch (Throwable throwable) {
                    throw new CDFException.ReaderError(throwable.getMessage());
                }
                this.threadMap.remove(string);
                return byteBuffer;
            }
        }
        throw new CDFException.ReaderError("Thread " + string + " is working");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getOneDArray(String string, boolean bl) throws CDFException.ReaderError {
        if (this.threadFinished(string)) {
            Hashtable hashtable = this.threadMap;
            synchronized (hashtable) {
                VDataContainer vDataContainer = ((ThreadMapEntry)this.threadMap.get(string)).getContainer();
                Object object = null;
                try {
                    object = vDataContainer.asOneDArray(bl);
                }
                catch (Throwable throwable) {
                    throw new CDFException.ReaderError(throwable.getMessage());
                }
                this.threadMap.remove(string);
                return object;
            }
        }
        throw new CDFException.ReaderError("Thread " + string + " is working");
    }

    public final ByteBuffer getBuffer(String string, String string2, int[] nArray, boolean bl) throws CDFException.ReaderError {
        return this.getBuffer(string, string2, nArray, bl, true);
    }

    public final ByteBuffer getBuffer(String string, String string2, int[] nArray, boolean bl, boolean bl2) throws CDFException.ReaderError {
        Class clazz;
        try {
            clazz = this.getContainerClass(string2);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        if (!this.isCompatible(string, clazz, bl)) {
            throw new CDFException.ReaderError("Requested type " + string2 + " not compatible with preserve = " + bl);
        }
        VDataContainer vDataContainer = null;
        try {
            vDataContainer = this.getContainer(string, clazz, nArray, bl, ByteOrder.nativeOrder());
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        vDataContainer.setDirect(bl2);
        vDataContainer.run();
        return vDataContainer.getBuffer();
    }

    public final Object getOneDArray(String string, String string2, int[] nArray, boolean bl, boolean bl2) throws CDFException.ReaderError {
        VDataContainer vDataContainer = null;
        try {
            Class clazz = this.getContainerClass(string2);
            vDataContainer = this.getContainer(string, clazz, nArray, bl, ByteOrder.nativeOrder());
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        vDataContainer.run();
        return vDataContainer.asOneDArray(bl2);
    }

    String threadName(String string, String string2, int[] nArray, boolean bl, ByteOrder byteOrder) {
        StringBuffer stringBuffer = new StringBuffer(string + "_" + string2 + "_");
        if (nArray == null) {
            stringBuffer.append("null_");
        } else {
            stringBuffer.append(nArray[0]).append("_").append(nArray[1]);
            stringBuffer.append("_");
        }
        stringBuffer.append(bl).append("_" + Math.random() + "_" + byteOrder);
        return stringBuffer.toString();
    }

    Class getContainerClass(String string) throws Throwable {
        Class clazz = (Class)classMap.get(string.toLowerCase());
        if (clazz == null) {
            throw new Throwable("Unrecognized type " + string);
        }
        return clazz;
    }

    void checkType(String string) throws CDFException.ReaderError {
        Variable variable = this.thisCDF.getVariable(string);
        if (variable == null) {
            throw new CDFException.ReaderError("No such variable " + string);
        }
        int n = variable.getType();
        if (DataTypes.typeCategory[n] == 5) {
            throw new CDFException.ReaderError("This method cannot be used for variables of type long. Use the get methods for the variable and the associated time variable. ");
        }
    }

    public final boolean sourceIsFile() {
        return this.thisCDF.getSource().isFile();
    }

    public final String getSource() {
        return this.thisCDF.getSource().getName();
    }

    public final boolean isScalar(String string) throws CDFException.ReaderError {
        return this.getEffectiveRank(string) == 0;
    }

    public final boolean isVector(String string) throws CDFException.ReaderError {
        return this.getEffectiveRank(string) == 1;
    }

    @Override
    public String userTimeVariableName(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return null;
    }

    BaseVarContainer getRangeContainer(String string, int[] nArray, String string2, boolean bl) throws Throwable {
        if (!this.existsVariable(string)) {
            throw new Throwable("CDF does not hava a variable named " + string);
        }
        if (DataTypes.isStringType(this.getType(string))) {
            throw new Throwable("Function not supported for string variables");
        }
        Class clazz = (Class)classMap.get(string2);
        if (clazz == null) {
            throw new Throwable("Invalid type " + string2);
        }
        BaseVarContainer baseVarContainer = null;
        Variable variable = this.thisCDF.getVariable(string);
        if (string2 == "float") {
            baseVarContainer = new FloatVarContainer(this.thisCDF, variable, nArray, bl);
        }
        if (string2 == "double") {
            baseVarContainer = new DoubleVarContainer(this.thisCDF, variable, nArray, bl);
        }
        if (string2 == "int") {
            baseVarContainer = new IntVarContainer(this.thisCDF, variable, nArray, bl);
        }
        if (string2 == "short") {
            baseVarContainer = new ShortVarContainer(this.thisCDF, variable, nArray, bl);
        }
        if (string2 == "byte") {
            baseVarContainer = new ByteVarContainer(this.thisCDF, variable, nArray);
        }
        if (string2 == "long") {
            baseVarContainer = new LongVarContainer(this.thisCDF, variable, nArray);
        }
        baseVarContainer.run();
        return baseVarContainer;
    }

    public Object getSampled(String string, int[] nArray, int n, String string2, boolean bl, boolean bl2) throws CDFException.ReaderError {
        try {
            int[] nArray2;
            BaseVarContainer baseVarContainer = this.getRangeContainer(string, nArray, string2, bl);
            if (n > 0) {
                int[] nArray3 = new int[1];
                nArray2 = nArray3;
                nArray3[0] = n;
            } else {
                int[] nArray4 = new int[2];
                nArray4[0] = -1;
                nArray2 = nArray4;
                nArray4[1] = -n;
            }
            int[] nArray5 = nArray2;
            return baseVarContainer.asOneDArray(bl2, new Stride(nArray5));
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public Object getSampled(String string, int n, int n2, int n3, String string2, boolean bl) throws CDFException.ReaderError {
        try {
            int[] nArray;
            BaseVarContainer baseVarContainer = this.getRangeContainer(string, new int[]{n, n2}, string2, bl);
            if (n3 > 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = n3;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = -1;
                nArray = nArray3;
                nArray3[1] = -n3;
            }
            int[] nArray4 = nArray;
            return baseVarContainer.asSampledArray(new Stride(nArray4));
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    private static final boolean coreNeeded(Variable variable) {
        return variable.isMissingRecords();
    }

    private static final boolean coreNeeded(Variable variable, int[] nArray) {
        int[] nArray2 = variable.getRecordRange();
        if (nArray.length == 1) {
            if (nArray[0] >= nArray2[0]) {
                return variable.isMissingRecords();
            }
            return true;
        }
        if (nArray[0] >= nArray2[0] && nArray[1] <= nArray2[1]) {
            return variable.isMissingRecords();
        }
        return true;
    }

    VDataContainer getContainer(String string, Class clazz, int[] nArray, boolean bl, ByteOrder byteOrder) throws Throwable {
        Variable variable = this.thisCDF.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable " + string);
        }
        if (clazz == Double.TYPE) {
            return variable.getDoubleContainer(nArray, bl, byteOrder);
        }
        if (clazz == Float.TYPE) {
            return variable.getFloatContainer(nArray, bl, byteOrder);
        }
        if (clazz == Long.TYPE) {
            return variable.getLongContainer(nArray, byteOrder);
        }
        if (clazz == Integer.TYPE) {
            return variable.getIntContainer(nArray, bl, byteOrder);
        }
        if (clazz == Short.TYPE) {
            return variable.getShortContainer(nArray, bl, byteOrder);
        }
        if (clazz == Byte.TYPE) {
            return variable.getByteContainer(nArray);
        }
        if (clazz == String.class) {
            return variable.getStringContainer(nArray);
        }
        throw new Throwable("Invalid type ");
    }

    public final int getBufferCapacity(String string, String string2, int[] nArray) throws CDFException.ReaderError {
        VDataContainer vDataContainer = null;
        try {
            Class clazz = this.getContainerClass(string2);
            vDataContainer = this.getContainer(string, clazz, nArray, false, ByteOrder.nativeOrder());
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        return vDataContainer.getCapacity();
    }

    public final ByteBuffer getBuffer(String string, String string2, int[] nArray, boolean bl, ByteBuffer byteBuffer) throws CDFException.ReaderError {
        VDataContainer vDataContainer = null;
        try {
            Class clazz = this.getContainerClass(string2);
            vDataContainer = this.getContainer(string, clazz, nArray, bl, ByteOrder.nativeOrder());
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        vDataContainer.setUserBuffer(byteBuffer);
        vDataContainer.run();
        return vDataContainer.getBuffer();
    }

    static {
        classMap.put("long", Long.TYPE);
        classMap.put("double", Double.TYPE);
        classMap.put("float", Float.TYPE);
        classMap.put("int", Integer.TYPE);
        classMap.put("short", Short.TYPE);
        classMap.put("byte", Byte.TYPE);
        classMap.put("string", String.class);
    }

    class ThreadMapEntry {
        VDataContainer container;
        Thread thread;

        ThreadMapEntry(VDataContainer vDataContainer, Thread thread) {
            this.container = vDataContainer;
            this.thread = thread;
        }

        VDataContainer getContainer() {
            return this.container;
        }

        Thread getThread() {
            return this.thread;
        }
    }
}

