/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.nio.ByteBuffer;

public class CDR {
    static int libraryVersion = 3;
    static int libraryRelease = 7;
    static int libraryIncrement = 1;
    static int libraryIdentifier = 1;
    static final byte[] magic = new byte[]{-51, -13, 0, 1, 0, 0, -1, -1};
    int encoding = 6;
    int flags = 2;
    ByteBuffer record = ByteBuffer.allocate(312);
    static String copyRight = new String("\nCommon Data Format (CDF)\nhttps://cdf.gsfc.nasa.gov\nSpace Physics Data Facility\nNASA/Goddard Space Flight Center\nGreenbelt, Maryland 20771 USA\n(User support: gsfc-cdf-support@lists.nasa.gov)\n");

    public void setEncoding(int n) {
        this.encoding = n;
    }

    public void setRowMajority(boolean bl) {
        if (bl) {
            this.flags |= 1;
        }
        if (!bl) {
            this.flags &= 0xFFFFFFFE;
        }
    }

    public void setMD5Needed(boolean bl) {
        if (bl) {
            this.flags |= 0xC;
        }
        if (!bl) {
            this.flags &= 0xFFFFFFF3;
        }
    }

    public ByteBuffer get() {
        this.record.position(0);
        this.record.putLong(this.record.capacity());
        this.record.putInt(1);
        this.record.putLong((long)this.record.capacity() + (long)magic.length);
        this.record.putInt(libraryVersion);
        this.record.putInt(libraryRelease);
        this.record.putInt(this.encoding);
        this.record.putInt(this.flags);
        this.record.putInt(0);
        this.record.putInt(0);
        this.record.putInt(libraryIncrement);
        this.record.putInt(libraryIdentifier);
        this.record.putInt(0);
        this.record.put(copyRight.getBytes());
        int n = 256 - copyRight.length();
        this.record.put(String.format("%-" + n + "." + n + "s", " ").getBytes());
        this.record.position(0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.record.capacity() + magic.length);
        byteBuffer.put(magic);
        byteBuffer.put(this.record);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public int getSize() {
        return this.record.capacity() + magic.length;
    }
}

