/******************************************************************************
* Copyright 1996-2014 United States Government as represented by the
* Administrator of the National Aeronautics and Space Administration.
* All Rights Reserved.
******************************************************************************/

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import javax.swing.JTable;
import java.awt.*;

public class ExportVarDisplayTable {

    private JTable table;
    private MyTableModel myModel;
    private Object[][] data;
    private String[] columnNames;

    public ExportVarDisplayTable(Object[][] data,
				 String[] columnNames) {

	this.data = data;
	this.columnNames = columnNames;

        myModel = new MyTableModel();
        table = new JTable(myModel);
//	myModel.addTableModelListener(this);
        table.setPreferredScrollableViewportSize(new Dimension(800, 450));
	table.setRowSelectionAllowed(false);
	table.sizeColumnsToFit(JTable.AUTO_RESIZE_ALL_COLUMNS);
//	table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

	TableColumn column = null;
	for (int i = 0; i < columnNames.length; i++) {
	   column = table.getColumnModel().getColumn(i);
	   column.setResizable(true);
	   if (columnNames[i].equals(ExportCDFTable.headrow1) || 
	       columnNames[i].equals(ExportCDFTable.headrow2))
	        column.setPreferredWidth(50);
           else column.setPreferredWidth(60);
	}
	table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    public void setDataTable(Object[][] data) {
	this.data = data;
	myModel.fireTableChanged(new TableModelEvent(myModel));

    }

    public Object[][] getDataTable() {

        return (Object[][]) data;

    }

    public void setColumnNames(String[] columnNames) {

        this.columnNames = columnNames;

    }

    public String[] getColumnNames() {

        return (String[]) columnNames;

    }

    public JTable getTable() {

        return table;

    }

    public void setTable(JTable newTable) {

        table = newTable;
	if (table != null) 
	  myModel.fireTableChanged(new TableModelEvent(myModel));

    }

    public MyTableModel getModel() {

        return myModel;

    }

    class MyTableModel extends AbstractTableModel {

        static final long serialVersionUID = 1L;

        public int getColumnCount() {
            return columnNames.length;
        }
        
        public int getRowCount() {
            return data.length;
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return data[row][col];
        }

        // public Class getColumnClass(int c) {
        //    return getValueAt(0, c).getClass();
        // }


    }

}

