/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VariableValuePanel
extends JLabeledPanel
implements CDFConstants,
ActionListener,
KeyListener,
FocusListener,
DocumentListener,
VariableEventListener {
    private CDF cdf;
    private MYEditor myEditor;
    private VariablePanel myVP;
    private Variable var = null;
    private Variable oldVar = null;
    private VariableValuePanel values;
    private boolean variance;
    private long nDims;
    private long[] sizes;
    private long dataType;
    private long[] dimVars;
    private long[] dimSizes;
    private Object padValue;
    private long sparseRec;
    private long maxRec;
    private long numElements;
    private long status;
    private String Virtual = "<Virtual>";
    private boolean virtual;
    private Object datavalue;
    private String output;
    private Object focusedObj = null;
    private JLabeledTF jtfRec;
    private JLabeledTF jtfVal;
    private JTextField oldRec;
    private JLabeledPanel jpIndex;
    private JTextField[] jtfIndex;
    private JTextField[] oldIndex;
    private JButton update;
    private JButton cancel;
    private static final String UPDATE = "Update";
    private static final String CANCEL = "Cancel";
    private long[] dimIndex;
    private long recNum;
    private JLabeledPanel jp;
    private String format;
    static final long serialVersionUID = 1L;

    public VariableValuePanel(VariablePanel variablePanel) {
        super("Edit Data", BorderFactory.createEtchedBorder(), 2, 2, new FlowLayout());
        this.setSize(720, 20);
        this.values = this;
        this.myVP = variablePanel;
        this.myEditor = variablePanel.getMyEditor();
        this.cdf = this.myEditor.theCDF;
        this.jtfRec = new JLabeledTF("Record", 10);
        this.jtfRec.textField.setHorizontalAlignment(4);
        this.oldRec = new JTextField();
        this.add(this.jtfRec);
        this.jpIndex = new JLabeledPanel("Index", BorderFactory.createEmptyBorder(), 2, 2, new FlowLayout());
        JTextField jTextField = new JTextField("1");
        JTextField jTextField2 = new JTextField("1");
        JTextField jTextField3 = new JTextField("1");
        this.jpIndex.add(jTextField);
        this.jpIndex.add(jTextField2);
        this.jpIndex.add(jTextField3);
        jTextField.setHorizontalAlignment(4);
        jTextField2.setHorizontalAlignment(4);
        jTextField3.setHorizontalAlignment(4);
        this.add(this.jpIndex);
        this.jtfVal = new JLabeledTF("Data Value", 32);
        this.jtfVal.textField.getDocument().addDocumentListener(this);
        this.jtfVal.textField.addFocusListener(this);
        this.add(this.jtfVal);
        this.add(Box.createRigidArea(new Dimension(18, 8)));
        JPanel jPanel = new JPanel();
        this.update = new JButton(UPDATE){
            static final long serialVersionUID = 1L;

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        this.update.setToolTipText("Click to apply change to the Variable's value");
        this.update.addActionListener(this);
        this.update.setEnabled(false);
        this.add(this.update);
        this.cancel = new JButton(CANCEL){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.cancel.setToolTipText("Click to cancel change to the Variable's value");
        this.cancel.addActionListener(this);
        this.cancel.setEnabled(false);
        this.add(this.cancel);
        this.values.setVisible(false);
    }

    public void set(Variable variable) {
        this.values.setVisible(true);
        this.var = variable;
        if (this.oldVar != null && this.oldVar.getRecVariance()) {
            this.jtfRec.removeActionListener(this);
            this.jtfRec.textField.removeKeyListener(this);
            this.jtfRec.textField.removeFocusListener(this);
        }
        this.oldVar = variable;
        this.variance = variable.getRecVariance();
        this.nDims = variable.getNumDims();
        this.dataType = variable.getDataType();
        this.numElements = variable.getNumElements();
        this.dimVars = variable.getDimVariances();
        this.dimSizes = variable.getDimSizes();
        this.padValue = null;
        try {
            if (variable.checkPadValueExistence()) {
                this.padValue = variable.getPadValue();
            }
        }
        catch (CDFException cDFException) {
            // empty catch block
        }
        this.format = CDFToolUtils.getCFormat(variable);
        this.sparseRec = variable.getSparseRecords();
        try {
            this.maxRec = variable.getMaxWrittenRecord();
        }
        catch (CDFException cDFException) {
            this.maxRec = -1L;
        }
        if (this.variance) {
            this.jtfRec.setEnabled(true);
            this.jtfRec.setEditable(true);
            this.jtfRec.addActionListener(this);
            this.jtfRec.textField.addKeyListener(this);
            this.jtfRec.textField.addFocusListener(this);
            this.jtfRec.textField.setRequestFocusEnabled(true);
        } else {
            this.jtfRec.setEditable(false);
            this.jtfRec.setEnabled(true);
            this.jtfRec.textField.setRequestFocusEnabled(false);
        }
        this.jpIndex.removeAll();
        if (this.nDims > 0L) {
            this.jtfIndex = new JTextField[(int)this.nDims];
            this.oldIndex = new JTextField[(int)this.nDims];
            this.dimIndex = new long[(int)this.nDims];
            for (int i = 0; i < (int)this.nDims; ++i) {
                final long l = this.dimVars[i];
                this.jtfIndex[i] = new JTextField(4){

                    @Override
                    public boolean isFocusTraversable() {
                        return l == -1L;
                    }
                };
                this.jtfIndex[i].setHorizontalAlignment(4);
                this.oldIndex[i] = new JTextField();
                if (this.dimVars[i] == -1L) {
                    this.jtfIndex[i].addActionListener(this);
                    this.jtfIndex[i].addKeyListener(this);
                    this.jtfIndex[i].addFocusListener(this);
                } else {
                    this.jtfIndex[i].setRequestFocusEnabled(false);
                }
                this.jpIndex.add(this.jtfIndex[i]);
            }
        } else {
            this.jtfIndex = new JTextField[1];
            this.jtfIndex[0] = new JTextField();
            this.jtfIndex[0].setHorizontalAlignment(4);
            this.dimIndex = new long[]{0L};
            this.jtfIndex[0] = new JTextField(4);
            this.jtfIndex[0].setEnabled(false);
            this.jtfIndex[0].setRequestFocusEnabled(false);
            this.jpIndex.add(this.jtfIndex[0]);
        }
        this.validate();
        this.setInitialIndex();
        this.showIndexData();
    }

    private void setInitialIndex() {
        this.recNum = 0L;
        if (this.variance) {
            this.jtfRec.set("1");
        } else {
            this.jtfRec.set("*");
        }
        if (this.nDims > 0L) {
            for (int i = 0; i < (int)this.nDims; ++i) {
                String string;
                this.dimIndex[i] = 0L;
                if (this.dimVars[i] == 0L) {
                    string = "*";
                    this.jtfIndex[i].setEditable(false);
                } else {
                    string = "1";
                    this.jtfIndex[i].setEditable(true);
                }
                this.jtfIndex[i].setText(string);
            }
        } else {
            String string = "*";
            this.jtfIndex[0].setEnabled(false);
            this.jtfIndex[0].setEditable(false);
            this.jtfIndex[0].setText(string);
        }
    }

    private void showIndexData() {
        this.virtual = false;
        try {
            this.datavalue = this.var.getSingleData(this.recNum, this.dimIndex);
            this.status = this.cdf.getStatus();
            if (this.status == 1001L) {
                this.virtual = true;
            }
            if (this.dataType == 31L) {
                this.output = Epoch.encode((double)((Double)this.datavalue));
            } else if (this.dataType == 32L) {
                this.output = Epoch16.encode((Object)((double[])this.datavalue));
            } else if (this.dataType == 33L) {
                this.output = CDFTT2000.toUTCstring((long)((Long)this.datavalue));
            } else if (this.dataType == 51L || this.dataType == 52L) {
                if ((long)((String)this.datavalue).length() >= this.numElements) {
                    this.output = ((String)this.datavalue).substring(0, (int)this.numElements);
                } else if ((long)((String)this.datavalue).length() < this.numElements) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < (int)this.numElements - ((String)this.datavalue).length(); ++i) {
                        stringBuffer.append(" ");
                    }
                    this.output = (String)this.datavalue + stringBuffer.toString();
                }
                this.output = "\"" + this.output + "\"";
            } else if (this.format == null) {
                this.output = this.datavalue.toString();
            } else if (this.dataType == 21L || this.dataType == 44L || this.dataType == 45L) {
                double d = this.dataType == 21L || this.dataType == 44L ? (double)((Float)this.datavalue).floatValue() : (Double)this.datavalue;
                this.output = Cformat.getInstance(this.format).form(d).toString();
            } else {
                this.output = this.datavalue.toString();
            }
        }
        catch (CDFException cDFException) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor.getFrame(), "Exception:" + this.cdf.getStatus());
        }
        this.jtfVal.set(this.virtual ? this.output + "     " + this.Virtual : this.output);
        this.update.setEnabled(true);
        this.cancel.setEnabled(true);
    }

    public void reset() {
        this.values.setVisible(false);
    }

    @Override
    public void performVariableAction(VariableEvent variableEvent) {
        Variable variable = variableEvent.getVariable();
        int n = variableEvent.getID();
        switch (n) {
            case 2009: {
                new NewVariableAction(this.myEditor, variable.toString());
                break;
            }
            case 2019: {
                this.reset();
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = (String)this.jtfRec.get();
        long l = string.trim().equals("*") ? 1L : Long.parseLong(string.trim());
        if (this.variance) {
            if (--l < 0L) {
                Toolkit.getDefaultToolkit().beep();
                this.jtfRec.set(this.oldRec.getText());
                return;
            }
            this.oldRec.setText(string);
            this.recNum = l;
        }
        if (this.nDims < 1L) {
            this.dimIndex = new long[]{0L};
        } else {
            int n = 0;
            while ((long)n < this.nDims) {
                if (object == this.jtfIndex[n]) {
                    l = Long.parseLong(this.jtfIndex[n].getText().trim());
                    if (l < 1L || l > this.dimSizes[n]) {
                        Toolkit.getDefaultToolkit().beep();
                        this.jtfIndex[n].setText(this.oldIndex[n].getText());
                        return;
                    }
                    this.oldIndex[n].setText(this.jtfIndex[n].getText());
                    this.dimIndex[n] = l - 1L;
                }
                ++n;
            }
        }
        if (object instanceof JTextField) {
            this.showIndexData();
        } else if (object instanceof JButton) {
            this.update.setEnabled(false);
            this.cancel.setEnabled(false);
            String string2 = actionEvent.getActionCommand();
            if (string2.equals(CANCEL)) {
                this.showIndexData();
            } else if (string2.equals(UPDATE)) {
                try {
                    Object object2 = null;
                    String string3 = ((String)this.jtfVal.get()).trim();
                    boolean bl = false;
                    int n = string3.toLowerCase().indexOf("<virtual>");
                    if (n != -1) {
                        object2 = CDFToolUtils.parseContent(string3.substring(0, n - 1).trim(), this.dataType, this.numElements);
                        this.jtfVal.set(string3);
                    } else {
                        object2 = CDFToolUtils.parseContent(string3, this.dataType, this.numElements);
                    }
                    bl = true;
                    if (bl) {
                        this.var.putSingleData(this.recNum, this.dimIndex, object2);
                        if (this.sparseRec == 0L && this.recNum > this.maxRec || this.sparseRec != 0L && this.virtual) {
                            this.myEditor.variablePanel.getVarSpecPanel().set(this.var);
                            this.myEditor.variablePanel.getRightPanel().revalidate();
                            this.myEditor.variablePanel.getRightPanel().repaint();
                            this.maxRec = this.recNum;
                            if (CDFToolUtils.getMaxRecNum(this.myEditor.theCDF) != this.myEditor.gAttrPanel.getMaxWritten()) {
                                int n2 = CDFToolUtils.getMaxRecNum(this.myEditor.theCDF);
                                this.myEditor.gAttrPanel.setMaxWritten(n2);
                                this.myEditor.gAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                                this.myEditor.gAttrPanel.getRightPanel().revalidate();
                                this.myEditor.gAttrPanel.getRightPanel().repaint();
                                this.myEditor.vAttrPanel.setMaxWritten(n2);
                                this.myEditor.vAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                                this.myEditor.vAttrPanel.getRightPanel().revalidate();
                                this.myEditor.vAttrPanel.getRightPanel().repaint();
                            }
                            this.showIndexData();
                        }
                    }
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myEditor.getFrame(), CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "MYEditor: CDFException", 0);
                    this.showIndexData();
                    this.update.setEnabled(true);
                    this.cancel.setEnabled(true);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myEditor.getFrame(), numberFormatException.toString(), "MYEditor: CDFException", 0);
                    this.showIndexData();
                    this.update.setEnabled(true);
                    this.cancel.setEnabled(true);
                }
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.update.setEnabled(true);
        this.cancel.setEnabled(true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.update.setEnabled(true);
        this.cancel.setEnabled(true);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.update.setEnabled(true);
        this.cancel.setEnabled(true);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        block11: {
            int n;
            block12: {
                block13: {
                    n = keyEvent.getKeyCode();
                    if (n != 38) break block12;
                    if (this.focusedObj != this.jtfRec.textField) break block13;
                    ++this.recNum;
                    this.jtfRec.set("" + (this.recNum + 1L));
                    this.showIndexData();
                    break block11;
                }
                if (this.nDims <= 0L) break block11;
                int n2 = 0;
                while ((long)n2 < this.nDims) {
                    if (this.focusedObj == this.jtfIndex[n2]) {
                        if (this.dimVars[n2] == 0L) break block11;
                        int n3 = n2;
                        this.dimIndex[n3] = this.dimIndex[n3] + 1L;
                        if (this.dimIndex[n2] == this.dimSizes[n2]) {
                            this.dimIndex[n2] = 0L;
                        }
                        this.jtfIndex[n2].setText("" + (this.dimIndex[n2] + 1L));
                        this.showIndexData();
                        break block11;
                    }
                    ++n2;
                }
                break block11;
            }
            if (n != 40) break block11;
            if (this.focusedObj == this.jtfRec.textField) {
                --this.recNum;
                if (this.recNum < 0L) {
                    this.recNum = this.maxRec;
                }
                if (this.recNum < 0L) {
                    this.recNum = 0L;
                }
                this.jtfRec.set("" + (this.recNum + 1L));
                this.showIndexData();
            } else if (this.nDims > 0L) {
                int n4 = 0;
                while ((long)n4 < this.nDims) {
                    if (this.focusedObj == this.jtfIndex[n4]) {
                        if (this.dimVars[n4] == 0L) break;
                        int n5 = n4;
                        this.dimIndex[n5] = this.dimIndex[n5] - 1L;
                        if (this.dimIndex[n4] < 0L) {
                            this.dimIndex[n4] = this.dimSizes[n4] - 1L;
                        }
                        this.jtfIndex[n4].setText("" + (this.dimIndex[n4] + 1L));
                        this.showIndexData();
                        break;
                    }
                    ++n4;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.focusedObj = focusEvent.getSource();
        boolean bl = false;
        if (this.focusedObj == this.jtfRec.textField) {
            if (this.nDims > 0L) {
                int n = 0;
                while ((long)n < this.nDims) {
                    if (this.dimVars[n] == -1L) {
                        this.jtfRec.textField.setNextFocusableComponent(this.jtfIndex[n]);
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.jtfRec.textField.setNextFocusableComponent(this.jtfVal.textField);
            }
        } else if (this.focusedObj == this.jtfVal.textField) {
            if (this.variance) {
                this.jtfVal.textField.setNextFocusableComponent(this.jtfRec.textField);
            } else {
                if (this.nDims > 0L) {
                    int n = 0;
                    while ((long)n < this.nDims) {
                        if (this.dimVars[n] == -1L) {
                            this.jtfVal.textField.setNextFocusableComponent(this.jtfIndex[n]);
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!bl) {
                    this.jtfVal.textField.setNextFocusableComponent(this.jtfVal.textField);
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean isFocusCycleRoot() {
        return true;
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public long getRecNum() {
        return this.recNum;
    }
}

