/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends NumberField {
    private boolean parseNegative = true;
    static final long serialVersionUID = 1L;

    public boolean isParseNegative() {
        return this.parseNegative;
    }

    public void setParseNegative(boolean bl) {
        this.parseNegative = bl;
    }

    public WholeNumberField(int n, int n2) {
        super(n2);
        this.formatter = NumberFormat.getNumberInstance(Locale.US);
        this.formatter.setParseIntegerOnly(true);
        this.setText(new Long(n).toString());
    }

    @Override
    public Document createDefaultModel() {
        return new PlainDocument(){
            static final long serialVersionUID = 1L;

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                char[] cArray = this.getText(0, this.getEndPosition().getOffset()).toCharArray();
                char[] cArray2 = string.toCharArray();
                char[] cArray3 = new char[cArray2.length];
                int n2 = 0;
                for (int i = 0; i < cArray3.length; ++i) {
                    if (Character.isDigit(cArray2[i]) || WholeNumberField.this.isParseNegative() && n == 0 && cArray2[i] == '-') {
                        cArray3[n2++] = cArray2[i];
                        continue;
                    }
                    Toolkit.getDefaultToolkit().beep();
                }
                super.insertString(n, new String(cArray3, 0, n2), attributeSet);
            }
        };
    }

    @Override
    public Integer getInteger() {
        try {
            return new Integer(this.formatter.parse(this.getText()).intValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Long getLong() {
        try {
            return new Long(this.formatter.parse(this.getText()).longValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Float getFloat() {
        try {
            return new Float(this.formatter.parse(this.getText()).floatValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Double getDouble() {
        try {
            return new Double(this.formatter.parse(this.getText()).doubleValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

