/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.UIManager;

public class CDFEdit
extends JFrame
implements ActionListener,
ItemListener,
MouseListener,
FocusListener,
CDFConstants,
Runnable {
    private CDFEdit cdfedit;
    protected JDialog dialog;
    public MYEditor aCDFEditor = null;
    protected JFrame parentDriver;
    protected CDF sourceCDF = null;
    private String channelFile;
    private boolean cdfHandling = false;
    private boolean MacOS = false;
    private boolean WindowsOS = false;
    private ButtonGroup selectgp;
    private JRadioButton select1;
    private JRadioButton select2;
    private JRadioButton select3;
    private JButton entrb;
    private JButton helpb;
    private JButton quitb;
    private JButton slt1;
    private JButton slt2;
    private JButton slt3;
    private JCheckBox abc;
    protected JTextArea info;
    private JTextField cdf1;
    private JTextField cdf2;
    private JTextField cdf3;
    private JScrollPane scroller;
    protected String cdfspec;
    private int editSelection = -1;
    private String currentdir = System.getProperty("user.dir");
    private String[] cdfs = new String[]{"cdf", "CDF"};
    private SimpleFileFilter cdffilter = new SimpleFileFilter(this.cdfs, " CDF files (*.cdf, *.CDF)");
    private JTextField focused = null;
    private JTextField prevfocused = null;
    protected int ROWS = 26;
    protected int COLUMNS = 9;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuEdit;
    private JMenu menuHelp;
    private JMenuItem menuEditCopy;
    private JMenuItem menuEditCut;
    private JMenuItem menuEditPaste;
    private JMenuItem menuFileOpen;
    private JMenuItem menuFileCreate1;
    private JMenuItem menuFileCreate2;
    private JMenuItem menuFileExit;
    private JMenuItem menuHelpHelp;
    private int istart = -1;
    private int iend = -1;
    private int backwardEnvVar;
    private long backwardFlag;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    Dimension hpad5 = new Dimension(5, 1);
    Dimension hpad10 = new Dimension(10, 1);
    Dimension hpad20 = new Dimension(20, 1);
    Dimension hpad25 = new Dimension(25, 1);
    Dimension hpad30 = new Dimension(30, 1);
    Dimension hpad40 = new Dimension(40, 1);
    Dimension hpad80 = new Dimension(80, 1);
    Dimension vpad5 = new Dimension(1, 5);
    Dimension vpad10 = new Dimension(1, 10);
    Dimension vpad20 = new Dimension(1, 20);
    Dimension vpad25 = new Dimension(1, 25);
    Dimension vpad30 = new Dimension(1, 30);
    Dimension vpad40 = new Dimension(1, 40);
    Dimension vpad80 = new Dimension(1, 80);
    Font defaultFont = new Font("Dialog", 0, 12);
    Font boldFont = new Font("Dialog", 1, 12);
    Font bigFont = new Font("Dialog", 0, 18);
    Font bigboldFont = new Font("Dialog", 1, 18);
    static int INITIAL_WIDTH = 400;
    static int INITIAL_HEIGHT = 200;
    static boolean defaultModal = false;
    boolean modal;
    int frommain = 0;
    static String osName = System.getProperty("os.name");
    static final long serialVersionUID = 1L;

    CDFEdit() {
        this(null, defaultModal);
    }

    CDFEdit(JFrame jFrame) {
        this(jFrame, defaultModal);
    }

    CDFEdit(JFrame jFrame, boolean bl) {
        this.cdfedit = this;
        this.parentDriver = jFrame;
        this.dialog = new JDialog((Frame)this, bl);
        this.modal = bl;
        if (osName.indexOf("Mac OS") != -1 && osName.indexOf("Mac OS X") == -1) {
            this.MacOS = true;
        }
        if (osName.indexOf("Windows") != -1) {
            this.WindowsOS = true;
        }
        try {
            this.backwardEnvVar = CDF.getFileBackwardEnvVar();
        }
        catch (Exception exception) {
            System.out.println("Error getting Env Var..." + exception);
        }
        RepaintManager.currentManager(null).setDoubleBufferingEnabled(true);
    }

    @Override
    public void run() {
        this.buildDailog();
        this.dialog.pack();
        Dimension dimension = this.dialog.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
        this.dialog.setVisible(true);
        if (this.parentDriver != null) {
            this.parentDriver.setVisible(false);
        }
    }

    public void reEnter() {
        this.dialog.setVisible(true);
        if (this.parentDriver != null) {
            this.parentDriver.setVisible(false);
        }
    }

    private void buildDailog() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (CDFEdit.this.frommain == 0) {
                    if (CDFEdit.this.modal) {
                        CDFEdit.this.dialog.dispose();
                    } else {
                        CDFEdit.this.dialog.setVisible(false);
                    }
                    if (CDFEdit.this.parentDriver != null) {
                        CDFEdit.this.parentDriver.setVisible(true);
                    }
                } else {
                    System.exit(1);
                }
            }
        };
        this.dialog.addWindowListener(windowAdapter);
        this.dialog.setTitle("Enter   Selections  for  CDFEdit");
        this.dialog.setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.buildMenu();
        this.buildGUIs();
        JPanel jPanel = new JPanel(new BorderLayout(), true);
        JPanel jPanel2 = new JPanel(new GridLayout(5, 1), true);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1), true);
        JPanel jPanel4 = new JPanel(new BorderLayout(), true);
        JPanel jPanel5 = new JPanel(new BorderLayout(), true);
        JLabel jLabel = new JLabel("    File Name: ");
        jPanel3.add(this.select1);
        jPanel5.add((Component)jLabel, "West");
        jPanel5.add((Component)this.cdf1, "East");
        jPanel4.add((Component)jPanel5, "West");
        jPanel4.add((Component)this.slt1, "East");
        jPanel3.add(jPanel4);
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1), true);
        JPanel jPanel7 = new JPanel(new BorderLayout(), true);
        JPanel jPanel8 = new JPanel(new BorderLayout(), true);
        JPanel jPanel9 = new JPanel(new GridLayout(2, 1), true);
        JPanel jPanel10 = new JPanel(new BorderLayout(), true);
        JPanel jPanel11 = new JPanel(new BorderLayout(), true);
        JLabel jLabel2 = new JLabel("    File Name: ");
        JLabel jLabel3 = new JLabel("    File Name: ");
        if (this.backwardEnvVar == 1) {
            jPanel6.add(this.select3);
            jPanel8.add((Component)jLabel3, "West");
            jPanel8.add((Component)this.cdf3, "East");
            jPanel7.add((Component)jPanel8, "West");
            jPanel7.add((Component)this.slt3, "East");
            jPanel6.add(jPanel7);
        } else {
            jPanel6.add(this.select2);
            jPanel8.add((Component)jLabel2, "West");
            jPanel8.add((Component)this.cdf2, "East");
            jPanel7.add((Component)jPanel8, "West");
            jPanel7.add((Component)this.slt2, "East");
            jPanel6.add(jPanel7);
            jPanel9.add(this.select3);
            jPanel11.add((Component)jLabel3, "West");
            jPanel11.add((Component)this.cdf3, "East");
            jPanel10.add((Component)jPanel11, "West");
            jPanel10.add((Component)this.slt3, "East");
            jPanel9.add(jPanel10);
        }
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel6);
        if (this.backwardEnvVar == 0) {
            jPanel2.add(jPanel9);
        }
        jPanel2.add(Box.createRigidArea(this.vpad5));
        JPanel jPanel12 = new JPanel(new GridLayout(1, 5), true);
        jPanel12.add(this.abc);
        jPanel12.add(Box.createRigidArea(this.hpad10));
        jPanel12.add(Box.createRigidArea(this.hpad10));
        jPanel12.add(Box.createRigidArea(this.hpad10));
        jPanel12.add(Box.createRigidArea(this.hpad10));
        jPanel2.add(jPanel12);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel13 = new JPanel(new BorderLayout(), true);
        JPanel jPanel14 = new JPanel(new GridLayout(1, 5, 50, 20), true);
        jPanel14.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel14.add(this.entrb);
        jPanel14.add(this.helpb);
        jPanel14.add(this.quitb);
        jPanel14.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel13.add((Component)jPanel14, "North");
        jPanel13.add((Component)this.scroller, "South");
        jPanel.add((Component)jPanel13, "South");
        this.dialog.getContentPane().add((Component)jPanel, "North");
        this.dialog.getContentPane().add((Component)this.scroller, "Center");
    }

    private void buildGUIs() {
        this.slt1 = new JButton("Select");
        this.slt1.addActionListener(this);
        this.slt1.setToolTipText("Select an existing CDF file for editing");
        this.cdf1 = new JTextField("", 30);
        this.cdf1.addActionListener(this);
        this.cdf1.addMouseListener(this);
        this.cdf1.addFocusListener(this);
        this.cdf1.setToolTipText("Enter an existing CDF (without extension) for editing");
        this.slt2 = new JButton("Select");
        this.slt2.addActionListener(this);
        this.slt2.setToolTipText("Select a directory/file for creating a new V3.* CDF file");
        this.cdf2 = new JTextField("", 30);
        this.cdf2.addActionListener(this);
        this.cdf2.addMouseListener(this);
        this.cdf2.addFocusListener(this);
        this.cdf2.setToolTipText("Enter a new CDF file name (without extension) to create");
        this.slt3 = new JButton("Select");
        this.slt3.addActionListener(this);
        this.slt3.setToolTipText("Select a directory/file for creating a new V2.7 CDF file");
        this.cdf3 = new JTextField("", 30);
        this.cdf3.addActionListener(this);
        this.cdf3.addMouseListener(this);
        this.cdf3.addFocusListener(this);
        this.cdf3.setToolTipText("Enter a new CDF file name (without extension) to create");
        this.selectgp = new ButtonGroup();
        this.select1 = new JRadioButton("Open an existing CDF file");
        this.select2 = new JRadioButton("Create a new V3.* CDF file");
        this.select3 = new JRadioButton("Create a new V2.7 CDF file");
        SelectListener selectListener = new SelectListener();
        this.select1.setActionCommand("1");
        this.select1.addActionListener(selectListener);
        this.select1.setSelected(true);
        this.select1.setToolTipText("Edit an existing CDF");
        this.selectgp.add(this.select1);
        if (this.backwardEnvVar == 0) {
            this.select2.setActionCommand("2");
            this.select2.addActionListener(selectListener);
            this.selectgp.add(this.select2);
            this.select2.setToolTipText("Create a new V3 CDF and edit its contents");
        }
        this.select3.setActionCommand("3");
        this.select3.addActionListener(selectListener);
        this.selectgp.add(this.select3);
        this.select3.setToolTipText("Create a new V2 CDF and edit its contents");
        this.abc = new JCheckBox("About");
        this.abc.addItemListener(this);
        this.abc.setToolTipText("Check the CDF library version");
        this.entrb = new JButton(" Enter ");
        this.helpb = new JButton(" Help ");
        this.quitb = new JButton(" Quit ");
        this.entrb.addActionListener(this);
        this.helpb.addActionListener(this);
        this.quitb.addActionListener(this);
        this.entrb.setToolTipText("Continue processing...");
        this.helpb.setToolTipText("Get the help information");
        this.quitb.setToolTipText("Exit CDFEdit");
        this.info = new JTextArea(15, 20);
        this.info.setEditable(false);
        this.info.setVisible(true);
        this.scroller = new JScrollPane(){
            static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(80, 160);
            }

            @Override
            public float getAlignmentX() {
                return 0.0f;
            }
        };
        this.scroller.getViewport().add(this.info);
    }

    private void buildMenu() {
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuEdit = new JMenu("Edit");
        this.menuHelp = new JMenu("Help");
        this.menuEditCopy = new JMenuItem("Copy");
        this.menuEditCut = new JMenuItem("Cut");
        this.menuEditPaste = new JMenuItem("Paste");
        this.menuFileOpen = new JMenuItem("Open");
        this.menuFileCreate1 = new JMenuItem("Create a V3 CDF");
        this.menuFileCreate2 = new JMenuItem("Create a V2 CDF");
        this.menuFileExit = new JMenuItem("Exit");
        this.menuHelpHelp = new JMenuItem("Help");
        this.dialog.setJMenuBar(this.menuBar);
        this.menuBar.add(this.menuFile);
        this.menuFile.add(this.menuFileOpen);
        if (this.backwardEnvVar == 1) {
            this.menuFile.add(this.menuFileCreate2);
        } else {
            this.menuFile.add(this.menuFileCreate1);
            this.menuFile.add(this.menuFileCreate2);
        }
        this.menuFile.add(this.menuFileExit);
        this.menuFileOpen.addActionListener(this);
        this.menuFileCreate1.addActionListener(this);
        this.menuFileCreate2.addActionListener(this);
        this.menuFileExit.addActionListener(this);
        this.menuBar.add(this.menuEdit);
        this.menuEdit.add(this.menuEditCopy);
        this.menuEdit.add(this.menuEditCut);
        this.menuEdit.add(this.menuEditPaste);
        this.menuEditCopy.addActionListener(this);
        this.menuEditCut.addActionListener(this);
        this.menuEditPaste.addActionListener(this);
        this.menuBar.add(this.menuHelp);
        this.menuHelp.add(this.menuHelpHelp);
        this.menuHelpHelp.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.quitb || object == this.menuFileExit) {
            if (this.frommain == 0) {
                if (this.modal) {
                    this.dialog.dispose();
                } else {
                    this.dialog.setVisible(false);
                }
                if (this.parentDriver != null) {
                    this.parentDriver.setVisible(true);
                }
            } else {
                System.exit(1);
            }
        } else if (object == this.menuFileOpen || object == this.slt1) {
            this.cdf2.setText("");
            this.cdf3.setText("");
            String string = CDFToolUtils.doFileChooser("Select/Enter the Source CDF File Name", 1, this.cdffilter, this.currentdir, this.cdfedit);
            if (string != null && string.trim().length() != 0) {
                if (this.MacOS) {
                    this.currentdir = string.substring(0, string.lastIndexOf(47));
                    if (string.startsWith(":") || string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    string = string.replace('/', ':');
                } else {
                    int n = this.WindowsOS ? string.lastIndexOf(92) : string.lastIndexOf(47);
                    this.currentdir = n != -1 ? string.substring(0, n) : System.getProperty("user.dir");
                }
                this.cdf1.setText(string);
                System.getProperties().put("user.dir", this.currentdir);
            }
            this.select1.setSelected(true);
        } else if (object == this.menuFileCreate1 || object == this.menuFileCreate2 || object == this.slt2 || object == this.slt3) {
            this.cdf1.setText("");
            String string = CDFToolUtils.doFileChooser("Select/Enter the New CDF File Name", 1, this.cdffilter, this.currentdir, this.cdfedit);
            if (string != null && string.trim().length() != 0) {
                if (this.MacOS) {
                    this.currentdir = string.substring(0, string.lastIndexOf(47));
                    if (string.startsWith(":") || string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    string = string.replace('/', ':');
                } else {
                    int n = this.WindowsOS ? string.lastIndexOf(92) : string.lastIndexOf(47);
                    this.currentdir = n != -1 ? string.substring(0, n) : System.getProperty("user.dir");
                }
                if (object == this.slt2 || object == this.menuFileCreate1) {
                    this.cdf2.setText(string);
                    this.cdf3.setText("");
                    this.backwardFlag = 0L;
                    this.select2.setSelected(true);
                } else {
                    this.cdf3.setText(string);
                    this.cdf2.setText("");
                    this.backwardFlag = 1L;
                    this.select3.setSelected(true);
                }
                System.getProperties().put("user.dir", this.currentdir);
            }
        } else if (object == this.helpb || object == this.menuHelpHelp) {
            this.info.setText("");
            try {
                InputStream inputStream = this.cdfedit.getClass().getResourceAsStream("cdfedit.txt");
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                this.info.read(inputStreamReader, null);
                this.info.setCaretPosition(0);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.info.setText("Help info is not available...");
            }
            catch (IOException iOException) {
                this.info.setText("Help info is not available...");
            }
            catch (Exception exception) {
                this.info.setText("Help info is not available...");
            }
        } else if (object == this.entrb) {
            String string = this.selectgp.getSelection().getActionCommand();
            if (string.equals("1")) {
                this.cdfspec = this.cdf1.getText();
                if (this.cdfspec == null || this.cdfspec.equals("") || this.cdfspec.trim().length() == 0) {
                    this.info.setText("Please enter the source CDF file name");
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                this.editSelection = 0;
            } else {
                if (string.equals("2")) {
                    this.cdfspec = this.cdf2.getText();
                    this.backwardFlag = 0L;
                } else {
                    this.cdfspec = this.cdf3.getText();
                    this.backwardFlag = 1L;
                }
                if (this.cdfspec == null || this.cdfspec.equals("") || this.cdfspec.trim().length() == 0) {
                    this.info.setText("Please enter the new CDF file name");
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                this.editSelection = 1;
            }
            if (this.MacOS) {
                this.cdfspec = this.cdfspec.replace('/', ':');
                if (this.cdfspec.startsWith(":")) {
                    this.cdfspec = this.cdfspec.substring(1);
                }
            }
            if (this.getCDF()) {
                if (this.aCDFEditor != null) {
                    this.aCDFEditor = null;
                }
                this.aCDFEditor = new MYEditor(this.cdfedit, this.cdfspec);
            }
        } else if (object == this.cdf1) {
            this.cdfspec = this.cdf1.getText();
            if (this.MacOS) {
                this.cdfspec = this.cdfspec.replace('/', ':');
                if (this.cdfspec.startsWith(":")) {
                    this.cdfspec = this.cdfspec.substring(1);
                }
            }
            this.select1.setSelected(true);
            this.cdf2.setText("");
            this.cdf3.setText("");
        } else if (object == this.cdf2) {
            this.cdfspec = this.cdf2.getText();
            if (this.MacOS) {
                this.cdfspec = this.cdfspec.replace('/', ':');
                if (this.cdfspec.startsWith(":")) {
                    this.cdfspec = this.cdfspec.substring(1);
                }
            }
            this.select2.setSelected(true);
            this.cdf1.setText("");
            this.cdf3.setText("");
        } else if (object == this.cdf3) {
            this.cdfspec = this.cdf3.getText();
            if (this.MacOS) {
                this.cdfspec = this.cdfspec.replace('/', ':');
                if (this.cdfspec.startsWith(":")) {
                    this.cdfspec = this.cdfspec.substring(1);
                }
            }
            this.select3.setSelected(true);
            this.cdf1.setText("");
            this.cdf2.setText("");
        } else if (object == this.menuEditCopy) {
            if (this.istart == -1) {
                this.info.setText("Where to copy from?");
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.focused.setSelectionStart(this.istart);
                this.focused.setSelectionEnd(this.iend);
                this.focused.copy();
            }
        } else if (object == this.menuEditCut) {
            if (this.istart == -1) {
                this.info.setText("What to cut?");
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.focused.setSelectionStart(this.istart);
                this.focused.setSelectionEnd(this.iend);
                this.focused.cut();
            }
        } else if (object == this.menuEditPaste) {
            if (this.focused == null) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                if (this.istart != -1) {
                    this.focused.setSelectionStart(this.istart);
                    this.focused.setSelectionEnd(this.iend);
                }
                try {
                    String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor);
                    if (string == null) {
                        this.info.setText("No current selection on clipboard");
                        Toolkit.getDefaultToolkit().beep();
                    } else if (string.indexOf("\n") != -1) {
                        this.info.setText("Multiple lines selection on clipboard - not allowed:");
                        this.info.append("\n\n");
                        this.info.append(string);
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        this.focused.paste();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    boolean getCDF() {
        try {
            int n;
            if (this.editSelection == 0) {
                this.sourceCDF = CDF.open((String)this.cdfspec, (long)0L);
            } else {
                CDF.setFileBackward((long)this.backwardFlag);
                this.sourceCDF = CDF.create((String)this.cdfspec);
            }
            if (this.sourceCDF == null && (n = JOptionPane.showConfirmDialog(this, "Do you want to create this CDF? ", "CDF: " + this.cdfspec + " not exists!", 0)) == 0) {
                CDF.setFileBackward((long)this.backwardFlag);
                this.sourceCDF = CDF.create((String)this.cdfspec);
            }
            return this.sourceCDF != null;
        }
        catch (CDFException cDFException) {
            Toolkit.getDefaultToolkit().beep();
            if (this.editSelection == 0) {
                JOptionPane.showMessageDialog(this, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEditor: Error", 0);
                return false;
            }
            int n = JOptionPane.showConfirmDialog(this, "Do you want to delete and re-create this CDF? ", "CDF: " + this.cdfspec + " already exists!", 0);
            if (n == 0) {
                try {
                    this.sourceCDF = CDF.open((String)this.cdfspec, (long)0L);
                    this.sourceCDF.delete();
                    CDF.setFileBackward((long)this.backwardFlag);
                    this.sourceCDF = CDF.create((String)this.cdfspec);
                }
                catch (CDFException cDFException2) {
                    this.sourceCDF = null;
                }
            }
            return this.sourceCDF != null;
        }
    }

    void reset() {
        this.ROWS = 26;
        this.COLUMNS = 9;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.focused = (JTextField)focusEvent.getSource();
        if (this.prevfocused != null) {
            this.prevfocused.setText(this.prevfocused.getText());
            if (this.iend != -1) {
                if (this.iend < this.focused.getText().length()) {
                    this.prevfocused.setCaretPosition(this.iend);
                } else {
                    this.focused.setCaretPosition(this.focused.getText().length());
                }
            }
        }
        if (this.focused == this.cdf1) {
            this.cdf2.setText("");
            this.cdf3.setText("");
            this.select1.setSelected(true);
        } else if (this.focused == this.cdf2) {
            this.cdf1.setText("");
            this.cdf3.setText("");
            this.select2.setSelected(true);
        } else if (this.focused == this.cdf3) {
            this.cdf1.setText("");
            this.cdf2.setText("");
            this.select3.setSelected(true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.istart != -1) {
            this.focused.setSelectionStart(this.istart);
            this.focused.setSelectionEnd(this.iend);
            this.prevfocused = this.focused;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.focused != null) {
            String string = this.focused.getSelectedText();
            if (string != null) {
                this.istart = this.focused.getSelectionStart();
                this.iend = this.focused.getSelectionEnd();
            } else {
                this.istart = -1;
                this.iend = -1;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.abc && this.abc.isSelected()) {
            try {
                this.info.setText("CDF library distribution: " + CDF.getLibraryVersion());
            }
            catch (CDFException cDFException) {
                System.err.println("error: " + (Object)((Object)cDFException));
            }
            this.abc.setSelected(false);
        }
    }

    private void makeJButton(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Container container, Object object, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        Component component = object instanceof String ? new JButton((String)object) : (Component)object;
        container.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    protected JDialog getDialog() {
        return this.dialog;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        CDFEdit cDFEdit = new CDFEdit();
        cDFEdit.frommain = 1;
        String string = System.getProperty("os.version");
        String string2 = System.getProperty("java.version");
        if (osName.toLowerCase().indexOf("windows") != -1) {
            int n;
            int n2 = new Integer(string.substring(0, string.indexOf(".")));
            int n3 = string2.indexOf(".");
            String string3 = string2.substring(n3 + 1);
            int n4 = new Integer(string2.substring(0, n3));
            int n5 = new Integer(string3.substring(0, string3.indexOf(".")));
            int n6 = n = n5 < 10 ? n4 * 10 + n5 : n4 * 100 + n5;
            if (n2 >= 5 && n >= 14) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    Process process = runtime.exec("cmd /c assoc .cdf");
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 8192);
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("Error with assoc... 1 " + interruptedException);
                    }
                    cDFEdit.channelFile = bufferedReader.readLine();
                    if (cDFEdit.channelFile != null && cDFEdit.channelFile.toLowerCase().equals(".cdf=channelfile")) {
                        process = runtime.exec("cmd /c assoc .cdf=");
                        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 8192);
                        String string4 = bufferedReader.readLine();
                        try {
                            process.waitFor();
                            runtime.addShutdownHook(new RestoreChannelDefinition(cDFEdit.channelFile));
                        }
                        catch (InterruptedException interruptedException) {
                            System.err.println("Error with assoc... 2 " + interruptedException);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        cDFEdit.run();
    }

    private static class RestoreChannelDefinition
    extends Thread {
        String channelDefinition;

        RestoreChannelDefinition(String string) {
            this.channelDefinition = string;
        }

        @Override
        public void run() {
            try {
                Process process = Runtime.getRuntime().exec("cmd /c assoc " + this.channelDefinition);
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Error with assoc... 3 " + interruptedException);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error running assoc on Windows...(3): " + iOException);
            }
        }
    }

    private class SelectListener
    implements ActionListener {
        private SelectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            CDFEdit.this.info.setText("");
            if (string.equals("1")) {
                CDFEdit.this.cdf2.setText("");
                CDFEdit.this.cdf3.setText("");
            } else if (string.equals("2")) {
                CDFEdit.this.cdf1.setText("");
                CDFEdit.this.cdf3.setText("");
            } else {
                CDFEdit.this.cdf1.setText("");
                CDFEdit.this.cdf2.setText("");
            }
        }
    }
}

