/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class ExportFilterOptions
extends JDialog {
    static final long serialVersionUID = 1L;
    private static ExportFilterOptions dialog;
    private JLabeledPanel filterPanel;
    private JCheckBox uic;
    private JCheckBox uxc;
    private JCheckBox fic;
    private ButtonGroup filtergp;
    private JRadioButton noFilter;
    private JRadioButton yesFilter;
    private CDFExport cdfexport;
    static boolean defaultModal;
    private static final String ENTER = "Continue";
    private static final String CANCEL = "Cancel";
    private static final String RESET = "Reset";

    private ExportFilterOptions(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
    }

    public static ExportFilterOptions createFilterOptions(JFrame jFrame, CDFExport cDFExport, boolean bl) {
        if (dialog == null) {
            dialog = new ExportFilterOptions(jFrame, bl);
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.setTitle("Filtering Options");
            dialog.setDefaultCloseOperation(0);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                }
            });
            dialog.setSize(400, 500);
            dialog.buildCBUIs();
            dialog.buildPanels();
        }
        ExportFilterOptions.dialog.cdfexport = cDFExport;
        dialog.pack();
        Dimension dimension = dialog.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
        return dialog;
    }

    void buildPanels() {
        JPanel jPanel = (JPanel)dialog.getContentPane();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.filterPanel = new JLabeledPanel("Filtering");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.filterPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.add(this.noFilter);
        jPanel2.add(this.yesFilter);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.filterPanel.add(jPanel2);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(Box.createRigidArea(new Dimension(15, 1)), gridBagConstraints);
        this.filterPanel.add(Box.createRigidArea(new Dimension(15, 1)));
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.uic, gridBagConstraints);
        this.filterPanel.add(this.uic);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(Box.createRigidArea(new Dimension(15, 1)), gridBagConstraints);
        this.filterPanel.add(Box.createRigidArea(new Dimension(15, 1)));
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.uxc, gridBagConstraints);
        this.filterPanel.add(this.uxc);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(Box.createRigidArea(new Dimension(15, 1)), gridBagConstraints);
        this.filterPanel.add(Box.createRigidArea(new Dimension(15, 1)));
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.fic, gridBagConstraints);
        this.filterPanel.add(this.fic);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(Box.createVerticalStrut(20), gridBagConstraints);
        this.filterPanel.add(Box.createVerticalStrut(20));
        jPanel.add((Component)this.filterPanel, "Center");
        this.createButtonPanel(jPanel);
    }

    public void displayFilterOptions() {
        dialog.setVisible(true);
    }

    private void buildCBUIs() {
        this.uic = new JCheckBox("Use VALIDMIN - less than the value of VALIDMIN won't be extracted", false);
        this.uxc = new JCheckBox("Use VALIDMAX - greater than the value of VALIDMAX won't be extracted", false);
        this.fic = new JCheckBox("Use FILLVAL - use the fill value for any invalid data, if checked", false);
        this.filtergp = new ButtonGroup();
        this.noFilter = new JRadioButton("Extract data without filtering");
        this.yesFilter = new JRadioButton("Search/Extract criteria defined by the following attributes");
        FilterListener filterListener = new FilterListener();
        this.noFilter.setActionCommand("0");
        this.yesFilter.setActionCommand("1");
        this.noFilter.addActionListener(filterListener);
        this.yesFilter.addActionListener(filterListener);
        this.noFilter.setSelected(true);
        this.filtergp.add(this.noFilter);
        this.filtergp.add(this.yesFilter);
        this.noFilter.setToolTipText("All data will be extracted");
        this.yesFilter.setToolTipText("Data will be filtered");
        this.uic.setToolTipText("Data less than the value of VALIDMIN won't be extracted");
        this.uxc.setToolTipText("Data greater than the value of VALIDMAX won't be extracted");
        this.fic.setToolTipText("Filled value will be used for missing/invalid data");
    }

    private void createButtonPanel(JPanel jPanel) {
        JButton jButton = new JButton(ENTER);
        JButton jButton2 = new JButton(CANCEL);
        JButton jButton3 = new JButton(RESET);
        JPanel jPanel2 = new JPanel(true);
        SelectionListener selectionListener = new SelectionListener();
        jButton.addActionListener(selectionListener);
        jButton3.addActionListener(selectionListener);
        jButton2.addActionListener(selectionListener);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 1)));
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 1)));
        jPanel2.add(jButton3);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 1)));
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 1)));
        jButton.setToolTipText("Save the options and return...");
        jButton3.setToolTipText("Reset the options to their defaults...");
        jButton2.setToolTipText("Cancel the option selections...");
        jPanel.add((Component)jPanel2, "South");
    }

    public void reset() {
        this.noFilter.setSelected(true);
        this.uic.setSelected(false);
        this.uxc.setSelected(false);
        this.fic.setSelected(false);
        this.cdfexport.setFiltering(0);
        this.cdfexport.setValidMin(0);
        this.cdfexport.setValidMax(0);
        this.cdfexport.setFillVal(0);
    }

    public void set() {
        int n = this.cdfexport.getValidMin() * 4 + this.cdfexport.getValidMax() * 2 + this.cdfexport.getFillVal();
        if (this.noFilter.isSelected()) {
            this.cdfexport.setFiltering(0);
            this.cdfexport.setValidMin(0);
            this.cdfexport.setValidMax(0);
            this.cdfexport.setFillVal(0);
        } else {
            this.cdfexport.setFiltering(1);
            if (this.uic.isSelected()) {
                this.cdfexport.setValidMin(1);
            } else {
                this.cdfexport.setValidMin(0);
            }
            if (this.uxc.isSelected()) {
                this.cdfexport.setValidMax(1);
            } else {
                this.cdfexport.setValidMax(0);
            }
            if (this.fic.isSelected()) {
                this.cdfexport.setFillVal(1);
            } else {
                this.cdfexport.setFillVal(0);
            }
        }
        int n2 = this.cdfexport.getValidMin() * 4 + this.cdfexport.getValidMax() * 2 + this.cdfexport.getFillVal();
        if (n == n2) {
            this.cdfexport.setFilterChanged(false);
        } else {
            this.cdfexport.setFilterChanged(true);
        }
    }

    public void recover() {
        this.noFilter.setSelected(true);
        this.uic.setSelected(false);
        this.uxc.setSelected(false);
        this.fic.setSelected(false);
        if (this.cdfexport.getFiltering() == 0) {
            this.noFilter.setSelected(true);
            this.uic.setSelected(false);
            this.uxc.setSelected(false);
            this.fic.setSelected(false);
        } else {
            this.yesFilter.setSelected(true);
            if (this.cdfexport.getValidMin() == 0) {
                this.uic.setSelected(false);
            } else {
                this.uic.setSelected(true);
            }
            if (this.cdfexport.getValidMax() == 0) {
                this.uxc.setSelected(false);
            } else {
                this.uxc.setSelected(true);
            }
            if (this.cdfexport.getFillVal() == 0) {
                this.fic.setSelected(false);
            } else {
                this.fic.setSelected(true);
            }
        }
    }

    static {
        defaultModal = true;
    }

    private class SelectionListener
    implements ActionListener {
        private SelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                String string = actionEvent.getActionCommand();
                if (string.equals(ExportFilterOptions.ENTER)) {
                    ExportFilterOptions.this.set();
                    dialog.setVisible(false);
                    ExportFilterOptions.this.cdfexport.repaint();
                } else if (string.equals(ExportFilterOptions.RESET)) {
                    ExportFilterOptions.this.reset();
                } else {
                    ExportFilterOptions.this.recover();
                    dialog.setVisible(false);
                }
            }
        }
    }

    private class FilterListener
    implements ActionListener {
        private FilterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            if (n == 1) {
                ExportFilterOptions.this.uic.setSelected(true);
                ExportFilterOptions.this.uxc.setSelected(true);
                ExportFilterOptions.this.fic.setSelected(true);
            } else {
                ExportFilterOptions.this.uic.setSelected(false);
                ExportFilterOptions.this.uxc.setSelected(false);
                ExportFilterOptions.this.fic.setSelected(false);
            }
        }
    }
}

