;
;Copyright 1996-2013 United States Government as represented by the
;Administrator of the National Aeronautics and Space Administration.
;All Rights Reserved.
; This software may be used, copied, or redistributed as long as it is not
; sold and this copyright notice is reproduced on each copy made.  This
; routine is provided as is without any express or implied warranties
; whatsoever.
;
pro cmb_create_plot_file,file,type=type
;Caveat Emptor: this code was written by Scott Boardsen, Heliophysics Division, NASA/GSFC and UMBC/GEST.
common deviceTypeC, deviceType
if lmgr(/demo) eq 1 then begin
   print,'IN DEMO mode, no plot file can be created.'
   return
endif
file = cmb_valid_var_name(file,/filename)
typedef = 'png'
if n_elements(type) eq 0 then type=typedef
if n_elements(file) eq 0 then file='idl'
if !d.name eq 'X' or !d.name eq 'WIN' then begin
   file0 =file
   suff = 'png'
   bytemap = tvread(file=file0,/png,/nodialog)
endif
fout = file + '.' + typedef
if (!d.name eq 'PS') then begin
   suff = '.ps'
   fout = file + suff
   file_copy,'idl.ps', fout, /overwrite
   device,/close
   file_delete,'idl.ps'
endif
if (!d.name eq 'Z') then begin
     bytemap = tvrd()
     tvlct,r,g,b,/get 
      write_png, fout, bytemap,r,g,b
endif

print,'created file:', fout
end

