;cread_wind_3s
; Loads 3 sec binned WIND vector magnetic field, proton density, temperature, velocity, and  He++ density, temperature, velocity.;L1

timename='j_day' ;name of time variable -- Julian days
start_time = '1998-06-10T00:00:00.0Z'  ;start time
stop_time  = '1998-06-10T23:59:59.0Z'  ;stop time
dt_sec=3.0 ;sec -- bin size in seconds


;dataset_id='WI_H2_MFI'  ; full resolution Wind mag field, not needed for 3 sec fields
;vars=[ 'BF1','BGSM', 'BGSE']

dataset_id='WI_H0_MFI'
; ;          Wind Magnetic Fields Investigation: 3 sec, 1 min, and hourly Definitive Data. - R. Lepping (NASA/GSFC)
; vars=[ 'BF1', 'BF1LOG', 'BRMSF1', 'BGSM', 'BRMSGSM', 'BGSE', 'BGSEa', 'BRMSGSE', $
;  'DIST', 'PGSM', 'PGSE', 'B3F1', 'B3F1LOG', 'B3RMSF1', 'B3GSM', 'B3RMSGSM', $
;  'B3GSE', 'B3GSEa', 'B3RMSGSE', 'B1F1', 'B1F1LOG', 'B1RMSF1', 'B1GSM', 'B1RMSGSM', $
;  'B1GSE', 'B1GSEa', 'B1RMSGSE', 'DIST1', 'P1GSM', 'P1GSE', 'DISTV', 'PGSMV', $
;  'PGSEV', 'DIST1V', 'P1GSMV', 'P1GSEV']
; next line is just the 3 sec quantities
;vars=[ 'B3F1', 'B3F1LOG', 'B3RMSF1', 'B3GSM', 'B3RMSGSM','B3GSE', 'B3GSEa', 'B3RMSGSE','PGSMV']
vars=[ 'B3F1=Bmag', 'B3GSE=Bx,By,Bz']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename

dataset_id='WI_PM_3DP'
; vars=[ 'P_DENS', 'P_VELS', 'P_TENS', 'P_TEMP', 'A_DENS', 'A_VELS', 'A_TENS', 'A_TEMP', 'E_RANGE', 'GAP', 'VALID', 'TIME']
vars=[ 'P_DENS=np', 'P_VELS=Vxp,Vyp,Vzp',  'P_TEMP=Tp', 'A_DENS=na', 'A_VELS=Vxa,Vya,Vza', 'A_TEMP=Ta']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,/autobad,sigmul=5.0

; cmb_set_up_colors
; window, 2, retain=2, xsize = 900, ysize = 900
; nx = 1
; ny = 2
; ch = 0.01
; pos = [0.085,0.085,0.97,0.96]
; charsize=1.4
; ip=0
; plot,j_day,bmag,xtickformat='cmb_nonames',ytitle='|B| (nT)',charsize=charsize,pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch)
; plot,j_day,np,xtickformat='cmb_label_date',ytitle='SOLAR WIND DENSITY (cm!u-3!n)',charsize=charsize,pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase

end
