; cread_uly_plasmag_8min.pro
; Load 480s binned ULYSSES magnetometer and solar wind density and velocity data. Note the cdf time resolution of the magnetometer data is ~60 sec, and the plasma data is ~240 sec.

timename='j_day8' ;name of time variable -- Julian days
start_time = '1995-01-00T00:00:00.0Z'  ;start time
stop_time  = '1995-06-30T23:59:59.0Z'  ;stop time
dt_sec=480.0 ;sec -- bin size in seconds
;dt_sec=0

dataset_id = 'UY_1MIN_VHM'
vars = ['B_RTN=BR8,BT8,BN8', 'B_MAG=BMAG8']

cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename

dataset_id = 'UY_M0_BAI'
vars = ['Density=np8,na8', 'Temperature=Tlarge,Tsmall', 'Velocity=VR8,VT8,VN8']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,/autobad

dataset_id='UY_COHO1HR_MERGED_MAG_PLASMA'
vars=[ 'heliocentricDistance=R1', 'heliographicLatitude=Lat1', 'heliographicLongitude=Lon1']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename

na_to_np = na8/np8


end