;demo_polar_3sets
; Plots 120s binned POLAR spacecraft TIMAS H+, PWI Plasma wave (5 minute res.) electric dynamic spectra, vector magnetic field measurements with IGRF field subtracted.
;In this demo:
;1. The Polar PWI wave key parameter data is loaded, which has a resoution of 5 minutes.
;2. The high resolution TIMAS proton and O+ data are loaded, which has a resolution of 12 s, note each ion component has a different time tag in the cdf.
;3. The magnetometer key parameter data is loaded which has a resoution of 55 s.
;All variables are binned into a time series with a time bin size of 120 s.
;The top panel is an energy-time spectrogram of the proton differential flux.
;The middle panel is an wave power spectral density-time spectrogram of the electric field component.
;the three white lines on this panel are the proton cyclotron (bottom), lower hybrid (middle) and electron cycltron frequencies derived from
;the magnetic field data.
;The bottom panels are the magnetic field components with the IGRF model substracted off, the red, green, and blue curves are the x,y,z SM coordinates.
FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata

start_time = '1997-03-11T00:00:00.0Z'
stop_time  = '1997-03-11T23:59:59.0Z'

;dates = [cmb_input_time( 1996, 4, 15, 8, 0, 0), cmb_input_time( 1996, 4, 15, 16, 59, 0)] & start_time=dates[0] & stop_time = dates[1]

dt_sec =120.;seconds, size of a time bin
time_name='j_day' ;center time of bins in Julian day

dataset_id = 'PO_H0_TIM'
vars = ['Flux_HQ', 'Flux_OQ'];; cdf variable names, note to rename FLux_HQ to say proton_flux, set vars = ['Flux_HQ=proton_flux', 'Flux_OQ']
;d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name

dataset_id = 'PO_K0_PWI'
vars = ['SFRA_Av_E','SFRA_Av_M','SFRB_Av_E','SFRB_Av_M','SFRA_Antenna','SFRB_Antenna']
;d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name

dataset_id = 'PO_K0_MFE'
vars = ['B_SM','MBCIGRF_SM','POS_SM'];; cdf variable names, note to save as components, set vars = ['B_SM=Bx,By,Bz','MBCIGRF_SM','POS_SM=X,Y,Z']
;d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name

; average differential ion flux over pitch angle.
ii=where(flux_hq lt 0)
a = flux_hq & a[ii] = 0.
b = flux_hq*0 +1 & b[ii] =0.
iav = where( abs(angle-90.) lt 10.)
fluxave = total(a[*,iav,*],2)/total(b[*,iav,*],2)
fluxave= transpose(fluxave)
colorbar_title_flux = cmbmeta.PO_H0S_TIM.FLUX_HQ.fieldnam + '!c' + cmbmeta.PO_H0S_TIM.FLUX_HQ.UNITS

; extract electric field power spectral density
if max(sfra_av_e_nbin) gt 0 then begin
   psd = transpose(sfra_av_e)
   colorbar_title_wave = cmbmeta.PO_K0S_PWI.SFRA_AV_E.fieldnam + '!c' + cmbmeta.PO_K0S_PWI.SFRA_AV_E.units
endif else begin
   psd = transpose(sfrb_av_e)
   colorbar_title_wave = cmbmeta.PO_K0S_PWI.SFRB_AV_E.fieldnam + '!c' + cmbmeta.PO_K0S_PWI.SFRB_AV_E.units
endelse

db0 = sqrt(total((b_sm-mbcigrf_sm)^2,1))
b0 = sqrt(total((b_sm)^2,1))

;form time axis labels
r = sqrt(total(pos_sm^2,1))
mlat = reform(!radeg*asin(pos_sm[2,*]/r))
mlt = reform((atan(pos_sm[1,*],pos_sm[0,*])*12/!pi + 12) mod 24)
lshell = r/cos(mlat/!radeg)^2
atimeaxis = {time:j_day,r:r,lshell:lshell, mlat:mlat,mlt:mlt,labels:['hh:mm:ss','r(re)','l-shell','mlat(degrees)','mlt(hours)']}

dummy = cmb_label_date(xaxis_info=atimeaxis) ;store x axis information for labelling

cmb_set_up_colors
;xsize = 1000  & ysize = 1000 & cmb_adjust_screen_size,xsize,ysize
window, 0, retain=2;, xsize = xsize, ysize = ysize
;cgerase

;!p.charsize = 1.2
!p.charsize = 0
!x.ticklen = -0.04
!y.ticklen = -0.012
nx = 1
ny = 3
ch = 0.005
pos = [.18,.2,.85,.9]
xrange = [min(j_day),max(j_day)]
title = 'POLAR EXAMPLE for ' + start_time + ' to '+ stop_time

ytitle=cmbmeta.PO_H0S_TIM.energy.fieldnam +' ('+cmbmeta.PO_H0S_TIM.energy.units+')'
xminor=3
xticks=8

;cgplot,xrange,[min(energy),max(energy)],/nodata,ytype=1,xminor = xminor,xtickformat='cmb_nonames',xtitle='  ',ytitle=ytitle,title=title,xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,0,pos=pos,ch=ch)
plot,xrange,[min(energy),max(energy)],/nodata,ytype=1, xticks=xticks, xminor = xminor,xtickformat='cmb_nonames',xtitle='  ',ytitle=ytitle,title=title,xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,0,pos=pos,ch=ch)
cmb_polyarea_tv, fluxave,j_day,energy,fill=0.,/takelog,/add_colorbar,ctitle=colorbar_title_flux

ytitle='Frequency (Hz)'
;cgplot,xrange,[min(frequency),max(frequency)],/nodata,ytype=1,xminor = xminor,xtickformat='cmb_nonames',xtitle='  ',ytitle=ytitle,xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,1,pos=pos,ch=ch),/noerase
plot,xrange,[min(frequency),max(frequency)],/nodata,ytype=1, xticks=xticks,xminor = xminor,xtickformat='cmb_nonames',xtitle='  ',ytitle=ytitle,xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,1,pos=pos,ch=ch),/noerase
cmb_polyarea_tv,psd,j_day,frequency,fill=0.,/takelog,/add_colorbar,ctitle=colorbar_title_wave

oplot,j_day,0.015245481*b0,color=!p.background ; proton cyclotron frequency
oplot,j_day,0.015245481*b0*sqrt(1836.1),color=!p.background ;proxy for lower hybrid frequency
oplot,j_day,0.015245481*b0*1836.1,color=!p.background ;electron cycltron frequency

ytitle='B-B_IGRF SM (nT)'
plot,xrange,[-1,1]*max(db0),/nodata, xticks=xticks,xminor = xminor,xtickformat='cmb_label_date',xtitle='  ',ytitle=ytitle,xstyle=1,pos=cmb_pp_pos_b(nx,ny,2,pos=pos,ch=ch),/noerase
cmb_label_pos_label,charsize=!p.charsize ;plot x-axis labels in lower left corner
oplot,j_day,db0
oplot,j_day,-db0,linestyle=1
;colors = [cgcolor('red'),cgcolor('green'),cgcolor('blue')]
colors= [250, 120,  85]
for ic=0,2 do oplot,j_day, b_sm[ic,*]-mbcigrf_sm[ic,*], color=colors[ic]

!p.charsize = 0
!x.ticklen = 0
!y.ticklen = 0
end
