; cread_isee1_mag_4sec.pro 
; Loads both ISEE1 4sec (Note: coordinates are very close to GSE in the 4s dataset) and 60 s datasets in GSE, if iplot=1 in code a plot is created that overlays the 60s and 4s data.;MagnetosphereEarth
FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata

dt_sec=60.0
time_name='jd'
dataset_id='ISEE1_4SEC_MFI'
 
 ; Time range: '1977-10-22T21:04:19.000Z'- '1987-09-25T16:10:30.000Z'
 ;          12-sec avg vector magnetic field at 4-sec intervals - C. T. Russell (UCLA)
 
 vars=[ 'BX', 'BY', 'BZ', 'BT']


 dates = ['1977-11-24T18:00:00.000Z', '1977-11-24T24:00:00.000Z']
 start_time=dates[0]
 stop_time=dates[1]

cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name, to_struct='d'


dataset_id='ISEE1_60SEC_MFI'; Time range: '1977-10-22T14:49:00.000Z'-'1987-09-26T05:59:00.000Z'
 ;          60-sec vector magnetic field - C. T. Russell (UCLA)
 vars=[ 'BX', 'BY', 'BZ', 'BTOT', 'BX_GSM', 'BY_GSM', 'BZ_GSM', 'BX_GSE', 'BY_GSE', $
  'BZ_GSE', 'SDX', 'SDY', 'SDZ', 'SDT', 'SDC', 'BINT', 'BXIM_GSM', 'BYIM_GSM', $
  'BZIM_GSM', 'BINTEXT', 'BXIE_GSM', 'BYIE_GSM', 'BZIE_GSM', 'R', 'X_GSM', 'Y_GSM', $
  'Z_GSM', 'X_GSE', 'Y_GSE', 'Z_GSE', 'ZNS_GSM', 'TILT', 'L', 'Local_time', 'MLAT', $
  'SES', 'PHI', 'SPIN', 'SLNG_GSM', 'SLT_GSM', 'SLNG_GSE', 'SLT_GSE', 'VX_GSM', $
  'VY_GSM', 'VZ_GSM', 'V', 'DVX_GSM', 'DVY_GSM', 'DVZ_GSM', 'DV', 'DX_GSM', 'DY_GSM', $
  'DZ_GSM', 'DX_GSE', 'DY_GSE', 'DZ_GSE', 'DR', 'NMPX_GSE', 'NMPY_GSE', 'NMPZ_GSE', $
  'MPS', 'NSX_GSE', 'NSY_GSE', 'NSZ_GSE', 'SS', 'QUAL']


vars=['BTOT', 'BX_GSE', 'BY_GSE', $
  'BZ_GSE', 'R', 'X_GSE', 'Y_GSE', 'Z_GSE', 'TILT', 'L', 'Local_time', 'MLAT',  'QUAL']


cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name, to_struct='d60'


iplot=1
if iplot then begin
cmb_set_up_colors
window,/free
pos=[.1,.1,.9,.9]
nx=1
ny=4


atimeaxis = {time:d60.jd,r:d60.r,lshell:d60.l, mlat:d60.mlat,mlt:d60.local_time,labels:['hh:mm:ss','r(re)','l-shell','mlat(deg)','mlt(hrs)']}
dummy = cmb_label_date(xaxis_info=atimeaxis) ;store x axis information for labelling


title='ISEE-1 4s and 1 min MAG DATA for ' + dates[0] + ' to ' + dates[1]

dummy = LABEL_DATE(DATE_FORMAT='%n/%d %H:%S')
ip=0
plot,d60.jd, d60.bx_gse,ytitle=vars[0], xtickformat='cmb_nonames',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),xticks=4
oplot,d.jd,d.bx,color=250
plot,d60.jd, d60.by_gse,ytitle=vars[1], xtickformat='cmb_nonames',xstyle=1,xtitle=xtitle,title='', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),xticks=4,/noerase
oplot,d.jd,d.by,color=250
plot,d60.jd, d60.bz_gse,ytitle=vars[2], xtickformat='cmb_nonames',xstyle=1,xtitle=xtitle,title='', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),xticks=4,/noerase
oplot,d.jd,d.bz,color=250
plot,d60.jd, d60.btot,ytitle=vars[3], xtickformat='cmb_label_date',xstyle=1,xtitle=xtitle,title='', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),xticks=4,/noerase
oplot,d.jd,d.bt,color=250
cmb_label_pos_label,charsize=!p.charsize ;plot x-axis labels in lower left corner
cmb_create_plot_file,'ISEE-1_mag_4s_60s'
endif
 end



