;
;Copyright 1996-2013 United States Government as represented by the
;Administrator of the National Aeronautics and Space Administration.
;All Rights Reserved.
; This software may be used, copied, or redistributed as long as it is not
; sold and this copyright notice is reproduced on each copy made.  This
; routine is provided as is without any express or implied warranties
; whatsoever.
;


pro cmb_search_for_duplicate_variables_names,s

v = s.vars
nv =n_elements( where(v ne ''))
vu = cmb_unique_string(v)
v = s.vars
vu = vu[where(vu ne '')]
if n_elements(vu) eq nv then return ;no duplicate variable names found
print,'Duplicate variable names found between dataset_ids:', s.dataset_id
suffixs = strarr(n_elements(s))
for i=0,n_elements(s)-1 do begin
    suffix='_'+cmb_remove_quotes(s[i].dataset_id)
    ;print,'Suggested suffix=',suffix,' to append to variable name for dataset_id=',s[i].dataset_id
    read,'Type in suffix to add to variable names for dataset_id='+s[i].dataset_id+':',suffix
    suffixs[i] = suffix
endfor

vnew = v
for i=0,n_elements(vu)-1 do begin
    j=where( vu[i] eq v )
    ia = ARRAY_INDICES(v,j)
;    print,v[ia[0,*],ia[1,*]]
    mm = size(/dim,ia)
    if n_elements(mm) lt 2 then goto,next
    m = (size(/dim,ia))(1)
    for k=0,m-1 do begin
        var = cmb_remove_quotes(v[ia[0,k],ia[1,k]])
;        print,k,' ',var
        varnew = var+suffixs[ia[1,k]]
        if varnew ne var then vnew[ia[0,k],ia[1,k]] = cmb_add_single_quotes(var+'='+varnew)   
    endfor
    next:
endfor
s.vars = vnew
end

pro cmb_add_suffix_to_variables_names,s
for i=0,n_elements(s)-1 do begin
    suffix='_'+cmb_remove_quotes(s[i].dataset_id)
    ;print,'Suggested suffix=',suffix,' to append to variable name for dataset_id=',s[i].dataset_id
    read,'Type in suffix to add to variable names for dataset_id='+s[i].dataset_id+':',suffix
    v = s[i].vars
    m=where(v ne '')
    for im=0,n_elements(m)-1 do begin
        var = cmb_remove_quotes(v[im])
        varnew = var+suffix
        if varnew ne var then s[i].vars[im] = cmb_add_single_quotes(var + '=' + varnew)
        print, 'new variable:',s[i].vars[im]
    endfor
endfor
end

pro cmb_datasetid_filter, s, idfilter,wid=wid

common cmb_creader_creator_event, base0
   idfilter = 'rbsp'
    read,'input dataset_id filter (not case sensitive):', idfilter
    ip = strpos( strlowcase( s.dataset_id), strlowcase(idfilter)) & ii=where( ip ne -1)
      if ii[0] ne -1 then begin
	s=s[ii]
      endif else print,'No matches for ' + idfilter + ' so IDs not filtered' 
	if n_elements(base0) ne 0 then widget_control,base0,/destroy,bad_id=badid
	base0=cmb_showlist(s.dataset_id+' '+s.info0,title='Current DATA_IDs',ysize=30,xsize=max(strlen(s.dataset_id)) + wid)
end

pro cmb_datasetkeyword_filter,s,keyword,wid=wid
common cmb_creader_creator_event, base0
keyword=''
read,'input a keyword (like magnet) filter datasets by keyword or <ret> to not filter by keyword:', keyword
if keyword ne '' then begin
  keyword= strlowcase(keyword)
  help,keyword
  ip = strpos( strlowcase(s.info0),keyword) & ip=where( ip ge 0)
  help,ip
  if ip[0] eq -1 then begin
      read,'No occurrences of ' + keyword + ' input  another keyword or <ret> to skip:', keyword
  endif else begin
      print,'LIST of DATASET_IDs that contain this kewyord:'
      for i=0,n_elements(ip)-1 do print, s[ip[i]].dataset_id, ': ', s[ip[i]].info0
       s=s[ip]
  endelse
endif
	if n_elements(base0) ne 0 then widget_control,base0,/destroy,bad_id=badid
	base0=cmb_showlist(s.dataset_id+' '+s.info0,title='Current DATA_IDs',ysize=30,xsize=max(strlen(s.dataset_id)) + wid)
end

function cmb_load_dataids
; s= cmb_load_dataids()
print,"************************************************"
print,'Note: creader_creator uses the file "List_of_valid_CDAWEB_dataset_IDs_and_variable_names.txt"'
print,'The updated version of this file is at "
print,'"http://cdaweb.gsfc.nasa.gov/pub/software/cdaweb_idl_clients/cdaweb_get_bin/List_of_valid_CDAWEB_dataset_IDs_and_variable_names.txt"'
print,'This file must be placed in the current IDL directory, or retrieved directly over the web.' ;, or in directory containing creader_creator, or'
loadfromweb=0
print,"************************************************"
print,"    "
if cmb_file_exists('List_of_valid_CDAWEB_dataset_IDs_and_variable_names.txt') then begin
   print,'FILE: '+'List_of_valid_CDAWEB_dataset_IDs_and_variable_names.txt' +' FOUND in current directory.'
   print,'Input 2 to load file from current directory:'
   print,'      1 to download the current version over the web into the current directory,'
   print,'      0 to quit:'
   read,loadfromweb
endif else begin
   print,'FILE: '+'List_of_valid_CDAWEB_dataset_IDs_and_variable_names.txt' +' NOT FOUND in current directory.'
   print,'Input 1 to download the current version over the web into the current directory,'
   print,'      0 to quit:'
   read,loadfromweb
endelse
if loadfromweb eq 0 then return,0
if loadfromweb eq 2 then loadfromweb=0
flist='List_of_valid_CDAWEB_dataset_IDs_and_variable_names.txt'
;path=''
;if loadfromweb eq 2 then goto, jump
;istat = cmb_file_exists(path + flist)
;if istat eq 0 then begin
;path = file_which('creader_creator.pro')
;path = strmid(path,0, strpos(path,('creader_creator.pro')) )
;flist='List_of_valid_CDAWEB_dataset_IDs_and_variable_names.txt'
;istat = cmb_file_exists(flist)
;endif

; if istat eq 0 then begin
;   print,"************************************************"
;   print,'Note the current directory or the directory:',path
;   print,'does not contain the file: List_of_valid_CDAWEB_dataset_IDs_and_variable_names.txt.'
;   print,'move this file to one of these directories and restart the code.'
;   print,"************************************************"
;   return,0
; endif

;help,flist,loadfromweb & stop
;jump:
s= cmb_load_id_list(flist,loadfromweb=loadfromweb)

return,s
end


function cmb_creader_creator_menu,list=list
; command = cmb_creader_creator_menu()
list = ['List dataset ids with brief description', $
   'Input dataset id filter', $
   'Input keyword filter', $
;   'List current id and keyword filters.', $
   'Select dataset id', $
   'Create creader', $
   'Reset id list', $
   'Quit program']
print,'**************** LIST of OPTIONS *******************'
cmb_string_list,list
icommand=-1

valid = 0 ; Valid flag
WHILE valid EQ 0 DO BEGIN
   ON_IOERROR, bad_num
   read,'Input # (integer) of option:',icommand
   ;If we get here, icommand is good.
   VALID = 1
   if icommand lt 0 or icommand gt 6 then valid=0
   bad_num: IF ~ valid THEN PRINT, 'You entered an invalid integer, valid integers are 0 to 6.'   
ENDWHILE

return, list[icommand]
end

function cmb_creader_creator_event, command, s, datasetids
common cmb_creader_creator_event, base0
wid=120
; inext= cmb_creader_creator_event( command, s, datasetids)
inext=1
case command of
 'List dataset ids with brief description':begin
    if n_elements(base0) ne 0 then widget_control,base0,/destroy,bad_id=badid
    base0=cmb_showlist(s.dataset_id+' '+s.info0,title='Current DATA_IDs',ysize=30,xsize=max(strlen(s.dataset_id)) + wid)
    end
 'Input dataset id filter': cmb_datasetid_filter, s, idfilter,wid=wid
 'Input keyword filter': cmb_datasetkeyword_filter,s,keyword, wid=wid 
 'Select dataset id': begin
    if n_elements(base0) ne 0 then widget_control,base0,/destroy,bad_id=badid
        dummy =cmb_func_choose_item(s.dataset_id+'  '+s.info0,index=index0,title='CHOOSE DATASET ID', xsize=max(strlen(s.dataset_id)) +wid)
        datasetid0 = s[index0].dataset_id
        if n_elements(datasetids) eq 0 then datasetids = datasetid0 $
        else begin
        i0 = where(  datasetid0 eq datasetids)
        if i0[0] eq -1 then datasetids = [datasetids ,datasetid0]
        endelse
        print,'Selected IDs:', datasetids
        base0=cmb_showlist(s.dataset_id+' '+s.info0,title='Current DATA_IDs',ysize=30,xsize=max(strlen(s.dataset_id)) + wid)
    end
 'Create creader':begin
    inext=2
    if n_elements(datasetids) eq 0 then begin
    print,'No datasetids selected, you must select one:'
    inext=1
    endif else  if n_elements(base0) ne 0 then widget_control,base0,/destroy,bad_id=badid
    end
 'Quit program':begin
    inext=0
    if n_elements(base0) ne 0 then widget_control,base0,/destroy,bad_id=badid
    end
 'Reset id list':begin
    s = cmb_load_dataids()
    if n_elements(base0) ne 0 then widget_control,base0,/destroy,bad_id=badid
    base0=cmb_showlist(s.dataset_id+' '+s.info0,title='Current DATA_IDs',ysize=30,xsize=max(strlen(s.dataset_id)) + wid)
    end
endcase
return,inext
end





pro creader_creator
;main
;goto,skip
s = cmb_load_dataids() & s0 = s
if cmb_var_type(s) ne 'STRUCT' then return

next:command = cmb_creader_creator_menu()
     inext= cmb_creader_creator_event( command, s, datasetids)
     
     if n_elements(datasetids) ne 0 then begin
        print,' '
        print,'LIST OF SELECTED IDs'
        cmb_string_list, datasetids
        print,' '
     endif
     if inext eq 1 then goto,next
if inext eq 0 then return

datasetids = datasetids[where(datasetids ne '')]
file=''
dt_sec=''
read,'input the width of the time bin dt_sec in seconds (float or double):', dt_sec
dt_sec = dt_sec*1d0
read,'input name of creader you are creating (e.g. cread_test.pro or full path like /home/user/cread_test.pro):', file

skip:
s = s0
for i=0l, n_elements(datasetids)-1 do begin
    ip =where( s.dataset_id eq datasetids[i])
    if ip[0] ne -1 then begin
       if n_elements(ips) eq 0 then ips=ip else ips = [ips,ip]
    endif else begin
       print,'ERROR DATASET_ID not found:', datasetids[i]
    endelse
endfor

s=s[ips]
;cmb_string_list,datasetids & print, ' ' & cmb_string_list,s.dataset_id & stop  ;for diagnostic
;read,'Input 1<ret> if you want to add a suffix to each variable for a dataset id, 0<ret> for no suffix:',isuffix
;if isuffix eq 1 then cmb_add_suffix_to_variables_names,s
cmb_search_for_duplicate_variables_names,s

openw,/get_lun,lun,file
for i=0l,  n_elements(datasetids)-1 do begin
    ip =where( s.dataset_id eq datasetids[i])
    a = s[ip[0]]
    vars = '[' + cmb_str_flatten(a.vars[0:a.nvars-1],sp=', ',/skipend) + ']'
    if i eq 0 then begin
      printf,lun,"timename='j_day'"
      printf,lun,'dt_sec='+ string(dt_sec)+'d0'
      printf,lun,'start_time = ' + cmb_add_single_quotes(a.t0)
      printf,lun,'stop_time = ' + cmb_add_single_quotes(a.t1)
    endif
    printf,lun, 'dataset_id = ' + a.dataset_id
    printf,lun, '; ' + a.info0
    printf,lun, 'vars = ' + vars
    printf,lun, '; d = spdfgetdata(dataset_id, vars, [start_time, stop_time])
    printf,lun, 'cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename'
    printf,lun, ' '
endfor
printf,lun, 'end '
free_lun,lun
print,'The following file was created:', file
end
