;  .compile cmb_to_cdf


function load_example_cdf
;dm= load_example_cdf()
;  status = write_mycdf(dm,filename='test1.cdf',/longtime,/bothtimes,/lowercase) ) ;,/autoname)
dataset_id='ISEE1_4SEC_MFI'
vars=[ 'BX', 'BY', 'BZ', 'BT']
dates = ['1977-11-24T18:00:00.000Z', '1977-11-24T24:00:00.000Z']
dm = spdfGetData( dataset_id,vars , dates)
return,dm
end

function cmb_update_meta,d
; d= cmb_update_meta(d)
tnames = tag_names(d)
for itag=0,n_tags(d)-1 do d.(itag).varname = tnames[itag]
for itag=0,n_tags(d)-1 do if d.(itag).var_type eq 'data' then d.(itag).depend_0 = 'EPOCH'
tnames = tag_names(d)
ip=where( tnames eq 'EPOCH') & ip=ip[0] & 
d.(ip).var_type='CDF_EPOCH'
d.(ip).CDFMAJOR = 'ROW_MAJOR'
d.(ip).CDFRECVARY = 'CDFRECVARY'
d.(ip).var_type = 'support_data'

ip = where( strpos(strlowcase(tnames),'_nbin') ne -1)

for i=0,n_elements(ip)-1 do begin
    i0 = ip[i]
    d.(i0).var_type = 'data'
    d.(i0).depend_0 = 'EPOCH'
    d.(i0).CDFRECVARY = d.(i0-1).CDFRECVARY
    d.(i0).CDFTYPE = d.(i0-1).CDFTYPE
    d.(i0).CDFRECVARY = d.(i0-1).CDFRECVARY
    d.(i0).CDFMAJOR = d.(i0-1).CDFMAJOR
endfor

return,d
end

function find_meta_for_variable,o,var,vartype
; meta = find_meta_for_variable(o,var)
for itag=0,n_tags(o.cmbmeta)-1 do begin
    tnames = strlowcase(tag_names(o.cmbmeta.(itag)))
    ip = where( strlowcase(var) eq tnames) & ip=ip[0]
    if ip ne -1 then return, add_more_meta( o.cmbmeta.(itag).(ip), vartype)
end
print, 'meta data not found for variable:',var,' creating dummy meta data'
list =]
n=n_elements(list)
meta = create_struct(list[0],var)
for i=1,n-1 do meta =  create_struct(meta,list[i],'')
return,add_more_meta(meta,vartype)
end


function to_read_mycdf_struct,o,timevarname
;d = to_read_mycdf_struct(o,timevarname)
if n_elements( timevarname) eq 0 then timevarname='JD'
tnames = strlowcase(tag_names(o))
ip0 = where( strlowcase(timevarname) eq tnames) & ip0=ip0[0] & help,ip0
epochs = cmb_epoch2jd(/inverse, o.(ip0))
d0 =  create_struct(find_meta_for_variable(o,tnames[ip0],'CDF_EPOCH'),'dat', epochs )
d = create_struct('epoch',d0)

for itag=0,n_elements(tnames)-1 do begin
    print,'var name:', tnames[itag]
    if strlowcase( timevarname) ne tnames[itag] and 'cmbmeta' ne tnames[itag] then begin
    d1 = create_struct(find_meta_for_variable(o,tnames[itag], var_type(o.(itag))),'dat', o.(itag) )
    d = create_struct(d,tnames[itag],d1)
    endif
endfor
 d= cmb_update_meta(d)
return,d
end


;main
; .run  scread_cluster_spin_res_mag.pro & o=cl
;var ='bv1' & meta = find_meta_for_variable(o,var)

d = to_read_mycdf_struct(o) ;,timevarname)
for i=0,n_tags(d)-1 do print,string(d.(i).varname, d.(i).var_type, d.(i).depend_0,d.(i).validmin,d.(i).validmax,format='(6(a10,2x))')
fout = 'test.cdf'

for i=0,n_tags(d)-1 do  b = evaluate_varstruct(d.(i))
; status = write_mycdf(d,filename=fout ),/autoname,/longtime,/bothtimes,/lowercase)
;
; dummy = LIST_mystruct(d,/NOVATT, /NORV, FILE='test.txt')
help,var, meta,/str

end