;
;Copyright 1996-2013 United States Government as represented by the
;Administrator of the National Aeronautics and Space Administration.
;All Rights Reserved.
; This software may be used, copied, or redistributed as long as it is not
; sold and this copyright notice is reproduced on each copy made.  This
; routine is provided as is without any express or implied warranties
; whatsoever.
;

function cmb_cdf_get_depend0,d, varsthathavedepend0=vars
; a = cmb_cdf_get_depend0(d)
;Purpose scan structure for all depend_0
; return structure of unique depend_0 and their CDFTYPEcmb_add_element(depend0
; depend0 = cmb_cdf_get_depend0(d)

tnames= tag_names(d)
c=''
for itag=0,n_tags(d)-1 do begin
    a = d.(itag)
     if cmb_tag_name_exists('depend_0',a) then begin
        if n_elements(vars) eq 0 then vars = tnames[itag] else vars = [vars, tnames[itag]]
        ;pprint, tnames[itag],' ',a.depend_0
        c0 = strupcase(a.depend_0)
        if strlen(c0) gt 3 then begin
           i=where( c0 eq c)
           ;print,c0,' ',c,' ',i
           if i[0] eq -1 then c = [c,c0] 
        endif
     endif        
endfor
c=c[1:*]
cmb_string_list,c
s = replicate({name:'',DELTA_MINUS_VAR:'',DELTA_PLUS_VAR:'', cdftype:'',index:0},n_elements(c))
for ic = 0,n_elements(c)-1 do begin
    i=where( c[ic] eq tnames) & i=i[0]
    s[ic].name = tnames[i]
    s[ic].cdftype = d.(i).cdftype
    if cmb_tag_name_exists('DELTA_MINUS_VAR',d) then s[ic].DELTA_MINUS_VAR = d.(i).DELTA_MINUS_VAR
    if cmb_tag_name_exists('DELTA_PLUS_VAR',d) then s[ic].DELTA_PLUS_VAR = d.(i).DELTA_PLUS_VAR
    s[ic].index = i
endfor
return,s
end
