;cread_wind_overview_3s.pro
; Loads 10 sec binned WIND vector magnetic field, proton density, temperature, velocity, and  He++ density, temperature, velocity and generates an overview plot. Note the Cotoye's IDL library must be installed (http://www.idlcoyote.com/code_tips/installcoyote.php);L1

timename='j_day3' ;name of time variable -- Julian days
start_time = '1996-10-25T00:00:00.0Z'  ;start time
stop_time  = '1996-10-30T23:59:59.0Z'  ;stop time


dt_sec=10.0 ;sec -- bin size in seconds
;dt_sec=0

ihardcopy = 0
ireaddata = 1
if(ireaddata eq 1) then begin
;dataset_id='WI_H2_MFI'  ; full resolution Wind mag field, not needed for 3 sec fields
;vars=[ 'BF1','BGSM', 'BGSE']

dataset_id='WI_H0_MFI'
; ;          Wind Magnetic Fields Investigation: 3 sec, 1 min, and hourly Definitive Data. - R. Lepping (NASA/GSFC)
; vars=[ 'BF1', 'BF1LOG', 'BRMSF1', 'BGSM', 'BRMSGSM', 'BGSE', 'BGSEa', 'BRMSGSE', $
;  'DIST', 'PGSM', 'PGSE', 'B3F1', 'B3F1LOG', 'B3RMSF1', 'B3GSM', 'B3RMSGSM', $
;  'B3GSE', 'B3GSEa', 'B3RMSGSE', 'B1F1', 'B1F1LOG', 'B1RMSF1', 'B1GSM', 'B1RMSGSM', $
;  'B1GSE', 'B1GSEa', 'B1RMSGSE', 'DIST1', 'P1GSM', 'P1GSE', 'DISTV', 'PGSMV', $
;  'PGSEV', 'DIST1V', 'P1GSMV', 'P1GSEV']
; next line is just the 3 sec quantities
;vars=[ 'B3F1', 'B3F1LOG', 'B3RMSF1', 'B3GSM', 'B3RMSGSM','B3GSE', 'B3GSEa', 'B3RMSGSE','PGSMV']
vars=[ 'B3F1=Bmag3', 'B3GSE=Bx3,By3,Bz3']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,/autobad


dataset_id='WI_PM_3DP'
; vars=[ 'P_DENS', 'P_VELS', 'P_TENS', 'P_TEMP', 'A_DENS', 'A_VELS', 'A_TENS', 'A_TEMP', 'E_RANGE', 'GAP', 'VALID', 'TIME']
vars=[ 'P_DENS=np3', 'P_VELS=Vxp3,Vyp3,Vzp3',  'P_TEMP=Tp3', 'A_DENS=na3', 'A_VELS=Vxa3,Vya3,Vza3', 'A_TEMP=Ta3']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,/autobad,sigmul=4.0

endif

na_to_np3 = 100.*na3/np3
beta3 = 0.403*np3*tp3/bmag3^2


entropy = tp3/np3^0.67

; Note that Tp is in eV.  

if (ihardcopy eq 1) then ps_start,file='/IDL_files/test.ps'
cgerase
!p.charsize = 1.0
!x.ticklen = 0.08
!p.thick = 1.0
;title = 'WIND 3s data ' + start_time + ' to '+ stop_time
multiplot,[1,5],gap=0.005 
xtickformat=''
;dummy = LABEL_DATE(DATE_FORMAT='%n:%d')
dummy = LABEL_DATE(DATE_FORMAT='%H:%I')
title = 'WIND 10s data ' + start_time + ' to '+ stop_time
cgplot,j_day3,np3,xtickunit='time',xminor = 4,xtickformat=xtickformat,ytitle='Np (cm!u-3!n)',xstyle=1,xtitle=xtitle,title=title
multiplot
;cgplot,j_day3,-vxp3,xtickunit='time',xminor = 4,xtickformat='nonames',ytitle='Vp (km/s)',xstyle=1
cgplot,j_day3,-vxp3+mean(vxp3),xtickunit='time',xminor = 4,xtickformat=xtickformat,ytitle='Vp-<Vp>, Vy, Vz (km/s)',xstyle=1
cgplot,j_day3,-vyp3,xtickunit='time',xminor = 4,xtickformat=xtickformat,xstyle=1,color='blue',/overplot
cgplot,j_day3,-vzp3,xtickunit='time',xminor = 4,xtickformat=xtickformat,color='red',xstyle=1,/overplot
multiplot
;cgplot,j_day3,beta3,xtickunit='time',xminor = 4,yrange=[0,5],xtickformat='nonames',ytitle='Beta_p',xstyle=1

cgplot,j_day3,bmag3,xtickunit='time',xminor = 4,xtickformat=xtickformat,yrange=[-max(bmag3),max(bmag3)],ytitle='|B|, Bx, By (nT)',xstyle=1
cgplot,j_day3,by3,xtickunit='time',xminor = 4,xtickformat=xtickformat,xstyle=1, color='blue',/overplot
cgplot,j_day3,bx3,xtickunit='time',xminor = 4,xtickformat=xtickformat,xstyle=1, color='red',/overplot
multiplot
cgplot,j_day3,beta3,xtickunit='time',xminor = 4,yrange=[0,5],xtickformat=xtickformat,ytitle='Beta_p',xstyle=1
multiplot
cgplot,j_day3,na_to_np3,xtickunit='time',xminor = 4,xtickformat='label_date',xtitle='Time (hr:min)',ytitle='100*na/np',xstyle=1
multiplot,/reset

!p.charsize = 0
!x.ticklen = 0
!p.thick = 0 
if (ihardcopy eq 1) then ps_end

end