;cread_wind_mfi_overview_hires.pro
; Loads 1s binned WIND magnetometer data and generates an overview plot. Note the Cotoye's IDL library must be installed (http://www.idlcoyote.com/code_tips/installcoyote.php).;L1

timename='j_day01' ;name of time variable for Julian days
start_time = '2005-11-23T06:14:53.383Z'  ;start time
stop_time  = '2005-11-26T01:52:05.269Z'  ;stop time
dt_sec=0.092 ;sec --- bin size in seconds

ihardcopy = 0
ireaddata = 1

if(ireaddata eq 1) then begin
dataset_id='WI_H2_MFI'
; ;         Wind MFI Data at full resolution
; vars=[ 'BF1', 'BGSE', 'BGSM']


vars=[ 'BF1=bmag01', 'BGSE=bx01,by01,bz01']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,0,time_name=timename

; cmb_set_up_colors
; window, 2, retain=2, xsize = 900, ysize = 900
; plot,j_day,bf1,xtickformat='cmb_label_date',ytitle='B (nT)',yr=[-1,1]*max(bf1),charsize=1.5
; colors=[250.,110.,80.]
; for ic=0,2 do oplot,j_day,bgse[ic,*],color=colors[ic]
endif

if (ihardcopy eq 1) then ps_start,file='/IDL_files/test.ps'
cgerase
!p.charsize = 1.0
!x.ticklen = 0.08
!p.thick = 1.0
;title = 'WIND 10Hz data ' + start_time + ' to '+ stop_time
multiplot,[1,4],gap=0.005 
xtickformat=''
xticknames = replicate(' ', 30)
dummy = LABEL_DATE(DATE_FORMAT='%D:%H')
title = 'WIND 10 Hz data ' + start_time + ' to '+ stop_time
cgplot,j_day01,bmag01,xtickunit='time',xminor = 4,xtickformat=xtickformat,ytitle='|B| (nt)',xstyle=1,xtitle=xtitle,title=title
multiplot
cgplot,j_day01,bx01,xtickunit='time',xminor = 4,xtickformat=xtickformat,ytitle='Bx (nT)',xstyle=1
multiplot
cgplot,j_day01,by01,xtickunit='time',xminor = 4,xtickformat=xtickformat,ytitle='By (nT)',xstyle=1
multiplot
cgplot,j_day01,bz01,xtickunit='time',xminor = 4,xtickformat='label_date',xtitle='Time (day:hr)',ytitle='Bz (nT)',xstyle=1
multiplot,/reset

!p.charsize = 0
!x.ticklen = 0
!p.thick = 0 
if (ihardcopy eq 1) then ps_end

end