;cread_wind_92s.pro
; Loads 3 sec binned WIND vector magnetic field, proton density, temperature, velocity, and  He++ density, temperature, velocity.;L1

timename='j_day' ;name of time variable in Julian days
start_time ='1998-06-10T00:00:00.0Z'  ;start time
stop_time  ='1998-07-10T23:59:59.0Z'  ;stop time
dt_sec=92.0 ;sec bin size in seconds

; Note that the dataset contains the magnetic field as well as proton and alpha quantities
; and anisotropies in the proton temperature (thermal speed).

	dataset_id='WI_H1_SWE'
; ;          Wind Solar Wind Experiment, 100-sec Solar Wind Proton Anisotropy Analysis - K. Ogilvie (NASA GSFC)
; vars=[ 'Proton_V_nonlin', 'Proton_sigmaV_nonlin', 'Proton_VX_nonlin', 'Proton_sigmaVX_nonlin', $
;  'Proton_VY_nonlin', 'Proton_sigmaVY_nonlin', 'Proton_VZ_nonlin', 'Proton_sigmaVZ_nonlin', $
;  'Proton_W_nonlin', 'Proton_sigmaW_nonlin', 'Proton_Wperp_nonlin', 'Proton_sigmaWperp_nonlin', $
;  'Proton_Wpar_nonlin', 'Proton_sigmaWpar_nonlin', 'EW_flowangle', 'SigmaEW_flowangle', $
;  'NS_flowangle', 'SigmaNS_flowangle', 'Proton_Np_nonlin', 'Proton_sigmaNp_nonlin', $
;  'Alpha_V_nonlin', 'Alpha_sigmaV_nonlin', 'Alpha_VX_nonlin', 'Alpha_sigmaVX_nonlin', $
;  'Alpha_VY_nonlin', 'Alpha_sigmaVY_nonlin', 'Alpha_VZ_nonlin', 'Alpha_sigmaVZ_nonlin', $
;  'Alpha_W_nonlin', 'Alpha_sigmaW_nonlin', 'Alpha_Na_nonlin', 'Alpha_sigmaNa_nonlin', $
;  'ChisQ_DOF_nonlin', 'Proton_V_moment', 'Proton_VX_moment', 'Proton_VY_moment', $
;  'Proton_VZ_moment', 'Proton_W_moment', 'Proton_Wperp_moment', 'Proton_Wpar_moment', $
;  'Proton_Np_moment', 'BX', 'BY', 'BZ', 'Ang_dev', 'dev', 'xgse', 'ygse', 'zgse', $
;  'Ygsm', 'Zgsm']
vars=[ 'Proton_V_nonlin=Vp', 'Proton_VX_nonlin=Vxp', 'Proton_VY_nonlin=Vyp', 'Proton_VZ_nonlin=Vzp', $
 'Proton_W_nonlin=Vth_p', 'Proton_Wperp_nonlin =Vth_p_perp', 'Proton_Wpar_nonlin =Vth_p_para', 'Proton_Np_nonlin=Np', $
  'Alpha_V_nonlin=Valpha', 'Alpha_VX_nonlin=Vx_alpha', 'Alpha_VY_nonlin=Vy_alpha', 'Alpha_VZ_nonlin=Vz_alpha', $
  'Alpha_W_nonlin=Vth_alpha', 'Alpha_Na_nonlin=Nalpha', 'BX', 'BY', 'BZ', 'xgse', 'ygse', 'zgse']

cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,/autobad

end