; cread_stereo_swimf.pro
; Loads 1 hr binned STEREO A&B vector magnetic field, proton density, temperature, velocity, and position in HGI. ; Heliosphere1AU
; Dataset: STA_L2_PLA_1DMAX_1MIN
;          STEREO/PLASTIC Level 2  - Dr. Antoinette Galvin (University of New Hampshire)
; Time range: 2007-02-14T00:00:37.000Z - 2014-02-28T23:59:56.000Z
;

start_time = '2007-02-14T00:00:37.000Z'
stop_time  = '2014-02-28T23:59:56.000Z'

dt_sec=3600.0 ;s
time_name='j_day'
;dates = [start_time, stop_time]

; dataset_id = 'STA_L2_PLA_1DMAX_1MIN'
; vars = ['error', 'caution', 'attitude_flag', 'ew_source_flag', 'proton_number_density', 'proton_bulk_speed', 'proton_temperature', 'proton_thermal_speed', 'proton_n_s_flow_angle_inst', 'proton_e_w_flow_angle_inst', 'proton_n_s_flow_angle_HERTN', 'proton_e_w_flow_angle_HERTN', 'proton_Vr_HERTN', 'proton_Vt_HERTN', 'proton_Vn_HERTN', 'proton_n_s_flow_angle_RTN', 'proton_e_w_flow_angle_RTN', 'proton_Vr_RTN', 'proton_Vt_RTN', 'proton_Vn_RTN']
; 
; 
; dataset_id='STA_L2_PLA_1DMAX_1HR'
;  ;          STEREO/PLASTIC Level 2  - Dr. Antoinette Galvin (University of New Hampshire)
;  vars=[ 'error_1hr', 'caution_1hr', 'cycles_den_1hr', 'cycles_vel_1hr', 'attitude_flag_1hr', $
;   'ew_source_flag_1hr', 'proton_number_density_1hr', 'proton_bulk_speed_1hr', $
;   'proton_temperature_1hr', 'proton_thermal_speed_1hr', 'proton_n_s_flow_angle_inst_1hr', $
;   'proton_e_w_flow_angle_inst_1hr', 'proton_n_s_flow_angle_HERTN_1hr', 'proton_e_w_flow_angle_HERTN_1hr', $
;   'proton_Vr_HERTN_1hr', 'proton_Vt_HERTN_1hr', 'proton_Vn_HERTN_1hr', 'proton_n_s_flow_angle_RTN_1hr', $
;   'proton_e_w_flow_angle_RTN_1hr', 'proton_Vr_RTN_1hr', 'proton_Vt_RTN_1hr', $
;   'proton_Vn_RTN_1hr']
  
dataset_id='STB_COHO1HR_MERGED_MAG_PLASMA'
 ;          Merged hourly magnetic field, plasma and ephermis data - Natasha Papitashvili (NASA/GSFC)
 vars=[ 'radialDistance', 'heliographicLatitude', 'heliographicLongitude', 'BR', $
  'BT', 'BN', 'B', 'plasmaSpeed=vp', 'lat', 'lon', 'plasmaDensity=np', 'plasmaTemp=tpr']  
;d = spdfGetData( dataset_id, vars, dates)
cdaweb_get_bin,dataset_id,vars, start_time, stop_time, dt_sec, time_name=time_name, to_struct=to_struct

end