; cread_rbsp_efw_mag.pro
; Load RBSP hi resolution EFW electric field data (32 samples/s) X & Y in MGSE coordinates,
; load hi resolution magnetometer data (64 samples/s) in GSE coordinates, 
; place measurements in common uniformly spaced time bins.
FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata
;dates =['2014-02-10T00:00:00.0Z', '2014-02-10T23:59:59.9Z']
jdr = [julday(02,23,2014, 6), julday(02,23,2014,9)]  ;Result = JULDAY(Month, Day, Year, Hour, Minute, Second)
satid='B'
dates = cmb_date(jdr,format='isodate1',/time_in_julday)

if n_elements(q) ne 0 then goto,skip
satid=strupcase(satid)
dt=0.1d0 ;s size of time bin in seconds
time_name='jd'

dataset_id = 'RBSP-'+satid+'_MAGNETOMETER_HIRES-GSE_EMFISIS-L3'
;vars = ['Mag', 'Magnitude', 'delta', 'lambda', 'coordinates', 'range_flag', 'partition', 'MET', 'calState', 'magInvalid', 'magFill']
;dmag = spdfGetData( dataset_id,vars , dates)
vars = ['Mag=bfl', 'Magnitude=b0']
cdaweb_get_bin,dataset_id,vars,dates[0], dates[1],dt,time_name=time_name,to_struct='q'


dataset_id='RBSP'+satid+'_EFW-L2_ESVY_DESPUN'
;          Despun (32 Samples/sec) E-Field estimates in M-GSE coords - J. R. Wygant (University of Minnesota)
;vars=[ 'efield_mgse', 'efw_qual', 'mlt', 'mlat', 'lshell', 'pos_gse', 'vel_gse']
;defw = spdfgetdata(dataset_id, vars, dates,/verbose)
vars=[ 'efield_mgse=efl', 'efw_qual', 'mlt', 'mlat', 'lshell', 'pos_gse', 'vel_gse']
cdaweb_get_bin,dataset_id,vars,dates[0], dates[1],dt,time_name=time_name,to_struct='q'

help,jd, q,/str

skip:
iplot=1
if iplot eq 1 then begin

cmb_set_up_colors
;xsize = 1000 
;ysize = 1000
cmb_adjust_screen_size,xsize,ysize
window,/free, retain=2, xsize = xsize, ysize = ysize

!p.charsize=0
!x.ticklen = -0.04
!y.ticklen = -0.012
nx = 1
ny = 5
ch = 0.005
pos = [.1,.1,.9,.9]
;jdr = [julday(02,23,2014, 6, 45), julday(02,23,2014, 7,25)]
jdr = [julday(02,23,2014, 7, 42), julday(02,23,2014, 7,43)]  ;Result = JULDAY(Month, Day, Year, Hour, Minute, Second)
xr = jdr
sat='RBSP-' + satid

dates = cmb_date(jdr,format='isodate1',/time_in_julday)
title0 =  sat + ' EFW/MAG for ' + dates[0] + ' to '+ dates[1]

;n=101 & q={jd: pts_crange(n,xr=jdr), efl: randomu(seed, 3,n), bfl: randomu(seed, 3,n)}
dummy = LABEL_DATE(DATE_FORMAT='%H:%I:%S')
xtickformat='cmb_nonames'
ip=0
ytitles='E!d' + ['X','Y','Z'] +'MGSE' + '!n (V/M)'
plot,[0,1],xstyle=5,ystyle=5,/nodata
for ic=1,2 do begin
      help,ic
      if ic eq 1 then noearse=0 else noerase=1
      if ic eq 1 then title=title0 else title=''
      xtickname = replicate(' ',30)
      plot, q.jd, q.efl[ic,*], xstyle=1,xr=xr $
                  , ytitle=ytitles[ic],title=title $
                  , xtickname=xtickname,xtickformat=xtickformat $
                  , pos = cmb_pp_pos_b(nx,ny,ch=ch,pos=pos,ip),noerase=noerase
endfor
ytitles='dB!d' + ['X','Y','Z']  +'GSE' + '!n (nT)'
for ic=0,2 do begin
      ii=where(q.jd ge jdr[0] and q.jd le jdr[1])
      bm = mean( q.bfl[ic,ii] ) ;subtract off mean
      bm = poly(q.jd[ii]-q.jd[ii[0]], poly_fit(q.jd[ii]-q.jd[ii[0]],reform(q.bfl[ic,ii]),1) ) ;linearly detrend
      if ic eq 2 then xtickname = replicate(' ',30)
      if ic eq 2 then xtickformat='label_date'
      plot, q.jd[ii], q.bfl[ic,ii]-bm, xstyle=1,xr=xr $
                  , ytitle=ytitles[ic] $
                  , xtickname=xtickname,xtickformat=xtickformat $
                  , pos = cmb_pp_pos_b(nx,ny,ch=ch,pos=pos,ip),noerase=noerase
endfor
cmb_create_plot_file,'demo_rbsp-'+satid + '_EFW_MAG'
endif
end
