;cread_polar_pwi_hires
;  This combines the hi-resolution dynamic spectra from the 4 PWI receivers with different cadences, into one dynamic spectra with one time cadence. Loads 120s binned POLAR  TIMAS H+, O+ energy spectra, for 3 pitch angle bins, PWI Plasma wave electric and magnetic field dynamic spectra, vector magnetic field measurements.  Note the cdf time resolution of the magnetometer and ion spectra datasets are ~ 55 s,  ~24 s respectively.  The cdf time resolution of the four PWI receivers ares  33 s, 16.5 s, 6.0 s, and 2.35 s respectively.;MagnetosphereEarth
;load hires data from the POLAR spacecraft plasma wave receiver
; the mag data is also load to compute the proton cyclotron frequency.
; note if the receiver switches antennas it is connected during the time interval
; data from 2 different antenna will be average at the time of the switch.
; the high resolution plasma wave data is loaded the measurements from 5 receiver channels are combined into one
; with the same time resoulion.

;The high resolution wave data consists of 5 receiver channels, each one with a different time tag and set of frequencies.
;These 5 channels of 32,32,32,64,64 frequency measurements are binned into a common timeseries and one channel of 224 frequencies.
;The time resolution of receiver 1,2,3,4 and 5 is 33s, 16.5s, 8.24s, 2.4s and 2.4 s respectively.
;CATDESC         STRING    'Antenna (SFRB) 0=Eu, 1=Ev, 2=Ez, 3=L'
;CATDESC         STRING    'Antenna (SFRA) 0=Eu, 1=Ez, 2=L, 3=Bz'
;          Polar Plasma Wave Instrument, Step Frequency Receivers A & B, ~2 sec resolution fields - D. Gurnett (U. Iowa)
;  vars=[ 'SFRA_Antenna', 'SFRB_Antenna', 'SFR_Mode', 'SFR5A', 'SFR4A', 'SFR3A', $
;   'SFR2A', 'SFR1A', 'SFR5B', 'SFR4B', 'SFR3B', 'SFR2B', 'SFR1B', 'SFR5Phase', $
;   'SFR4Phase', 'SFR3Phase', 'SFR2Phase', 'SFR1Phase', 'SFR5_Corr', 'SFR4_Corr', $
;   'SFR3_Corr', 'SFR2_Corr', 'SFR1_Corr', 'Fce', 'fUHR', 'Ne']
; d = spdfgetdata(dataset_id, vars,[start_time,stop_time])
;
; start_time = '1997-03-11T00:00:00.0Z'
; stop_time  = '1997-03-11T23:59:59.0Z'
; start_time = '1997-09-10T22:00:00.0Z'
; stop_time  = '1997-09-10T23:59:59.0Z'
; start_time = '1997-09-10T06:00:00.0Z'
; stop_time  = '1997-09-10T12:00:00.0Z'

start_time = '1997-03-11T00:00:00.0Z'
stop_time  = '1997-03-11T23:59:59.0Z'
time_name ='j_day'
dt_sec =8.;seconds, size of a time bin

;get plasma wave receiver data at specified time resolution.
dataset_id = 'PO_H1_PWI'
vars = ['SFR1A','SFR2A','SFR3A','SFR4A','SFR5A','SFRA_Antenna','SFR1B','SFR2B','SFR3B','SFR4B','SFR5B','SFRB_Antenna']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name

;get mag data and position with same time resoution
dataset_id = 'PO_K0_MFE'
vars = ['B_SM','POS_SM=PSM'];; cdf variable names, note to save as components, set vars = ['B_SM=Bx,By,Bz','MBCIGRF_SM','POS_SM=X,Y,Z']
;d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name


;combine PWI frequency channels into one channel of 224 frequencies verus time.
frequency = [frequency1,frequency2,frequency3,frequency4,frequency5]
sfra = [ sfr1a,sfr2a,sfr3a,sfr4a,sfr5a]
sfra_nbin = [ sfr1a_nbin,sfr2a_nbin,sfr3a_nbin,sfr4a_nbin,sfr5a_nbin]

sfrb = [ sfr1b,sfr2b,sfr3b,sfr4b,sfr5b]
sfra_nbin = [ sfr1b_nbin,sfr2b_nbin,sfr3b_nbin,sfr4b_nbin,sfr5b_nbin]

unitsa = cmbmeta.PO_H1S_PWI.SFR1a.fieldnam + cmbmeta.PO_H1S_PWI.SFR1a.units
unitsb = cmbmeta.PO_H1S_PWI.SFR1b.fieldnam + cmbmeta.PO_H1S_PWI.SFR1b.units

print,' '
print,'*****************LIST of VARIABLES CREATED AND THEIR DEPENDENCIES*******************'
for i=0,n_elements(cmbnotes)-1 do print,cmbnotes[i]

print,'Power Spectral Density of all receiver A channels combined into the variable SFRA with units of ' + unitsa
print,'Power Spectral Density of all receiver B channels combined into the variable SFRB with units of ' + unitsb
print,'the frequencies are combined into one variable frequency in Hz'

fcp = 0.015245481*sqrt(total(b_sm^2,1)) ;proton cyclotron frequency in Hz
print,'created varibable proton cyclotron frequency: fcp'




end