;cread_get_polar_3sets
;This combines the low time resolution dynamic spectra from the PWI receivers with 120s binned POLAR  TIMAS H+, O+ energy spectra, for 3 pitch angle bins, PWI Plasma wave electric and magnetic field dynamic spectra, vector magnetic field measurements.  Note the cdf time resolution of the magnetometer and ion spectra datasets are ~ 55 s,  ~24 s respectively.  The cdf time resolution of the four PWI receivers ares  33 s, 16.5 s, 6.0 s, and 2.35 s respectively.;MagnetosphereEarth
;1. The Polar PWI wave key parameter data is loaded, which has a resoution of 5 minutes.
;2. The high resolution TIMAS proton and O+ data are loaded, which has a resolution of 12 s, note each ion component has a different time tag in the cdf.
;3. The magnetometer key parameter data is loaded which has a resoution of 55 s.
;All variables are binned into a time series with a time bin size of 120 s.

start_time = '1997-03-11T00:00:00.0Z'
stop_time  = '1997-03-11T23:59:59.0Z'

dt_sec =120.;seconds, size of a time bin
time_name='j_day' ;center time of bins in Julian day

dataset_id = 'PO_H0_TIM'
vars = ['Flux_HQ', 'Flux_OQ'];; cdf variable names, note to rename FLux_HQ to say proton_flux, set vars = ['Flux_HQ=proton_flux', 'Flux_OQ']
;d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name

dataset_id = 'PO_K0_PWI'
vars = ['SFRA_Av_E','SFRA_Av_M','SFRB_Av_E','SFRB_Av_M','SFRA_Antenna','SFRB_Antenna']
;d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name

dataset_id = 'PO_K0_MFE'
vars = ['B_SM','POS_SM'];; cdf variable names, note to save as components, set vars = ['B_SM=Bx,By,Bz','MBCIGRF_SM','POS_SM=X,Y,Z']
;d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name

fcp = 0.015245481*sqrt(total(b_sm^2,1)) ;proton cyclotron frequency in Hz

end
