; cread_cluster_spin_res_mag.pro
; Loads spin resolution magnetometer data from all CLUSTER spacecraft in GSE along with position, if iplot =1 the field from all spacecraft are plotted red-Bxgse, green-Bygse, blue-Bzgse, black-magniutde;MagnetosphereEarth
; Note the time resoultion of the cdf's is ~4.15 s
FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata
timename='jd'
dt_sec=6.0
;start_time = '2001-01-30T20:17:42.000Z'
;stop_time = '2014-02-28T22:59:57.000Z'


start_time = '2014-02-10T15:30:00.000Z'
stop_time = '2014-02-10T17:30:00.000Z'

;start_time = '2014-02-22T18:40:00.000Z'
;stop_time = '2014-02-23T00:40:00.000Z'

dataset_id = 'C1_CP_FGM_SPIN'
vars = ['B_vec_xyz_gse__C1_CP_FGM_SPIN=bv1', 'B_mag__C1_CP_FGM_SPIN=b01', 'sc_pos_xyz_gse__C1_CP_FGM_SPIN=p1']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='cl'

dataset_id = 'C2_CP_FGM_SPIN'
vars = ['B_vec_xyz_gse__C2_CP_FGM_SPIN=bv2', 'B_mag__C2_CP_FGM_SPIN=b02', 'sc_pos_xyz_gse__C2_CP_FGM_SPIN=p2']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='cl'

dataset_id = 'C3_CP_FGM_SPIN'
vars = ['B_vec_xyz_gse__C3_CP_FGM_SPIN=bv3', 'B_mag__C3_CP_FGM_SPIN=b03', 'sc_pos_xyz_gse__C3_CP_FGM_SPIN=p3']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='cl'

dataset_id = 'C4_CP_FGM_SPIN'
vars = ['B_vec_xyz_gse__C4_CP_FGM_SPIN=bv4', 'B_mag__C4_CP_FGM_SPIN=b04', 'sc_pos_xyz_gse__C4_CP_FGM_SPIN=p4']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='cl'

if cmb_var_type(cl) ne 'STRUCT' then stop

iplot=0
if keyword_set(iplot) then begin
  cmb_set_up_colors
  window,/free
  !x.ticklen = -0.04
  !y.ticklen = -0.012
  nx = 1
  ny = 4
  ch = 0.1
  pos = [0.085,0.085,0.97,0.96]
  !x.ticklen = 0.08
  dummy = LABEL_DATE(DATE_FORMAT='%n:%d')
  jdr = [min(jd),max(jd)]
  ;!p.charsize = 1.2
  !p.charsize = 0
  ip=0
  cmb_mag_plot,jdr, cl, 'b01','bv1','p1', 'Cluster-1', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),noerase=0
  cmb_mag_plot,jdr, cl, 'b02','bv2','p2', 'Cluster-2', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),noerase=1
  cmb_mag_plot,jdr, cl, 'b03','bv3','p3', 'Cluster-3', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),noerase=1
  cmb_mag_plot,jdr, cl, 'b04','bv4','p4', 'Cluster-4', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),noerase=1
  ip=0
  cmb_create_plot_file,'cluster_spin_res_mag'
endif

end 
