;cread_ace_64s
;  Loads 64 sec binned ACE vector magnetic field, proton density, temperature, velocity, He++/H+ ratio.;L1

timename='j_day' ;name of time variable for Julian days
start_time = '2001-01-01T00:00:00.0Z'  ;start time
stop_time  = '2001-05-31T23:59:59.0Z'  ;stop time
dt_sec=64.0 ;sec --- bin size in seconds

dataset_id='AC_H0_MFI'
; ;          H0 - ACE Magnetic Field 16-Second Level 2 Data - N. Ness (Bartol Research Institute)
; vars=[ 'Magnitude', 'BGSEc', 'BGSM', 'dBrms', 'SC_pos_GSE', 'SC_pos_GSM']

vars=[ 'Magnitude=Bmag', 'BGSEc=Bx,By,Bz']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename

dataset_id='AC_H0_SWE'
; ;          ACE/SWEPAM Solar Wind Experiment 64-Second Level 2 Data - D. J. McComas (SWRI)
; vars=[ 'Np', 'Vp', 'Tpr', 'alpha_ratio', 'V_GSE', 'V_RTN', 'V_GSM', 'SC_pos_GSE', 'SC_pos_GSM']

vars=[ 'Np', 'Vp', 'Tpr', 'alpha_ratio', 'V_GSE=Vx,Vy,Vz']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,/autobad,sigmul=5.0



;cmb_set_up_colors
; window, 2, retain=2, xsize = 900, ysize = 900
; nx = 1
; ny = 2
; ch = 0.01
; pos = [0.085,0.085,0.97,0.96]
; charsize=1.4
; ip=0
; dummy = LABEL_DATE(DATE_FORMAT='%n:%d')
; plot,j_day,bmag,xtickformat='cmb_nonames',ytitle='|B| (nT)',charsize=charsize,pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch)
; plot,j_day,np,xtickformat='label_date',xtitle='Time (mo:day)',ytitle='SOLAR WIND DENSITY (cm!u-3!n)',charsize=charsize,pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase


end
