;cread_ace_1hr.pro
;  Load 1 hr binned ACE vector magnetic field, proton density, temperature, velocity, He++/H+ ratio,  various isotope ratios.;L1 

timename='j_day' ;name of time variable for time in Julian days
start_time = '2007-01-01T00:00:00.0Z'  ;start time
stop_time  = '2007-04-30T23:59:59.0Z'  ;stop time
dt_sec_sec=3600.0 ;sec --- bin size in seconds

dataset_id = 'AC_H2_MFI'
;vars = ['Magnitude', 'BGSEc', 'BGSM', 'SC_pos_GSE', 'SC_pos_GSM'] ;variables for dataset
vars = ['Magnitude=B0', 'BGSEc=Bx,By,Bz']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec_sec,time_name=timename

dataset_id = 'AC_H2_SWE'
; vars=[ 'Np', 'Vp', 'Tpr', 'alpha_ratio', 'V_GSE', 'V_RTN', 'V_GSM', 'SC_pos_GSE', 'SC_pos_GSM']
vars = ['Np', 'Vp', 'Tpr','alpha_ratio=nalpha_to_np','V_GSE=Vxp,Vyp,Vzp']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec_sec,time_name=timename

; NOTE the SWI cdf is being modified, so SWI is commented out until modfications are complete.
; dataset_id = 'AC_H2_SWI'
; ;vars = ['nHe2', 'vHe2', 'vC5', 'vO6', 'vFe10', 'vthHe2', 'vthC5', 'vthO6', 'vthFe10', 'He_qual', 'C5_qual', 'O6_qual', 'Fe10_qual', 'C6to5', 'O7to6', 'avqC', 'avqO', 'avqFe', 'C6to5_qual', 'O7to6_qual', 'avqC_qual', 'avqO_qual', 'avqFe_qual', 'FetoO', 'FetoO_qual', 'SW_type']
; vars = ['nHe2', 'vHe2', 'vthHe2', 'vthFe10', 'C6to5', 'O7to6', 'avqFe', 'FetoO', 'SW_type']
; cdaweb_get_bin,dataset_id,vars, start_time, stop_time, dt_sec_sec, time_name=timename

dataset_id='AC_H2_ULE'
; ;          ACE/ULEIS Solar Suprathermal and Energetic Particle Intensities 1-Hour Level 2 Data - G. Mason (University of Maryland)
;    For energy bins, use the "Get Data" button after a search for "ULEIS" at http://heliophysicsdata.gsfc.nasa.gov

; vars=[ 'H_S1', 'H_S2', 'H_S3', 'H_S4', 'H_S5', 'unc_H_S1', 'unc_H_S2', 'unc_H_S3', $
;  'unc_H_S4', 'unc_H_S5', 'He3_S1', 'He3_S2', 'He3_L2', 'He3_L3', 'He3_L4', 'He3_L5', $
;  'He3_L6', 'unc_He3_S1', 'unc_He3_S2', 'unc_He3_L2', 'unc_He3_L3', 'unc_He3_L4', $
;  'unc_He3_L5', 'unc_He3_L6', 'He4_S1', 'He4_S2', 'He4_S3', 'He4_L1', 'He4_L2', $
;  'He4_L3', 'He4_L4', 'He4_L5', 'He4_L6', 'He4_L7', 'He4_L8', 'He4_L9', 'He4_L10', $
;  'He4_L11', 'He4_L12', 'unc_He4_S1', 'unc_He4_S2', 'unc_He4_S3', 'unc_He4_L1', $
;  'unc_He4_L2', 'unc_He4_L3', 'unc_He4_L4', 'unc_He4_L5', 'unc_He4_L6', 'unc_He4_L7', $
;  'unc_He4_L8', 'unc_He4_L9', 'unc_He4_L10', 'unc_He4_L11', 'unc_He4_L12', 'C_S1', $
;  'C_L1', 'C_L2', 'C_L3', 'C_L4', 'C_L5', 'C_L6', 'C_L7', 'C_L8', 'unc_C_S1', $
;  'unc_C_L1', 'unc_C_L2', 'unc_C_L3', 'unc_C_L4', 'unc_C_L5', 'unc_C_L6', 'unc_C_L7', $
;  'unc_C_L8', 'O_S1', 'O_L1', 'O_L2', 'O_L3', 'O_L4', 'O_L5', 'O_L6', 'O_L7', $
;  'unc_O_S1', 'unc_O_L1', 'unc_O_L2', 'unc_O_L3', 'unc_O_L4', 'unc_O_L5', 'unc_O_L6', $
;  'unc_O_L7', 'Ne_S_L1', 'Ne_S_L2', 'Ne_S_L3', 'Ne_S_L4', 'Ne_S_L5', 'Ne_S_L6', $
;  'Ne_S_L7', 'unc_Ne_S_L1', 'unc_Ne_S_L2', 'unc_Ne_S_L3', 'unc_Ne_S_L4', 'unc_Ne_S_L5', $
;  'unc_Ne_S_L6', 'unc_Ne_S_L7', 'Fe_L1', 'Fe_L2', 'Fe_L3', 'Fe_L4', 'Fe_L5', $
;  'Fe_L6', 'Fe_L7', 'Fe_L8', 'Fe_L9', 'unc_Fe_L1', 'unc_Fe_L2', 'unc_Fe_L3', $
;  'unc_Fe_L4', 'unc_Fe_L5', 'unc_Fe_L6', 'unc_Fe_L7', 'unc_Fe_L8', 'unc_Fe_L9']; 
vars=['H_S2', 'He3_S2', 'He4_S2', 'C_L2', 'O_L2', 'Ne_S_L2', 'Fe_L2']
cdaweb_get_bin,dataset_id,vars, start_time, stop_time, dt_sec_sec, time_name=timename

dataset_id='AC_H2_EPM'
; ;          ACE/EPAM Solar Energetic Particle 1-Hour Level 2 Data - R. Gold (JHU/APL)
;    For energy bins, use the "Get Data" button after a search for "ULEIS" at http://heliophysicsdata.gsfc.nasa.gov
; vars=[ 'P1', 'P2', 'P3', 'P4', 'P5', 'P6', 'P7', 'P8', 'unc_P1', 'unc_P2', 'unc_P3', $
;  'unc_P4', 'unc_P5', 'unc_P6', 'unc_P7', 'unc_P8', 'DE1', 'DE2', 'DE3', 'DE4', $
;  'unc_DE1', 'unc_DE2', 'unc_DE3', 'unc_DE4', 'W3', 'W4', 'W5', 'W6', 'W7', 'W8', $
;  'unc_W3', 'unc_W4', 'unc_W5', 'unc_W6', 'unc_W7', 'unc_W8', 'E1p', 'E2p', 'E3p', $
;  'E4p', 'FP5p', 'FP6p', 'FP7p', 'unc_E1p', 'unc_E2p', 'unc_E3p', 'unc_E4p', $
;  'unc_FP5p', 'unc_FP6p', 'unc_FP7p', 'Z2', 'Z2A', 'Z3', 'Z4', 'unc_Z2', 'unc_Z2A', $
;  'unc_Z3', 'unc_Z4', 'P1p', 'P2p', 'P3p', 'P4p', 'P5p', 'P6p', 'P7p', 'P8p', $
;  'unc_P1p', 'unc_P2p', 'unc_P3p', 'unc_P4p', 'unc_P5p', 'unc_P6p', 'unc_P7p', $
;  'unc_P8p', 'E1', 'E2', 'E3', 'E4', 'FP5', 'FP6', 'FP7', 'unc_E1', 'unc_E2', $
;  'unc_E3', 'unc_E4', 'unc_FP5', 'unc_FP6', 'unc_FP7']
vars=['DE2','W4','E2p','Z2A','P2p']
cdaweb_get_bin,dataset_id,vars, start_time, stop_time, dt_sec_sec, time_name=timename

; cmb_set_up_colors
; window, 2, retain=2, xsize = 900, ysize = 900
; nx = 1
; ny = 2
; ch = 0.01
; pos = [0.085,0.085,0.97,0.96]
; charsize=1.4
; ip=0
; dummy = LABEL_DATE(DATE_FORMAT='%n:%d')
; plot,j_day,b0,xtickformat='cmb_nonames',ytitle='|B| (nT)',charsize=charsize,pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch)
; plot,j_day,np,xtickformat='label_date',xtitle='Time (mo:day)',ytitle='SOLAR WIND DENSITY (cm!u-3!n)',charsize=charsize,pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
; oplot,j_day,nhe2

end
