;tdas_ace_2sets
FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata
print,'**********************************************************************************************'
print,'Note TDAS or SPEDAS must be installed.
print,'You can get TDAS at http://themis.ssl.berkeley.edu/software.shtml'
print,'**********************************************************************************************'
read,'Input 1 to continue:',ichoice
if ichoice ne 1 then stop
start_time = '1998-06-10T00:00:00.0Z'
stop_time  = '1998-11-10T23:59:59.0Z'
dt_sec_sec=3600.0 ;s

time_name='j_day'

dataset_id = 'AC_H2_MFI'
vars = ['Magnitude=B0', 'BGSEc=Bx,By,Bz']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec_sec,time_name=time_name,/tdas

dataset_id = 'AC_H2_SWE'
vars = ['Np', 'Vp', 'Tpr','alpha_ratio','V_GSE=Vxp,Vyp,Vzp']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec_sec,time_name=time_name,/tdas

; Note commented out because SWI cdfs are in the process of being updated.
; dataset_id = 'AC_H2_SWI'
; vars = ['nHe2', 'vHe2', 'vthHe2', 'vthFe10', 'He_qual', 'C6to5', 'O7to6', 'avqFe', 'FetoO', 'SW_type']
; cdaweb_get_bin,dataset_id,vars, start_time, stop_time, dt_sec_sec, time_name=time_name,/tdas

;timespan, ['1998-06-10T00:00:00.0Z','1998-11-10T23:59:59.0Z']
cmb_set_up_colors
xsize = 900 
ysize = 600
cmb_adjust_screen_size,xsize,ysize
window, 0, retain=2, xsize = xsize, ysize = ysize
tplot_options,'title', 'ACE EXAMPLE for ' + start_time + ' to '+ stop_time
tplot_options,'position',[.1,.1,.9,.9]
tplot_options,'charsize',1.4
tplot,['Np','Vp','Bx','O7to6']

read,'input 1 to run the tplot_gui:',icont
if icont then tplot_gui

end