;demo_stereoab_omni_swimf
; Plots overlaid 1 hr binned Stere A (red) & B (blue) and Omni (black) data, proton density, proton speed, IMF radial components, and IMF magnitude.
FORWARD_FUNCTION  cmb_da_degrees, cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata

start_time = '2007-02-14T00:00:37.000Z'
stop_time  = '2009-02-28T23:59:56.000Z'

dates = [start_time, stop_time]


dt_sec=3600.0 ;s
time_name='j_day'

keepfiles=0 ;if set keep the downloaded cdf files that contain the requested variable.
;move_cdf_files_to_directory='cdf' ;if set to a directory and if keepfiles is set move the downloaded cdf files to that directory.

dataset_id='STB_COHO1HR_MERGED_MAG_PLASMA'
 ;          Merged hourly magnetic field, plasma and ephermis data - Natasha Papitashvili (NASA/GSFC)
 vars=[ 'radialDistance=rb', 'heliographicLatitude=latb', 'heliographicLongitude=longb', 'BR=brb', $
  'BT=btb', 'BN=bnb', 'B=b0b', 'plasmaSpeed=vpb', 'lat=vlatb', 'lon=vlonb', 'plasmaDensity=npb', 'plasmaTemp=tpb']  
;d = spdfGetData( dataset_id, vars, dates)
sigmul=5.0
cdaweb_get_bin,dataset_id,vars, start_time, stop_time, dt_sec, time_name=time_name, to_struct=to_struct,/autobad, sigmul=sigmul


dataset_id='STA_COHO1HR_MERGED_MAG_PLASMA'
 ;          Merged hourly magnetic field, plasma and ephermis data - Natasha Papitashvili (NASA/GSFC)
 vars=[ 'radialDistance=ra', 'heliographicLatitude=lata', 'heliographicLongitude=longa', 'BR=bra', $
  'BT=bta', 'BN=bna', 'B=b0a', 'plasmaSpeed=vpa', 'lat=vlata', 'lon=vlona', 'plasmaDensity=npa', 'plasmaTemp=tpa']  
;d = spdfGetData( dataset_id, vars, dates)
sigmul=5.0
cdaweb_get_bin,dataset_id,vars, start_time, stop_time, dt_sec, time_name=time_name, to_struct=to_struct,/autobad, sigmul=sigmul


dataset_id='OMNI_COHO1HR_MERGED_MAG_PLASMA'
vars=[ 'heliographicLatitude=lato', 'heliographicLongitude=longo', 'BR=bro', 'BT=bto', 'BN=bno', 'ABS_B=b0o', $
  'V=vpo', 'elevAngle', 'azimuthAngle', 'N=npo', 'T=tpo']

cdaweb_get_bin,dataset_id,vars, start_time, stop_time, dt_sec, time_name=time_name, to_struct=to_struct,/autobad, sigmul=sigmul

cmb_set_up_colors
;xsize = 900  & ysize = 600 &cmb_adjust_screen_size,xsize,ysize
window,/free, retain=2;, xsize = xsize, ysize = ysize

;Sun sidereal rotation period at equator 25.05 days.

rate= 360.0/27.2

nt=n_elements(j_day)
rotations =  rate/360.*(j_day[nt-1]-j_day[0])

daoa = median( cmb_da_degrees( longo,longa) )
daob = median( cmb_da_degrees( longo,longb) )
daab = median( cmb_da_degrees( longb,longa) )

text = string('STEREO-A leads OMNI by ', daoa/rate, ' days,  STEREO-B leads OMNI by ', daob/rate, ' days,  STEREO-A leads STEREO-B by ', daab/rate, ' days',format='(3(a,f6.2),a)')


b0aa = sqrt(bra^2+bna^2+bta^2)
b0oo = sqrt(bro^2+bno^2+bto^2)
b0bb = sqrt(brb^2+bnb^2+btb^2)


!x.ticklen = -0.04
!y.ticklen = -0.012

nx = 1
ny = 4
ch = 0.01
pos = [0.085,0.085,0.97,0.96]

!x.ticklen = 0.08

dummy = LABEL_DATE(DATE_FORMAT='%n:%d')
title = 'OMNI (black), STEREO-A (red), B (blue) EXAMPLE for ' + start_time + ' to '+ stop_time + ' No. of Solar Rotations=' + string(rotations,format='(f7.1)')
;!p.charsize = 1.2
!p.charsize = 0
ip=0
plot,j_day,npo,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='Np (cm!u-3!n)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch)
oplot,j_day,npa,color=250
oplot,j_day,npb,color=80
plot,j_day,vpo,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='Vp (km/s)',xstyle=1, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
oplot,j_day,vpa,color=250
oplot,j_day,vpb,color=80
plot,j_day,bro,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',xtitle='',ytitle='Br (nT)',xstyle=1, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
oplot,j_day,bra,color=250
oplot,j_day,brb,color=80
plot,j_day,b0o,xtickunit='time',xminor = 4,xtickformat='label_date',xtitle='Time (mo:day)',ytitle='B (nT)',xstyle=1, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
oplot,j_day,b0a,color=250
oplot,j_day,b0b,color=80

 xyouts,0.1,0.02,text,/norm
 
 cmb_create_plot_file,'demo_omni_stereo_swimf'
!p.charsize = 0
!x.ticklen = 0
!y.ticklen = 0
end
