;demo_omni.pro
; 1 hour binned OMNI solar wind speed, proton density, IMF Bz,Kp, Dst, and AE are plotted.
FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata
start_time = '2012-08-10T00:00:00.000Z'
stop_time  = '2015-01-10T00:00:00.000Z'

dt=3600d0 ;s
dates = [start_time, stop_time]
time_name='jd'

cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt,time_name=time_name

dataset_id='OMNI2_H0_MRG1HR'
 ;          OMNI Combined, Definitive, 1AU Hourly IMF, Plasma, Energetic Proton Fluxes, and Solar and Magnetic Indices - J.H. King, N. Papatashvilli (ADNET, NASA GSFC)
;  vars=[ 'Rot1800', 'IMF1800', 'PLS1800', 'IMF_PTS1800', 'PLS_PTS1800', 'ABS_B1800', $
;   'F1800', 'THETA_AV1800', 'PHI_AV1800', 'BX_GSE1800', 'BY_GSE1800', 'BZ_GSE1800', $
;   'BY_GSM1800', 'BZ_GSM1800', 'SIGMA-ABS_B1800', 'SIGMA-B1800', 'SIGMA-Bx1800', $
;   'SIGMA-By1800', 'SIGMA-Bz1800', 'T1800', 'N1800', 'V1800', 'PHI-V1800', 'THETA-V1800', $
;   'Ratio1800', 'Pressure1800', 'SIGMA-T1800', 'SIGMA-N1800', 'SIGMA-V1800', 'SIGMA-PHI-V1800', $
;   'SIGMA-THETA-V1800', 'SIGMA-ratio1800', 'E1800', 'Beta1800', 'Mach_num1800', $
;   'Mgs_mach_num1800', 'PR-FLX_11800', 'PR-FLX_21800', 'PR-FLX_41800', 'PR-FLX_101800', $
;   'PR-FLX_301800', 'PR-FLX_601800', 'MFLX1800', 'R1800', 'F10_INDEX1800', 'KP1800', $
;   'DST1800', 'AE1800', 'AP_INDEX1800', 'AL_INDEX1800', 'AU_INDEX1800', 'PC_N_INDEX1800']

vars=[ 'BX_GSE1800=Bx', $
  'BY_GSM1800=By', 'BZ_GSM1800=Bz', $
  'T1800=T', 'N1800=N', 'V1800=V', $
  'Pressure1800=Pr', $
  'F10_INDEX1800=f10', 'KP1800=kp', $
  'DST1800=dst', 'AE1800=ae']  
  
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt,time_name=time_name

cmb_set_up_colors
xsize = 900  & ysize = 900 ; &  cmb_adjust_screen_size,xsize,ysize
window, 2, retain=2, xsize = xsize, ysize = ysize


!y.ticklen = -0.012
!p.charsize = 0

nx = 1
ny = 7
ch = 0.01
pos = [0.085,0.085,0.97,0.96]

dummy = LABEL_DATE(DATE_FORMAT='%n/%d %H')
title = 'OMNI EXAMPLE for ' + start_time + ' to '+ stop_time

ip=0
plot,jd,pr,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='PRESSURE (nPa)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch)
title=''
plot,jd,v,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='SW V (km/s)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
plot,jd,n,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='SW N!dP!n (cm!u-3!n)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
plot,jd,Bz,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='IMF Bz (nT)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
oplot,!x.crange,[1,1]*0.
plot,jd,kp,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='KP',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase

plot,jd,dst,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='DST (nT)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
oplot,!x.crange,[1,1]*0.
plot,jd,ae,xtickunit='time',xminor = 4,xtickformat='label_date',xtitle='Time (mo/day hh)',ytitle='AE',xstyle=1,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
!p.charsize = 0
!x.ticklen = 0
!y.ticklen = 0
cmb_create_plot_file,'demo_omni'
;o={jd:jd, n:n, v:v, bz:bz, bx:bx, by:by,kp:kp,dst:dst, ae:ae,ae_nbin:ae_nbin, kp_nbin:kp_nbin, dst_nbin:dst_nbin,v_nbin:v_nbin, bz_nbin:bz_nbin}
;save,o,file='omni_1hr.dat'
end