; demo_ace_2sets
; Plots 1 hr binned ACE vector magnetic field, proton density, temperature, velocity, He++/H+ ratio,  various isotope ratios. ;L1

FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata
start_time = '1998-06-10T00:00:00.0Z'
stop_time  = '1998-11-10T23:59:59.0Z'

dt_sec_sec=3600.0 ;s

keepfiles=0 ;if set keep the downloaded cdf files that contain the requested variable.
;move_cdf_files_to_directory='cdf' ;if set to a directory and if keepfiles is set move the downloaded cdf files to that directory.

time_name='j_day'


dataset_id = 'AC_H2_MFI'
vars = ['Magnitude=B0', 'BGSEc=Bx,By,Bz']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec_sec,time_name=time_name, keepfiles=keepfiles, move_cdf_files_to_directory=move_cdf_files_to_directory


dataset_id = 'AC_H2_SWE'
vars = ['Np', 'Vp', 'Tpr','alpha_ratio','V_GSE=Vxp,Vyp,Vzp']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec_sec,time_name=time_name, keepfiles=keepfiles, move_cdf_files_to_directory=move_cdf_files_to_directory

; NOTE the SWI cdf is being modified, so SWI is commented out until modfications are complete.
; dataset_id = 'AC_H2_SWI'
; ;vars = ['nHe2', 'vHe2', 'vC5', 'vO6', 'vFe10', 'vthHe2', 'vthC5', 'vthO6', 'vthFe10', 'He_qual', 'C5_qual', 'O6_qual', 'Fe10_qual', 'C6to5', 'O7to6', 'avqC', 'avqO', 'avqFe', 'C6to5_qual', 'O7to6_qual', 'avqC_qual', 'avqO_qual', 'avqFe_qual', 'FetoO', 'FetoO_qual', 'SW_type']
; vars = ['nHe2', 'vHe2', 'vthHe2', 'vthFe10', 'He_qual', 'C6to5', 'O7to6', 'avqFe', 'FetoO', 'SW_type']
; cdaweb_get_bin,dataset_id,vars, start_time, stop_time, dt_sec_sec, time_name=time_name, keepfiles=keepfiles, move_cdf_files_to_directory=move_cdf_files_to_directory

cmb_set_up_colors
;xsize = 900  & ysize = 600 &cmb_adjust_screen_size,xsize,ysize
window, 2, retain=2;, xsize = xsize, ysize = ysize


!x.ticklen = -0.04
!y.ticklen = -0.012

nx = 1
ny = 3 ;4
ch = 0.01
pos = [0.085,0.085,0.97,0.96]

!x.ticklen = 0.08

dummy = LABEL_DATE(DATE_FORMAT='%n:%d')
title = 'ACE EXAMPLE for ' + start_time + ' to '+ stop_time
;!p.charsize = 1.2
!p.charsize = 0

plot,j_day,np,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='Np (cm!u-3!n)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,0,pos=pos,ch=ch)

plot,j_day,-vxp,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='Vp (km/s)',xstyle=1, pos=cmb_pp_pos_b(nx,ny,1,pos=pos,ch=ch),/noerase

plot,j_day,bx,xtickunit='time',xminor = 4,xtickformat='label_date',xtitle='Time (mo:day)',ytitle='Bx (nT)',xstyle=1, pos=cmb_pp_pos_b(nx,ny,2,pos=pos,ch=ch),/noerase

;plot,j_day,o7to6,xtickunit='time',xminor = 4,xtickformat='label_date',xtitle='Time (mo:day)',ytitle='O!u7+!n/O!u6+',xstyle=1, ;pos=cmb_pp_pos_b(nx,ny,3,pos=pos,ch=ch),/noerase

!p.charsize = 0
!x.ticklen = 0
!y.ticklen = 0
end
