/* search sdr for siecific entries */
/**************************************************************************
 * TITLE:  vsdrdmp.c
 *
 * AUTHOR:         Unknown
 * CREATED:        Sep 8, 1994
 * modified:   Ray Bambery - 20200810
 *             add debug statements for migration to solaris 2.10
 *             on shock3
 *             Ray Bambery - 20200827
 *             add print of arguments for log
 *             Ray Bambery - 20210309
 *             Made program command line driven, got rid of getline routine.
 *             reworked main routine to get rid of interactive modesi
 *             Ray Bambery - 20220102
 *             include stdio.h for printf
 *              `print to printf
 * COMPILER:    gcc version 4.5.2 (GCC)
 * OS:          Solaris 10.2   
 *
 ************************************************************************
 * program to dump the contents of a Voyager system
 * data record (SDR) file.  For details see  JPL Doc 
 * structure. For details see  JPL Doc MJS-MTTS-IPL-MTIS SIS 
 * 4-4000-8 and 4-4000-11, dated - 12 May 1976
 *
 * Each SDR has a common SDR header as specified in that 
 * document. Section 5 (page 7) goes into details about the Header format. 
 * Section 6 goes into details about the subheader. Section 7 goes into
 * details about logical data record parts.
 */

#include <math.h>                                                               
#include <string.h>                                                             
#include <stdlib.h>                                                             
#include <ctype.h>  
#include <stdio.h>                                                            
#define  MIN       "MIN"                                                        
#define  BLNK      " "                                                          
#define  MAXLN     72           /*  width of input field  */                       
#define  HDRSIZE   64           /* 64 byte structure  below */                                                      
#define  MAXCHAR   32           /*characters per line of hex dump */            
#define  INTCNT     9  
#define  TWOEXP16  65536                                                        
#define  XSCET(X,Y)  (TWOEXP16*(X) + (Y))                                       
                                                                                
unsigned char input[MAXLN+1];                                                  
unsigned char file_name[44];                                                  
unsigned char datax[5000];      /*  max length of a record   */             
                                                                                
long int    blk_bgn = 0 ;                                                          
long int    blk_end = 10 ;                                                         
short       prfmt = 0;                                                                
short int   do_type[8];
short int   ntypes = 8;        /* number of in_type entries(8 is all)*/ 
short int   ok_flag= 0;        /* if zero then no legal type found */
char        in_mode[5];                                                           
char        in_scid[3] = "al";                                                    
char        fds_bgn[5];                                                           
char        fds_end[5];                                                           
char        cur_fds[5];                                                           
char        tim_bgn[7];                                                           
char        tim_end[7];                                                           
char        ert_bgn[7];                                                           
char        ert_end[7];                                                           
char        cur_ert[7];                                                           
char        sct_bgn[7];                                                           
char        sct_end[7];                                                           
char        cur_sct[7];                                                           
unsigned long int recnum = 0   ;      /*  running count of records  **/         
unsigned long int recsiz = 0   ;      /*  length of current record   **/
unsigned long int totalm = 0   ;      /*  count of records in range  **/
  
unsigned long  int  nbyte = 0;                                                  
unsigned short int  hdr_ok= 0;                                                  
unsigned short int  tim_typ = 1;    /*  default to blk        */                
unsigned short int  hdr_ln;
unsigned char       rectype;

//edr
char                hdr_ebc[4];                                                           
char                sc_id[2];                                                            
unsigned short      sublen;                                                          
unsigned short int  mode ;                                                      
unsigned short int  tmode ;                                                     
unsigned long  int  new_scet = 0;                                               
unsigned short int  nscet_frc = 0;                                              
unsigned short int  fds_linum = 0;                                              
char                low_scet[22];                                                         
char                high_scet[22];                                                         
char                low_ert[22];                                                         
char                high_ert[22];                                                         
char                pscet [20];                                                        
char                pert [20];                                                        
double              dptim[4];                                                          
long int            tmaray[16];                                                        
char                tstrng[22];                                                            
char                rtcode[5];                                                             
int                 i,j,k,m,n;                                                                 
int                 itype;                                                                     
int                 maxl = MAXLN;                                                              
int                 lineln,c;                                                                  
short               lcn;                                                                      
short               prln;                                                                     
short               xval;                                                                     
unsigned short      fval;                                                            
char                ltyp[6];                                                               
char                amode[6];                                                              


//sdr header - defs see MJS-MTTS-IPL-MTIS SIS - 4-4000-8 and 4-4000-11,  - 12 May 1976
// Header = 64 bytes (40x)
struct       {                      //word 0-1  TDRID (0-15)    words 0-1   RECORD_ID                                            
  unsigned int  sdrprj:4;           //4-bits    TDPRJ (0-3)     word 0      PROJECT                                                 
  unsigned int  val_flg:1;          //1-bit     TDVAL (4)       word 0      VALID_DATA                                    
  unsigned int  scft_id:3;          //3-bits    TDSCID (5-7)    word 0      SPACECRAFT_ID                          
  unsigned int  majr_type:4;        //4-bits    TDMJT (8-11)    word 0      major data type                                             
  unsigned int  minr_type:4;        //4-bits    TDMIT (12-15)   word 0      minor data type                                            
  unsigned int  sc_pb:1;            //1-bit     TDAAC (12)      word 0      AACS Flag                                             
  unsigned int  dsn_pb:1;           //1-bit     TDPBK (0)       word 1      S/C Playback
  unsigned int  ext_lv:3;           //3-bits    TDEXL (2-4)     word 1      Extraction Level                                         
  unsigned int  sdline:3;           //3-bits    TDLNE (5-7)     word 1      Line Port in Telemety System                                             
  unsigned int  sdsrce:3;           //3-bits    TDSRC (8-10)    word 1      Source (RT,SDR,IDR,NDR,EDR)                                             
  unsigned int  sdfrmt:5;           //5-bits    TDFMT (11-15)   word 1      Format (from TDMJT modes)                                             
  unsigned short sdrlrecl;          //16-bits   TDRCL (1-15)    word 2      LRECL
  char          sdrdtsub;           //8-bits    TDHLM (0-7)     word 3      Offeet to Record Subheader 
  char          sdrdtdat;           //8-bits    TDHSL (8-15)    word 3      Offset to Data Block    
  unsigned short sdrdtral;          //16-bits   TDORT (0-15)    word 4      Offset to Record Trailer
  unsigned short sdrphseq;          //16-bits   TDSQN (0-15)    word 5      Physical Rec Seq Number
  unsigned short sdrecseq;          //16-bits   TDISB (0-15)    word 6      Record ID Sequence Number                                            
  unsigned short int ert_begn[3];   //3-words   TDERT           words 7-9   7-Hour,8-Secs,9-msecs
  unsigned short int fds_md16;      //16-bits   TDM16 (0-15)    word 10     FDSC Mod16 Counter
  unsigned int   fds_md60:6;        //6-bits    TDM60 (0-5)     word 11     FDSC Mod-60 counter
  unsigned int   fds_lncnt:10;      //10-bits   TDFLC (6-15)    word 11     FDSC Line Count
  unsigned short scet[3];           //3-words   TDSET           words 12-14 12-Hour,13-secs,14-msecs                               
  unsigned short mrt[3];            //3-words   TDMRT           words 15-17 13-Hour,16-secs,17-msecs
  unsigned short sdrsystm;          //16-bits   TDSYS (0-15)    word 18     Created in System
  char          sdr_year;           //8-bits    TDYRS (0-7)     word 19     Yr record created
  char          sdr_logn;           //8-bits    TDRLG (8-15)    word 19     Reason for Logging
  unsigned short sdlokcnt;          //16-bits   TDLCT (0-15)    word 20     Lock Count
                                                       
  unsigned char  sdr_scid;          //8-bits    TDSCN (0-7)     word 21      DSN S/C number
 
  unsigned char  sdr_dsno;          //8-bits    TDPRT (8-15)    word 21      DSN Stn
 
  unsigned int  gcf_gdd:3 ;         //3-bits    TDDSN (0-2)     word 22      DSN Gross Data Description
  unsigned int  gcf_udtc:7 ;        //7-bits    TDSCN (3-9)     word 22      DSN User Dependent Type Code
  unsigned int  gcf_ddtc:6 ;        //6-bits    TDSCN  (10-15)  word 22      DSN Data Dependent Type Code
  unsigned int  gcf_code:2 ;        //2-bits    TDSCN  (0-1)    word 23      DSN coded/uncoded Data
  unsigned int  gcf_lock:5 ;        //5-bits    TDSCN  (2-7)    word 23      DSN Lock Status
  unsigned int  gcf_sxbd:1 ;        //1-bit     TDSCN  (2-7)    word 23      
  char          dsn_confg;          //8-bits    TDSCN  (8-15)   word 23      DSN Configuration
  unsigned short decsnr;            //16-bits   TDSCN  (0-15)   word 24      DSN decoder error rate - bit snr
  unsigned short symsnr;            //16-bits   TDSCN  (0-15)   word 25      DSN SNR - symbol snr                         
  unsigned short xcv_agc;           //16-bits   TDSCN  (0-15)   word 26      DSN Receiver AGC
  char          dwn_link;           //8-bits    TDSRT  (0-7)    word 27      Source Input Telemetry Rate
  char          exp_rate;           //8-bits    TDCRT  (8-15)   word 27      Computed Telemetry Rate
  unsigned short dsnber;            //16-bits   TDPER  (0-15)   word 28      Frame Sync bit error rate
  unsigned short sdrfsflg;          //16-bits   TDFSY  (0-15)   word 29      Frame Sync Output and Flags
  unsigned short sdreserv;          //16-bits   TDFS   (0-15)   word 30      Reserved for frame synchronizer
  unsigned short sdr_corr_flags;    //16-bits   TDFLG  (0-15)   word 31      Flags for Data record
  }  sdr_hdr;                                                                   
                                                                                
                                                                                
                                                                                
  /****    modified for VGR SDR dump     ****/                                  
 char *type_tbl[11]    = {
     "ENGE ","ENGS ","DCOM ","GDSI ",
     "GSE  ","CCS  ","HSKP ","QQC  ","DCM  ","SCI  ","MON  "}  ; 
 
 char typid[] = {0,1,2,3,4,5,6,7,2,4,3};
 
 unsigned char majmin[8] = {0X00,0X01,0X42,0X43,0X10,0X02,0X03,0XB0};
                                                                                
 char *sc_tbl[6] = {"32","31","PT","**","41","42"};                          
                                                                                
 char *noyes[2] = {"N","Y"};                                                
                                                                                
 char *fmtbl[7] = {"MIN","FMT","HDR","SUB","DATA","ALL"};                   
 
 //parameter table for allowed 2nd parameter (search_term) values                                                                               
 char *parmtbl[INTCNT] =                                                    
    {"BLK ","ERT ","SCET","FDS ","TYPE","SKIP",  
            "FMT ","SCID","MODE"};                         
                                                                                
 char mode_ids[18] =                                                        
    {0,1,2,3,4,5,6,7,8,10,12,14,22,23,24,25,26,29};                             
// currently only CR5A and UV5A ares supported                                                                                
 char *mode_tbl[18] =     {"ENG  ","CR2  ","CR3  ","CR4  ",                     
                           "CR5  ","CR6  ","CR7  ","CR1  ",                     
                           "GS10A","GS3  ","GS7  ","GS6  ",                     
                           "OC2  ","OC1  ","CR5A ","GS10 ",                     
                           "GS8  ","UV5A "};                                    
                                                                                
char *prt_typs[9]    = {"GSE  ",                                            
     "ENG  ","DCOM ","GDSI ","**** ",
     "**** ","**** ","**** ","****"}  ;
 
 char *emodes[] =                                                            
  {"LN-10","CR-10","EN-10","TC-10","MC-10","SM-10","CC-10","FD-10",             
   "LN-40","CR-40","EN-40","TC-40","MC-40","SM-40","CC-40","FD-40",             
   "LN-12","CR-12","EN-12","TC-12","MC-12","SM-12","CC-12","FD-12",             
   "LN-72","CR-72","EN-72","TC-72","MC-72","SM-72","CC-72","FD-72",             
   "LA-10","RA-10","EA-10","TA-10","MA-10","SA-10","CA-10","FA-10",             
   "LA-40","RA-40","EA-40","TA-40","MA-40","SA-40","CA-40","FA-40",             
   "LA-12","RA-12","EA-12","TA-12","MA-12","SA-12","CA-12","FA-12",             
   "LA-72","RA-72","EA-72","TA-72","MA-72","SA-72","CA-72","FA-72"};            
                                                                                
                                                                                
 char *dsn_tbl[] =                                                          
   {"00","00","70","72","03","00","33","00","00","97","53","74","00",           
    "32","16","09","75","00","00","81","00","00","00","00","00","00",           
    "00","00","75","75","75","48","75","00","21","00","00","00","75",           
    "54","00","75","00","75","00","49","00","00","75","00","75","00",           
    "00","75","00","00","75","75","00","00","75","00","00","00","00",           
    "55","22","00","00","00","75","00","00","00","58","00","75","75",           
    "00","00","75","99","00","04","00","05","00","10","00","23",                
    "00","06","00","00","24","07","73","00","00","75","00","86","08",           
    "50","00","75","00","00","30","39","00","00","75","00","00","75",           
    "77","00","00","24","26","00","00","00","29","79","75","20",                
    "00","12","14","15","16","85","00","00","00","13","75","75","00",           
    "00","00","75","40","00","42","43","45","46","00","51","75","00",           
    "83","75","00","00","00","00","00","56","00","00","98","00","00",           
    "52","00","75","34","35","36","37","38","02","00","00","75","75",           
    "00","75","00","25","75","00","00","75","24","78","75","75",                
    "00","00","75","00","75","00","75","96","80","91","92","93",                
    "94","75","95","00","59","00","19","82","75","84","00","60","00",           
    "00","00","17","00","75","00","00","75","75","00","00","00","62",           
    "27","28","57","00","00","00","75","00","75","00","00","00","75",           
    "61","63","00","66","00","00","00","00","00","75","65","00","75"};          
                                                                                
//------------------------------------------------------------------------------// 
/* prototypes */
int  main(int, char**);
void dumphex(char ltyp[], short lcn, short);                  
                                                                                
void blkproc(char input[],int lineln,long *blk_bgn,long *blk_end);          
                                                                                
int typproc(char input[],int lineln,char **type_tbl,                        
                                      short do_type[]); 
                                                                                
int skiproc(char input[],int lineln,char **type_tbl,                        
                                      short do_type[]);
                                                                                
void fdsproc(char input[],int lineln,                                       
                        char fds_bgn[],char fds_end[]);
                                                                                
void timeproc(void);

//--------------------------------------------------------------------------//
int  main (int argc,char** argv)
{                                                                                
FILE  *sdrin;  


    if (argc < 2 ){

      printf("usage:  vsdrdmp infile search_term \n");
      exit(0);


    }
    strcpy (&file_name[0], argv[1]);
     printf(" INPUT FILE= %s  \n\n",file_name);
     sdrin = fopen(file_name,"rb");
       if (sdrin == NULL)
     {
        printf("vsdrcmp:  UNABLE TO OPEN FILE %s FOR INPUT.\n",file_name);
        exit(0);
     }

    if (argc < 3) {
        printf ("Missing 2nd parameter - search_term\n");
        exit(0);
    } else {
//    input = toupper(argv[2]);
        strcpy(&input[0],argv[2]);
    
        for(i=0; i<8; i++) 
            {
                  do_type[i] = majmin[i];
            }
    } 
   //"BLK ","ERT ","SCET","FDS ","TYPE","SKIP",
   //            "FMT ","SCID","MODE","ENDF","EXIT"                                                                             
  for (i = 0; i < INTCNT ; i++)                                                 
       {                                                                        
       if (memcmp(input,parmtbl[i],3) == 0)                                 
          {                                                                     
          break;                                                                
          }                                                                     
       }                                                                        
  switch(i)                                                                     
     {

      printf ("input = %s\n",&input);                                                                          
      case 0:        /*  blk=   */  
        printf ("BLK\n");                                            
        tim_typ=1;
        printf("blk_beg = %d bld_end = %d\n",blk_bgn,blk_end);                                                              
        blkproc(input,lineln,&blk_bgn,&blk_end);                                
        break;                                                                  

      case 1:      /*  ert=   */                                                
        tim_typ=2;                                                              
   /****timeproc(input,lineln,ert_bgn,ert_end);   ****/                         
        timeproc();       /*input,lineln);  */                                  
        memcpy(ert_bgn,tim_bgn,7);                                              
        memcpy(ert_end,tim_end,7);                                              
        break;                                                                  

      case 2:      /*  scet=  */   
        printf ("SCET\n");                                             
        tim_typ=3;                                                              
  /**** timeproc(input,lineln,sct_bgn,sct_end);    *****/                       
        timeproc();        /*input,lineln);  */                                 
        memcpy(sct_bgn,tim_bgn,7);                                              
        memcpy(sct_end,tim_end,7);                                              
        break;                                                                  

      case 3:      /*  fds=   */                                                
        tim_typ=4;                                                              
        fdsproc(input,lineln,fds_bgn,fds_end);          
        break;                                                                  

      case 4:      /*  type=  */                                                
        ntypes = typproc(input,lineln,type_tbl,do_type);
        break;                                                                  

      case 5:      /*  skip=  */                                                
        ntypes = skiproc(input,lineln,type_tbl,do_type); 
        break; 

      case 6:      /*  fmt=   */
        printf ("FMT\n");
        printf ("input = %s\n",&input);  
        j = 1;                                              
        for(prfmt=0; prfmt<6; prfmt++)            //corrected to input[4] - 3-8-2021                              
        { // "MIN","FMT","HDR","SUB","DATA","ALL"  
            printf ("input[4] = %s\n",&input[4]);                                                                    
           if(strncmp(&input[4],fmtbl[prfmt],3) ==0) {
           j = 0;
//            printf ("FMT - before break\n"); 
           break;
           }
        }
        if(j == 1)  {
           printf("\n ILLEGAL FMT PARAMETER -- \n");
            j = 0;
	 }
        break;                                                                  

      case 7:      /*  scid=  */                                                
        memcpy(in_scid,&input[5],2);                                       
        break; 

      case 8:       /*   mode --- not implemented yet */
        break; 
                                                                
      case 9:      /*  endf   */         
        goto RUNIT;
  
      case 10:      /*  exit   */
        printf("\n EXIT ON INPUT ERROR \n");         
        goto EXITS;
   
      default:      /*  undefined input   */                                    
        printf(" UNDEFINED INPUT PARAMETER __ %s \n",input);                    
        printf(" REENTER OR TYPE EXIT TO ABORT JOB \n");
        break;
   }          /* end of switch.                  */                             
//  }     /*  end of while ...  getline ...        */                             
                                                                                
RUNIT:   ;                                                                      
   printf("  END OF PROGRAM INPUT  ");                                          

    printf(" \f");     /* EJECT A PAGE & START DATA PRINT  */ 
//----------------------------------------------------------------------//                                                                                
    for (;;)          /*   do forever            */                             
    {                                                                           


    if((fread(datax,1,HDRSIZE,sdrin)) == 0) /* READ SDR HEADER up tp 5000 bytes */
        { 
        printf("\n"); 
        printf("    END OF INPUT FILE. \n"); 

        printf("\n");                                                           
        break;                                                                  
        }                                                                       
                                                                                
    hdr_ln = HDRSIZE;                                                           
      /*     code for bad records/ block with leading garbage */                  
    for(k=0, nbyte=0; k<hdr_ln; k++)                                            
        {                                                                       
        memcpy((char *)&sdr_hdr,datax,hdr_ln);     /* copy hdr to structure */
 
          if(sdr_hdr.sdrprj == 0 & sdr_hdr.sdrdtsub == 32)  /* good sdr*/         
           {                                                                    
           hdr_ok = 1;                                                          
           break;                                                               
           }                                                                    
        else                                                                    
           {                                                                    
           nbyte++;                                                             
           hdr_ok = 0;

           }                                                                    
    printf(" DATA READ IS NOT VGR SDR RECORD __ JOB TERMINATES");         
        exit(2);    /*  bad data --- terminate job.      */                     
                                                                                
    }                       /*  end of for(k=0 ... loop   */                    
    if(hdr_ok == 0) goto ENDLOOP;  /* read more data, no hdr yet */             
    memcpy(hdr_ebc,&datax[nbyte],3);                                       
    hdr_ebc[4] = '\0' ;                                                     
    hdr_ln -= nbyte;                                                            
    if(hdr_ln < HDRSIZE)         /* for partial pps blocks   */                 
      {                                                                         
      fread(&datax[HDRSIZE],1,nbyte,sdrin);                                 
      memcpy(&datax[0],&datax[nbyte],HDRSIZE);                          
 
      }                                                                         
    memcpy((char *)&sdr_hdr,datax,HDRSIZE); /* copy hdr to structure */                
    recnum++;               /*  TOTAL RECORD COUNT   */                         
                                                                                
                    /*   READ REMAINDER OF RECORD   */                          
    k = sdr_hdr.minr_type;  
    rectype = sdr_hdr.majr_type*16+sdr_hdr.minr_type; 
  
    if(ntypes != 0)
      { 
          for(n=0; n < 8 ; n++)
          {                                                         
          if(rectype == do_type[n])                                               
             {                                                                  
             ok_flag = 1;                                                       
             break;                                                             
             }              /*  end of if(k  ...     */                         
          ok_flag = 0;                                                          
        }             /*  end of for(n  ...    */                               
    }                 /*  end of if(ntypes ... */                               
    else   /*   come here if ntypes=0   */                                      
        ok_flag = 1;                                                            
                                                                                
    itype = typid [n]; 
    mode = 0;                                                                   
    if(sdr_hdr.majr_type == 1)    /*  if gse data, set mode  */                 
    {                                                                           
    for (j=0; j<18; j++)                                                        
       {                                                                        
       if (sdr_hdr.sdfrmt == mode_ids[j] )                                  
          {                                                                     
          mode = j;                                                             
          break;                                                                
          }                                                                     
       }                                                                        
    }                       /*  end of majr_type test   */                      
                                                                                
    n = sdr_hdr.scft_id;                                                        
    memcpy(sc_id,sc_tbl[sdr_hdr.scft_id],2);                               
                                                                                
    memcpy(&cur_fds[0],&sdr_hdr.fds_md16,5);                                
                                                                                
    cur_ert[0] = sdr_hdr.sdr_year ;                                         
    memcpy(&cur_ert[1],sdr_hdr.ert_begn,6);                                
                                                                                
    cur_sct[0] = sdr_hdr.sdr_year;                                          
    memcpy(&cur_sct[1],sdr_hdr.scet,6);                                    
                                                                                
    hdr_ln = sdr_hdr.sdrlrecl*2 - HDRSIZE;                                      
  /******   READ REMAINDER OF THIS RECORD, THEN TEST AGAINST INPUTS */          
                                                                                
    n = fread(&datax[HDRSIZE],1,hdr_ln,sdrin);                              
    recsiz = hdr_ln + HDRSIZE;                                                  
                                                                                
    if (ok_flag == 1)      /* if type selected do rest of code  */              
    {                                                                           
    /***    test start/stop conditions here       ***/                          
    switch(tim_typ)                                                             
    {                                                                           
    case 1:         /***   blk input   ***/                                     
       if(recnum < blk_bgn) goto ENDLOOP;                                       
       if(recnum > blk_end) goto EXITS;                                         
       break;                                                                   

    case 2:         /***   ert input   ***/                                     
       if(memcmp(cur_ert,ert_bgn,7) < 0) goto ENDLOOP;                          
       if(memcmp(cur_ert,ert_end,7) > 0) goto EXITS  ;                          
       break;                                                                   

    case 3:         /***   sct input   ***/                                     
       if(memcmp(cur_sct,sct_bgn,7) < 0) goto ENDLOOP;                          
       if(memcmp(cur_sct,sct_end,7) > 0) goto EXITS  ;                          
       break;                                                                   

    case 4:         /***   fds input   ***/                                     
       if(memcmp(cur_fds,fds_bgn,5) < 0) goto ENDLOOP;                          
       if(memcmp(cur_fds,fds_end,5) > 0) goto EXITS  ;                          
       break;                                                                   

    default:        /***   no  input   ***/                                     
       break;                                                                   
    }    
    /*   RECORD IN RANGE FOR PROCESSING   */
    totalm++;
   
    tmaray[0] = sdr_hdr.sdr_year +1900;                                     
    if (tmaray[0] < 1970) tmaray[0] +=100;  /* after 2000 */            
    tmaray[2] = sdr_hdr.ert_begn[0];                                    
    tmaray[3] = sdr_hdr.ert_begn[1];                                    
    tmaray[9] = sdr_hdr.ert_begn[2];                                    
    dictmcnv(tmaray,NULL,NULL,dptim,NULL,"hoy","doy",high_ert,rtcode);          
    high_ert[4] = high_ert[8] = ':';                                    
    memcpy(pert,&high_ert[2],20);    /*   begin ert  */                    
                                                                                
                                                                                
    tmaray[0] = sdr_hdr.sdr_year +1900;                                     
    if (tmaray[0] < 1970) tmaray[0] +=100;  /* after 2000 */            
    tmaray[2] = sdr_hdr.scet[0];                                        
    tmaray[3] = sdr_hdr.scet[1];                                        
    tmaray[9] = sdr_hdr.scet[2];                                        
    dictmcnv(tmaray,NULL,NULL,dptim,NULL,"hoy","doy",high_scet,rtcode);         
    high_scet[4] = high_scet[8] = ':';                                  
    memcpy(pscet,&high_scet[2],20);                                        
                                                                                
      tmode = sdr_hdr.sdfrmt;                                                   
    if(mode == 0) {      /*  for dcom and eng types   */                        
      strcpy(amode,emodes[tmode]);                                          
      }                                                                         
    else  {                                                                     
      strcpy(amode,mode_tbl[mode]);                                         
      }                                                                         
    printf("here6\n");                                                                             
  fds_linum = sdr_hdr.fds_lncnt;                                                
                                                                                
    if((memcmp(in_scid,sc_id,2) != 0)  &&                                     
      (memcmp(in_scid,"al",2) != 0))  goto ENDLOOP;                            
           /****  PRINT MIN FORMAT FROM HEADER  ****/                           
                                                                                
  if(prfmt == 0)   {    /*  prt=min     */          
    printf("PRINT MIN\n");                            
    printf("\nSEQ#=%6d SC=%2s %s",recnum,sc_id,type_tbl[itype]);            
                                                                                
      printf("FMT=%s ",amode);                                                  
                                                                                
    printf("ERT=%s FDS=%.5d.%.2d.%.3d \n",                                      
            pert,sdr_hdr.fds_md16,sdr_hdr.fds_md60,fds_linum);
    printf("here6a\n");
    n = sdr_hdr.sdr_dsno;

    printf("%22s SCPB=%s DSPB=%s DSN=%s ",BLNK,
             noyes[sdr_hdr.sc_pb],noyes[sdr_hdr.dsn_pb],
             dsn_tbl[n]);

    printf("%6s SCET=%s  \n",BLNK,pscet); 

   }         /*      end of fmt=min     */                                      
                                                                                
   else       /*  FULL FMT PRINT BELOW HERE     */                              
   {                                                                            
   /******    insert full print of hdr for fmt=hdr,sub,all etc.  ****/   
    printf ("here8\n");       
    printf("\n %07d  %s ",recnum,type_tbl[itype]);                          
    printf("MODE=%s ",mode_tbl[mode]);                                      
    printf("S/C=%02s ",sc_id);

    n = sdr_hdr.sdr_dsno;

    printf("DSN=%s ",dsn_tbl[n]);

    printf("MAJ=%02d MIN=%02d FMT=%02d ",sdr_hdr.majr_type,                     
                sdr_hdr.minr_type,sdr_hdr.sdfrmt);                              
                                                                                
    printf("ERT =%s   FDS=%.5d.%.2d.%.3d ",                                     
            pert,sdr_hdr.fds_md16,sdr_hdr.fds_md60,fds_linum);                  
                                                                                
    printf("\n%18s",BLNK);                                                      
    printf("VALID=%s  ",noyes[!sdr_hdr.val_flg]);                           
    if(mode != 0)  strcpy(amode,"N/A  ");                                       
    printf("FID=%s",amode);                                                     
                                                                                
    printf("  SCPB=%s DSPB=%s",
            noyes[sdr_hdr.sc_pb],noyes[sdr_hdr.dsn_pb]);                       
                                                                                
    printf("%10s",BLNK);                                                        
    printf(" SCET=%s",pscet);                                                                                
    printf("\n%18s",BLNK);                                                      
    printf("LRECL= %5d",recsiz);                                                
    printf("%7s",BLNK);                                                                                 
    printf(" CFG=%02X ",sdr_hdr.dsn_confg);                                                                                
    xval = sdr_hdr.symsnr;   /* ssnr has 9 bits integ & 7 bit frac*/            
    if(xval<0) xval = -xval;  /*  knock off sign bit for shifting  */           
    xval = xval>>7;          /* shift off fraction bits.      */                
    if(sdr_hdr.symsnr<0) xval = -xval;   /* put sign back    */                 
    printf("SSNR=%4d.",xval);  

    fval = sdr_hdr.symsnr<<9;  /*  shift off integer bits  */                   
    fval = fval>>8;          /* shift back 8 for alignment    */                
    fval = (((float)fval)/256.)*100.;                                           
    printf("%02.2uDB ",fval);    /*  print symbol snr  */                                                                                 
    xval = sdr_hdr.decsnr;   /* dsnr has 9 bits integ & 7 bit frac*/            
    if(xval<0) xval = -xval;  /*  knock off sign bit for shifting  */           
    xval = xval>>7;          /* shift off fraction bits.      */                
    if(sdr_hdr.decsnr<0) xval = -xval;   /* put sign back    */                 
    printf("DSNR=%4d.",xval);                                                   
    fval = sdr_hdr.decsnr<<9;  /*  shift off integer bits  */                   
    fval = fval>>8;          /* shift back 8 for alignment    */                
    fval = (((float)fval)/256.)*100.;                                           
    printf("%02.2uDB ",fval);     /*   print bit snr       */                                                                                 
    xval = sdr_hdr.xcv_agc;   /*  agc has 9 bits integ & 7 bit frac*/           
    if(xval<0) xval = -xval;  /*  knock off sign bit for shifting  */           
    xval = xval>>7;          /* shift off fraction bits.      */                
    if(sdr_hdr.xcv_agc<0) xval = -xval;   /* put sign back    */                
    printf("AGC =%4d.",xval);                                                   
    fval = sdr_hdr.xcv_agc<<9;  /*  shift off integer bits  */                  
    fval = fval>>8;          /* shift back 8 for alignment    */                
    fval = (((float)fval)/256.)*100.;                                           
    printf("%02.2uDB  ",fval);      /*  print xcvr agc   */                     
                                    /*  end of line 3   */                      
                                                                                
    if (prfmt > 1)     /* at least HDR print    */                              
       {                                                                        
       printf("\n");                                                            
       lcn = 0;                                                                 
       prln = HDRSIZE;                                                          
       dumphex("HDR",lcn,prln);
                                           
          /*   end of header hex print    */
       }                                                                                
    if (prfmt > 2)     /* at least SUB print    */
       { 
       lcn = prln; 
       sublen = sdr_hdr.sdrdtdat*2; 
       prln = sublen ;
       dumphex("SUB ",lcn,prln);
    /*   end of data hex print    */
       } 
 
    if (prfmt > 3)     /* print entire record   */  
       { 
       lcn = prln; 
       prln = recsiz;
       dumphex("DATA",lcn,prln);
    /*   end of data hex print    */ 
       }                                                                        
    }         /*  end of print loop   ********/                                 

    printf("\n\n");          /*  space between records   */                     
                                                                                
    }           /*  end of ok_flag loop        */                               
ENDLOOP:  ;                                                                     
  }         /*  end of main while loop    */                                    
                                                                                
EXITS:    ;      /*  end time or eof reached - get out   */ 
  fclose(sdrin);  
       printf("    %d SDR RECORDS READ. \n",recnum);
 
       printf("    %lu RECORDS IN RANGE. \n",totalm);

  printf("     JOB ENDS    *********  \n"); 
  fclose(stdout); 

 exit(0);     /*****  END OF JOB ___ EXIT TO SYSTEM  *****/    

 }                                                                               
 /*****************************************************************/            
 /*********                                             ***********/            
 /*********   BEGINNING OF FUNCTIONS                    ***********/            
 /*********                                             ***********/            
 /*****************************************************************/            

 /*****************************************************************/            
                                                                                
 /****   FUNCTION  DUMPHEX                      ****/                           
 /****   print data record in hex, 32 char per line  ****/                      
                                                                                
 /* void dumphex(char datax[],char ltyp[],short lcn,short prln) */
void dumphex(char ltyp[],short lcn,short prln)             
 {                                                                              
 int lc,pt,incnt;                                                               
                                                                                
 for (lc=lcn, incnt=0; lc<prln; lc++)     /* process data from  */              
   {                                                                            
   if((incnt%MAXCHAR)==0)      /* start to end.  print 32 char  */              
      {                                                                         
      printf("\n%04X",lc);     /* per line(modifiable).         */              
     if(incnt != 0) printf("%6s",BLNK);                                         
      else          printf(" %-5s",ltyp);                                       
    }            /*   end of maxchar loop   */                                  
   if((incnt%2) ==0) printf("%s",BLNK);  /* space every 2 bytes */              
    printf("%02X",datax[lc]);                                               
    incnt++;                                                                    
   }       /*  end of for(lc=                               */                  
  }       /*  end of dumphex ---- there is no return value  */                  
 /*****************************************************************/            
                                                                                
 /****   FUNCTION  TYPPROC                      ****/                           
 /****   convert type=aaaa,bbb,ccc... to type numbers.  ****/                   
                                                                                
 /* int typproc(char input[],int lineln,\
                        char **type_tbl,short do_type[])     */
  int typproc(input,lineln,type_tbl,do_type)
  char     input[];
  int      lineln;
  char     **type_tbl;
  short    do_type[];
                   
 {                                                                              
    int i,j,k,n;
    char  in_type[5];                                                          
    int ntypes=0;

        printf("typproc\n"); 
    for(i=0; i<8; i++) {      /*  initialize do_type all on for skip  */             
          do_type[i] = 99;
    }
    j = 0;                                                                         
    for(i=5; i<lineln+1; i++)    /*  scan input line for legal types */          
    {                                                                           
         /***  comma separates entries, \0 marks end of line ***/               
    if(isalnum(input[i]) == 0)      /*  check for separator */              
       {                                                                        
                                                                                
       if(j != 0)        /* check for blank entry   */                          
       {                                                                        
       memcpy(in_type,&input[i-j],j);                                       
       in_type[j] = '\0'; 
  
       if(memcmp(in_type,"ALL ",3) == 0)  {
         ntypes = 8;
         for(k=0; k<8; k++) {
              do_type[k] = majmin[typid[k]];
	    }
       }
        if(ntypes == 8) goto ENDTYP;
  
 
       for(k=0; k<11 ; k++)       /* is name legal?     */ 
          { 
          if (memcmp(in_type,type_tbl[k],strlen(in_type)) == 0)             
             { 
             do_type[typid[k]] = majmin[typid[k]];
             j=0;        /*  NOTE:  J IS RESET HERE!!!!!!  */ 
             break;     
             }    /*  end of if(memcmp ...  loop     */  
           
          }          /*  end of for(k=0   ...  loop     */ 

          for(k=0; k<8; k++) {
             if(do_type[k] != 99) ntypes++;
          }  
          if(j!=0) 
             {
               printf("  ILLEGAL TYPE VALUE  \n");    
               printf(" REENTER OR TYPE EXIT TO ABORT JOB.\n");
               ntypes=0;
               break;
               }  
               
       }    /*   end of if j!= 0 test.    */    

    }         /*   end of isalnum loop      */ 

    else        /*  no separator found yet, keep looking    */
       {
       j++;
       if(j>5)
          { 
          printf("  ILLEGAL TYPE VALUE  \n"); 
          printf(" REENTER OR TYPE EXIT TO ABORT JOB.\n");
          ntypes=0;
          break;
          }                                                                     
     }               /*  end of else  ...                  */                   
   }                   /*  end of for(i=5 ...  loop          */
ENDTYP:
    printf ("num of types read = ntypes = %d\n",ntypes);
 return ntypes;      /* return number of type names read   */                   
}                                                                               
 /*****************************************************************/            
                                                                                
 /****   FUNCTION  SKIPROC                      ****/                           
 /****   convert type=aaaa,bbb,ccc... to type numbers.  ****/                   
                                                                                
 /* int skiproc(char input[],int lineln,                                       
                        char **type_tbl,short do_type[])   */

  int skiproc(input,lineln,type_tbl,do_type) 
  
  char    input[];
  int     lineln;
  char    **type_tbl;
  short   do_type[];                  
 {                                                                              
 int i,j,k;                                                                     
 char  in_type[5]; 
 
 int ntypes=8; 

 for(i=0; i<8; i++)      /*  initialize do_type all on for skip  */
          do_type[i] = majmin[typid[i]];  
                                                   
 j = 0;                                                                         
 for(i=5; i<lineln+1; i++)      /*  scan input line for legal types */          
    {                          
         /***  comma separates entries, \0 marks end of line ***/               
    if(isalnum(input[i]) == 0)      /*  check for separator */              
       { 
       if(j != 0)        /* check for blank entry   */
       {  
       memcpy(in_type,&input[i-j],j);                                       
       in_type[j] = '\0';                                                   
       for(k=0; k<11 ; k++)       /* is name legal?     */  
          {  
          if (memcmp(in_type,type_tbl[k],strlen(in_type)) == 0)             
             {                                                                  
             do_type[typid[k]] = 99;  /*  delete type here  */
             j=0;        /*  NOTE:  J IS RESET HERE!!!!!!  */ 
             break;   
             }    /*  end of if(memcmp ...  loop     */
          }          /*  end of for(k=0   ...  loop     */

          for(k=0; k<8; k++) {
               if(do_type[k] == 99) ntypes--;
	     }
          if(j!=0)            
                 {
                 printf("  ILLEGAL TYPE VALUE  \n");
                 printf(" REENTER OR TYPE EXIT TO ABORT JOB.\n");
                 ntypes = 0;
                 break;                                     
                 }     
     }    /*   end of if j!= 0 test.    */                                      
                                                                                
    }         /*   end of isalnum loop      */                                  
    else        /*  no separator found yet, keep looking    */                  
       {                                                                        
       j++;                                                                     
       if(j>5)                                                                  
          {                                                                     
          printf("  ILLEGAL TYPE VALUE  \n");  
          printf(" REENTER OR TYPE EXIT TO ABORT JOB.\n");
          ntypes = 0;
          break;                                     
          }
     }               /*  end of else  ...                  */                   
 }                   /*  end of for(i=5 ...  loop          */                   
 return ntypes;      /* return number of type names read   */                   
}                                                                               
 /*****************************************************************/            
                                                                                
 /****   FUNCTION  BLKPROC                      ****/                           
 /****   convert blk=nnn,mmmm from char to int  ****/                           
                                                                                
 /* void blkproc(char input[],int lineln,long *blk_bgn,long *blk_end)   */
  void blkproc(input,lineln,blk_bgn,blk_end)
  
  char    input[];
  int     lineln;
  long    *blk_bgn;
  long    *blk_end;
           
 {                                                                              
 int k,ik,iblk;                                                                 
 char  inblk[2] [6];                                                    
 long bgnb,endb;                                                                
                              printf ("blkproc\n");                                                  
 bgnb=0;                                                                        
 endb=0;                                                                        
 iblk = 0;                                                                      
 ik = 0;                                                                        
 for (k=5; k< lineln-1; k++)      /* scan line from = on to the end */          
   {                                                                            
   if(input[k] != ',')     /* comma separates begin from end  */            
     { printf ("comma not found\n");                                                                          
     inblk[iblk] [ik] = input[k];                                   
     ik++;                                                                      
     }                                                                          
   else          /*   comma found in line   */                                  
     {printf ("comma found\n");                                                 
     iblk = 1;   /*   switch to end portion of work area    */                  
     ik   = 0;                                                                  
     }                                                                          
   }           /*   end of comma parser                   */                    
   printf ("k= %d\n",k) ;                                                                            
  for (k=0; k < lineln-ik-7; k++)   /*  translate from char to int */           
  {                                                                             
    bgnb = 10L*bgnb + (inblk[0] [k]-'0');                               
  }                                                                             
                                                                                
  for (k=0; k < ik; k++)   /*  translate from char to int */                    
  {                                                                             
    endb = 10L*endb + (inblk[1] [k]-'0');                               
  }                                                                             
                                                                                
  *blk_bgn = bgnb;                                                              
  *blk_end = endb;                                                              
  }       /*  end of blk parser - there is no return value  */                  
 /*****************************************************************/            
                                                                                
 /****   FUNCTION  FDSPROC                      ****/                           
 /****   convert fds=aaaaa.bb.ccc,aaaaa.bb.ccc to internal form  ***/           
                                                                                
 /* void fdsproc(char input[],int lineln, \
                                 char fds_bgn[],char fds_end[])  */
  
  void fdsproc(input,lineln,fds_bgn,fds_end)
  char    input[];
  int     lineln;
  char    fds_bgn[];
  char    fds_end[];
          
 {                                                                              
 int k,ik,ib,l1,l2,m;                                                           
 int kk;                                                                        
 static char  inblk[2] [13];                                            
 unsigned short wkfds=0;                                                        
                                                                                
 ib= ik= l1= l2= 0;                                                             
 for(k=5; k<lineln; k++)                                                        
   {                                                                            
   if(input[k] != ',')       /* break start from stop fds   */              
     {                                                                          
     inblk[ib] [ik] = input[k];                                     
     ik++;                                                                      
     l2++;                                                                      
     }          /*  end of if(input ...      */                                 
   else                                                                         
     {                                                                          
     inblk[ib] [ik] = '.';                                              
     l2++;                                                                      
     ik=0;                                                                      
     ib=1;                                                                      
     l1 = l2;                                                                   
     l2=0;                                                                      
     }                                                                          
   }        /*  end of for(k=5 ...        */                                    
                                                                                
   inblk[ib] [ik] = '.';                                                
   l2++;                                                                        
   ik = k = 0;                                                                  
                                                                                
   kk = l1;                                                                     
   for(ib=0; ib<2; ib++)       /*  process start fds count  */                  
     {                                                                          
     for(m=0; m<kk; m++)       /*  process start fds count  */                  
        {                                                                       
        if(inblk[ib] [m] != '.')                                        
           {                                                                    
           wkfds = 10*wkfds + (inblk[ib] [m] - '0');                    
           k++;                                                                 
        }       /*   end of if(inblk   ...       */                             
        else                                                                    
           {                                                                    
           if(ib==0)                                                            
            {                                                                   
            switch(ik)                                                          
            {                                                                   
            case 0:                                                             
            memcpy(&fds_bgn[0],&wkfds,2);                                   
            wkfds = 0;                                                          
            break;                                                              
            case 1:                                                             
            wkfds=wkfds<<8;                                                     
            memcpy(&fds_bgn[2],&wkfds,1);                                   
            wkfds = 0;                                                          
            break;                                                              
            case 2:                                                             
            memcpy(&fds_bgn[3],&wkfds,2);                                   
            wkfds = 0;                                                          
            break;                                                              
            }                                                                   
            ik++;                                                               
            }     /*   end of if(ib=0   .....   */                              
           else         /*   ib+1 ....          */                              
            {                                                                   
            switch(ik)                                                          
            {                                                                   
            case 0:                                                             
            memcpy(&fds_end[0],&wkfds,2);                                   
            wkfds = 0;                                                          
            break;                                                              
            case 1:                                                             
            wkfds=wkfds<<8;                                                     
            memcpy(&fds_end[2],&wkfds,1);                                   
            wkfds = 0;                                                          
            break;                                                              
            case 2:                                                             
            memcpy(&fds_end[3],&wkfds,2);                                   
            wkfds = 0;                                                          
            break;                                                              
            }                                                                   
            ik++;                                                               
            }      /*    end of else--switch */                                 
            }      /*    end of else         */                                 
        }        /*  end of for(m=0 ...        */                               
        wkfds = 0;                                                              
        kk = l2;                                                                
        ik = 0;                                                                 
   }        /*  end of for(ib=0  ...      */                                    
 }          /*  end of fdsproc........... */                                    
 /*****************************************************************/            
                                                                                
 /****   FUNCTION  TIMEPROC                     ****/                           
 /****   convert scet/ert=yy:ddd:mm:ss.sss to internal form  ***/               
                                                                                
void timeproc()      /*char input[],int lineln)  */                     
                  /*        char tim_bgn[],char tim_end[]) */           
 {                                                                              
  int i,l,m,n;                                                                  
  int ik=0;                                                                     
  short year_wk, hour_wk, secs_wk, msec_wk;                                     
  char time_str[30];     /* output from dictmcnv   */                       
                                                                                
  i = m = n = 0;                                                                

    printf ("timeproc\n");                                                                                
  input[lineln] = ',';         /*  force end of second entry  */            
  for(i=5; i<lineln+1; i++)      /*   scan input line for comma  */             
     {                                                                          
     if(input[i] != ',')                                                    
        {                                                                       
        tstrng[n] = input[i];                                           
        n++;                                                                    
        }                                                                       
     else         /* end of first field(comma found)    */                      
        {                                                                       
        tstrng[2] = tstrng[6] = ' ' ; /* clear colons */                
                                                                                
        for(ik=0; ik<16; ik++)  tmaray[ik] = 0;                             
                                                                                
        dictmcnv(tmaray,NULL,NULL,dptim,tstrng,"CHAR","HOY",                   
                 time_str,rtcode);                                              
                                                                                
        year_wk = tmaray[0] - 1900;                                         
        if(year_wk >= 100) year_wk-=100;                                        
                                                                                
        year_wk = year_wk<<8;           /* last 2 digits only */                
                                                                                
        hour_wk = tmaray[2];                /*  hr of yr */                 
                                                                                
        secs_wk = tmaray[3];                 /* sc of hr */                 
                                                                                
        msec_wk = tmaray[9];                 /*  msecs   */                 
                                                                                
        if(m == 0)      /*   start time field     */                            
            {                                                                   
            memcpy(&tim_bgn[0],&year_wk,1);                                 
            memcpy(&tim_bgn[1],&hour_wk,2);                                 
            memcpy(&tim_bgn[3],&secs_wk,2);                                 
            memcpy(&tim_bgn[5],&msec_wk,2);                                 
            n = 0;                                                              
            m++;                                                                
            }           /*   end of start time field   */                       
        else            /*   stop time field           */                       
            {                                                                   
            memcpy(&tim_end[0],&year_wk,1);                                 
            memcpy(&tim_end[1],&hour_wk,2);                                 
            memcpy(&tim_end[3],&secs_wk,2);                                 
            memcpy(&tim_end[5],&msec_wk,2);                                 
            }           /*   end of stop time field   */                        
        }     /*    end of else... tstrng      */                               
   }         /*    end of for(i=5    ...     */                                 
 }       /*    end of timeproc        */                                        
