#!/usr/bin/perl -w
#
$perlproc = "edr_split_recs.pl";
# 
#
#       - RJB - Mar 18, 2021 - initial release
#       - RJB - Dec 09, 2021 - Add test to see if byte reversed data
#       - RJB - Dec 23, 2021 - change header recs to dcom recs
#
#  usage: edr_split_recs.pl src_dir dest_dir edr_file edr_mod_file
#
#   Program to separate the records in a file created from the output
#   of program od on a Voyager EDR file.
#  
#   Environment variables:
#    <none>
#
#   Input:
#       Output of a unix od command of an edr file
#
#   Output:
#       The resultant edr file with records delineated
# 
#
use Env;
use POSIX qw(uname);
use Term::ANSIColor;
#use strict;
use warnings;

$argCount = scalar @ARGV;
if (($argCount eq 0)) {
    print color ("blue"), "\n";
    print "\n";
    print "    usage: $perlproc src_dir dest_dir    edr_file         edr_mod_file       format\n";
    print "            Ex:       ./       ./      crs20350.b.hex    crs20350.b.hexmod    hex \n";
    print "\n";
    print "Separate the records in a file created from the output of od on a Voyager EDR file\n";
    print "\n";
    print "\n", color("reset");
    exit(0);
}
if (($argCount == 1)) {
    if ($ARGV[0] =~ /-h/i || $ARGV[0] =~ /help/i || $ARGV[0] =~ /\?/i) {
        print color ("blue"), "\n";
        print "    Voyager Project program to Separate the records in a file created from the output of od on a Voyager EDR file\n";
        print "\n";
        print "    usage: $perlproc src_dir dest_dir edr_file   edr_mod_file format\n";
        print "                         [archive [work]       YYYY MM  DD  HH \n";
        print "\n";
        print "where:\n";
        print "     src_dir is location of input od dump file \n";
        print "     dest_dir is where data is processed and products created\n";
        print "     edr_file is sthe name of input od dump file \n";
        print "     edr_mod_file is the name of the output file with the records separated\n";
        print "     format is the internal format produced by command od\n";
        print "           byte = octal byte format fom command 'od -b'";
        print "           hex  = hex byte format from command 'od -x'";
        print "\n";
        print "\n", color("reset");
        exit;
    }
}
if ($argCount < 5) {
    print color ("red"), "\n";
    print "\n";
    print "Did you forget something?\n\n", color("reset");
    exit(1);
}

#**
#** DECLARATIONS:
#**
#
$byte = "byte";
$data_rec = "   Data Rec ";
$dcom_rec = "   DCOM Rec ";
$eng_rec = "   Engineering Rec ";
#$header = "   Header";
$hex = "hex";
$magic_hex = "d4d1 e2";
$rev_magic_hex = "d1d4";       #"JM"
$magic_byte = "324 321 342";   #"MJS"
$rev_magic_byte = "321 324";   #"JM""
#$rec ="   Rec "; 
$return = "\n";

#**
#**  ENVIRONMENT
#**
#
#print "ARGV[0] = $ARGV[0]\n";          #src dir
#print "ARGV[1] = $ARGV[1]\n";          #dest dir
#print "ARGV[2] = $ARGV[2]\n";          #edr_file 
#print "ARGV[3] = $ARGV[3]\n";          #edr_mod_file file extension
#print "ARGV[4] = $ARGV[4]\n";          #byte or hex
#
#
$destpath = $ARGV[1];

if (-d $destpath) {
    #
} else {
    print color ("red"), "      ??E destpath = $destpath does NOT exist\n", color("reset");
    exit(1);
}
my $format = $ARGV[4];

if ($format =~ m/byte/ || $format =~ m/hex/ ) {
# print "format = $format\n";
 
} else {
    print color ("red"), "      ??E format not byte or hex";
     print "\n", color("reset");
}
# open that file and find magic 
my $magic_num = 0;          #number of total records
my $eng_num = 0;            #number of engineering records
my $dcom_num = 0;           #number of DCOM records
open(INFILE,"$ARGV[2]") || die "Cannot find INFILE: $ARGV[2]\n";
open(OUTFILE,">$ARGV[3]") || die "Cannot open OUTFILE: $ARGV[3]\n";

LINEA: while (<INFILE>) {
    chop;
    $line = $_;
    @lineno  = split (/\s+/, $line);           #split on spaces
#    print "lineno[0] $lineno[0] lineno[1] = $lineno[1]\n";
    if (defined($lineno[1])) {
        if ($lineno[1] =~ $rev_magic_hex && $format =~ m/$hex/ ) {
            print color ("red"), "\n";
            print "DATA SET is Byte reversed\n";
            print "PLEASE run byteswap program\n\n", color("reset");
            exit;
        }
        if ($lineno[1] =~ $rev_magic_byte && $format =~ m/$byte/ ) {
            print color ("red"), "\n";
            print "DATA SET is Byte reversed\n";
            print "PLEASE run byteswap program\n\n", color("reset");
            exit;
        }
    }

    
#    next LINEA if($line =~ m/^\*/ );     # skip lines starting with *
    if ($format =~ m/$hex/ ) {
        if ($line =~ m/$magic_hex/ ) {
            $magic_num++;
#my @find = split / /, $str, 2;
            @find = split( /$magic_hex/, $line );
            print "find[0] = $find[0]\n";
#            print "find[1] = $find[1]\n";
            @next = split( /\s+/,$find[1]);
#my $result = index($string, $char);
#            print "next[0] = $next[0]\n";
            $rec_type = $next[0];
            $ctr = $magic_num;
            $recid = $data_rec; 
            if ($rec_type =~ "f0") {$recid = $dcom_rec; $dcom_num++; $ctr = $dcom_num; $magic_num--;}
            if ($rec_type =~ "f1") {$recid = $dcom_rec; $dcom_num++; $ctr = $dcom_num; $magic_num--;}
            if ($rec_type =~ "b0") {$recid = $eng_rec; $eng_num++; $ctr = $eng_num; $magic_num--;}
            if ($rec_type =~ "b1") {$recid = $eng_rec; $eng_num++; $ctr = $eng_num; $magic_num--;} 
            $posit = index($line,$magic_hex);
#            print "posit = $posit of $magic_hex\n";
# to get variable number of spaces -- perl -e 'print "4"x4; print "\n"'
            $filler = " "x$posit;
#            print "filler = <$filler>";
            $outline = "$find[0]$return$filler$magic_hex$find[1]$recid$ctr\n";
            print OUTFILE $outline;
        } else {
            $outline = "$line$return";
            print OUTFILE $outline;
        }
     }
     if ($format =~ m/$byte/ ) { 
         if ($line =~ m/$magic_byte/ ) { 
                $magic_num++; 
                @find = split (/$magic_byte/, $line);
#                print "find[0] = $find[0]\n";
#                print "find[1] = $find[1]\n";
                $rec_type = $find[1];
                $ctr = $magic_num;
                $recid = $data_rec;
                if ($rec_type =~ "360") {$recid = $dcom_rec; $dcom_num++; $ctr = $dcom_num;$magic_num--;}
                if ($rec_type =~ "361") {$recid = $dcom_rec; $dcom_num++; $ctr = $dcom_num;$magic_num--;}
                if ($rec_type =~ "260") {$recid = $eng_rec; $eng_num++; $ctr = $eng_num; $magic_num--;}
                if ($rec_type =~ "261") {$recid = $eng_rec; $eng_num++; $ctr = $eng_num; $magic_num--;}

                my $posit = index($line,$magic_byte);
                my $filler = " "x$posit;
                $outline = "$find[0]$return$filler$magic_byte$find[1]$recid$ctr\n";
                print OUTFILE $outline;
         } else {
            $outline = "$line$return";
            print OUTFILE $outline;
         }
     }
#        exit if ($magic_num == 4);
}
print "Number of data records   = $magic_num\n";
print "Number of DCOM records = $dcom_num\n";
print "Number of Engineering records = $eng_num\n";
$tr = $magic_num + $dcom_num + $eng_num;
print "TOTAL Records = $tr\n";
close (INFILE);
close (OUTFILE);
