#ifndef Header
/*****************************************************************
 * TITLE: streader.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 ******************************************************************
** MANUAL
**	SUN2IBM 3x "August 27, 1993"
**
** NAME
**	sun2ibm - convert from SUN single precision floating point
**	to IBM main frame floating point.
**
** SYNOPSIS
**
**	   void sun2ibm(input,output);
**
**	   long int *input;
**	   long int *output;
**
** DESCRIPTION
**
**	Convert from input[25] thru [28], from [30] thru [287]
**	using 'ieees2pr' to get parts then use 'pr2sibm' to get 
**	single precision ieee standard out.
**
** END MAN PAGES
*/
#endif /*  Header v*/
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"SCN2IBM0") csect(STATIC,"SCN2IBM1")
#endif

#include	<stdio.h>
#include	<dofloat.h>

static	int	mach_type = IEEE_BI_TYPE;

void
sun2ibm(input,output)

long	int	*input;
float	*output;

{

Float_Twos	parts;
int	i;
char	*pntr_in;
char	*pntr_out;

for ( i = 25 ; i < 288 ; i++)
{
	pntr_in = (char *)&input[i];
	pntr_out = (char *)&output[i];
	/*get parts to xlate*/
	ieees2pr(pntr_in,&parts,&mach_type);
	/*translate from parts to ieee single precision number*/
	pr2slibm(&parts,pntr_out,&mach_type);
}
return;
}
