/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: streader.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *                          added prototypes to fix error:
 *                          error: static declaration of 'ahf_open' follows non-static declaration
 *                          add #include <stdlib.h>
 ****************************************************************
 *
** MANUAL
**	STREADER 3x, "March 18, 1994"
**
** NAME
**	streader - read Twist Save File in ASCII.
**
** SYNOPSIS
**
**	  #include <streader.h>
**
**	  int streader(option,pntr_2_struct);
**
**	  char  *option;
**	  char  *pntr_2_struct;
**
** PARAMETERS
**
**	  1. option - points to option string.
**	     options are 'OPEN','CLOSE','READ'
**	  2. pntr_2_struct points to structure for
**	     the various options.
**	
** STRUCTURES
**
**	All structures are defined in 'streader.h'.
**
**	Structure for option equal to 'OPEN'.
**
**	  struct stopen {
**	         SFFOPDEF(fd);
**	         char  filename[100];
**	  };
**
**	  typedef struct stopen STOPEN;
**
**	structure for option equal to 'CLOSE'.
**
**	  struct stclose {
**	         SFFOPDEF(fd);
**	  };
**
**	  typedef struct stclose STCLOSE;
**
**	structure for option equal to 'READ';
**
**	  struct stread {
**	         SFFOPDEF(fd);
**	         char    group_id[12];
**	         char    item[12];
**	         int     rec_numbr;
**	         char    *buf;
**	         int     numbr_items;
**	         char    item_id;
**	  };
**
**	  typedef struct stread STREAD;
**
**        structure bufinfo, bufsin, rdbuf used for buffer management
**
**        struct  bufinfo {
**           char  *buf;     points to buffer containing map
**           int   buflen;   length of buffer in bytes
**           int   bufnumber; current buffer number.
**           BOOL  contflag; TRUE for more buffers.
**           int   bufrmode; returned mode for buffers.
**        } ;
**
**        bufrmode can be
**        1. NO_NEW_BUFR - ignore this request.
**        2. NEXT_BUFR - get next buffer.
**        3. PREV_BUFR - get previous buffer.
**        4. BOF - bottom of file get first buffer.
**        5. EOF - get last buffer.
**
**        struct rdinfo {
**           FOPDEF(frd) - frd is file descriptor.
**           char  *filename; file name of frd.
**           char  **list_pntr; set of string pointers
**                              used if filname = NULL
**           int   indx_in_list - used along with list_pntr.
**           char  *rdbuf; pointer to buffer struct.
**           char  *start_adis_pntr; points to first adis structure.
**        }
**
**        struct bufsin {
**           int   tot_bufs;  total number of buffers.
**           int   tot_bytes; total bytes in all buffers.
**           BOOL  more_reads; if All buffers full but
**                             more reads or lists needed.
**              char *pntr; points to buffer.
**              int  lngth; number of bytes in buf.
**              int  count; true buffer numbernot modulo MAXNUMBUFRS.
**           } [MAXNUMBUFRS];
**        }
**
** 
** DESCRIPTION
**
**	'streader' opens, closes and reads the Twist Save
**	navigation file (in ASCII).
**
**	On open it opens the file in 'filename'. Finds
**	the size of the record, including carrage controls and
**	or new line characters (the record size minus these
**	appears to be 80 bytes).
**
**	Read finds the 'group_id' i.e. 'ID' or 'DATA', then
**	finds the item i.e. 'REF-DATE' for a 'groupe_id' equal 
**	to 'ID', after the item name is a one character item
**	id [C] for character string. [I] for integer, [D] for
**	double precision. 'streader' translates from the ASCII
**	item to the item type and places numbr_items in 'buf'.
**
**	Close closes the file.
**
**	NOTE: At this point 'streader' only reads forward
**	and does not go back to a prior record or item or
**	group.
**
** RETURN
**
**	'streader' returns '-1' for error and zero or greater
**	than zero for no error.
**
**	For Open and close 'streader' returns '0' for succes.
**	
**	For read 'streader' returns the number of items found.
**
*/
#endif

#include	<stdio.h>
#include	<string.h>
#include    <stdlib.h>
#include	<sfbufmgr.h>
#include	<streader.h>

#if (NOPROTO)
extern	int	cnvs2dbl();
extern	int	sfetcall_parser();
extern	int	stpars_func();
extern	int	sfbufman();
extern	int	sfread_file_in();
#else
extern	int	cnvs2dbl(char *,DBL *);
extern	int	sfetcall_parser(RDINFO *,int,int,int,char *,
				int (*)(),char *,int);
extern	int	stpars_func(int,int,int,int,int,int,long int);
extern	int	sfbufman(BUFINFO *,RDINFO *);
extern	int	sfread_file_in(RDINFO *);

int streader(char *option,char *pntr_2_struct);
static int stopen_file(void);
static int stclose_file(void);
static int stread_file(void);
int stpars_func(int indx_of_1st_wrd,
        int len_1st_wrd,
        int buf_num_1st_wrd,
        int indx_of_2nd_wrd,
        int len_2nd_wrd,
        int buf_num_2nd_wrd,
        long int running_count);
static stspcl_proc(int indx_of_1st_wrd,int buf_num_1st_wrd,int len_2nd_wrd);        
static stbring_word(int len_wrd,int indx_of_wrd,char *word);
static proc_item(void);
static int do_doubles(void);
static int do_ints(void);
static int do_chars(void);
static int err_print_read(void);
#endif

static	STOPEN	*STO;
static	STCLOSE	*STC;
static	STREAD	*STR;
static	int	rec_numbr;
static	int	count;
static	int	rtc;
static	DBL	*dbl;
static	long	int	*li;
static	char	*buf_pntr;
static	char	last_item_name[20];
static	char	last_group_id[20];
static	char	prev_word[80];
static	BUFSIN	STBUFSIN;
static	BUFINFO	STBUFINFO;
static	RDINFO	STRDINFO;
static	int	indx_in_buf;
static	int	bufnumbr;
static	char	type_of_conversion;
static	BOOL	end_of_item;
static	BOOL	get_items;
static	BOOL	found_id;
static	BOOL	found_item;
static	int	repeat;

char	stspcl_chars[] = {'/','[',']','\0'};

/*****************************************************************************/
int
streader(option,pntr_2_struct)

char	*option;
char	*pntr_2_struct;

{

switch (option[0])
{

	case 'O': /*open*/
	case 'o':
		STO = (STOPEN *)pntr_2_struct;
		rtc = stopen_file();
	break;
	case 'C': /*close*/
	case 'c':
		STC = (STCLOSE *)pntr_2_struct;
		rtc = stclose_file();
	break;
	case 'R': /*read*/
	case 'r':
		STR = (STREAD *)pntr_2_struct;
		rtc = stread_file();
	break;
	default:
		fprintf(stderr,"%s is not a known option\n",
			option);
		return(-1);
}

return(rtc);

}
/***********************************************************************/
static	int
stopen_file()

{

int	len;
char	*pntr;

/*open file*/

int	i;

SFFOPEN(STO->stfd,STO->filename,SFRDONLY);
if (SFFERROPEN(STO->stfd))
{
	fprintf(stderr,"Error in opening file %s\n",
		STO->filename);
	return(-1);
}
/*set up rdinfo bufsin etc for parsing of Twist Save file*/
STRDINFO.frd = STO->stfd;
STRDINFO.rdbuf = (char *)&STBUFSIN;
for ( i = 0 ; i < MAXNUMBUFRS ; i++)
{
	STBUFSIN.bufs[i].pntr = NULL;
}
STBUFSIN.bytes_per_buf = MAXBUFL;
rtc = sfread_file_in(&STRDINFO);
if (rtc < 0)
{
	fprintf(stderr,
		"Error in reading in bufs for buffer management.\n");
	return(-1);
}
indx_in_buf = 0;
bufnumbr = 0;
return(0);
}
/**************************************************************************/
static int
stclose_file()

{

int	i;

/*free buffers incase there is another file comming along*/
for ( i = 0 ; i < MAXNUMBUFRS ; i++)
{
	if (STBUFSIN.bufs[i].pntr == NULL)
	{
		break;
	}
	free(STBUFSIN.bufs[i].pntr);
}

SFFCLOSE(STC->stfd);

return(0);

}
/**********************************************************************/
static	int
stread_file()

{

STR->eod = FALSE;
end_of_item = FALSE;
found_id = FALSE;
get_items = FALSE;
found_item = FALSE;
count = 0;
rtc = sfetcall_parser(&STRDINFO,indx_in_buf,bufnumbr,0,NULL,
			stpars_func,stspcl_chars,0L);
if (rtc < 0)
{
	return(rtc);
}
return(count);
}			

/***********************************************************************/
int
stpars_func(indx_of_1st_wrd,
	    len_1st_wrd,
	    buf_num_1st_wrd,
	    indx_of_2nd_wrd,
	    len_2nd_wrd,
	    buf_num_2nd_wrd,
	    running_count)
	    
int	indx_of_1st_wrd;
int	len_1st_wrd;
int	buf_num_1st_wrd;
int	indx_of_2nd_wrd;
int	len_2nd_wrd;
int	buf_num_2nd_wrd;
long	int	running_count;

{

/*
**	  int  indx_of_1st_wrd;   index in buffer
**	  int  len_1st_wrd;       length, in bytes, of 1st word.
**	  int  buf_num_1st_wrd;   number of buffer in rdbuf.
**	  int  indx_of_2nd_wrd;   index in buffer.
**	  int  len_2nd_wrd;       length, in bytes, of 2nd word.
**	  int  buf_num_2nd_wrd;   number of buffer in rdbuf.
**	  long running_count;     Number of bytes from start
**	                          of actual parsing to start
**	                          of word.
**
**	When a keyword value pair have been found, 'sfparser'
**	calls
**
**	  int  (*pars_func)(indx_of_1st_wrd,len_1st_wrd,
**	                    buf_num_1st_wrd,
**	                    indx_of_2nd_wrd,len_2nd_wrd,
**	                    buf_num_2nd_wrd,
**	                    running_count);
**
**	where 1st_wrd points to keyword, and 2nd_wrd points to
**	value. Because the file in 'rdinfo' can span several
**	buffers the start of the 1st word can be in a different buffer
**	than the 2nd_wrd. 'running_count' is the number of bytes
**	to second word.
**
**	For 'sfnetcall_parser' and 'sfetcall_parser' when a 'word'
**	(not a keyword value pair) has been found 'sfparser' calls
**
**	  int  (*pars_func)(indx_of_1st_wrd,len_1st_wrd,
**	                    buf_num_1st_wrd,
**	                    -1,-1,0,running_count);
**
**	where 1st word points to the lone word.
**
**	When a special character has been found 'sfparser'
**	calls (*pars_func) with the following parameters
**
**	  int  (*pars_func)(indx_of_char,1,
**	                    buf_of_char,
**	                    -1,indx_of_spcl_char,0,
**	                    running_count);
**
**	where 'indx_of_char' is the index into buffer,
**	the length is 1 byte, buf_of_char is the buffer number
**	for 'rdbuf', the -1 tells that this has no value
**	the indx_of_spcl_char is the index into 'spcl_chars'.
**
**	'sfparser' returns current buffer number for buffer management.
*/

int	len;
int	indx;
int	indx_buf;
int	buf_len;

if (len_1st_wrd < 0)
{
	return(1);
}
if (indx_of_2nd_wrd < 0  && len_2nd_wrd >= 0)
{
	/*this is a special character
	  special characters are
	  1. '/'
	  2. '['
	  3. ']'
	*/
	rtc = stspcl_proc(
		indx_of_1st_wrd,buf_num_1st_wrd,len_2nd_wrd);
	return(rtc);
}
/*get word for prev*/
STBUFINFO.bufrmode = USE_BUFINDX;
STBUFINFO.bufnumber = buf_num_1st_wrd;
rtc = sfbufman(&STBUFINFO,&STRDINFO);
if (rtc < 0)
{
	fprintf(stderr,
		"Error in reading in buffer\n");
	return(-1);
}
/*bring in word*/
rtc = stbring_word(len_1st_wrd,indx_of_1st_wrd,prev_word);
if (rtc < 0)
{
	return(-1);
}
if (!get_items)
{
	/*no need to save after '='*/
	return(0);
}
/*this is get item here*/
if (indx_of_2nd_wrd > 0)
{
	/*this is an item after 1st word*/
	/*convert previous word to record number*/
	sscanf(prev_word,"%d",&rec_numbr);
	if (STR->rec_numbr)
	{
		if (STR->rec_numbr > rec_numbr)
		{
			/*continue search*/
			get_items = FALSE;
			found_id = FALSE;
			return(0);
		}
	}
	/*its ok here get 2nd word*/
	if (buf_num_2nd_wrd != buf_num_1st_wrd)
	{
		/*get word for prev*/
		STBUFINFO.bufrmode = USE_BUFINDX;
		STBUFINFO.bufnumber = buf_num_2nd_wrd;
		rtc = sfbufman(&STBUFINFO,&STRDINFO);
		if (rtc < 0)
		{
			fprintf(stderr,
				"Error in reading in buffer\n");
			return(-1);
		}
	}
	/*bring in word*/
	rtc = stbring_word(len_2nd_wrd,indx_of_2nd_wrd,prev_word);
	if (rtc < 0)
	{
		return(-1);
	}
}
else
{
	/*check to see if first character in prev_word is 
	  1. '\''
	  2. one of the 10 digits
	  */
	  if (isalpha(prev_word[0]))
	  {
	  	/*this is probably a group id (I hope)*/
	  	return(0);
	  }
}
rtc = proc_item();
if (rtc == 1)
{
	indx_in_buf = indx_of_1st_wrd + len_1st_wrd;
	if (indx_in_buf >= STBUFINFO.buflen)
	{	
		indx_in_buf -= STBUFINFO.buflen;
		STBUFINFO.bufrmode = NEXT_BUFR;
		rtc = sfbufman(&STBUFINFO,&STRDINFO);
		if (rtc < 0)
		{
			fprintf(stderr,
				"Error in reading in buffer\n");
			return(-1);
		}
	}	
	bufnumbr = STBUFINFO.bufnumber;
}
return(rtc);
}
/************************************************************/
static
stspcl_proc(indx_of_1st_wrd,buf_num_1st_wrd,len_2nd_wrd)


int	indx_of_1st_wrd;
int	buf_num_1st_wrd;
int	len_2nd_wrd;

{

switch(len_2nd_wrd)
{
	case 0: /*this is '/'*/
		/*begin or end of item etc*/
		if (end_of_item)
		{
			end_of_item = FALSE;
			if (found_item)
			{
				get_items = TRUE;
			}	
			return(0);
		}
		/*this is not end of item but a new search*/
		if (get_items)
		{
			/*this ends search*/
			indx_in_buf = indx_of_1st_wrd;
			bufnumbr = buf_num_1st_wrd;
			/*reset BOOLEAN*/
			get_items = FALSE;
			found_id = FALSE;
			found_item = FALSE;
			return(1);
		}
		/*check qroup id*/
		end_of_item = TRUE;
		if (strcmp(STR->group_id,prev_word))
		{
			found_id = FALSE;
			if (!strcmp(STR->group_id,last_group_id))
			{
				STR->eod = TRUE;
				return(1);
			}
		}
		else
		{
			found_id = TRUE;
			strcpy(last_group_id,STR->group_id);
		}
	        return(0);
	case 1: /*'['*/
		if (!found_id)
		{
			return(0);
		}
		/*check item*/
		if (strcmp(STR->item,prev_word))
		{
			found_item = FALSE;
			if (!strcmp(STR->item,last_item_name))
			{
				fprintf(stderr,
				 "gone past item %s\n",
				 STR->item);
				return(-1);
			}
		}
		else
		{	
			found_item = TRUE;
		}
		return(0);
	case 2: /* ']'*/
		if (!found_item)
		{
			return(0);
		}
		/*the last word is type of conversion i.e.
		  'C' character 'D' double precision etc*/
		type_of_conversion = prev_word[0];
		switch (type_of_conversion)
		{
			case 'D': /*double precision*/
				dbl = (DBL *)STR->buf;
			break;
			case 'I': /*long integer*/
				li = (long int *)STR->buf;
			break;
			default:
				/*this is character strings*/
				buf_pntr = STR->buf;
				buf_pntr[0] = '\0';
			break;
		}
		return(0);
	default:
		return(0);
}
}
/********************************************************************/
static
stbring_word(len_wrd,indx_of_wrd,word)

int	len_wrd;
int	indx_of_wrd;
char	*word;

{

int	len;
int	indx;
int	buf_len;
int	indx_buf;

len = len_wrd;
indx = 0;
indx_buf = indx_of_wrd;
for (;;)
{
	buf_len = STBUFINFO.buflen - indx_buf;
	if (len <= buf_len)
	{
		memcpy(&word[indx],&STBUFINFO.buf[indx_buf],
			len);
		prev_word[indx+len] = '\0';
		return(0);
	}
	memcpy(&word[indx],&STBUFINFO.buf[indx_buf],
		buf_len);
	len -= buf_len;
	/*get word for prev*/
	indx = buf_len;
	indx_buf = 0;
	STBUFINFO.bufrmode = NEXT_BUFR;
	rtc = sfbufman(&STBUFINFO,&STRDINFO);
	if (rtc < 0)
	{
		fprintf(stderr,
			"Error in reading in buffer\n");
		return(-1);
	}
}
}
/******************************************************************/
static
proc_item()

{

char	*pntr;
int	i;
int	len;

/*this is process*/
/*first find if this is a repeater*/
pntr = strchr(prev_word,'*');
if (pntr != NULL)
{
	pntr[0] = '\0';
	sscanf(prev_word,"%d",&repeat);
	if (type_of_conversion == 'C')
	{
		return(0);
	}
	/*else find info to repeat*/
	pntr++;
	len = strlen(pntr);
	memcpy(prev_word,pntr,len);
	prev_word[len] = '\0';	
}

switch (type_of_conversion)
{
	case 'D': /*double precision*/
		rtc = do_doubles();
	break;
	case 'I': /*long integer*/
		rtc = do_ints();
	break;
	default:
		/*this is character strings*/
		rtc = do_chars();
	break;
}
return(rtc);
}
/***********************************************************************/
static int
do_doubles()

{

DBL	dbl_repeat;
int	i;
int	j;

rtc = cnvs2dbl(prev_word,dbl);
if (rtc < 0)
{
	fprintf(stderr,
		"Error in converting to double, string is %s\n",
		prev_word);
	err_print_read();
	return(-1);
}
count++;
if (STR->numbr_items)
{
	if (count >= STR->numbr_items)
	{
		return(1);
	}
}
if (repeat)
{
	dbl_repeat = dbl[0];
	for ( j = 0 ; j < repeat - 1 ; j++)
	{
		dbl++;
		dbl[0] = dbl_repeat;
		count++;
		if (STR->numbr_items)
		{
			if (count >= STR->numbr_items)
			{
				repeat = 0;
				return(1);
			}
		}
	}
	repeat = 0;
}
dbl++;
return(0);
}		
/*********************************************************************/
static int
do_ints()

{
long	int	repeat_li;
int	j;

sscanf(prev_word,"%ld",li);
count++;
if (STR->numbr_items)
{
	if (count >= STR->numbr_items)
	{
		return(1);
	}
}
if (repeat)
{
	repeat_li = li[0];
	for ( j = 0 ; j < repeat - 1 ; j++)
	{
		li++;
		li[0] = repeat_li;
		count++;
		if (STR->numbr_items)
		{
			if (count >= STR->numbr_items)
			{
				repeat = 0;
				return(1);
			}
		}
	}
	repeat = 0;
}
li++;
return(0);
}		
/***************************************************************/
static int
do_chars()

{

char	repeat_strng[80];
int	j;
int	len;

len = strlen(prev_word);
/*this has '   '*/
len -= 2;
memcpy(repeat_strng,&prev_word[1],len);
repeat_strng[len] = '\0';
strcpy(&buf_pntr[strlen(buf_pntr)],repeat_strng);
count++;
if (STR->numbr_items)
{
	if (count >= STR->numbr_items)
	{
		return(1);
	}
}
if (repeat)
{
	for ( j = 0 ; j < repeat - 1 ; j++)
	{
		strcpy(&buf_pntr[strlen(buf_pntr)],repeat_strng);
		count++;
		if (STR->numbr_items)
		{
			if (count >= STR->numbr_items)
			{
				repeat = 0;
				return(1);
			}
		}
	}
	repeat = 0;
}
return(0);
}
/********************************************************************/
static	int
err_print_read()

{

fprintf(stderr,
	"for group id of %s and itme %s\n",
	STR->group_id,STR->item);
if (STR->rec_numbr)
{
	fprintf(stderr,
		"for record number %d\n",
		STR->rec_numbr);
}
return(0);
}

