/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*
** MANUAL
**	SFILESIZ 3x "February 27, 1991"
**
** NAME
**	sfilesize - find the size of an open file.
**
** SYNOPSIS
**
**	  #include  <sffile.h>
**
**	  long  sfilesiz(fd);
**
**	  SFFOPDEF(fd);
**
** PARAMETER
**
**	  fd - is the file descriptor from SFFOPEN.
**
** DESCRIPTION
**
**	'sfilesiz' uses FTELL to find current posiotion in file
**	then positions to start of file then to end to fine length.
**
**	Before returning to user 'sfilesiz' repositions to
**	starting position.
**
** RETURN
**
**	'sfilesiz' returns size of file.
**
**	-1 for error.
**
** END MAN PAGES
*/
#endif
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"SCILESI0") csect(STATIC,"SCILESI1")
#endif

#include	<stdio.h>
#include	<sftypes.h>
#include	<sffile.h>

SFFTELLDEF;
SFFSEEKDEF;

long
sfilesiz(fd)

SFFOPDEF(fd);

{

long	start_pos;
long	end_pos;
long	pos = 0;
int	rt_code;

/*begin*/

start_pos = SFFTELL(fd);
if (start_pos < 0)
{
	printf("Error in SFFTELL for start positon in 'sfilesiz'");
	return(-1);
}
rt_code = SFFSEEK(fd,pos,SFSEEK_END);
if (rt_code < 0)
{
	printf("Error in FSEEK to EOF in 'sfilesiz'");
	return(-1);
}
end_pos = SFFTELL(fd);
if (end_pos < 0)
{
	printf("Error in SFFTELL for end positon in 'sfilesiz'");
	return(-1);
}
rt_code = SFFSEEK(fd,0,SFSEEK_SET);
if (start_pos)
{
	rt_code = SFFSEEK(fd,start_pos,SFSEEK_CUR);
}
if (rt_code < 0)
{
	printf(	"Error in SFFSEEK to start position in 'sfilesiz'");
	return(-1);
}
return(end_pos);
}
