/*****************************************************************
 * TITLE: sedrate.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *                  add prototypes
 ******************************************************************
 */

#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<sedrgl.h>

#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"SCDRATE0") csect(STATIC,"SCDRATE1")
#endif
extern	rateintrvl();

static	char	*prev_pntr;
static	int	nexrate;
static	int	onerate;

/* prototypes */
int sedrate(void);
static check_dbl_rate(void);

static singular_record_found(void);
static misc_info(DBL traj_time,char type);

/*****************************************************************/
sedrate()

{

DBL	rate;
int	rtc;

/*--------------------------------------------------------------
  -----ratechk checks the old and new rates for discontinous and
  -----skipped times etc. */
      if (prev_traj_time == 0.0)
      {
           return(0);
      }
         if (!yesintr)
         {
             yesintr = TRUE;
/*----------set rate into buffer for interval file
 -----------place time in start intervals*/
             instsce = prev_traj_time;
             instahf = intrvl_stahfs;
             numints = numints++;
/*----------set end loop for reading traj file*/
         }
/*-----compute rate */
      rate = curr_traj_time - prev_traj_time;
/*-----round rate and make into integer*/
      currate = (int)(rate + .5);
      if (!lasrate)
      {
          lasrate = currate;

          return(0);
      }
/*-----last rate is not zero check against current rate*/
      if (lasrate == currate)
      {
         return(0);
      }
/*-----rates not equal check further*/
      if (next_traj_time == 0.0)
      {
             rtc = check_dbl_rate();
             if (rtc == 2)
             {
                   /*duplicate record found*/
                   return(1);
             }
             if (rtc == 1)
             {
                  singular_record_found();
                  return(0);
             }
             lasrate = currate;
             return(0);
      }
      rate = next_traj_time - curr_traj_time;
      nexrate = (int)(rate + .5);
      if (currate == nexrate)
      {
          /*this is a change of rate now is the time*/
/*-----interval exists here
          place in a 'c' structure*/
             rateintrvl();
             numtrjp = 0;
             numahfp = 0;
             yesintr = FALSE;
             lasrate = currate;
             return(0);
      }
      rtc = check_dbl_rate();
      if (!rtc)
      {
            return(0);
      }
      if (rtc == 2)
      {
              /*duplicate record here*/
              return(1);
      }
      if (nexrate == lasrate)
      {
              /*discontinuous record found*/
              misc_info(curr_traj_time,'D');
                     
/*--------continue reading dptraj*/
             return(1);
      }
      if (onemore_traj_time == 0.0)
      {
            singular_record_found();
	    lasrate = currate;
             return(0);
      }
      rate = onemore_traj_time - next_traj_time;
      onerate = (int)(rate + .5);
      if (onerate != nexrate)
      {
           singular_record_found();
      }
      else
      {
            rateintrvl();
      }
      numtrjp = 0;
      numahfp = 0;
      yesintr = FALSE;
      lasrate = currate;
      return(0);
}
/*******************************************************************/
static
check_dbl_rate()

{

DBL	missing_time;
if (!currate)
{
	currate = lasrate;
	if (next_traj_time == 0.0)
	{
		return(2);
	}
	misc_info(curr_traj_time,'E');
	return(2);
}
if (currate != 2*lasrate)
{
	return(1);
}
/*this means a missing record here*/
if (next_traj_time != 0.0)
{
	if (nexrate != lasrate)
	{
		return(1);
	}
}
/*this is truley a missing record*/
missing_time =  prev_traj_time + (DBL)lasrate;
misc_info(missing_time,'M');
return(0);
}
/***********************************************************************/
static
singular_record_found()

{
misc_info(curr_traj_time,'S');
rateintrvl();
numtrjp = 0;
numahfp = 0;
yesintr = TRUE;
/*----------set rate into buffer for interval file
 -----------place time in start intervals*/
return(0);
}

int
rateintrvl()

{

char	*curr_pntr;
INTERVALS	*CURR_I;
INTERVALS	*PREV_I;


curr_pntr = malloc(sizeof(INTERVALS));
if (curr_pntr == NULL)
{
	fprintf(stderr,
		"Error in mallocing for intervals.\n");
	return(-1);
}
CURR_I = (INTERVALS *)curr_pntr;
if (start_intrvals == NULL)
{
	start_intrvals = curr_pntr;
	CURR_I->prev = NULL;
}
else
{
	PREV_I = (INTERVALS *)prev_pntr;
	PREV_I->next = curr_pntr;
	CURR_I->prev = prev_pntr;
}
CURR_I->next = NULL;
CURR_I->rate = lasrate;
CURR_I->interval = numints;
CURR_I->ntraj = numtrjp;
CURR_I->nahfs = numahfp;
CURR_I->sttraj = intrvl_sttraj;
CURR_I->entraj = prev_traj_time;
CURR_I->stahfs = intrvl_stahfs;
CURR_I->enahfs = intrvl_enahfs;
prev_pntr = curr_pntr;
return(0);
}
/***********************************************************/
static
misc_info(traj_time,type)

DBL	traj_time;
char	type;

{

char	*curr_pntr;
MISCINFO	*CURR_I;
MISCINFO	*PREV_I;


curr_pntr = malloc(sizeof(MISCINFO));
if (curr_pntr == NULL)
{
	fprintf(stderr,
		"Error in mallocing for miscilaneous information.\n");
	return(-1);
}
CURR_I = (MISCINFO *)curr_pntr;
if (start_misc == NULL)
{
	start_misc = curr_pntr;
	CURR_I->prev = NULL;
}
else
{
	PREV_I = (MISCINFO *)prev_misc_pntr;
	PREV_I->next = curr_pntr;
	CURR_I->prev = prev_misc_pntr;
}
CURR_I->next = NULL;
CURR_I->traj_time = traj_time;
CURR_I->type_rec_info = type;
prev_misc_pntr = curr_pntr;
return(0);
}

