/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
/*****************************************************************
 * TITLE: mchdblst.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *                  add prototypes
 ******************************************************************
 *           */

#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"MCHDBLS0") csect(STATIC,"MCHDBLS1")
#endif
#if (NOPROTO)
char	*	memchr();
#endif

#include	<stdio.h>
#include	<ctype.h>
#include	<string.h>
#include	<mchdblst.h>


char	hex40_flt[] = {
0x44,0x30,0x39,0xad
}; /*IBM main frame hex output for float of 12345.67890 */

char	hex40_dbl[] = {
0x44,0x30,0x39,0xad,
0xcc,0x63,0xf1,0x41
}; /*IBM main frame hex output for double 12345.67890 */

char	ieee_flt[] = {
0x46,0x40,0xe6,0xb7
}; /*ieee hex for float 12345.67890 */

char	ieee_dbl[] = {
0x40,0xC8,0x1C,0xD6,0xE6,0x31,0xF8,0xA1 
}; /*hex output for double 12345.67890 */


char	vax_flt[] = {
0x40,0x47,0xB7,0xE6
};

char	vax_dbl[] = {
0x40,0x47,0xB7,0xE6,0x8F,0x31,0x05,0xC5
};

int
mchdblst(flt_indx,dbl_indx)

int	*flt_indx;
int	*dbl_indx;

{

int	mach_type;
union	{
	DBL	dbl;
	char	cd[8];
} ud;

union {
	float	flt;
	char	cf[4];
} uf;
int	i;
int	j;
int	sizedbl;
int	sizeflt;
char	found;
char	*pntr;

sizedbl = sizeof(DBL);
if (sizedbl > 8)
{
	return(-1);
}
sizeflt = sizeof(float);
ud.dbl = 12345.67890;
uf.flt = (float)ud.dbl;
found = 1;
for (i = 0 ; i < sizedbl-1; i++)
{
	pntr = memchr(ud.cd,(int)ieee_dbl[i],sizedbl);
	if (pntr == NULL)
	{
		found = 0;
		break;
	}
	dbl_indx[i] = (int)((long int)pntr - (long int)ud.cd);
}
if (found)
{
	/*this is ieee format*/
	/*order float*/
	mach_type = IEEE_TYPE;
	for (i = 0 ; i < sizeflt-1 ;i++)
	{
		pntr = memchr(uf.cf,(int)ieee_flt[i],sizeflt);
		if (pntr == NULL)
		{
			found = 0;
			return(-1);
		}
		flt_indx[i] = (int)((long int)pntr - (long int)uf.cf);
	}
}
else
{
	found = 1;
	/*check out HEX 40 or IBM main frame double precision*/
	for (i = 0 ; i < sizedbl-1; i++)
	{
		pntr = memchr(ud.cd,(int)hex40_dbl[i],sizedbl);
		if (pntr == NULL)
		{
			found = 0;
			break;
		}
		dbl_indx[i] = (int)((long int)pntr - (long int)ud.cd);
	}
	if (found)
	{
		/*order float*/
		mach_type = HEX40_TYPE;
		for (i = 0 ; i < sizeflt-1 ;i++)
		{
			pntr = memchr(uf.cf,(int)hex40_flt[i],sizeflt);
			if (pntr == NULL)
			{
				found = 0;
				return(-1);
			}
			flt_indx[i] = (int)((long int)pntr - 
				(long int)uf.cf);
		}
	}		
}
if (!found)
{
	found = 1;
	/*check out VMS VAX double precision*/
	for (i = 0 ; i < sizedbl-1; i++)
	{
		pntr = memchr(ud.cd,(int)vax_dbl[i],sizedbl);
		if (pntr == NULL)
		{
			found = 0;
			break;
		}
		dbl_indx[i] = (int)((long int)pntr - (long int)ud.cd);
	}
	if (found)
	{
		/*order float*/
		mach_type = VAX_TYPE;
		for (i = 0 ; i < sizeflt-1 ;i++)
		{
			pntr = memchr(uf.cf,(int)vax_flt[i],sizeflt);
			if (pntr == NULL)
			{
				found = 0;
				return(-1);
			}
			flt_indx[i] = (int)((long int)pntr - 
				(long int)uf.cf);
		}
	}
}		
if (!found)
{
	return(-1);
}
/*set last index for all to see*/
for (i = 0 ; i < sizedbl ; i++)
{
	found = 0;
	for ( j = 0 ; j < sizedbl -1 ; j++)
	{
		if (i == dbl_indx[j])
		{
			found = 1;
			break;
		}
	}
	if (found)
	{
		continue;
	}
	/*else this is not in table*/
	dbl_indx[sizedbl-1] = i;
	break;
}
 for (i = 0 ; i < sizeflt ; i++)
{
	found = 0;
	for ( j = 0 ; j < sizeflt -1 ; j++)
	{
		if (i == flt_indx[j])
		{
			found = 1;
			break;
		}
	}
	if (found)
	{
		continue;
	}
	/*else this is not in table*/
	flt_indx[sizeflt-1] = i;
	break;
}
if (mach_type == IEEE_TYPE)
{
	/*find if big indian or little indian*/
	if (dbl_indx[0])
	{
		/*is little indian*/
		mach_type = IEEE_LI_TYPE;
	}
	else
	{
		/*is big indian*/
		mach_type = IEEE_BI_TYPE;
	}
}
return(mach_type);
}
