/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: ieees2pr.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 ****************************************************************
** MANUAL
**	IEEES2PR 3x "July 17, 1992"
**
** NAME 
**	ieees2pr - ieee floating point number (single precision) to 
**	parts i.e. characteristics, mantisa, sign bit.
**
** SYNOPSIS
**
**	   #include <dofloat.h>
**
**	   void ieees2pr(ieee_float,parts,mach_type);
**
**	   char   *ieee_float;  points to start of single precision 
**	                        floating point number in IEEE format.
**	   Float_Twos *parts;   points to structure for placing parts.
**	   int    *mach_type;   points to type of ieee i.e. big or
**	                        little indian.
**
** STRUCTURE
**
**	  typedef struct float_twos Float_Twos;
**
**	  struct float_twos;
**	      short int    characteristic;
**        BOOL         sign_bit;
**	      char         mantisa[7];
**    };
**
** EXTERNS
**
**	  1. int  mach_int_indx[4] - input tells what the storage of 
**	     the integer looks like i.e. VMS_VAX etc.
**	  2. short int  sizeofint - size of the int for this machine. 
**	     (2 or 4).
**	  3. int mindx_0 - index for placing bytes stream in proper count
**	      of int for shifting etc. 
**	  4. int mindx_1 - index for placing proper bytes in int for 
**	     shift etc.
**
** DESCRIPTION
**
**	The IEEE floating point notation for the IEEE standard is
**                     1           2           3
**	 bit  01234567  8 9012345  67890123  45678901  
**	     [scharact][e xxxxxxx][xxxxxxxx][xxxxxxxx]
**                  1^
**	where 's' is the sign bit 'characte' is 8 bits of characteristic 
**	(powers of 2), 1 is implied, ^ is where the decimal point is.
**
**	The first thing is to test for the sign 's' if minus, the 
**	sign_bit in parts is set to TRUE, else it is set to FALSE.
**
**	next get the characteristic into a half word, subtract '7F' 
**	(HEX) , the bias for the characteristic then add 1, because of 
**	the implied 1, shifted to the right 1, after the decimal 
**	which means subtracting 7E from the characteristic.
**
**	next replace the last bit of the characteristic with a '1' and
**	store the three bytes of the mantisa in 'mantisa' of parts.
**	(left adjsuted) zeroing out the remaining 4 bytes)
**
**	NOTE: The code is set up for int size of 2. It works for 4 
**	also but it does not depend on the int being 4.
**
*/
#endif /*  Header  */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"ICEES2P0") csect(STATIC,"ICEES2P1")
#endif

#include	<stdio.h>
#include	<dofloat.h>

#if (NOPROTO)
extern	void	partieee();
#else
extern	void	partieee();
#endif

ieees2pr(ieee_float,parts,type_mach)

char	*ieee_float;
Float_Twos	*parts;
int	*type_mach;

{

int	i;
Unn	un;
Unn	un1;
int	*indx;

/*begin*/
if (mindx_0 < 0)
{
	partieee();
}
if (type_mach[0] == IEEE_BI_TYPE)
{
	/*big indian i.e. Most to least signifigant*/
	indx = bi_s;
}
else
{
	indx = li_s;
}
if (ieee_float[indx[0]] == 0)
{
        /*its all zero here*/
        parts->characteristic = 0;
        parts->sign_bit = FALSE;
        for ( i = 0 ; i < 7 ; i++)
        {
                parts->mantisa[i] = 0;
        }
        return;
}
/*get sign */
/*load byte 0 and byte one*/
/*[scharact][exxxxxxx]*/
un.uint = 0;
un.uchar[mindx_0] = ieee_float[indx[0]]; 
un.uchar[mindx_1] = ieee_float[indx[1]];
/*this is done for machines like the VMS VAX etc that are backwards 
  for ints*/
if (un.uint & 0x8000) /*check sign bit only*/
{
	/*this is minus*/
	parts->sign_bit = TRUE;
}
else
{	
	parts->sign_bit = FALSE;
}
un1.uint = un.uint << 1; /*shift left by one*/
/*in byte order (not neccesarly int byte order) we have
  [characte][xxxxxxx0] we want [characte]
  place characteristic in parts*/
un1.uchar[mindx_1] = un1.uchar[mindx_0];
un1.uchar[mindx_0] = 0;
parts->characteristic = un1.uint - IEEE_BIAS_S; /*unbias characteristic  
                                                  now is power of 2*/
/*do mantisa. place 1 in leading bit of first byte of mantisa data*/
un.uint |= 0x80; /*[scharact][1xxxxxxx] */
parts->mantisa[0] = un.uchar[mindx_1];
parts->mantisa[1] = ieee_float[indx[2]];
parts->mantisa[2] = ieee_float[indx[3]];
for (i = 3 ; i < 7 ; i++)
{
	parts->mantisa[i] = 0;
}	
return;
}
