/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: ieeed2pr.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *****************************************************************
** MANUAL
**	IEEED2PR 3x "July 17, 1992"
**
** NAME 
**	ieeed2pr - ieee floating point number (double precision) to 
**	parts i.e. characteristics, mantisa, sign bit.
**
** SYNOPSIS
**
**	   #include <dofloat.h>
**
**	   void ieeed2pr(ieee_float,parts,mach_type);
**
**	   char   *ieee_float;  points to start of double precision 
**                     floating point number in IEEE format.
**	   Float_Twos *parts;   points to structure for placing parts.
**	   int    *mach_type;   points to type of double precision
**	               i.e. big or little indian.
**
** STRUCTURE
**
**	  typedef struct float_twos Float_Twos;
**
**	  struct float_twos;
**	      short int    characteristic;
**        BOOL         sign_bit;
**	      char         mantisa[7];
**    };
**
** EXTERNS
**
**	  1. int  mach_int_indx[4] - input tells what the storage of 
**	     the integer looks like i.e. VMS_VAX etc.
**	  2. short int  sizeofint - size of the int for this machine. 
**	     (2 or 4).
**	  3. int mindx_0 - index for placing bytes stream in proper 
**	     count of int for shifting etc. 
**	  4. int mindx_1 - index for placing proper bytes in int for 
**            shift etc.
**
** DESCRIPTION
**
**	The IEEE floating point notation for the IEEE standard is
**                    1            2           3             4        
**	  01234567  8901 2345  67890123  45678901  23456789  01234567 
**	 [scharact][eris xxxx][xxxxxxxx][xxxxxxxx][xxxxxxxx][xxxxxxxx]
**                 1^                                    
**	   5
**	 8901235  
**	[xxxxxxx]etc
**	where 's' is the sign bit 'characteris' is 11 bits of 
**	characteristic (powers of 2), 1 is implied, ^ is where the 
**	decimal point is.
**
**	The first thing is to test for the sign 's' if minus, the 
**	sign_bit in parts is set to TRUE, else it is set to FALSE.
**
**	next get the characteristic into a half word, subtract '3FF' 
**	(HEX) , the bias for the characteristic then add 1, because 
**	of the implied 1, shifted to the right 1, after the decimal 
**	which means subtracting 3FE from the characteristic.
**
**	next repleace the last bit of the characteristic with a '1' 
**	and store the three bytes of the mantisa in 'mantisa' of parts.
**	(left adjsuted) zeroing out the remaining 4 bytes)
**
**	NOTE: The code is set up for int size of 2. It works for 4 
**	also but it does not depend on the int being 4.
**
*/
#endif /*  Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"ICEED2P0") csect(STATIC,"ICEED2P1")
#endif

#include	<stdio.h>
#include	<dofloat.h>

#if (NOPROTO)
extern	void	partieee();
#else
extern	void	partieee();
#endif

ieeed2pr(ieee_float,parts,mach_type)

char	*ieee_float;
Float_Twos	*parts;
int	*mach_type;

{

Unn	un;
Unn	un1;
int	i;
int	*indx;

/*begin*/
if (mindx_0 < 0)
{
	partieee();
}
if (mach_type[0] == IEEE_BI_TYPE)
{
	/*big indian*/
	indx = bi_d;
}
else
{
	/*little indian*/
	indx = li_d;
}
if (ieee_float[indx[0]] == 0)
{
        /*its all zero here*/
        parts->characteristic = 0;
        parts->sign_bit = FALSE;
        for ( i = 0 ; i < 7 ; i++)
        {
                parts->mantisa[i] = 0;
        }
        return;
}

/*get sign */
/*load byte 0 and byte one*/
/*[scharact][erisxxxx]*/
un.uint = 0;
un.uchar[mindx_0] = ieee_float[indx[0]]; 
un.uchar[mindx_1] = ieee_float[indx[1]];
/*this is done for machines like the VMS VAX etc that are backwards 
  for ints*/
if (un.uint & 0x8000) /*check sign bit only*/
{
	/*this is minus*/
	parts->sign_bit = TRUE;
}
else
{	
	parts->sign_bit = FALSE;
}
/*get rid of sign bit*/
un.uint &= 0x7FFF;
/*0charact][erisxxxx] shift right 4*/
un1.uint = un.uint >> 4; 
/*unbias characteristic now is power of 2*/
parts->characteristic = un1.uint - IEEE_BIAS_D; 
/*brint in byte 1 and two containing mantisa*/
un.uint = 0;
un.uchar[mindx_0] = ieee_float[indx[1]]; 
un.uchar[mindx_1] = ieee_float[indx[2]];
/*contains [erisxxxx][xxxxxxxx] shift left three*/
un.uint <<= 3;
un.uint |= 0x8000; /*put implied one after new implied decimal point.*/
/*this is now left adjsusted adjust rest of mantisa*/
parts->mantisa[0] = un.uchar[mindx_0];
/*shift each byte into former byte starting with byte 2 and byte 3*/
for ( i = 2 ; i < 7 ; i++)
{
	un.uint = 0;
	un.uchar[mindx_0] = ieee_float[indx[i]]; 
	un.uchar[mindx_1] = ieee_float[indx[i+1]];
	un.uint <<= 3;
	parts->mantisa[i-1] = un.uchar[mindx_0];
}
parts->mantisa[6] = un.uchar[mindx_1];
return;
}
