/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
/*                  1234567                  1234567 */
#pragma csect(CODE,"FCT2FLT0") csect(STATIC,"FCT2FLT1")
#endif

#include	<stdio.h>
#include	<mchdblst.h>
#include	<sedrdspg.h>
#include	<dofloat.h>

flt2fltsedr(flt_in,type_in,flt_out,type_out,nflts)

float	*flt_in;
int	type_in;
float	*flt_out;
int	type_out;
int	nflts;

{

Float_Twos	parts;
int	i;

for ( i = 0 ; i < nflts ; i++)
{
	/*from to parts*/
	switch(type_in)
	{
		case IEEE_LI_TYPE:
		case IEEE_BI_TYPE:
			ieees2pr(&flt_in[i],&parts,&type_in);
		break;
		case HEX40_TYPE:
			libms2pr(&flt_in[i],&parts);
		break;
		case VAX_TYPE:
			vaxs2pr(&flt_in[i],&parts);
		break;
		default:
			return(-1);
	}
	/*now go back up*/
	switch(type_out)
	{
		case IEEE_LI_TYPE:
		case IEEE_BI_TYPE:
			pr2sieee(&parts,&flt_out[i],&type_out);
		break;
		case HEX40_TYPE:
			pr2slibm(&parts,&flt_out[i]);
		break;
		case VAX_TYPE:
			pr2svax(&parts,&flt_out[i]);
		break;
		default:
			return(-1);
	}
}
return(0);
}
